/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.xsd2java;

import com.sssw.jbroker.tools.xsd2java.ClassWriter;
import com.sssw.jbroker.tools.xsd2java.SimpleTypeUtil;
import com.sssw.jbroker.tools.xsd2java.ast.ASTAttribute;
import com.sssw.jbroker.tools.xsd2java.ast.ASTClass;
import com.sssw.jbroker.tools.xsd2java.ast.ASTComplexType;
import com.sssw.jbroker.tools.xsd2java.ast.ASTElement;
import com.sssw.jbroker.tools.xsd2java.ast.ASTField;
import com.sssw.jbroker.tools.xsd2java.ast.ASTModel;
import com.sssw.jbroker.tools.xsd2java.ast.ASTSimpleContent;
import com.sssw.jbroker.tools.xsd2java.ast.ASTSimpleType;
import com.sssw.jbroker.util.Formatter;
import com.sssw.jbroker.util.PrimitiveUtil;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class MarshalerWriter {
    private final HashMap _simpleTypeMap;
    private final HashMap _complexTypeMap;
    private boolean _nowarn;
    protected boolean _validationRequired;
    private boolean _verbose;
    private boolean _final;
    private final PrintStream _ps;
    private static final QName _ANY = new QName("http://www.w3.org/2001/XMLSchema", "any");
    private static final boolean _debug = false;

    public MarshalerWriter(HashMap hashMap, HashMap hashMap2, Hashtable hashtable, PrintStream printStream) {
        this._simpleTypeMap = hashMap;
        this._complexTypeMap = hashMap2;
        this._ps = printStream;
        this.parseParams(hashtable);
    }

    public void writeMarshaler(ASTClass aSTClass, boolean bl, Formatter formatter) {
        String string = aSTClass.getName() + "Marshaler";
        if (aSTClass.getPackage() != null && aSTClass.getPackage().length() > 0) {
            formatter.println("package " + aSTClass.getPackage() + ";");
        }
        formatter.println();
        formatter.print("public ");
        formatter.print(bl ? "final class " : "class ");
        formatter.println(string);
        if (!aSTClass.isSimple() && !aSTClass.isSimpleContent()) {
            boolean bl2;
            boolean bl3 = bl2 = aSTClass.getBaseClass() == null ? true : aSTClass.getBaseClass().isBasic();
            if (!bl2) {
                formatter.print("extends ");
                if (aSTClass.isException()) {
                    formatter.println(aSTClass.getBaseClass().getPackage() + "." + aSTClass.getBaseClass().getExceptionName() + "Marshaler");
                } else {
                    formatter.println(aSTClass.getBaseClass().fullName() + "Marshaler");
                }
            }
        }
        formatter.println(" implements com.sssw.jbroker.web.encoding.Marshaler");
        formatter.println("{");
        formatter.startBlock();
        MarshalerWriter.writeFields(aSTClass, formatter);
        this.writeMarshalerMethods(aSTClass, formatter);
        formatter.println();
        formatter.println("public java.lang.String getMechanismType() { return null; }");
        formatter.endBlock();
        formatter.println("}");
        formatter.flush();
        formatter.close();
    }

    private static void writeFields(ASTClass aSTClass, Formatter formatter) {
        MarshalerWriter.declareAttributeAndElementNames(aSTClass, formatter);
    }

    private static void declareAttributeAndElementNames(ASTClass aSTClass, Formatter formatter) {
        if (aSTClass.isSimple()) {
            return;
        }
        formatter.println("// attributes");
        if (((ASTSimpleContent)aSTClass).getAttributes().size() != 0) {
            MarshalerWriter.declareFieldNames(((ASTSimpleContent)aSTClass).getAttributes(), formatter);
            formatter.println();
        }
        if (aSTClass.isComplex()) {
            formatter.println("// elements");
            MarshalerWriter.declareFieldNames(((ASTComplexType)aSTClass).getModel().getChildren(), formatter);
        }
        if (aSTClass.isSimpleContent()) {
            MarshalerWriter.declareAttributeAndElementNames(aSTClass.getBaseClass(), formatter);
        }
    }

    protected static void declareFieldNames(ArrayList arrayList, Formatter formatter) {
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            ASTField aSTField = (ASTField)iterator.next();
            if (aSTField.isModel()) continue;
            MarshalerWriter.declareFieldName(aSTField, formatter);
        }
        formatter.println();
    }

    private static void declareFieldName(ASTField aSTField, Formatter formatter) {
        QName qName = aSTField.getXMLName();
        String string = "new javax.xml.namespace.QName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\")";
        String string2 = "_" + aSTField.getName().toUpperCase();
        MarshalerWriter.declareFieldName(string2, string, formatter);
    }

    private static void declareFieldName(String string, String string2, Formatter formatter) {
        ClassWriter.writeField("private", string, "javax.xml.namespace.QName", string2, true, true, formatter);
    }

    private void writeMarshalerMethods(ASTClass aSTClass, Formatter formatter) {
        ASTSimpleContent aSTSimpleContent;
        boolean bl = false;
        if (!aSTClass.isSimple()) {
            aSTSimpleContent = (ASTSimpleContent)aSTClass;
            while (aSTSimpleContent != null) {
                if (aSTSimpleContent.hasAnyAttributes()) {
                    bl = true;
                }
                if (aSTSimpleContent.getBaseClass() != null) {
                    if (aSTSimpleContent.getBaseClass().isSimple()) {
                        aSTSimpleContent = null;
                        continue;
                    }
                    aSTSimpleContent = (ASTSimpleContent)aSTSimpleContent.getBaseClass();
                    continue;
                }
                aSTSimpleContent = null;
            }
        }
        this.writeSerialize(aSTClass, formatter);
        this.writeDeserialize(aSTClass, bl, formatter);
        this.writeGetAttribute(aSTClass, bl, formatter);
        if (aSTClass.isSimple()) {
            return;
        }
        aSTSimpleContent = (ASTSimpleContent)aSTClass;
        this.writeDeserializeAttributes(aSTSimpleContent, bl, formatter);
        this.writeReadAttributes(aSTSimpleContent, bl, formatter);
    }

    private void writeGetAttribute(ASTClass aSTClass, boolean bl, Formatter formatter) {
        formatter.println("public com.sssw.jbroker.web.encoding.Attribute[] getAttributes(java.lang.Object object)");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("javax.xml.namespace.QName qname = null;");
        formatter.println("java.lang.String attVal = null;");
        formatter.println("java.util.ArrayList attribs = new java.util.ArrayList();");
        formatter.println("com.sssw.jbroker.web.encoding.Attribute[] attrs = null;");
        formatter.println("com.sssw.jbroker.web.encoding.Attribute attr = null;");
        formatter.println(aSTClass.fullName() + " obj = (" + aSTClass.fullName() + ") object;");
        if (aSTClass.isSimple()) {
            this.writeGetAttributeForSimpleType((ASTSimpleType)aSTClass, formatter);
        } else if (aSTClass.isSimpleContent()) {
            this.writeGetAttributeForSimpleContent((ASTSimpleContent)aSTClass, bl, formatter);
        } else {
            this.writeGetAttributeForComplexType((ASTSimpleContent)aSTClass, formatter);
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    private void writeGetAttributeForSimpleType(ASTClass aSTClass, Formatter formatter) {
        formatter.println("return null;");
    }

    private void writeGetAttributeForSimpleContent(ASTSimpleContent aSTSimpleContent, boolean bl, Formatter formatter) {
        ASTSimpleContent aSTSimpleContent2 = aSTSimpleContent;
        while (aSTSimpleContent2 != null) {
            this.writeGetAttributesForFields(aSTSimpleContent2.getAttributes(), formatter);
            if (aSTSimpleContent2.getBaseClass() != null) {
                if (aSTSimpleContent2.getBaseClass().isSimpleContent()) {
                    aSTSimpleContent2 = (ASTSimpleContent)aSTSimpleContent2.getBaseClass();
                    continue;
                }
                aSTSimpleContent2 = null;
                continue;
            }
            aSTSimpleContent2 = null;
        }
        if (bl) {
            this.writeGetAnyAttributes(aSTSimpleContent, formatter);
        }
        formatter.println();
        formatter.println("attrs = new com.sssw.jbroker.web.encoding.Attribute[attribs.size()];");
        formatter.println("attribs.toArray(attrs);");
        formatter.println("return attrs;");
    }

    private void writeGetAttributesForFields(ArrayList arrayList, Formatter formatter) {
        int n = 0;
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            formatter.println();
            ASTAttribute aSTAttribute = (ASTAttribute)iterator.next();
            String string = aSTAttribute.getName();
            String string2 = aSTAttribute.getClassName();
            String string3 = "_" + string.toUpperCase();
            String string4 = "obj." + MarshalerWriter.getMethodName(string) + "()";
            String string5 = null;
            boolean bl = PrimitiveUtil.isPrimitive(string2);
            if (!bl) {
                formatter.println("if (" + string4 + " != null) {");
                formatter.startBlock();
            }
            QName qName = aSTAttribute.getXMLName();
            if (aSTAttribute.isQualified()) {
                formatter.println("qname = " + string3 + ";");
            } else {
                formatter.println("qname = new javax.xml.namespace.QName(null, \"" + qName.getLocalPart() + "\");");
            }
            string5 = SimpleTypeUtil.getSimpleTypeContent(string2, string4);
            formatter.println("attVal = " + string5 + ";");
            if (this._validationRequired && aSTAttribute.isProhibited()) {
                formatter.println("if (attVal != null) throw new IllegalArgumentException(\"" + aSTAttribute.getXMLName() + " attribute is prohibited!\");");
            }
            if (this._validationRequired && aSTAttribute.isRequired()) {
                formatter.println("if (attVal == null) throw new IllegalArgumentException(\"" + aSTAttribute.getXMLName() + " attribute is required!\");");
            }
            formatter.println("attr = new com.sssw.jbroker.web.encoding.Attribute(qname, attVal);");
            formatter.println("attribs.add(attr);");
            ++n;
            if (bl) continue;
            formatter.endBlock();
            formatter.println("}");
        }
    }

    private void writeGetAttributeForComplexType(ASTSimpleContent aSTSimpleContent, Formatter formatter) {
        boolean bl;
        boolean bl2 = bl = aSTSimpleContent.getBaseClass() == null ? true : aSTSimpleContent.getBaseClass().isBasic();
        if (!bl) {
            formatter.println();
            formatter.print("com.sssw.jbroker.web.encoding.Attribute[] sattrs = ");
            formatter.println("super.getAttributes(object);");
            if (aSTSimpleContent.getAttributes().size() == 0 && !aSTSimpleContent.hasAnyAttributes()) {
                formatter.println("return sattrs;");
                return;
            }
            formatter.println("if (sattrs != null) {");
            formatter.startBlock();
            formatter.println("for (int i=0; i < sattrs.length; i++) {");
            formatter.startBlock();
            formatter.println("attribs.add(sattrs[i]);");
            formatter.endBlock();
            formatter.println("}");
            formatter.endBlock();
            formatter.println("}");
        } else if (aSTSimpleContent.getAttributes().size() == 0 && !aSTSimpleContent.hasAnyAttributes()) {
            formatter.println("return null;");
            return;
        }
        this.writeGetAttributesForFields(aSTSimpleContent.getAttributes(), formatter);
        if (aSTSimpleContent.hasAnyAttributes()) {
            this.writeGetAnyAttributes(aSTSimpleContent, formatter);
        }
        formatter.println();
        formatter.println("attrs = new com.sssw.jbroker.web.encoding.Attribute[attribs.size()];");
        formatter.println("attribs.toArray(attrs);");
        formatter.println("return attrs;");
    }

    private void writeGetAnyAttributes(ASTSimpleContent aSTSimpleContent, Formatter formatter) {
        formatter.println("attrs = obj.getOtherAttributes();");
        formatter.println("if (attrs != null) {");
        formatter.startBlock();
        formatter.println("for(int i =0; i < attrs.length; i++) ");
        formatter.startBlock();
        formatter.println("attribs.add(attrs[i]);");
        formatter.endBlock();
        formatter.endBlock();
        formatter.println("}");
    }

    private void writeSerialize(ASTClass aSTClass, Formatter formatter) {
        boolean bl;
        formatter.println("public void serialize(com.sssw.jbroker.web.portable.OutputStream os, java.lang.Object object) throws java.io.IOException");
        formatter.println("{");
        formatter.startBlock();
        boolean bl2 = bl = aSTClass.getBaseClass() == null ? true : aSTClass.getBaseClass().isBasic();
        if (!(aSTClass.isSimple() || aSTClass.isSimpleContent() || bl)) {
            formatter.println("super.serialize(os, object);");
        }
        formatter.println(aSTClass.fullName() + " obj = (" + aSTClass.fullName() + ") object;");
        if (aSTClass.isSimple()) {
            this.writeSerializeForSimpleType((ASTSimpleType)aSTClass, formatter);
        } else if (aSTClass.isSimpleContent()) {
            this.writeSerializeForSimpleType((ASTSimpleType)aSTClass, formatter);
        } else if (aSTClass.isComplex()) {
            this.writeSerializeForComplexType((ASTComplexType)aSTClass, formatter);
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    private void writeSerializeForSimpleType(ASTClass aSTClass, Formatter formatter) {
        formatter.println("os.writeContent(obj.toString());");
    }

    private void writeSerializeForSimpleContent(ASTClass aSTClass, Formatter formatter) {
        this.writeSerializeForSimpleType(aSTClass, formatter);
    }

    protected void writeSerializeForComplexType(ASTComplexType aSTComplexType, Formatter formatter) {
        ASTModel aSTModel = aSTComplexType.getModel();
        this.writeSerializeModel(formatter, aSTModel, "obj", aSTComplexType);
    }

    private void writeSerializeModel(Formatter formatter, ASTModel aSTModel, String string, ASTComplexType aSTComplexType) {
        String string2 = aSTModel.getModelName();
        if (string2.equalsIgnoreCase("sequence")) {
            this.writeSerializeSequence(aSTModel, string, aSTComplexType, formatter);
        } else if (string2.equalsIgnoreCase("all")) {
            this.writeSerializeSequence(aSTModel, string, aSTComplexType, formatter);
        } else if (string2.equalsIgnoreCase("choice")) {
            this.writeSerializeChoice(aSTModel, string, aSTComplexType, formatter);
        } else if (string2.equalsIgnoreCase("group")) {
            this.writeSerializeGroup(aSTModel, string, aSTComplexType, formatter);
        }
    }

    private void writeSerializeSequence(ASTModel aSTModel, String string, ASTComplexType aSTComplexType, Formatter formatter) {
        ArrayList arrayList = aSTModel.getChildren();
        if (aSTComplexType.isMixed()) {
            formatter.println("java.util.ArrayList contents = obj.getContents();");
            formatter.println("if (contents == null) contents = new java.util.ArrayList();");
            formatter.println("java.util.Iterator it = contents.iterator();");
            formatter.println("java.lang.String content = null;");
        }
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            QName qName;
            ASTField aSTField;
            if (aSTComplexType.isMixed()) {
                formatter.println();
                formatter.println("if (it.hasNext()) content = (java.lang.String) it.next();");
                formatter.println("else content = null;");
                formatter.println("if (content != null) os.writeContent(content);");
                formatter.println();
            }
            if ((aSTField = (ASTField)iterator.next()).isModel()) {
                this.writeSerializeModel((ASTModel)aSTField, string, formatter);
                continue;
            }
            String string2 = aSTField.getName();
            String string3 = "_" + string2.toUpperCase();
            String string4 = aSTField.getClassName();
            boolean bl = PrimitiveUtil.isPrimitive(string4);
            int n = ((ASTElement)aSTField).getMinOccurs();
            formatter.println();
            formatter.println("//" + string2);
            String string5 = "obj." + MarshalerWriter.getMethodName(string2) + "()";
            if (this._validationRequired && !bl && n == 1 && !aSTField.isNillable()) {
                formatter.println("if (" + string5 + " == null) throw new IllegalArgumentException(\"value can not be null for " + string2 + "\");");
            }
            if (!bl && n == 0) {
                formatter.println("if (" + string5 + " != null) {");
                formatter.startBlock();
            }
            String string6 = "writeObject";
            if (bl) {
                string5 = PrimitiveUtil.wrapIt(string4, string5);
            }
            if (aSTField.isQualified()) {
                formatter.print("os." + string6 + "(" + string5 + ", " + string3 + ".getNamespaceURI(), " + string3 + ".getLocalPart()");
            } else {
                formatter.print("os." + string6 + "(" + string5 + ", null, " + string3 + ".getLocalPart()");
            }
            if (!bl && (qName = ((ASTElement)aSTField).getXMLType()) != null) {
                formatter.print(", \"" + qName.getNamespaceURI() + "\"");
                formatter.print(", \"" + qName.getLocalPart() + "\"");
            }
            formatter.println(");");
            if (!bl && n == 0) {
                formatter.endBlock();
                formatter.println("}");
            }
            formatter.println();
        }
        if (aSTComplexType.isMixed()) {
            formatter.println();
            formatter.println("if (it.hasNext()) content = (java.lang.String) it.next();");
            formatter.println("else content = null;");
            formatter.println("if (content != null) os.writeContent(content);");
            formatter.println();
        }
    }

    private void writeSerializeChoice(ASTModel aSTModel, String string, ASTClass aSTClass, Formatter formatter) {
        String string2 = aSTModel.getName();
        String string3 = string2 + "Switch";
        formatter.print("int ");
        formatter.print(string3);
        formatter.print(" = obj.getChoice");
        formatter.println("();");
        ArrayList arrayList = aSTModel.getChildren();
        int n = 0;
        while (n < arrayList.size()) {
            ASTField aSTField = (ASTField)arrayList.get(n);
            formatter.print("if (");
            formatter.print(string3);
            formatter.print(" == obj.");
            formatter.print(aSTField.getName());
            formatter.println(") {");
            formatter.startBlock();
            if (aSTField.isModel()) {
                this.writeSerializeModel((ASTModel)aSTField, string, formatter);
            } else {
                String string4 = MarshalerWriter.getMethodName(aSTField.getName());
                String string5 = aSTField.getClassName();
                String string6 = "_" + aSTField.getName().toUpperCase();
                formatter.print("os.writeObject(");
                formatter.print("obj.");
                formatter.print(string4);
                formatter.print("(), ");
                if (aSTField.isQualified()) {
                    formatter.print(string6);
                    formatter.print(".getNamespaceURI(), ");
                } else {
                    formatter.print("null, ");
                }
                formatter.print(string6);
                formatter.println(".getLocalPart()");
                QName qName = ((ASTElement)aSTField).getXMLType();
                if (qName != null) {
                    formatter.print(", \"" + qName.getNamespaceURI() + "\"");
                    formatter.print(", \"" + qName.getLocalPart() + "\"");
                }
                formatter.print(");");
            }
            formatter.endBlock();
            formatter.println("}");
            if (n != arrayList.size() - 1) {
                formatter.print("else ");
            }
            ++n;
        }
    }

    private void writeSerializeGroup(ASTModel aSTModel, String string, ASTComplexType aSTComplexType, Formatter formatter) {
        ArrayList arrayList = aSTModel.getChildren();
        aSTModel = (ASTModel)arrayList.get(0);
        this.writeSerializeModel(aSTModel, string, formatter);
    }

    private void writeSerializeModel(ASTModel aSTModel, String string, Formatter formatter) {
        String string2;
        if (aSTModel.isModel() && aSTModel.isArray()) {
            this.writeSerializeModelArray(aSTModel, string, formatter);
            return;
        }
        String string3 = string2 = aSTModel.getClassName();
        String string4 = aSTModel.getName();
        String string5 = MarshalerWriter.getMethodName(string4);
        String string6 = aSTModel.getClassName() + "Marshaler";
        String string7 = string + "." + string5 + "()";
        formatter.println(string6 + ".serialize(os, " + string7 + ");");
    }

    private void writeSerializeModelArray(ASTModel aSTModel, String string, Formatter formatter) {
        String string2 = aSTModel.getClassName();
        String string3 = aSTModel.getName();
        String string4 = MarshalerWriter.getMethodName(string3);
        String string5 = aSTModel.getClassName() + "Marshaler";
        String string6 = string + "." + string4 + "()";
        formatter.println(string2 + " " + string3 + " = null;");
        formatter.println("if (" + string6 + " != null) {");
        formatter.startBlock();
        formatter.println("for (int i=0; i < " + string6 + ".length; i++) {");
        formatter.startBlock();
        formatter.println(string3 + " = " + string6 + "[i];");
        formatter.println(string5 + ".serialize(os, " + string3 + ");");
        formatter.endBlock();
        formatter.println("}");
        formatter.endBlock();
        formatter.println("}");
    }

    private void writeDeserialize(ASTClass aSTClass, boolean bl, Formatter formatter) {
        formatter.println("public java.lang.Object deserialize(com.sssw.jbroker.web.portable.InputStream is, java.lang.Class javaType) throws java.io.IOException");
        formatter.println("{");
        formatter.startBlock();
        boolean bl2 = aSTClass.getBaseClass() == null ? true : aSTClass.getBaseClass().isBasic();
        formatter.println("if (!" + aSTClass.fullName() + ".class.isAssignableFrom(javaType))");
        formatter.startBlock();
        formatter.println("throw new");
        formatter.startBlock();
        formatter.println("com.sssw.jbroker.web.ServiceException(\"can not deserialize \" + javaType.getName());");
        formatter.endBlock();
        formatter.endBlock();
        formatter.println();
        if (aSTClass.isSimple()) {
            this.writeDeserializeForSimpleType((ASTSimpleType)aSTClass, formatter);
        } else if (aSTClass.isSimpleContent()) {
            this.writeDeserializeForSimpleContent((ASTSimpleContent)aSTClass, bl2, bl, formatter);
        } else if (aSTClass.isComplex()) {
            this.writeDeserializeForComplexType((ASTComplexType)aSTClass, bl2, bl, formatter);
        }
        formatter.println();
        formatter.println("return obj;");
        formatter.endBlock();
        formatter.println("}");
    }

    private void writeDeserializeForSimpleType(ASTSimpleType aSTSimpleType, Formatter formatter) {
        if (aSTSimpleType.isEnum()) {
            formatter.println(aSTSimpleType.fullName() + " obj = " + aSTSimpleType.fullName() + ".fromString(is.readContent());");
        } else if (aSTSimpleType.isSimple()) {
            formatter.println(aSTSimpleType.fullName() + " obj = " + MarshalerWriter.getNewSimpleType(aSTSimpleType, "is.readContent()") + ";");
        }
    }

    private void writeDeserializeForSimpleContent(ASTSimpleContent aSTSimpleContent, boolean bl, boolean bl2, Formatter formatter) {
        if (aSTSimpleContent.isSimpleContent() || aSTSimpleContent.getAttributes().size() != 0 || bl2) {
            formatter.println("// get attributes");
            formatter.println("java.util.Map attributes = readAttributes(is.getAttributes());");
        }
        formatter.println(aSTSimpleContent.fullName() + " obj = null;");
        if (!bl && aSTSimpleContent.isComplex()) {
            formatter.println("obj = (" + aSTSimpleContent.fullName() + ") super.deserialize(is, javaType);");
        } else if (aSTSimpleContent.isSimpleContent()) {
            formatter.println("obj = (" + aSTSimpleContent.fullName() + ") " + MarshalerWriter.getNewSimpleType(aSTSimpleContent, "is.readContent()") + ";");
        } else {
            formatter.println("try {");
            formatter.startBlock();
            formatter.println("obj = (" + aSTSimpleContent.fullName() + ") " + "javaType.newInstance();");
            formatter.endBlock();
            formatter.println("} catch(Throwable e) {");
            formatter.startBlock();
            formatter.println("throw new com.sssw.jbroker.web.ServiceException(\"error instantiating \" + javaType.getName());");
            formatter.endBlock();
            formatter.println("}");
        }
        if (aSTSimpleContent.isSimpleContent() || aSTSimpleContent.getAttributes().size() != 0 || bl2) {
            formatter.println("deserializeAttributes(obj, attributes);");
        }
    }

    protected void writeDeserializeForComplexType(ASTComplexType aSTComplexType, boolean bl, boolean bl2, Formatter formatter) {
        this.writeDeserializeForSimpleContent(aSTComplexType, bl, bl2, formatter);
        this.writeDeserializeForComplexType(formatter, aSTComplexType, bl);
    }

    protected void writeDeserializeForComplexType(Formatter formatter, ASTComplexType aSTComplexType, boolean bl) {
        if (aSTComplexType.isMixed()) {
            formatter.println("java.util.ArrayList contents = new java.util.ArrayList(" + (aSTComplexType.getModel().getChildren().size() + 1) + ");");
            formatter.println("java.lang.String content = null;");
            formatter.println();
        }
        if (aSTComplexType.getModel().getChildren().size() != 0) {
            formatter.println("// read elements");
            formatter.println("com.sssw.jbroker.web.QName  qname  = null;");
            formatter.println("java.lang.String fName  = null;");
        }
        this.writeDeserializeModel(formatter, aSTComplexType.getModel(), "obj", aSTComplexType);
        formatter.println();
        if (aSTComplexType.isMixed()) {
            formatter.println("//read content");
            formatter.println("is.setMixedContent(true);");
            formatter.println("content = is.readContent();");
            formatter.println("is.setMixedContent(false);");
            formatter.println("contents.add(content);");
            formatter.println("obj.setContents(contents);");
        }
    }

    protected void writeDeserializeModel(Formatter formatter, ASTModel aSTModel, String string, ASTComplexType aSTComplexType) {
        String string2 = aSTModel.getModelName();
        if (string2.equalsIgnoreCase("sequence")) {
            this.writeDeserializeSequence(aSTModel, string, aSTComplexType, formatter);
        } else if (string2.equalsIgnoreCase("all")) {
            this.writeDeserializeAll(aSTModel, string, aSTComplexType, formatter);
        } else if (string2.equalsIgnoreCase("choice")) {
            this.writeDeserializeChoice(aSTModel, string, aSTComplexType, formatter);
        } else if (string2.equalsIgnoreCase("group")) {
            this.writeDeserializeGroup(aSTModel, string, aSTComplexType, formatter);
        }
    }

    private void writeDeserializeSequence(ASTModel aSTModel, String string, ASTClass aSTClass, Formatter formatter) {
        ArrayList arrayList = aSTModel.getChildren();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            if (aSTClass.isMixed()) {
                formatter.println("is.setMixedContent(true);");
                formatter.println("content = is.readContent();");
                formatter.println("is.setMixedContent(false);");
                formatter.println("contents.add(content);");
            }
            formatter.println("qname = is.peek();");
            if (n2 == 0 && aSTClass.isModel()) {
                formatter.println("if (qname == null) return null;");
            }
            ASTField aSTField = (ASTField)arrayList.get(n2);
            String string2 = aSTField.getName();
            if (aSTField.isModel()) {
                this.writeDeserializeModel((ASTModel)aSTField, "obj", formatter);
                formatter.println("if (" + string2 + " == null) ");
                formatter.startBlock();
                if (n2 == 0 && aSTClass.isModel()) {
                    formatter.println("return null;");
                } else {
                    formatter.println("throw new java.io.EOFException(\"missing particle:" + string2 + "\");");
                }
                formatter.endBlock();
                this.writeSetField(string2, string, formatter);
            } else {
                this.writeDeserializeSequenceField((ASTElement)aSTField, aSTClass, "obj", n2, formatter);
            }
            ++n2;
        }
    }

    private void writeSetField(String string, String string2, Formatter formatter) {
        formatter.println();
        String string3 = MarshalerWriter.getMethodName(string);
        formatter.print(string2 + ".");
        String string4 = MarshalerWriter.setMethodName(string);
        formatter.print(string4);
        formatter.println("(" + string + ");");
        formatter.println();
    }

    private void writeDeserializeSequenceField(ASTElement aSTElement, ASTClass aSTClass, String string, int n, Formatter formatter) {
        String string2 = aSTElement.getName();
        String string3 = aSTElement.getClassName();
        boolean bl = PrimitiveUtil.isPrimitive(string3);
        if (!bl) {
            formatter.println(string3 + " " + string2 + " = null;");
        }
        boolean bl2 = false;
        if (_ANY.equals(aSTElement.getXMLName())) {
            bl2 = true;
        }
        if ((aSTElement.getMinOccurs() == 0 || n == 0 && aSTClass.isModel()) && !bl2) {
            String string4 = "_" + string2.toUpperCase();
            formatter.println("qname = is.peek();");
            formatter.println("if (qname != null) {");
            formatter.startBlock();
            if (aSTElement.isQualified()) {
                formatter.println("if (qname.equals(" + string4 + ")) {");
            } else {
                formatter.println("if (qname.getLocalPart().equals(" + string4 + ".getLocalPart())) {");
            }
            formatter.startBlock();
        }
        this.writeDeserializeField(aSTElement, string, formatter);
        if (aSTElement.getFixed() == null) {
            this.writeSetField(string2, string, formatter);
        }
        if ((aSTElement.getMinOccurs() == 0 || n == 0 && aSTClass.isModel()) && !bl2) {
            formatter.endBlock();
            formatter.println("}");
            if (n == 0 && aSTClass.isModel()) {
                formatter.println("else return null;");
            }
            formatter.endBlock();
            formatter.println("}");
            formatter.println();
        }
    }

    private void writeDeserializeAll(ASTModel aSTModel, String string, ASTClass aSTClass, Formatter formatter) {
        ArrayList arrayList = aSTModel.getChildren();
        if (arrayList.size() == 0) {
            return;
        }
        formatter.println("for (int i = 0; i < " + arrayList.size() + "; i++) {");
        formatter.startBlock();
        if (aSTClass.isMixed()) {
            formatter.println("is.setMixedContent(true);");
            formatter.println("content = is.readContent();");
            formatter.println("is.setMixedContent(false);");
            formatter.println("contents.add(content);");
        }
        formatter.println("qname = is.peek();");
        formatter.println("if (qname == null) break;");
        formatter.println("fName = qname.getLocalPart();");
        int n = 0;
        while (n < arrayList.size()) {
            ASTField aSTField = (ASTField)arrayList.get(n);
            String string2 = aSTField.getName();
            String string3 = aSTField.getClassName();
            boolean bl = PrimitiveUtil.isPrimitive(string3);
            boolean bl2 = false;
            if (_ANY.equals(aSTField.getXMLName())) {
                bl2 = true;
            }
            if (!bl2) {
                String string4 = "_" + string2.toUpperCase();
                if (n > 0) {
                    formatter.print("else ");
                }
                if (aSTField.isQualified()) {
                    formatter.println("if (qname.equals(" + string4 + ")) {");
                } else {
                    formatter.println("if (fName.equals(" + string4 + ".getLocalPart())) {");
                }
            }
            formatter.startBlock();
            if (!bl) {
                formatter.println(string3 + " " + string2 + " = null;");
            }
            this.writeDeserializeField((ASTElement)aSTField, string, formatter);
            if (aSTField.getFixed() == null) {
                this.writeSetField(string2, string, formatter);
            }
            formatter.endBlock();
            if (!bl2) {
                formatter.println("}");
            }
            ++n;
        }
        if (arrayList.size() != 0) {
            formatter.println("else");
            formatter.startBlock();
            formatter.println("throw new java.io.IOException(\"encountered unexpected element: \" + fName);");
        }
        formatter.endBlock();
        formatter.println("}");
    }

    private void writeDeserializeChoice(ASTModel aSTModel, String string, ASTComplexType aSTComplexType, Formatter formatter) {
        formatter.println();
        formatter.println("qname = is.peek();");
        formatter.println("if (qname != null) {");
        formatter.startBlock();
        formatter.println("fName = qname.getLocalPart();");
        ArrayList arrayList = aSTModel.getChildren();
        int n = 0;
        while (n < arrayList.size()) {
            ASTField aSTField = (ASTField)arrayList.get(n);
            String string2 = aSTField.getName();
            String string3 = aSTField.getClassName();
            if (aSTField.isModel()) {
                this.writeDeserializeModel((ASTModel)aSTField, string, formatter);
            } else {
                this.writeDeserializeChoiceField((ASTElement)aSTField, string, formatter);
            }
            formatter.println();
            formatter.println("if (" + string2 + " != null) {");
            formatter.startBlock();
            String string4 = MarshalerWriter.getMethodName(string2);
            formatter.print(string + ".");
            String string5 = MarshalerWriter.setMethodName(string2);
            formatter.print(string5);
            formatter.println("(" + string2 + ");");
            formatter.println("return obj;");
            formatter.endBlock();
            formatter.println("}");
            formatter.println();
            ++n;
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
        if (aSTComplexType.isModel()) {
            formatter.println("obj = null;");
        }
    }

    private void writeDeserializeChoiceField(ASTElement aSTElement, String string, Formatter formatter) {
        String string2 = aSTElement.getName();
        String string3 = aSTElement.getClassName();
        String string4 = "_" + string2.toUpperCase();
        String string5 = MarshalerWriter.getReadStream(string2, string3, aSTElement.isQualified(), aSTElement.getXMLType());
        formatter.println(string3 + " " + string2 + " = null;");
        boolean bl = false;
        if (_ANY.equals(aSTElement.getXMLName())) {
            bl = true;
        }
        if (!bl) {
            formatter.println();
            if (aSTElement.isQualified()) {
                formatter.print("if (qname.equals(");
                formatter.print(string4);
            } else {
                formatter.print("if (fName.equals(");
                formatter.print(string4);
                formatter.print(".getLocalPart()");
            }
            formatter.println(")) {");
            formatter.startBlock();
        }
        if (this._validationRequired && aSTElement.getFixed() != null) {
            String string6 = MarshalerWriter.getMethodName(string2);
            String string7 = string + "." + string6 + "()";
            String string8 = string2 + "_fixed";
            formatter.println(string3 + " " + string8 + " = " + string5 + ";");
            formatter.println("if (!" + string7 + ".equals(" + string8 + "))");
            formatter.startBlock();
            formatter.println("throw new IllegalArgumentException(\"Fixed value not correct:\"+" + string8 + ");");
            formatter.endBlock();
        } else {
            formatter.println(string2 + " = " + string5 + ";");
        }
        if (!bl) {
            formatter.endBlock();
            formatter.println("}");
        }
        formatter.println();
    }

    private void writeDeserializeGroup(ASTModel aSTModel, String string, ASTClass aSTClass, Formatter formatter) {
        ArrayList arrayList = aSTModel.getChildren();
        aSTModel = (ASTModel)arrayList.get(0);
        this.writeDeserializeModel(aSTModel, "obj", formatter);
        formatter.println("if (" + aSTModel.getName() + " == null) return null;");
        this.writeSetField(aSTModel.getName(), string, formatter);
    }

    private void writeDeserializeModel(ASTModel aSTModel, String string, Formatter formatter) {
        this.writeDeserializeModel(aSTModel, string, aSTModel.getName(), formatter);
    }

    private void writeDeserializeModel(ASTModel aSTModel, String string, String string2, Formatter formatter) {
        boolean bl = aSTModel.isArray();
        if (bl) {
            this.writeDeserializeModelArray(aSTModel, string, formatter);
        } else {
            String string3 = aSTModel.getClassName();
            formatter.println(string3 + " " + string2 + " = null;");
            this.writeDeserializeModelField(aSTModel, string, string2, formatter);
        }
    }

    private void writeDeserializeModelField(ASTModel aSTModel, String string, String string2, Formatter formatter) {
        String string3 = aSTModel.getClassName() + "Marshaler";
        formatter.println(string2 + " = " + string3 + ".deserialize(is);");
    }

    private void writeDeserializeModelArray(ASTModel aSTModel, String string, Formatter formatter) {
        String string2;
        String string3 = string2 = aSTModel.getClassName();
        String string4 = aSTModel.getName();
        String string5 = string4 + "List";
        String string6 = string4;
        String string7 = string4 + "Item";
        String string8 = string2 + "Marshaler";
        formatter.println("java.util.ArrayList " + string5 + " = new java.util.ArrayList();");
        formatter.println(string2 + " " + string7 + " = null;");
        formatter.println("while(true) {");
        formatter.startBlock();
        this.writeDeserializeModelField(aSTModel, string, string7, formatter);
        formatter.println("if (" + string7 + " == null) break;");
        formatter.println(string5 + ".add(" + string7 + ");");
        formatter.endBlock();
        formatter.println("}");
        formatter.println(string2 + "[] " + string6 + " = new " + string2 + "[" + string5 + ".size()];");
        formatter.println(string5 + ".toArray(" + string6 + ");");
        formatter.println();
    }

    private void writeDeserializeField(ASTElement aSTElement, String string, Formatter formatter) {
        String string2 = aSTElement.getClassName();
        String string3 = aSTElement.getName();
        String string4 = "_" + string3.toUpperCase();
        boolean bl = PrimitiveUtil.isPrimitive(string2);
        String string5 = MarshalerWriter.getReadStream(string3, string2, aSTElement.isQualified(), aSTElement.getXMLType());
        if (this._validationRequired && aSTElement.getFixed() != null) {
            String string6 = MarshalerWriter.getMethodName(string3);
            String string7 = string + "." + string6 + "()";
            String string8 = string3 + "_fixed";
            formatter.println(string2 + " " + string8 + " = " + string5 + ";");
            formatter.println("if (!" + string7 + ".equals(" + string8 + "))");
            formatter.startBlock();
            formatter.println("throw new IllegalArgumentException(\"Fixed value not correct:\"+" + string8 + ");");
            formatter.endBlock();
        } else {
            if (bl) {
                formatter.print(string2 + " ");
            }
            formatter.print(string3 + " = " + string5 + ";");
            formatter.println();
        }
    }

    private static String getReadStream(String string, String string2, boolean bl, QName qName) {
        String string3 = "_" + string.toUpperCase();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = PrimitiveUtil.isPrimitive(string2);
        String string4 = string2;
        String string5 = null;
        if (bl2 && !bl) {
            string5 = MarshalerWriter.getISMethodName(string2, "read");
            stringBuffer.append("is.");
            stringBuffer.append(string5);
            stringBuffer.append("(");
        } else {
            if (bl2) {
                string2 = PrimitiveUtil.getPrimitiveWrapper(string2);
            }
            stringBuffer.append("(");
            stringBuffer.append(string2);
            stringBuffer.append(")is.readObject(");
            stringBuffer.append(string2);
            stringBuffer.append(".class");
            stringBuffer.append(", ");
        }
        if (bl) {
            stringBuffer.append(string3);
            stringBuffer.append(".getNamespaceURI(), ");
        }
        stringBuffer.append(string3);
        stringBuffer.append(".getLocalPart())");
        String string6 = stringBuffer.toString();
        if (bl2 && bl) {
            return PrimitiveUtil.getPrimitiveFromObject(string4, string6);
        }
        return string6;
    }

    private static String getISMethodName(String string, String string2) {
        if (PrimitiveUtil.isPrimitive(string)) {
            return string2 + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string2 + "Object";
    }

    private void writeReadAttributes(ASTSimpleContent aSTSimpleContent, boolean bl, Formatter formatter) {
        if (bl) {
            this.writeReadAttributesForAnyAttributes(aSTSimpleContent, formatter);
        } else {
            this.writeReadAttributesForRegularAttributes(aSTSimpleContent, formatter);
        }
    }

    private void writeReadAttributesForAnyAttributes(ASTSimpleContent aSTSimpleContent, Formatter formatter) {
        formatter.println("private java.util.Map readAttributes(org.xml.sax.Attributes attributes) {");
        formatter.startBlock();
        formatter.println("java.util.Map attrs = new java.util.HashMap();");
        formatter.println("int len = attributes.getLength();");
        formatter.println("for (int i=0; i < len; i++) {");
        formatter.startBlock();
        formatter.println("java.lang.String uri = attributes.getURI(i);");
        formatter.println("java.lang.String ln = attributes.getLocalName(i);");
        formatter.println("javax.xml.namespace.QName attName = new javax.xml.namespace.QName(uri, ln);");
        formatter.println("java.lang.String attVal = attributes.getValue(i);");
        formatter.println("if (ln.equalsIgnoreCase(\"type\"))");
        formatter.startBlock();
        formatter.println("if (uri.equalsIgnoreCase(\"http://www.w3.org/2001/XMLSchema-instance\"))");
        formatter.startBlock();
        formatter.println("continue;");
        formatter.endBlock();
        formatter.endBlock();
        formatter.println("attrs.put(attName, attVal);");
        formatter.endBlock();
        formatter.println("}");
        formatter.println("return attrs;");
        formatter.endBlock();
        formatter.println("}");
    }

    private void writeReadAttributesForRegularAttributes(ASTSimpleContent aSTSimpleContent, Formatter formatter) {
        ArrayList arrayList = aSTSimpleContent.getAttributes();
        formatter.println("private java.util.Map readAttributes(org.xml.sax.Attributes attributes) {");
        formatter.startBlock();
        formatter.println("java.util.Map attrs = new java.util.HashMap();");
        this.writeReadAttributes(arrayList, formatter);
        if (aSTSimpleContent.getBaseClass() != null && aSTSimpleContent.getBaseClass().isSimpleContent() && !aSTSimpleContent.getBaseClass().isBasic()) {
            this.writeReadAttributes(((ASTSimpleContent)aSTSimpleContent.getBaseClass()).getAttributes(), formatter);
        }
        formatter.println("return attrs;");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    private void writeReadAttributes(ArrayList arrayList, Formatter formatter) {
        int n = arrayList.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            ASTField aSTField = (ASTField)arrayList.get(n2);
            String string = aSTField.getName();
            String string2 = aSTField.getClassName();
            String string3 = "_" + string.toUpperCase();
            QName qName = aSTField.getXMLName();
            String string4 = aSTField.isQualified() ? "attributes.getValue(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\")" : "attributes.getValue(\"" + qName.getLocalPart() + "\")";
            formatter.println("attrs.put(" + string3 + ", " + string4 + ");");
            ++n2;
        }
    }

    private void writeDeserializeAttributes(ASTSimpleContent aSTSimpleContent, boolean bl, Formatter formatter) {
        formatter.println("private void deserializeAttributes(" + aSTSimpleContent.fullName() + " obj, java.util.Map attributes)");
        formatter.println("throws java.io.IOException");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("// set attributes");
        formatter.println("java.lang.String attr = null;");
        if (aSTSimpleContent.isComplex()) {
            this.writeDeserializeAttributeFields(aSTSimpleContent.getAttributes(), formatter);
        }
        ASTSimpleContent aSTSimpleContent2 = aSTSimpleContent;
        while (aSTSimpleContent2 != null) {
            if (aSTSimpleContent.isSimpleContent()) {
                this.writeDeserializeAttributeFields(aSTSimpleContent2.getAttributes(), formatter);
            }
            if (aSTSimpleContent2.getBaseClass() != null) {
                if (aSTSimpleContent2.getBaseClass().isSimpleContent()) {
                    aSTSimpleContent2 = (ASTSimpleContent)aSTSimpleContent2.getBaseClass();
                    continue;
                }
                aSTSimpleContent2 = null;
                continue;
            }
            aSTSimpleContent2 = null;
        }
        if (bl) {
            formatter.println("deserializeAnyAttributes(obj, attributes);");
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
        if (bl) {
            this.writeDeserializeAnyAttributes(aSTSimpleContent, bl, formatter);
        }
    }

    private void writeRemoveSuperAttributes(ASTSimpleContent aSTSimpleContent, Formatter formatter) {
        ASTSimpleContent aSTSimpleContent2 = (ASTSimpleContent)aSTSimpleContent.getBaseClass();
        while (aSTSimpleContent2 != null) {
            int n = 0;
            while (n < aSTSimpleContent2.getAttributes().size()) {
                ASTAttribute aSTAttribute = (ASTAttribute)aSTSimpleContent2.getAttributes().get(n);
                formatter.println("attributes.remove(new javax.xml.namespace.QName(\"" + aSTAttribute.getXMLName().getNamespaceURI() + "\", \"" + aSTAttribute.getXMLName().getLocalPart() + "\"));");
                ++n;
            }
            aSTSimpleContent2 = (ASTSimpleContent)aSTSimpleContent2.getBaseClass();
        }
    }

    private void writeDeserializeAttributeFields(ArrayList arrayList, Formatter formatter) {
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            formatter.println();
            ASTAttribute aSTAttribute = (ASTAttribute)iterator.next();
            this.writeDeserializeAttributeField(aSTAttribute, formatter);
        }
    }

    private void writeDeserializeAnyAttributes(ASTSimpleContent aSTSimpleContent, boolean bl, Formatter formatter) {
        formatter.println("private void deserializeAnyAttributes(" + aSTSimpleContent.fullName() + " obj, java.util.Map attributes)");
        formatter.println("throws java.io.IOException");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("javax.xml.namespace.QName attName = null;");
        formatter.println("javax.xml.namespace.QName attVal = null;");
        formatter.println("com.sssw.jbroker.web.encoding.Attribute[] attrs = null;");
        formatter.println("com.sssw.jbroker.web.encoding.Attribute attr = null;");
        formatter.println();
        if (aSTSimpleContent.isComplex() && bl) {
            this.writeRemoveSuperAttributes(aSTSimpleContent, formatter);
        }
        formatter.println("attrs = new com.sssw.jbroker.web.encoding.Attribute[attributes.size()];");
        formatter.println("java.util.Set attSet = attributes.entrySet();");
        formatter.println("java.util.Iterator it = attSet.iterator();");
        formatter.println("int i =0;");
        formatter.println("while(it.hasNext()) {");
        formatter.startBlock();
        formatter.println("java.util.Map.Entry entry = (java.util.Map.Entry) it.next();");
        formatter.println("attName = (javax.xml.namespace.QName)entry.getKey();");
        formatter.println("attVal = new javax.xml.namespace.QName((java.lang.String)entry.getValue());");
        formatter.println("attr = new com.sssw.jbroker.web.encoding.Attribute(attName, attVal);");
        formatter.println("attrs[i] = attr;");
        formatter.println("i++;");
        formatter.endBlock();
        formatter.println("}");
        formatter.println("obj.setOtherAttributes(attrs);");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    public void writeDeserializeAttributeField(ASTAttribute aSTAttribute, Formatter formatter) {
        String string = aSTAttribute.getName();
        String string2 = aSTAttribute.getClassName();
        String string3 = "_" + string.toUpperCase();
        String string4 = "(java.lang.String) attributes.get(" + string3 + ")";
        formatter.println("attr = " + string4 + ";");
        formatter.println("attributes.remove(" + string3 + ");");
        formatter.println("if (attr != null) {");
        formatter.startBlock();
        if (this._validationRequired && aSTAttribute.isProhibited()) {
            formatter.print("throw new IllegalArgumentException(\"" + aSTAttribute.getXMLName() + " attribute is prohibited!\");");
        } else {
            ASTSimpleType aSTSimpleType = this.getSimpleType(string2);
            boolean bl = false;
            if (aSTSimpleType != null) {
                bl = aSTSimpleType.isEnum();
            }
            string4 = bl ? string2 + ".fromString(attr)" : SimpleTypeUtil.getNewSimpleType(string2, "attr");
            if (this._validationRequired && aSTAttribute.getFixed() != null) {
                String string5 = "\"" + aSTAttribute.getFixed() + "\"";
                string5 = SimpleTypeUtil.getNewSimpleType(string2, string5);
                formatter.println("if (!(" + string4 + ").equals(" + string5 + "))");
                formatter.startBlock();
                formatter.println("throw new IllegalArgumentException(\"Not a fixed value:\"+attr);");
                formatter.endBlock();
            } else {
                formatter.println("obj." + MarshalerWriter.setMethodName(string) + "(" + string4 + ");");
            }
        }
        formatter.endBlock();
        formatter.print("}");
        if (this._validationRequired && aSTAttribute.isRequired()) {
            formatter.print(" else throw new IllegalArgumentException(\"" + aSTAttribute.getXMLName() + " attribute is required!\");");
        }
        formatter.println();
    }

    public static String getMethodName(String string) {
        return "get" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String setMethodName(String string) {
        return "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    private boolean isSimpleType(String string) {
        return this._simpleTypeMap.get(string) != null;
    }

    private ASTSimpleType getSimpleType(String string) {
        return (ASTSimpleType)this._simpleTypeMap.get(string);
    }

    private String wrapIfPrimitive(String string, String string2) {
        String string3 = (String)PrimitiveUtil.primitiveWrappers.get(string);
        if (string3 != null) {
            return PrimitiveUtil.wrapIt(string, string2);
        }
        return string2;
    }

    private void warn(String string) {
        if (!this._nowarn) {
            this._ps.println("warn: " + string);
        }
    }

    protected void parseParams(Hashtable hashtable) {
        this._nowarn = hashtable.get("nowarn") != null;
        this._validationRequired = hashtable.get("novalidate") == null;
    }

    public static String getNewSimpleType(ASTClass aSTClass, String string) {
        return SimpleTypeUtil.getNewSimpleType(aSTClass.fullName(), string);
    }
}

