/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.xsd2java;

import com.sssw.jbroker.tools.xsd2java.MarshalerWriter;
import com.sssw.jbroker.tools.xsd2java.ast.ASTComplexType;
import com.sssw.jbroker.util.Formatter;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;

public class ModelMarshalerWriter
extends MarshalerWriter {
    public ModelMarshalerWriter(HashMap hashMap, HashMap hashMap2, Hashtable hashtable, PrintStream printStream) {
        super(hashMap, hashMap2, hashtable, printStream);
    }

    public void writeMarshaler(ASTComplexType aSTComplexType, boolean bl, Formatter formatter) {
        String string = aSTComplexType.getName() + "Marshaler";
        if (aSTComplexType.getPackage() != null && aSTComplexType.getPackage().length() > 0) {
            formatter.println("package " + aSTComplexType.getPackage() + ";");
        }
        formatter.println();
        formatter.print("public ");
        formatter.print(bl ? "final class " : "class ");
        formatter.println(string);
        formatter.println(" {");
        formatter.startBlock();
        ModelMarshalerWriter.writeFields(aSTComplexType, formatter);
        this.writeSerialize(aSTComplexType, formatter);
        this.writeDeserialize(aSTComplexType, formatter);
        formatter.println();
        formatter.endBlock();
        formatter.println("}");
        formatter.flush();
        formatter.close();
    }

    private static void writeFields(ASTComplexType aSTComplexType, Formatter formatter) {
        MarshalerWriter.declareFieldNames(aSTComplexType.getModel().getChildren(), formatter);
    }

    private void writeSerialize(ASTComplexType aSTComplexType, Formatter formatter) {
        formatter.println("public static void serialize(com.sssw.jbroker.web.portable.OutputStream os, " + aSTComplexType.fullName() + " object) throws java.io.IOException");
        formatter.println("{");
        formatter.startBlock();
        formatter.println("if (object == null) return;");
        formatter.println(aSTComplexType.fullName() + " obj = (" + aSTComplexType.fullName() + ") object;");
        this.writeSerializeForComplexType(aSTComplexType, formatter);
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    private void writeDeserialize(ASTComplexType aSTComplexType, Formatter formatter) {
        formatter.println("public static " + aSTComplexType.fullName() + " deserialize(com.sssw.jbroker.web.portable.InputStream is) throws java.io.IOException");
        formatter.println("{");
        formatter.startBlock();
        formatter.println(aSTComplexType.fullName() + " obj = new " + aSTComplexType.fullName() + "();");
        this.writeDeserializeForComplexType(formatter, aSTComplexType, false);
        formatter.println();
        formatter.println("return obj;");
        formatter.endBlock();
        formatter.println("}");
    }
}

