/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.xsd2java;

import com.sssw.jbroker.tools.xsd2java.BeanWriter;
import com.sssw.jbroker.tools.xsd2java.ClassWriter;
import com.sssw.jbroker.tools.xsd2java.SimpleTypeUtil;
import com.sssw.jbroker.tools.xsd2java.ast.ASTBaseTypeConstraint;
import com.sssw.jbroker.tools.xsd2java.ast.ASTConstraint;
import com.sssw.jbroker.tools.xsd2java.ast.ASTField;
import com.sssw.jbroker.tools.xsd2java.ast.ASTNumericConstraint;
import com.sssw.jbroker.tools.xsd2java.ast.ASTSimpleType;
import com.sssw.jbroker.tools.xsd2java.ast.ASTStringBasedConstraint;
import com.sssw.jbroker.tools.xsd2java.ast.ASTWhiteSpace;
import com.sssw.jbroker.util.Formatter;
import com.sssw.jbroker.util.PrimitiveUtil;
import java.util.ArrayList;
import java.util.Map;

public class SimpleBeanWriter
extends BeanWriter {
    private static final String _UNKNOWN = "UNKNOWN";

    public static void writeBean(ASTSimpleType aSTSimpleType, Map map, Formatter formatter) {
        SimpleBeanWriter simpleBeanWriter = new SimpleBeanWriter(map);
        simpleBeanWriter.writeBean(aSTSimpleType, formatter);
    }

    public SimpleBeanWriter(Map map) {
        super(map);
    }

    public void writeBean(ASTSimpleType aSTSimpleType, Formatter formatter) {
        if (aSTSimpleType.getPackage() != null && aSTSimpleType.getPackage().length() > 0) {
            formatter.println("package " + aSTSimpleType.getPackage() + ";");
        }
        formatter.println();
        formatter.print("public ");
        formatter.print(this._final ? "final class " : "class ");
        formatter.println(aSTSimpleType.getName());
        if (!aSTSimpleType.isEnum()) {
            boolean bl;
            boolean bl2 = bl = aSTSimpleType.getBaseClass() == null ? true : aSTSimpleType.getBaseClass().isBasic();
            if (!bl) {
                formatter.println("    extends " + aSTSimpleType.getSuperClass());
            } else if (aSTSimpleType.isException()) {
                formatter.println("    extends java.lang.Exception");
            }
        } else if (aSTSimpleType.isException()) {
            formatter.println("    extends java.lang.Exception");
        }
        formatter.println(" implements java.io.Serializable");
        formatter.println("{");
        formatter.startBlock();
        this.writeJavaForSimpleType(aSTSimpleType, formatter);
        formatter.endBlock();
        formatter.println("}");
        formatter.flush();
        formatter.close();
    }

    protected void writeJavaForSimpleType(ASTSimpleType aSTSimpleType, Formatter formatter) {
        if (aSTSimpleType.getEnums() != null) {
            this.writeJavaForEnums(aSTSimpleType, formatter);
        } else if (aSTSimpleType.isUnion()) {
            this.writeJavaForUnion(aSTSimpleType, formatter);
        } else if (aSTSimpleType.isList()) {
            this.writeJavaForList(aSTSimpleType, formatter);
        } else {
            this.writeJavaForPlainSimpleType(aSTSimpleType, formatter);
        }
    }

    private void writeJavaForPlainSimpleType(ASTSimpleType aSTSimpleType, Formatter formatter) {
        boolean bl;
        String string = aSTSimpleType.getSimpleContentType();
        this.writeStringConstructor("public", aSTSimpleType, formatter);
        if (!string.equals("java.lang.String")) {
            this.writeBaseTypeConstructor("public", aSTSimpleType, formatter);
        }
        boolean bl2 = bl = aSTSimpleType.getBaseClass() == null ? true : aSTSimpleType.getBaseClass().isBasic();
        if (bl) {
            BeanWriter.writeBeanReadProperty("value", string, formatter);
        }
        this.writeSetValue(aSTSimpleType, formatter);
        if (this._validationRequired) {
            this.writeValidateMethods(aSTSimpleType, formatter);
        }
        if (bl) {
            this.writeParse(aSTSimpleType, formatter);
            this.writeToString(aSTSimpleType, formatter);
            this.writeEquals(aSTSimpleType, formatter);
            BeanWriter.writeHashCode(aSTSimpleType, formatter);
            this.writeBCCode(aSTSimpleType, formatter);
        }
    }

    protected void writeSetValue(ASTSimpleType aSTSimpleType, Formatter formatter) {
        String string = aSTSimpleType.getSimpleContentType();
        this.writeSetValue(string, aSTSimpleType, formatter);
    }

    protected void writeSetValue(String string, ASTSimpleType aSTSimpleType, Formatter formatter) {
        this.writeSetValue(string, "value", aSTSimpleType, formatter);
    }

    protected void writeSetValue(String string, String string2, ASTSimpleType aSTSimpleType, Formatter formatter) {
        boolean bl;
        String string3 = BeanWriter.setMethodName(string2);
        String string4 = "_" + string2;
        formatter.println("public void " + string3 + "(" + string + " val) {");
        formatter.startBlock();
        if (!BeanWriter.isPrimitive(string)) {
            formatter.println("if (val == null) throw new IllegalArgumentException(\"Can not set null value for simple content!\");");
        }
        if (this._validationRequired) {
            if (!string.equals("java.lang.String")) {
                if (this.isArray(string)) {
                    formatter.println("validate(getContent(val));");
                } else {
                    formatter.println("validate(" + SimpleTypeUtil.getSimpleTypeContent(string, "val") + ");");
                }
            }
            formatter.println("validate(val);");
            if (string.equals("java.lang.String")) {
                this.writeWhiteSpaceConstraintCode(aSTSimpleType, formatter);
            }
        }
        boolean bl2 = bl = aSTSimpleType.getBaseClass() == null ? true : aSTSimpleType.getBaseClass().isBasic();
        if (bl) {
            formatter.println(string4 + " = val;");
        } else {
            formatter.println("super.setValue(val);");
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    private void writeToString(ASTSimpleType aSTSimpleType, Formatter formatter) {
        String string = aSTSimpleType.getSimpleContentType();
        formatter.println("public java.lang.String toString() { return getContent(_value); }");
        formatter.println();
        formatter.print("protected static java.lang.String getContent(");
        formatter.print(string);
        formatter.print(" val) { return ");
        formatter.print(SimpleTypeUtil.getSimpleTypeContent(string, "val"));
        formatter.println("; }");
        formatter.println();
    }

    protected void writeGetContent(ASTSimpleType aSTSimpleType, Formatter formatter) {
        formatter.println("/**@deprecated since jBrokerWeb 2.0 use getValue*/");
        formatter.println("public java.lang.String getContent() { return toString(); }");
        formatter.println();
    }

    private void writeBCCode(ASTSimpleType aSTSimpleType, Formatter formatter) {
        this.writeGetContent(aSTSimpleType, formatter);
        if (aSTSimpleType.isEnum()) {
            return;
        }
        formatter.println("/**@deprecated since jBrokerWeb 2.0, use <code>setValue</code>*/");
        formatter.print("public void setContent(java.lang.String val) {");
        formatter.println(" setValue(new " + aSTSimpleType.fullName() + "(val).getValue()" + "); }");
        formatter.println();
    }

    protected void writeWhiteSpaceConstraintCode(ASTSimpleType aSTSimpleType, Formatter formatter) {
        int n = aSTSimpleType.getConstraintPosition("whiteSpace");
        if (n == -1) {
            return;
        }
        ASTWhiteSpace aSTWhiteSpace = (ASTWhiteSpace)aSTSimpleType.getConstraints().get(n);
        aSTWhiteSpace.writeConstraintCode("val", aSTSimpleType.getSimpleContentType(), formatter);
    }

    protected void writeValidateMethods(ASTSimpleType aSTSimpleType, Formatter formatter) {
        this.writeValidateString(aSTSimpleType, formatter);
        this.writeValidate(aSTSimpleType, formatter);
    }

    protected void writeValidateString(ASTSimpleType aSTSimpleType, Formatter formatter) {
        ArrayList arrayList = aSTSimpleType.getStringConstraints();
        formatter.println("private void validate(java.lang.String val) {");
        formatter.startBlock();
        this.writeConstraintsCode(aSTSimpleType, arrayList, formatter);
        String string = aSTSimpleType.getSimpleContentType();
        if (string.equals("java.lang.String")) {
            ArrayList arrayList2 = aSTSimpleType.getBaseTypeConstraints();
            this.writeConstraintsCode(aSTSimpleType, arrayList2, formatter);
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    protected void writeValidate(ASTSimpleType aSTSimpleType, Formatter formatter) {
        this.writeConstraintFields(aSTSimpleType, formatter);
        String string = aSTSimpleType.getSimpleContentType();
        if (string.equals("java.lang.String")) {
            return;
        }
        ArrayList arrayList = aSTSimpleType.getNonStringConstraints();
        formatter.println("private void validate(" + string + " val) {");
        formatter.startBlock();
        this.writeConstraintsCode(aSTSimpleType, arrayList, formatter);
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    /*
     * Unable to fully structure code
     */
    protected void writeConstraintFields(ASTSimpleType var1_1, Formatter var2_2) {
        var3_3 = var1_1.getSimpleContentType();
        var4_4 = var1_1.getConstraints();
        var5_5 = var4_4.size();
        var6_6 = 0;
        while (var6_6 < var5_5) {
            block5: {
                block6: {
                    var7_7 = (ASTConstraint)var4_4.get(var6_6);
                    var8_8 = "_" + var7_7.getName() + "Val";
                    var9_9 = var7_7.getValue();
                    if (var7_7.isBaseTypeBased()) break block5;
                    if (!var7_7.isNumeric()) break block6;
                    if (!PrimitiveUtil.isPrimitive(var3_3)) {
                        var9_9 = "new " + var3_3 + "(\"" + var9_9 + "\");";
                    }
                    ** GOTO lbl-1000
                }
                if (var7_7.isStringBased()) {
                    if (((ASTStringBasedConstraint)var7_7).isPattern()) {
                        var3_3 = "com.sssw.jbroker.util.regex.Regex";
                        ClassWriter.writeField("private", var8_8, var3_3, "getPattern()", true, true, var2_2);
                        var9_9 = "new com.sssw.jbroker.util.regex.Regex(\"" + this.escape(var9_9) + "\")";
                        var2_2.println("protected static com.sssw.jbroker.util.regex.Regex getPattern() {");
                        var2_2.startBlock();
                        var2_2.print("try {");
                        var2_2.print("return " + var9_9 + ";");
                        var2_2.println("} catch (Throwable e) {");
                        var2_2.startBlock();
                        var2_2.println("throw new IllegalArgumentException(\"Invalid regular expression:\"+e.getMessage());");
                        var2_2.endBlock();
                        var2_2.println("}");
                        var2_2.endBlock();
                        var2_2.println("}");
                        var2_2.println();
                    }
                } else lbl-1000:
                // 2 sources

                {
                    ClassWriter.writeField("private", var8_8, var3_3, var9_9, true, true, var2_2);
                }
            }
            ++var6_6;
        }
        var2_2.println();
    }

    protected void writeConstraintsCode(ASTSimpleType aSTSimpleType, ArrayList arrayList, Formatter formatter) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            ASTConstraint aSTConstraint = (ASTConstraint)arrayList.get(n2);
            if (aSTConstraint.isStringBased()) {
                this.writeStringBasedConstraint(aSTSimpleType, (ASTStringBasedConstraint)aSTConstraint, formatter);
            } else if (aSTConstraint.isBaseTypeBased()) {
                this.writeBaseTypeConstraint(aSTSimpleType, (ASTBaseTypeConstraint)aSTConstraint, formatter);
            } else {
                this.writeNumericConstraint(aSTSimpleType, (ASTNumericConstraint)aSTConstraint, formatter);
            }
            ++n2;
        }
    }

    protected void writeStringBasedConstraint(ASTSimpleType aSTSimpleType, ASTStringBasedConstraint aSTStringBasedConstraint, Formatter formatter) {
        if (aSTStringBasedConstraint.isWhiteSpace()) {
            return;
        }
        this.writeBaseTypeConstraint(aSTSimpleType, aSTStringBasedConstraint, formatter);
    }

    protected void writeBaseTypeConstraint(ASTSimpleType aSTSimpleType, ASTConstraint aSTConstraint, Formatter formatter) {
        String string = aSTSimpleType.getSimpleContentType();
        aSTConstraint.writeConstraintCode("val", string, formatter);
    }

    protected void writeNumericConstraint(ASTSimpleType aSTSimpleType, ASTNumericConstraint aSTNumericConstraint, Formatter formatter) {
        String string = aSTSimpleType.getSimpleContentType();
        String string2 = "_" + aSTNumericConstraint.getName() + "Val";
        String string3 = aSTNumericConstraint.getComparisonOperator();
        String string4 = this.getComparisonCode("val", string3, string2, string);
        formatter.println("if (" + string4 + ") throw new IllegalArgumentException(\"Invalid content as per " + aSTNumericConstraint.getName() + " constraint:\"+val);");
        formatter.println();
    }

    protected String getComparisonCode(String string, String string2, String string3, String string4) {
        if (PrimitiveUtil.isPrimitive(string4)) {
            return string + " " + string2 + " " + string3;
        }
        if (string2.equals(">")) {
            return string + ".compareTo(" + string3 + ") == 1";
        }
        if (string2.equals(">=")) {
            return string + ".compareTo(" + string3 + ") >= 0";
        }
        if (string2.equals("<")) {
            return string + ".compareTo(" + string3 + ") == -1";
        }
        if (string2.equals("<=")) {
            return string + ".compareTo(" + string3 + ") <= 0";
        }
        if (string2.equals("=")) {
            return string + ".compareTo(" + string3 + ") == 0";
        }
        throw new Error("invalid comparison operator:" + string2);
    }

    protected void writeFromString(ASTSimpleType aSTSimpleType, Formatter formatter) {
        formatter.print("public ");
        formatter.print(aSTSimpleType.fullName());
        formatter.print(" fromString(");
        formatter.print("java.lang.String");
        formatter.println(" value) { ");
        formatter.startBlock();
        formatter.println("return valueOf(value);");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    protected void writeValueOf(ASTSimpleType aSTSimpleType, Formatter formatter) {
        formatter.print("public ");
        formatter.print(aSTSimpleType.fullName());
        formatter.print(" valueOf(");
        formatter.print("java.lang.String");
        formatter.println(" value) { ");
        formatter.startBlock();
        formatter.print(aSTSimpleType.fullName());
        formatter.print(" val = ");
        formatter.print("new ");
        formatter.print(aSTSimpleType.fullName());
        formatter.println("(value);");
        formatter.println("return val;");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    protected void writeStringConstructor(String string, ASTSimpleType aSTSimpleType, Formatter formatter) {
        boolean bl;
        formatter.println(string + " " + aSTSimpleType.getName() + "(java.lang.String value) {");
        formatter.startBlock();
        String string2 = "value";
        boolean bl2 = bl = aSTSimpleType.getBaseClass() == null ? true : aSTSimpleType.getBaseClass().isBasic();
        if (bl) {
            formatter.println("if (value == null) throw new IllegalArgumentException(\"Can not instantiate simple type with null value!\");");
            String string3 = aSTSimpleType.getSimpleContentType();
            if (!string3.equals("java.lang.String")) {
                string2 = "cVal";
                formatter.println(string3 + " " + string2 + " = parse(value);");
            }
            formatter.println("setValue(" + string2 + ");");
        } else {
            formatter.println("super(value);");
            formatter.println("if (value == null) throw new IllegalArgumentException(\"Can not instantiate simple type with null value!\");");
            formatter.println("setValue(getValue());");
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    protected void writeBaseTypeConstructor(String string, ASTSimpleType aSTSimpleType, Formatter formatter) {
        boolean bl;
        String string2 = aSTSimpleType.getSimpleContentType();
        formatter.println(string + " " + aSTSimpleType.getName() + "(" + string2 + " value) {");
        formatter.startBlock();
        boolean bl2 = bl = aSTSimpleType.getBaseClass() == null ? true : aSTSimpleType.getBaseClass().isBasic();
        if (!bl) {
            formatter.println("super(value);");
        }
        if (!BeanWriter.isPrimitive(string2)) {
            formatter.println("if (value == null) throw new IllegalArgumentException(\"Can not instantiate simple type with null value!\");");
        }
        formatter.println("setValue(value);");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    protected void writeParse(ASTSimpleType aSTSimpleType, Formatter formatter) {
        String string = aSTSimpleType.getSimpleContentType();
        if (string.equals("java.lang.String")) {
            return;
        }
        formatter.println("private " + string + " parse(java.lang.String val) {");
        formatter.startBlock();
        String string2 = "cVal";
        formatter.print("return ");
        formatter.print(SimpleTypeUtil.getNewSimpleType(string, "val"));
        formatter.println(";");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    protected void writeJavaForEnums(ASTSimpleType aSTSimpleType, Formatter formatter) {
        formatter.println();
        ClassWriter.writeField("private", "_value", aSTSimpleType.getBaseClass().fullName(), null, formatter);
        formatter.println();
        this.writeEnumConstructor("protected", aSTSimpleType, formatter);
        formatter.println();
        this.writeEnumConstantFields(aSTSimpleType, formatter);
        formatter.println();
        this.writeEnumFromValue(aSTSimpleType, formatter);
        formatter.println();
        this.writeEnumFromString(aSTSimpleType, formatter);
        formatter.println();
        formatter.println();
        BeanWriter.writeGetMethod("_value", false, "value", aSTSimpleType.getBaseClass().fullName(), formatter);
        formatter.println();
        this.writeEnumtoString(aSTSimpleType, formatter);
        formatter.println();
        this.writeEnumequals(aSTSimpleType, formatter);
        formatter.println();
    }

    protected void writeEnumequals(ASTSimpleType aSTSimpleType, Formatter formatter) {
        formatter.println("public boolean equals(java.lang.Object obj) {");
        formatter.startBlock();
        formatter.println("if (obj == null) return false;");
        formatter.println("if (!(" + aSTSimpleType.fullName() + ".class.isAssignableFrom(obj.getClass()))) return false;");
        formatter.println(aSTSimpleType.fullName() + " object = (" + aSTSimpleType.fullName() + ") obj;");
        if (BeanWriter.isPrimitive(aSTSimpleType.getBaseClass().fullName())) {
            formatter.println("return (object.getValue() == this.getValue());");
        } else {
            formatter.println("return object.getValue().equals(this.getValue());");
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    protected void writeEnumtoString(ASTSimpleType aSTSimpleType, Formatter formatter) {
        if (BeanWriter.isPrimitive(aSTSimpleType.getBaseClass().fullName())) {
            formatter.println("public java.lang.String toString() {");
            formatter.startBlock();
            ArrayList arrayList = aSTSimpleType.getEnums();
            int n = 0;
            while (n < arrayList.size()) {
                ASTField aSTField = (ASTField)arrayList.get(n);
                String string = aSTField.getName();
                String string2 = aSTField.getXMLName().getLocalPart();
                formatter.println("if (_" + string + " == _value ) return \"" + string2 + "\";");
                ++n;
            }
            formatter.println("throw new java.lang.IllegalArgumentException(\"not in enumeration!\");");
            formatter.endBlock();
            formatter.println("}");
        } else {
            formatter.print("public java.lang.String toString() { return ");
            formatter.print("_value.toString()");
            formatter.println("; }");
        }
    }

    protected void writeEnumFromValue(ASTSimpleType aSTSimpleType, Formatter formatter) {
        boolean bl = BeanWriter.isPrimitive(aSTSimpleType.getBaseClass().fullName());
        formatter.println("public static " + aSTSimpleType.fullName() + " fromValue(" + aSTSimpleType.getBaseClass().fullName() + " value) {");
        formatter.startBlock();
        if (!bl) {
            formatter.println("if (value == null) throw new java.lang.IllegalArgumentException(\"can not instantiate enumeration with null value!\");");
        }
        ArrayList arrayList = aSTSimpleType.getEnums();
        int n = 0;
        while (n < arrayList.size()) {
            ASTField aSTField = (ASTField)arrayList.get(n);
            String string = aSTField.getName();
            String string2 = "_" + aSTField.getName();
            String string3 = aSTField.getXMLName().getLocalPart();
            if (bl) {
                formatter.println("if (value == " + string2 + ") " + "return " + string + ";");
            } else {
                formatter.println("if (value.equals(" + string2 + ")) " + "return " + string + ";");
            }
            ++n;
        }
        formatter.println("throw new java.lang.IllegalArgumentException(\">\"+value+\"< not in enumeration!\");");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    protected void writeEnumFromString(ASTSimpleType aSTSimpleType, Formatter formatter) {
        formatter.println("public static " + aSTSimpleType.fullName() + " fromString(" + "java.lang.String" + " value) {");
        formatter.startBlock();
        formatter.println("if (value == null) throw new java.lang.IllegalArgumentException(\"can not instantiate enumeration with null value!\");");
        ArrayList arrayList = aSTSimpleType.getEnums();
        int n = 0;
        while (n < arrayList.size()) {
            ASTField aSTField = (ASTField)arrayList.get(n);
            String string = aSTField.getName();
            String string2 = aSTField.getXMLName().getLocalPart();
            formatter.println("if (value.equals(\"" + string2 + "\"))" + " return " + string + ";");
            ++n;
        }
        formatter.println("throw new java.lang.IllegalArgumentException(\">\"+value+\"< not in enumeration!\");");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    protected void writeEnumConstantFields(ASTSimpleType aSTSimpleType, Formatter formatter) {
        ArrayList arrayList = aSTSimpleType.getEnums();
        int n = 0;
        while (n < arrayList.size()) {
            ASTField aSTField = (ASTField)arrayList.get(n);
            String string = aSTField.getName();
            String string2 = aSTField.getXMLName().getLocalPart();
            formatter.println();
            String string3 = aSTSimpleType.getBaseClass().fullName();
            String string4 = SimpleTypeUtil.getNewSimpleType(string3, '\"' + string2 + '\"');
            ClassWriter.writeField("public", "_" + string, string3, string4, true, true, false, formatter);
            ClassWriter.writeField("public", string, aSTSimpleType.getName(), "new " + aSTSimpleType.getName() + "(_" + string + ")", true, true, formatter);
            ++n;
        }
    }

    protected void writeEnumConstructor(String string, ASTSimpleType aSTSimpleType, Formatter formatter) {
        String string2 = aSTSimpleType.getBaseClass().fullName();
        formatter.print(string);
        formatter.print(" ");
        formatter.print(aSTSimpleType.getName());
        formatter.print("(");
        formatter.print(string2);
        formatter.println(" value) {");
        formatter.startBlock();
        formatter.println("_value = value;");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    protected void writeEquals(ASTSimpleType aSTSimpleType, Formatter formatter) {
        formatter.println("public boolean equals(java.lang.Object object) {");
        formatter.startBlock();
        formatter.println("if (object == null) return false;");
        formatter.println("if (!(" + aSTSimpleType.fullName() + ".class.isAssignableFrom(object.getClass()))) return false;");
        formatter.println(aSTSimpleType.fullName() + " obj = (" + aSTSimpleType.fullName() + ") object;");
        formatter.println();
        String string = aSTSimpleType.getSimpleContentType();
        if (PrimitiveUtil.isPrimitive(string)) {
            formatter.println("return (_value == obj._value);");
        } else {
            formatter.println("return obj._value.equals(_value);");
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    private void writeJavaForUnion(ASTSimpleType aSTSimpleType, Formatter formatter) {
        ClassWriter.writeField("public static final", _UNKNOWN, "int", "-1", formatter);
        formatter.println();
        ClassWriter.writeField("private ", "_union_value_discriminator", "int", _UNKNOWN, formatter);
        formatter.println();
        BeanWriter.writeGetMethod("_union_value_discriminator", false, "unionValueDiscriminator", "int", formatter);
        formatter.println();
        this.writeUnionMethods(aSTSimpleType, formatter);
        formatter.println();
        this.writeUnionEquals(aSTSimpleType, formatter);
        formatter.println();
        BeanWriter.writeHashCode(aSTSimpleType, formatter);
        formatter.println();
        this.writeUnionBCCode(aSTSimpleType, formatter);
        formatter.println();
    }

    private void writeUnionMethods(ASTSimpleType aSTSimpleType, Formatter formatter) {
        this.writeUnionStringConstructor(aSTSimpleType, formatter);
        formatter.println();
        String[][] stringArray = aSTSimpleType.getUnionMemberTypes();
        String[] stringArray2 = stringArray[0];
        String[] stringArray3 = stringArray[1];
        boolean bl = false;
        int n = 0;
        while (n < stringArray2.length) {
            String string = stringArray2[n];
            String string2 = stringArray3[n];
            bl = "java.lang.String".equals(string);
            ClassWriter.writeField("private", '_' + string2 + "_value", string, null, formatter);
            formatter.println();
            String string3 = string2.toUpperCase() + "_TYPE";
            ClassWriter.writeField("public static final", string3, "int", "" + n, formatter);
            formatter.println();
            if (!bl) {
                this.writeUnionConstructor(string, string2, aSTSimpleType, formatter);
                formatter.println();
            }
            this.writeUnionGetMethod(string, string2, aSTSimpleType, formatter);
            formatter.println();
            this.writeUnionSetMethod(string, string2, aSTSimpleType, formatter);
            formatter.println();
            this.writeUnionParseMethod(string, string2, aSTSimpleType, formatter);
            formatter.println();
            ++n;
        }
        ClassWriter.writeField("private", "_union_value", "java.lang.String", null, formatter);
        formatter.println();
        this.writeUnionToString(aSTSimpleType, formatter);
        formatter.println();
    }

    private void writeUnionConstructor(String string, String string2, ASTSimpleType aSTSimpleType, Formatter formatter) {
        String string3 = BeanWriter.setMethodName(string2);
        formatter.print("public ");
        formatter.print(aSTSimpleType.getName());
        formatter.print('(');
        formatter.print(string);
        formatter.println(" value) {");
        formatter.startBlock();
        formatter.print(string3);
        formatter.println("(value);");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    private void writeUnionStringConstructor(ASTSimpleType aSTSimpleType, Formatter formatter) {
        formatter.print("public ");
        formatter.print(aSTSimpleType.getName());
        formatter.print('(');
        formatter.print("java.lang.String");
        formatter.println(" value) {");
        formatter.startBlock();
        formatter.println("if (value == null) throw new IllegalArgumentException(\"Can not instantiate simple type with null value!\");");
        formatter.println("_union_value = value;");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    private void writeUnionGetMethod(String string, String string2, ASTSimpleType aSTSimpleType, Formatter formatter) {
        String string3 = BeanWriter.getMethodName(string2);
        String string4 = BeanWriter.setMethodName(string2);
        String string5 = string2.toUpperCase() + "_TYPE";
        String string6 = "parse_" + string2;
        String string7 = '_' + string2 + "_value";
        formatter.print("public ");
        formatter.print(string);
        formatter.print(' ');
        formatter.print(string3);
        formatter.println("() {");
        formatter.startBlock();
        formatter.println("if (_union_value_discriminator == " + string5 + ") return " + string7 + ";");
        formatter.println("if (_union_value_discriminator == UNKNOWN) {");
        formatter.startBlock();
        if ("java.lang.String".equals(string)) {
            formatter.println(string4 + "(_union_value);");
        } else {
            formatter.println(string4 + '(' + string6 + "(_union_value));");
        }
        formatter.println("return " + string7 + ";");
        formatter.endBlock();
        formatter.println("}");
        formatter.println("throw new IllegalArgumentException(\"union type is not " + string + "\");");
        formatter.endBlock();
        formatter.println("}");
    }

    private void writeUnionSetMethod(String string, String string2, ASTSimpleType aSTSimpleType, Formatter formatter) {
        String string3 = BeanWriter.setMethodName(string2);
        String string4 = string2.toUpperCase() + "_TYPE";
        String string5 = '_' + string2 + "_value";
        formatter.print("public void ");
        formatter.print(string3);
        formatter.print(" (");
        formatter.print(string);
        formatter.println(" value) {");
        formatter.startBlock();
        formatter.println(string5 + " = value;");
        formatter.println("_union_value_discriminator = " + string4 + ";");
        formatter.endBlock();
        formatter.println("}");
    }

    private void writeUnionParseMethod(String string, String string2, ASTSimpleType aSTSimpleType, Formatter formatter) {
        String string3 = "parse_" + string2;
        formatter.print("private ");
        formatter.print(string);
        formatter.print(' ');
        formatter.print(string3);
        formatter.println("(java.lang.String value) {");
        formatter.startBlock();
        formatter.println("try {");
        formatter.startBlock();
        formatter.print("return ");
        formatter.print(SimpleTypeUtil.getNewSimpleType(string, "value"));
        formatter.println(';');
        formatter.endBlock();
        formatter.println("} catch(Throwable e) {");
        formatter.startBlock();
        formatter.println("throw new IllegalArgumentException(e.getMessage());");
        formatter.endBlock();
        formatter.println("}");
        formatter.endBlock();
        formatter.println("}");
    }

    private void writeUnionToString(ASTSimpleType aSTSimpleType, Formatter formatter) {
        String[][] stringArray = aSTSimpleType.getUnionMemberTypes();
        formatter.println("public java.lang.String toString() { ");
        formatter.startBlock();
        formatter.println("switch(_union_value_discriminator) {");
        formatter.startBlock();
        String[] stringArray2 = stringArray[0];
        String[] stringArray3 = stringArray[1];
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            String string2 = stringArray3[n2];
            String string3 = string2.toUpperCase() + "_TYPE";
            String string4 = BeanWriter.getMethodName(string2);
            formatter.print("case ");
            formatter.print(string3);
            formatter.print(": return ");
            formatter.print(SimpleTypeUtil.getSimpleTypeContent(string, string4 + "()"));
            formatter.println(";");
            ++n2;
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println("return _union_value;");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    private void writeUnionEquals(ASTSimpleType aSTSimpleType, Formatter formatter) {
        String[][] stringArray = aSTSimpleType.getUnionMemberTypes();
        formatter.println("public boolean equals(java.lang.Object object) { ");
        formatter.startBlock();
        formatter.println("if (object == null) return false;");
        formatter.println("return this.toString().equals(object.toString());");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    private void writeUnionBCCode(ASTSimpleType aSTSimpleType, Formatter formatter) {
        formatter.println("/**@deprecated since jBrokerWeb 2.0*/");
        formatter.println("public java.lang.String getValue() { return toString();  }");
        formatter.println();
        formatter.println("/**@deprecated since jBrokerWeb 2.0*/");
        formatter.println("public void setValue(java.lang.String val) {");
        formatter.startBlock();
        formatter.println("_union_value = val;");
        formatter.println("_union_value_discriminator = UNKNOWN;");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
        this.writeSimpleBCCode(aSTSimpleType, formatter);
    }

    private void writeSimpleBCCode(ASTSimpleType aSTSimpleType, Formatter formatter) {
        formatter.println("/**@deprecated since jBrokerWeb 2.0 use getValue*/");
        formatter.println("public java.lang.String getContent() { return getValue(); }");
        formatter.println();
        formatter.println("/**@deprecated since jBrokerWeb 2.0 use setValue*/");
        formatter.println("public void setContent(java.lang.String val) { setValue(val); }");
        formatter.println();
    }

    private void writeJavaForList(ASTSimpleType aSTSimpleType, Formatter formatter) {
        String string = aSTSimpleType.getListItemType();
        String string2 = string + "[]";
        this.writeListConstructors(aSTSimpleType, formatter);
        formatter.println();
        BeanWriter.writeBeanReadProperty("value", string2, formatter);
        formatter.println();
        this.writeListSetValue(aSTSimpleType, formatter);
        formatter.println();
        this.writeListParse(aSTSimpleType, formatter);
        formatter.println();
        this.writeListToString(aSTSimpleType, formatter);
        formatter.println();
        this.writeUnionEquals(aSTSimpleType, formatter);
        formatter.println();
        BeanWriter.writeHashCode(aSTSimpleType, formatter);
        formatter.println();
        this.writeListBCCode(aSTSimpleType, formatter);
        formatter.println();
    }

    private void writeListConstructors(ASTSimpleType aSTSimpleType, Formatter formatter) {
        this.writeListArrayConstructor(aSTSimpleType, formatter);
        this.writeListStringConstructor(aSTSimpleType, formatter);
    }

    private void writeListArrayConstructor(ASTSimpleType aSTSimpleType, Formatter formatter) {
        String string = aSTSimpleType.getListItemType() + "[]";
        formatter.print("public ");
        formatter.print(aSTSimpleType.getName());
        formatter.print('(');
        formatter.print(string);
        formatter.print(" value) { setValue(value); }");
        formatter.println();
    }

    private void writeListStringConstructor(ASTSimpleType aSTSimpleType, Formatter formatter) {
        formatter.print("public ");
        formatter.print(aSTSimpleType.getName());
        formatter.print('(');
        formatter.print("java.lang.String");
        formatter.print(" value) { setValue(parse(value)); }");
        formatter.println();
    }

    private void writeListParse(ASTSimpleType aSTSimpleType, Formatter formatter) {
        String string = aSTSimpleType.getListItemType();
        String string2 = string + "[]";
        formatter.print("private ");
        formatter.print(string2);
        formatter.println(" parse(java.lang.String value) {");
        formatter.startBlock();
        formatter.println("try {");
        formatter.startBlock();
        formatter.println("value = value.trim();");
        formatter.println("java.util.StringTokenizer st = new java.util.StringTokenizer(value, \" \");");
        formatter.println("java.util.ArrayList tokens = new java.util.ArrayList();");
        formatter.println("while(st.hasMoreTokens())");
        formatter.startBlock();
        formatter.println("tokens.add(st.nextToken());");
        formatter.endBlock();
        formatter.println("int len = tokens.size();");
        String string3 = string + "[len]";
        if (string.equals("byte[]")) {
            string3 = "byte[len][]";
        }
        formatter.println(string2 + " array = new " + string3 + ";");
        formatter.println("for (int i=0; i < len; i++) {");
        formatter.startBlock();
        formatter.print("array[i] = ");
        formatter.print(SimpleTypeUtil.getNewSimpleType(string, "(java.lang.String)tokens.get(i)"));
        formatter.println(';');
        formatter.endBlock();
        formatter.println("}");
        formatter.println("return array;");
        formatter.endBlock();
        formatter.println("} catch(Throwable e) {");
        formatter.startBlock();
        formatter.println("throw new IllegalArgumentException(e.getMessage());");
        formatter.endBlock();
        formatter.println("}");
        formatter.endBlock();
        formatter.println("}");
    }

    protected void writeListSetValue(ASTSimpleType aSTSimpleType, Formatter formatter) {
        String string = aSTSimpleType.getListItemType();
        String string2 = string + "[]";
        formatter.println("public void setValue(" + string2 + " val) {");
        formatter.startBlock();
        formatter.println("if (val == null) throw new IllegalArgumentException(\"Can not set null value for simple content!\");");
        formatter.println("_value = val;");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    private void writeListToString(ASTSimpleType aSTSimpleType, Formatter formatter) {
        String string = aSTSimpleType.getListItemType();
        String string2 = string + "[]";
        formatter.println("public java.lang.String toString() {  return getContent(_value); }");
        formatter.println();
        formatter.println("protected static java.lang.String getContent(" + string2 + " val) {");
        formatter.startBlock();
        formatter.println("java.lang.StringBuffer sb = new java.lang.StringBuffer();");
        formatter.println("for (int i=0; i < val.length; i++) {");
        formatter.startBlock();
        formatter.print("sb.append(");
        formatter.print(SimpleTypeUtil.getSimpleTypeContent(string, "val[i]"));
        formatter.println(");");
        formatter.println("if (i == val.length -1) break;");
        formatter.println("sb.append(' ');");
        formatter.endBlock();
        formatter.println("}");
        formatter.println("return new java.lang.String(sb);");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    private void writeListBCCode(ASTSimpleType aSTSimpleType, Formatter formatter) {
        formatter.println("/**@deprecated since jBrokerWeb 2.0 use getValue*/");
        formatter.println("public java.lang.String getContent() { return toString(); }");
        formatter.println();
        formatter.println("/**@deprecated since jBrokerWeb 2.0 use setValue*/");
        formatter.println("public void setContent(java.lang.String val) { setValue(parse(val)); }");
        formatter.println();
    }

    protected boolean isArray(String string) {
        return string.lastIndexOf("[]") != -1;
    }
}

