/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.xsd2java;

import com.sssw.jbroker.tools.xsd2java.BeanWriter;
import com.sssw.jbroker.tools.xsd2java.ClassWriter;
import com.sssw.jbroker.tools.xsd2java.SimpleBeanWriter;
import com.sssw.jbroker.tools.xsd2java.SimpleTypeUtil;
import com.sssw.jbroker.tools.xsd2java.ast.ASTClass;
import com.sssw.jbroker.tools.xsd2java.ast.ASTField;
import com.sssw.jbroker.tools.xsd2java.ast.ASTSimpleContent;
import com.sssw.jbroker.tools.xsd2java.ast.ASTSimpleType;
import com.sssw.jbroker.util.Formatter;
import com.sssw.jbroker.util.PrimitiveUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class SimpleContentWriter
extends SimpleBeanWriter {
    public static void writeBean(ASTSimpleContent aSTSimpleContent, Map map, Formatter formatter) {
        SimpleContentWriter simpleContentWriter = new SimpleContentWriter(map);
        simpleContentWriter.writeBean(aSTSimpleContent, formatter);
    }

    public SimpleContentWriter(Map map) {
        super(map);
    }

    public void writeBean(ASTSimpleContent aSTSimpleContent, Formatter formatter) {
        boolean bl;
        if (aSTSimpleContent.getPackage() != null && aSTSimpleContent.getPackage().length() > 0) {
            formatter.println("package " + aSTSimpleContent.getPackage() + ";");
        }
        formatter.println();
        formatter.print("public ");
        formatter.print(this._final ? "final class " : "class ");
        formatter.println(aSTSimpleContent.getName());
        ASTClass aSTClass = aSTSimpleContent.getBaseClass();
        boolean bl2 = bl = aSTSimpleContent.getBaseClass() == null ? true : aSTSimpleContent.getBaseClass().isBasic();
        if (aSTClass != null && aSTClass.fullName().equals("java.lang.String")) {
            bl = true;
        }
        if (!aSTSimpleContent.isEnum()) {
            if (!bl) {
                if (aSTSimpleContent.isException()) {
                    formatter.println("    extends " + aSTSimpleContent.getBaseClass().getPackage() + "." + aSTSimpleContent.getBaseClass().getExceptionName());
                } else {
                    formatter.println("    extends " + aSTSimpleContent.getBaseClass().fullName());
                }
            } else if (aSTSimpleContent.isException()) {
                formatter.println("    extends java.lang.Exception");
            }
        } else if (aSTSimpleContent.isException()) {
            formatter.println("    extends java.lang.Exception");
        }
        formatter.println(" implements java.io.Serializable");
        formatter.println("{");
        formatter.startBlock();
        this.writeJavaForSimpleType(aSTSimpleContent, formatter);
        this.writeBeanProperties(aSTSimpleContent.getAttributes(), formatter);
        this.writeFixedValuesForAttributes(aSTSimpleContent, formatter);
        if (aSTSimpleContent.hasAnyAttributes()) {
            this.writeOtherAttributesProperty(formatter);
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.flush();
        formatter.close();
    }

    protected void writeOtherAttributesProperty(Formatter formatter) {
        this.writeBeanProperty("otherAttributes", "com.sssw.jbroker.web.encoding.Attribute[]", formatter);
    }

    protected void writeEquals(ASTSimpleType aSTSimpleType, Formatter formatter) {
        boolean bl;
        ASTSimpleContent aSTSimpleContent = (ASTSimpleContent)aSTSimpleType;
        formatter.println("public boolean equals(java.lang.Object object) {");
        formatter.startBlock();
        formatter.println("if (object == null) return false;");
        formatter.println("if (!(" + aSTSimpleContent.fullName() + ".class.isAssignableFrom(object.getClass()))) return false;");
        formatter.println(aSTSimpleContent.fullName() + " obj = (" + aSTSimpleContent.fullName() + ") object;");
        formatter.println();
        this.writeEqualsForFields(aSTSimpleContent.getAttributes(), formatter);
        formatter.println();
        String string = aSTSimpleContent.getSimpleContentType();
        if (PrimitiveUtil.isPrimitive(string)) {
            formatter.println("if (_value != obj._value) return false;");
        } else {
            formatter.println("if (!obj._value.equals(_value)) return false;");
        }
        boolean bl2 = bl = aSTSimpleContent.getBaseClass() == null ? true : aSTSimpleContent.getBaseClass().isBasic();
        if (bl) {
            formatter.println("return true;");
        } else {
            formatter.println("return super.equals(obj);");
        }
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
    }

    protected void writeEqualsForFields(ArrayList arrayList, Formatter formatter) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            ASTField aSTField = (ASTField)arrayList.get(n2);
            this.writeEqualsForField(aSTField, formatter);
            ++n2;
        }
        formatter.println();
    }

    protected void writeEqualsForField(ASTField aSTField, Formatter formatter) {
        if (this._validationRequired && aSTField.getFixed() != null) {
            return;
        }
        String string = "_" + aSTField.getName();
        if (PrimitiveUtil.isPrimitive(aSTField.getClassName())) {
            formatter.println("if (this." + string + " != obj." + string + ") return false;");
            formatter.println();
            return;
        }
        formatter.println("if (" + string + " == null) {");
        formatter.startBlock();
        formatter.println("if (obj." + string + " != null) return false;");
        formatter.endBlock();
        formatter.println("} else if (!" + string + ".equals(obj." + string + ")) return false;");
        formatter.println();
    }

    protected String getFixedVarName(String string, String string2) {
        return string + "_" + string2 + "_fixed";
    }

    protected void writeFixedValuesForAttributes(ASTSimpleContent aSTSimpleContent, Formatter formatter) {
        ArrayList arrayList = aSTSimpleContent.getAttributes();
        int n = 0;
        while (n < arrayList.size()) {
            ASTField aSTField = (ASTField)arrayList.get(n);
            this.writeFixedValueForField(aSTField, formatter);
            ++n;
        }
    }

    protected void writeFixedValueForField(ASTField aSTField, Formatter formatter) {
        String string = aSTField.getFixed();
        if (string == null) {
            return;
        }
        String string2 = this.getFixedVarName("", aSTField.getName());
        String string3 = "get" + string2 + "()";
        ClassWriter.writeField("public", string2, aSTField.getClassName(), string3, true, true, formatter);
        formatter.println("private static " + aSTField.getClassName() + " " + string3 + " {");
        formatter.startBlock();
        formatter.println("try {");
        formatter.startBlock();
        string = "\"" + string + "\"";
        string = SimpleTypeUtil.getNewSimpleType(aSTField.getClassName(), string);
        formatter.println("return " + string + ";");
        formatter.endBlock();
        formatter.println("} catch(Exception e) { throw new RuntimeException(e.getMessage()); }");
        formatter.endBlock();
        formatter.println("}");
        formatter.println();
        BeanWriter.writeGetMethod(string2, false, aSTField.getName(), aSTField.getClassName(), formatter);
        this.writeSetMethod(aSTField, formatter);
    }

    protected void writeBeanProperties(ArrayList arrayList, Formatter formatter) {
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            ASTField aSTField = (ASTField)iterator.next();
            this.writeBeanProperty(aSTField, formatter);
        }
    }
}

