/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.xsd2java.ast;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.QName;

public class ASTClass {
    private String _package;
    private String _name;
    private boolean _isMixed = false;
    private boolean _isValidationRequired = false;
    private ASTClass _baseClass;
    private String _super;
    private boolean _isBasic;
    private ArrayList _methods = new ArrayList(8);
    private QName _xmlType;
    private boolean _generateBean = true;
    private boolean _generateMarsh = true;
    private boolean _isArray = false;
    private String _arrayType;
    private String _finalDerivation;
    protected static final String _JLO = "java.lang.Object";
    private boolean _isException;

    public ASTClass() {
    }

    public ASTClass(Class clazz) {
        if (!clazz.isPrimitive() && !clazz.isArray()) {
            this._package = clazz.getPackage().getName();
        }
        this._name = clazz.getName();
        int n = this._name.lastIndexOf(".");
        if (n > 0) {
            this._name = this._name.substring(n + 1);
        }
    }

    public ASTClass(String string) {
        int n = string.lastIndexOf(".");
        this._name = string.substring(n + 1);
        if (n == -1) {
            return;
        }
        this._package = string.substring(0, n);
    }

    public String getPackage() {
        return this._package;
    }

    public void setPackage(String string) {
        this._package = string;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public boolean isMixed() {
        return this._isMixed;
    }

    public void setMixed(boolean bl) {
        this._isMixed = bl;
    }

    public boolean isValidationRequired() {
        return this._isValidationRequired;
    }

    public void setValidationRequired(boolean bl) {
        this._isValidationRequired = bl;
    }

    public ASTClass getBaseClass() {
        return this._baseClass;
    }

    public void setBaseClass(ASTClass aSTClass) {
        this._baseClass = aSTClass;
        this._super = aSTClass != null ? aSTClass.fullName() : null;
    }

    public String getSuperClass() {
        return this._super;
    }

    public boolean isBasic() {
        return this._isBasic;
    }

    public void setBasic(boolean bl) {
        this._isBasic = bl;
    }

    public ArrayList getMethods() {
        return this._methods;
    }

    public void addMethod(String string) {
        this._methods.add(string);
    }

    public QName getTypeQName() {
        return this._xmlType;
    }

    public void setTypeQName(QName qName) {
        this._xmlType = qName;
    }

    public QName getXMLType() {
        return this._xmlType;
    }

    public void setXMLType(QName qName) {
        this._xmlType = qName;
    }

    public void setGenerateBean(boolean bl) {
        this._generateBean = bl;
    }

    public boolean generateBean() {
        return this._generateBean;
    }

    public void setGenerateMarshaller(boolean bl) {
        this._generateMarsh = bl;
    }

    public boolean generateMarshaller() {
        return this._generateMarsh;
    }

    public String fullName() {
        return this._package != null && this._package.trim().length() > 0 ? this._package + "." + this._name : this._name;
    }

    public String getExceptionName() {
        String string = this._name;
        int n = this._name.indexOf("_Type");
        if (n != -1) {
            string = this._name.substring(0, n);
        }
        string = string + "_Exception";
        return string;
    }

    public String toString() {
        return this.fullName();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            ASTClass aSTClass = (ASTClass)object;
            if (this.fullName() == null) {
                return this.hashCode() == object.hashCode();
            }
            return this == aSTClass;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean isArray() {
        return this._isArray;
    }

    public void setArray(boolean bl) {
        this._isArray = bl;
    }

    public String getArrayType() {
        return this._arrayType;
    }

    public void setArrayType(String string) {
        this._arrayType = string;
    }

    public String getFinalDerivation() {
        return this._finalDerivation;
    }

    public void setFinalDerivation(String string) {
        this._finalDerivation = string;
    }

    public boolean isRestrictionFinal() {
        if (this._finalDerivation == null) {
            return false;
        }
        return this._finalDerivation.equals("restriction");
    }

    public boolean isExtensionFinal() {
        if (this._finalDerivation == null) {
            return false;
        }
        return this._finalDerivation.equals("extension");
    }

    public void eraseFailedTypes(HashSet hashSet) {
        if (hashSet.contains(this._super)) {
            this.replaceSuper(null);
        }
    }

    public void replaceTypes(Map map) {
        if (this._baseClass == null) {
            return;
        }
        String string = (String)map.get(this._baseClass.fullName());
        if (string != null) {
            this.replaceSuper(string);
        }
    }

    protected void replaceSuper(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            this._baseClass.setPackage(null);
            this._baseClass.setName(string);
        } else {
            this._baseClass.setPackage(string.substring(0, n));
            this._baseClass.setName(string.substring(n + 1));
        }
        this.setBaseClass(this._baseClass);
    }

    public boolean isSimpleContent() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    public boolean isComplex() {
        return false;
    }

    public boolean isModel() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isException() {
        return this._isException;
    }

    public void setException(boolean bl) {
        this._isException = bl;
    }
}

