/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.tools.xsd2java.ast;

import com.sssw.jbroker.tools.xsd2java.ast.ASTStringBasedConstraint;
import com.sssw.jbroker.util.Formatter;

public class ASTWhiteSpace
extends ASTStringBasedConstraint {
    private static String _PRESERVE = "preserve";
    private static String _REPLACE = "replace";
    private static String _COLLAPSE = "collapse";

    public ASTWhiteSpace(String string, boolean bl) {
        super("whiteSpace", string, bl);
    }

    public boolean isWhiteSpace() {
        return true;
    }

    public void writeConstraintCode(String string, String string2, Formatter formatter) {
        super.writeConstraintCode(string, string2, formatter);
        formatter.print("//");
        formatter.println(this.getValue());
        if (this.getValue().equals(_PRESERVE)) {
            return;
        }
        if (this.getValue().equals(_COLLAPSE)) {
            this.writeCollapseCode(string, formatter);
        }
        if (this.getValue().equals(_REPLACE)) {
            this.writeReplaceCode(string, formatter);
        }
    }

    private void writeReplaceCode(String string, Formatter formatter) {
        formatter.print("java.lang.StringBuffer sb = ");
        formatter.println("new java.lang.StringBuffer();");
        formatter.println("int len = " + string + ".length();");
        formatter.println("char c;");
        formatter.println("for(int i=0; i < len; i++) {");
        formatter.startBlock();
        formatter.println("c = " + string + ".charAt(i);");
        formatter.print("if (java.lang.Character.isWhitespace(c)) ");
        formatter.println("sb.append(' ');");
        formatter.println("else sb.append(c);");
        formatter.endBlock();
        formatter.println("}");
        formatter.println(string + " = new java.lang.String(sb);");
    }

    private void writeCollapseCode(String string, Formatter formatter) {
        formatter.print("java.lang.StringBuffer sb = ");
        formatter.println("new java.lang.StringBuffer();");
        formatter.println("int len = " + string + ".length();");
        formatter.println("char pc,c;");
        formatter.println("pc = c = (char) -1;");
        formatter.println("for(int i=0; i < len; i++) {");
        formatter.startBlock();
        formatter.println("c = " + string + ".charAt(i);");
        formatter.println("if (java.lang.Character.isWhitespace(c)) {");
        formatter.startBlock();
        formatter.println("c =' ';");
        formatter.println("if (pc != c) sb.append(c);");
        formatter.endBlock();
        formatter.println("} else sb.append(c);");
        formatter.println("pc =c;");
        formatter.endBlock();
        formatter.println("}");
        formatter.println(string + " = new java.lang.String(sb).trim();");
    }
}

