/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.util;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Configurator {
    private static final boolean _debug = false;
    private final String _resourceName;
    private final Hashtable _configurations;
    private final ConfigurationFactory _configFactory;

    public Configurator(String string, ConfigurationFactory configurationFactory) {
        this._resourceName = string;
        this._configFactory = configurationFactory;
        this._configurations = new Hashtable(5);
    }

    public final Properties getConfiguration(String string) {
        return (Properties)this._configurations.get(string);
    }

    public void addConfiguration(String string, Properties properties) {
        this._configurations.put(string, properties);
    }

    public final Enumeration getConfigurations() {
        return this._configurations.elements();
    }

    public final void loadConfiguration() {
        this.loadConfiguration(this.getClass().getClassLoader());
    }

    public final void loadConfiguration(ClassLoader classLoader) {
        try {
            Object object;
            Object object2;
            Properties properties;
            Enumeration<URL> enumeration = classLoader.getResources(this._resourceName);
            Vector<Properties> vector = new Vector<Properties>();
            while (enumeration.hasMoreElements()) {
                properties = new Properties();
                object2 = enumeration.nextElement();
                if (object2 instanceof URL) {
                    object = ((URL)object2).openStream();
                    properties.load((InputStream)object);
                }
                vector.addElement(properties);
            }
            if (vector.size() == 0) {
                try {
                    properties = new Properties();
                    properties.load(classLoader.getResourceAsStream(this._resourceName));
                    vector.addElement(properties);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                properties = (Properties)((Object)enumeration.nextElement());
                object2 = properties.propertyNames();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    String string = properties.getProperty((String)object);
                    int n = ((String)object).indexOf(46);
                    String string2 = ((String)object).substring(0, n);
                    object = ((String)object).substring(n + 1);
                    Properties properties2 = this.getConfiguration(string2);
                    if (properties2 == null) {
                        properties2 = this._configFactory.create(string2);
                        this.addConfiguration(string2, properties2);
                    }
                    properties2.setProperty((String)object, string);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static interface ConfigurationFactory {
        public Properties create(String var1);
    }
}

