/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class FileClassLoader
extends ClassLoader {
    private static final boolean _debug = false;
    private JarFile _file;
    private File _path;

    public FileClassLoader(ClassLoader classLoader, JarFile jarFile) {
        super(classLoader);
        this._file = jarFile;
    }

    public FileClassLoader(ClassLoader classLoader, File file) {
        super(classLoader);
        this._path = file.isAbsolute() ? file : file.getAbsoluteFile();
    }

    public Class findClass(String string) throws ClassNotFoundException {
        try {
            int n;
            InputStream inputStream;
            Object object;
            if (this._file != null) {
                object = string.replace('.', '/') + ".class";
                JarEntry jarEntry = (JarEntry)this._file.getEntry((String)object);
                if (jarEntry == null) {
                    throw new ClassNotFoundException();
                }
                inputStream = this._file.getInputStream(jarEntry);
            } else {
                object = new File(this._path, string.replace('.', File.separatorChar) + ".class");
                inputStream = new FileInputStream((File)object);
            }
            object = new byte[1024];
            int n2 = 0;
            while ((n = inputStream.read((byte[])object, n2, 1024)) != -1) {
                if (1024 + (n2 += n) <= ((Object)object).length) continue;
                byte[] byArray = new byte[2 * ((Object)object).length];
                System.arraycopy(object, 0, byArray, 0, ((Object)object).length);
                object = byArray;
            }
            return this.defineClass(string, (byte[])object, 0, n2);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException();
        }
    }

    public InputStream getResourceAsStream(String string) {
        if (this._file != null) {
            JarEntry jarEntry = (JarEntry)this._file.getEntry(string);
            if (jarEntry == null) {
                return null;
            }
            try {
                return this._file.getInputStream(jarEntry);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        try {
            File file = new File(this._path, string);
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

