/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.util;

import java.io.OutputStream;
import java.io.PrintWriter;

public final class Formatter
extends PrintWriter {
    String _tab;
    int _numIndent = 0;
    boolean _doIndent = true;
    static String FOUR_SPACES = "    ";

    public Formatter(PrintWriter printWriter) {
        this(FOUR_SPACES, printWriter);
    }

    public Formatter(String string, PrintWriter printWriter) {
        super(printWriter);
        this._tab = string;
    }

    public Formatter(OutputStream outputStream) {
        this(FOUR_SPACES, outputStream);
    }

    public Formatter(String string, OutputStream outputStream) {
        super(outputStream);
        this._tab = string;
    }

    public void startBlock(String string) {
        this.println(string);
        this.startBlock();
    }

    public void endBlock(String string) {
        this.endBlock();
        this.println(string);
    }

    public void startBlock() {
        ++this._numIndent;
    }

    public void endBlock() {
        --this._numIndent;
    }

    public void print(String string) {
        if (this._doIndent) {
            int n = 0;
            while (n < this._numIndent) {
                super.print(this._tab);
                ++n;
            }
        }
        super.print(string);
        this._doIndent = false;
    }

    public void printHeading(String string) {
        this.println("//");
        this.println("// " + string);
        this.println("//");
    }

    public void println() {
        this.println("");
    }

    public void println(String string) {
        this.print(string);
        this.print("\n");
        this._doIndent = true;
    }
}

