/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.util;

public class IntHashtable {
    private int _count = 0;
    private int _threshold;
    private float _loadFactor;
    private int _initialCapacity;
    private Object[] _keys;
    private int[] _values;
    private static final boolean _debug = false;

    public IntHashtable() {
        this(99, 0.75f);
    }

    public IntHashtable(int n) {
        this(n, 0.75f);
    }

    public IntHashtable(int n, float f) {
        this._loadFactor = f;
        this._initialCapacity = n;
    }

    public void put(Object object, int n) {
        int n2;
        int n3;
        if (object == null) {
            throw new IllegalArgumentException("null key");
        }
        if (this._keys == null || this._count > this._threshold) {
            this.growCache();
        }
        if (this._keys[n3 = ((n2 = System.identityHashCode(object)) & Integer.MAX_VALUE) % this._keys.length] == null) {
            this._keys[n3] = object;
            this._values[n3] = n;
        } else {
            boolean bl = false;
            int n4 = n3 + 1;
            while (n4 < this._keys.length) {
                if (this._keys[n4] == null) {
                    this._keys[n4] = object;
                    this._values[n4] = n;
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                int n5 = 0;
                while (n5 < n3) {
                    if (this._keys[n5] == null) {
                        this._keys[n5] = object;
                        this._values[n5] = n;
                        break;
                    }
                    ++n5;
                }
            }
        }
        ++this._count;
    }

    public int size() {
        return this._count;
    }

    public boolean contains(Object object) {
        return this.get(object) != -1;
    }

    public int get(Object object) {
        if (this._keys != null) {
            int n = System.identityHashCode(object);
            int n2 = (n & Integer.MAX_VALUE) % this._keys.length;
            Object object2 = this._keys[n2];
            if (object2 == null) {
                return -1;
            }
            if (object2 == object) {
                return this._values[n2];
            }
            int n3 = n2 + 1;
            while (n3 < this._keys.length) {
                object2 = this._keys[n3];
                if (object2 == null) {
                    return -1;
                }
                if (object2 == object) {
                    return this._values[n3];
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < n2) {
                object2 = this._keys[n4];
                if (object2 == null) {
                    return -1;
                }
                if (object2 == object) {
                    return this._values[n4];
                }
                ++n4;
            }
        }
        return -1;
    }

    public void growCache() {
        if (this._keys == null) {
            this._keys = new Object[this._initialCapacity];
            this._values = new int[this._initialCapacity];
        } else {
            int n = this._keys.length;
            int n2 = n * 2 + 1;
            int[] nArray = this._values;
            Object[] objectArray = this._keys;
            this._values = new int[n2];
            this._keys = new Object[n2];
            this._count = 0;
            int n3 = 0;
            while (n3 < n) {
                if (objectArray[n3] != null) {
                    this.put(objectArray[n3], nArray[n3]);
                }
                ++n3;
            }
        }
        this._threshold = (int)((float)this._keys.length * this._loadFactor);
    }
}

