/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.util;

import com.sssw.jbroker.util.ClassUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;

public class JavaUtil {
    private static PrintStream out = System.out;
    public static HashSet reservedWords = new HashSet();

    private static boolean isPunct(char c) {
        return c == '.' || c == '-' || c == ':' || c == '_' || c == '\u00b7' || c == '\u0387' || c == '\u06dd' || c == '\u06de';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9' || Character.isDigit(c);
    }

    private static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z' || Character.isUpperCase(c);
    }

    private static boolean isLower(char c) {
        return c >= 'a' && c <= 'z' || Character.isLowerCase(c);
    }

    private static boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c);
    }

    private static void escape(StringBuffer stringBuffer, String string, int n) {
        int n2 = string.length();
        int n3 = n;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (Character.isJavaIdentifierPart(c)) {
                stringBuffer.append(c);
            } else {
                stringBuffer.append("_");
                if (c <= '\u000f') {
                    stringBuffer.append("000");
                } else if (c <= '\u00ff') {
                    stringBuffer.append("00");
                } else if (c <= '\u0fff') {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toString(c, 16));
            }
            ++n3;
        }
    }

    private static String escape(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isJavaIdentifierPart(string.charAt(n2))) {
                StringBuffer stringBuffer = new StringBuffer(string.substring(0, n2));
                JavaUtil.escape(stringBuffer, string, n2);
                return stringBuffer.toString();
            }
            ++n2;
        }
        return string;
    }

    private static String capitalize(String string) {
        if (!JavaUtil.isLower(string.charAt(0))) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(Character.toUpperCase(string.charAt(0)));
        stringBuffer.append(string.substring(1).toLowerCase());
        return stringBuffer.toString();
    }

    private static int nextBreak(String string, int n) {
        int n2 = string.length();
        int n3 = n;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (n3 < n2 - 1) {
                char c2 = string.charAt(n3 + 1);
                if (JavaUtil.isPunct(c2)) {
                    return n3 + 1;
                }
                if (JavaUtil.isDigit(c) && !JavaUtil.isDigit(c2)) {
                    return n3 + 1;
                }
                if (!JavaUtil.isDigit(c) && JavaUtil.isDigit(c2)) {
                    return n3 + 1;
                }
                if (JavaUtil.isLower(c) && !JavaUtil.isLower(c2)) {
                    return n3 + 1;
                }
                if (JavaUtil.isLetter(c) && !JavaUtil.isLetter(c2)) {
                    return n3 + 1;
                }
                if (!JavaUtil.isLetter(c) && JavaUtil.isLetter(c2)) {
                    return n3 + 1;
                }
                if (n3 < n2 - 2) {
                    char c3 = string.charAt(n3 + 2);
                    if (JavaUtil.isUpper(c) && JavaUtil.isUpper(c2) && JavaUtil.isLower(c3)) {
                        return n3 + 1;
                    }
                }
            }
            ++n3;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public static String[] toWordList(String var0) {
        block4: {
            block3: {
                var1_1 = new ArrayList<String>();
                var2_2 = var0.length();
                var4_3 = 0;
                break block3;
                while (JavaUtil.isPunct(var0.charAt(var4_3))) {
                    ++var4_3;
lbl7:
                    // 2 sources

                    ** while (var4_3 >= var2_2)
lbl8:
                    // 1 sources

                }
lbl9:
                // 2 sources

                if (var4_3 >= var2_2) break block4;
                var3_4 = JavaUtil.nextBreak(var0, var4_3);
                var5_5 = var3_4 != -1 ? var0.substring(var4_3, var3_4) : var0.substring(var4_3);
                var1_1.add(JavaUtil.escape(JavaUtil.capitalize(var5_5)));
                if (var3_4 == -1) break block4;
                var4_3 = var3_4;
            }
            if (var4_3 < var2_2) ** GOTO lbl7
        }
        if (var1_1.size() == 0) {
            throw new IllegalArgumentException("Zero-length identifier");
        }
        return var1_1.toArray(new String[0]);
    }

    private static String toMixedCaseName(String[] stringArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bl ? stringArray[0] : stringArray[0].toLowerCase());
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String toMixedCaseVariableName(String[] stringArray, boolean bl, boolean bl2) {
        if (bl2) {
            int n = 1;
            while (n < stringArray.length) {
                stringArray[n] = JavaUtil.capitalize(stringArray[n]);
                ++n;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bl ? stringArray[0] : stringArray[0].toLowerCase());
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String toClassName(String string) {
        return JavaUtil.toClassName(JavaUtil.toWordList(string));
    }

    public static String toClassName(String[] stringArray) {
        String string = JavaUtil.toMixedCaseName(stringArray, true);
        if (string.length() > 0 && !Character.isJavaIdentifierStart(string.charAt(0))) {
            string = "_" + string;
        }
        return string;
    }

    public static String toPropertyName(String string) {
        return JavaUtil.toPropertyName(JavaUtil.toWordList(string));
    }

    public static String toPropertyName(String[] stringArray) {
        return JavaUtil.toMixedCaseName(stringArray, true);
    }

    public static String toMethodName(String string) {
        String string2 = JavaUtil.toMethodName(JavaUtil.toWordList(string));
        return reservedWords.contains(string2) ? "_" + string2 : string2;
    }

    public static String toMethodName(String[] stringArray) {
        String string = JavaUtil.toMixedCaseName(stringArray, false);
        if (string.length() > 0 && !Character.isJavaIdentifierStart(string.charAt(0))) {
            string = "_" + string;
        }
        return string;
    }

    public static String toVariableName(String string) {
        String string2 = JavaUtil.toMethodName(JavaUtil.toWordList(string));
        return reservedWords.contains(string2) ? "_" + string2 : string2;
    }

    public static String toVariableName(String[] stringArray) {
        return JavaUtil.toMixedCaseVariableName(stringArray, false, true);
    }

    public static String toConstantName(String string) {
        return JavaUtil.toConstantName(JavaUtil.toWordList(string));
    }

    public static String toConstantName(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0].toUpperCase());
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append('_');
            stringBuffer.append(stringArray[n].toUpperCase());
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean isJavaIdentifier(String string) {
        if (string.length() != 0) {
            if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                return false;
            }
            int n = 1;
            while (n < string.length()) {
                if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public static boolean isJavaVarName(String string) {
        if (!JavaUtil.isJavaIdentifier(string)) {
            return false;
        }
        return !reservedWords.contains(string);
    }

    public static boolean isInner(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(36);
        if (n != -1) {
            String string2 = string.substring(0, n);
            try {
                Class clazz2 = ClassUtil.forName(string2, clazz.getClassLoader());
                return clazz.getPackage() == clazz2.getPackage();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static String getInnerClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(36);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return string2 + "." + string3;
        }
        return string;
    }

    static {
        reservedWords.add("abstract");
        reservedWords.add("boolean");
        reservedWords.add("break");
        reservedWords.add("byte");
        reservedWords.add("case");
        reservedWords.add("catch");
        reservedWords.add("char");
        reservedWords.add("class");
        reservedWords.add("const");
        reservedWords.add("continue");
        reservedWords.add("default");
        reservedWords.add("do");
        reservedWords.add("double");
        reservedWords.add("else");
        reservedWords.add("extends");
        reservedWords.add("false");
        reservedWords.add("final");
        reservedWords.add("finally");
        reservedWords.add("float");
        reservedWords.add("for");
        reservedWords.add("goto");
        reservedWords.add("if");
        reservedWords.add("implements");
        reservedWords.add("import");
        reservedWords.add("instanceof");
        reservedWords.add("int");
        reservedWords.add("interface");
        reservedWords.add("long");
        reservedWords.add("native");
        reservedWords.add("new");
        reservedWords.add("null");
        reservedWords.add("package");
        reservedWords.add("private");
        reservedWords.add("protected");
        reservedWords.add("public");
        reservedWords.add("return");
        reservedWords.add("short");
        reservedWords.add("static");
        reservedWords.add("super");
        reservedWords.add("switch");
        reservedWords.add("synchronized");
        reservedWords.add("this");
        reservedWords.add("throw");
        reservedWords.add("throws");
        reservedWords.add("transient");
        reservedWords.add("true");
        reservedWords.add("try");
        reservedWords.add("void");
        reservedWords.add("volatile");
        reservedWords.add("while");
        reservedWords.add("strictfp");
    }
}

