/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public final class Namespace {
    private String _tns;
    private String _xmlns;
    private final HashMap _nsMap;
    private final HashMap _prefixMap;
    private static final String XSD_URI_1999 = "http://www.w3.org/1999/XMLSchema";
    private static final String XSD_URI_2000 = "http://www.w3.org/2000/10/XMLSchema";
    private static final String XSD_URI_2001 = "http://www.w3.org/2001/XMLSchema";

    public Namespace() {
        this._tns = "";
        this._xmlns = "";
        this._nsMap = new HashMap();
        this._prefixMap = new HashMap();
    }

    public Namespace(Namespace namespace) {
        this._tns = namespace._tns;
        this._xmlns = namespace._xmlns;
        this._nsMap = new HashMap(namespace._nsMap);
        this._prefixMap = new HashMap(namespace._prefixMap);
    }

    public static Namespace getNamespace(Namespace namespace, Element element) {
        Namespace namespace2 = new Namespace(namespace);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            if (attr.getNodeName().equalsIgnoreCase("xmlns")) {
                namespace2.setNamespaceURI(attr.getNodeValue());
            } else if (attr.getNodeName().startsWith("xmlns")) {
                String string = attr.getNodeName();
                int n3 = string.indexOf(":");
                if (n3 != -1) {
                    String string2 = string.substring(n3 + 1);
                    namespace2.addNamespaceURI(string2, attr.getNodeValue());
                }
            } else if (attr.getNodeName().equalsIgnoreCase("targetNamespace")) {
                namespace2.setTargetNamespace(attr.getNodeValue());
            }
            ++n2;
        }
        return namespace2;
    }

    public String getNamespaceURI() {
        return this._xmlns;
    }

    public void setNamespaceURI(String string) {
        this._xmlns = string;
    }

    public Map getNSMap() {
        return this._nsMap;
    }

    public String getTargetNamespace() {
        return this._tns;
    }

    public void setTargetNamespace(String string) {
        this._tns = string;
    }

    public String getNamespaceURI(String string) throws RuntimeException {
        if (string == null || string.equalsIgnoreCase("tns")) {
            return this._tns;
        }
        String string2 = (String)this._nsMap.get(string);
        if (string2 == null) {
            throw new RuntimeException("prefix " + string + " has not been declared");
        }
        return string2;
    }

    public String getPrefix(String string) {
        return (String)this._prefixMap.get(string);
    }

    private void addNamespaceURI(String string, String string2) {
        this._nsMap.put(string, string2);
        this._prefixMap.put(string2, string);
    }

    public String getXMLSchema() {
        Iterator iterator = this._nsMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)this._nsMap.get(iterator.next());
            if (string.equalsIgnoreCase(XSD_URI_1999) || string.equalsIgnoreCase(XSD_URI_2000) || string.equalsIgnoreCase(XSD_URI_2001)) {
                return string;
            }
            if (!string.startsWith("http://www.w3.org/") || !string.endsWith("XMLSchema") && !string.endsWith("XMLSchema/")) continue;
            return string;
        }
        return XSD_URI_2001;
    }
}

