/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.util.regex;

import com.sssw.jbroker.util.regex.JDKRegex;
import com.sssw.jbroker.util.regex.JakartaRegex;
import com.sssw.jbroker.util.regex.Matcher;
import com.sssw.jbroker.util.regex.RegexException;

public final class Regex {
    private static boolean _jdk;
    private static boolean _jakarta;
    private final Matcher _delegate;

    public static void main(String[] stringArray) throws Exception {
        Regex regex = new Regex(stringArray[0]);
        System.out.println(regex.match(stringArray[1]));
    }

    public Regex(String string) throws RegexException {
        if (_jdk) {
            this._delegate = new JDKRegex(string);
        } else if (_jakarta) {
            this._delegate = new JakartaRegex(string);
        } else {
            throw new RegexException("please add jakarta-regexp-1.2.jar to your CLASSPATH");
        }
    }

    public boolean match(String string) {
        return this._delegate.match(string);
    }

    static {
        try {
            Class.forName("java.util.regex.Matcher");
            _jdk = true;
        }
        catch (Throwable throwable) {
            try {
                Class.forName("org.apache.regexp.RE");
                _jakarta = true;
            }
            catch (Throwable throwable2) {}
        }
    }
}

