/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.util.xml;

import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMSerializer {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");

    public static void serialize(Node node, Writer writer) throws IOException {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                writer.write("<?xml version=\"1.0\"?>");
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    DOMSerializer.serialize(nodeList.item(n2), writer);
                    ++n2;
                }
                break;
            }
            case 1: {
                int n;
                Object object;
                writer.write('<' + node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n3 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
                int n4 = 0;
                while (n4 < n3) {
                    object = (Attr)namedNodeMap.item(n4);
                    writer.write(' ' + object.getNodeName() + "=\"" + DOMSerializer.escapeString(object.getValue()) + '\"');
                    ++n4;
                }
                object = node.getChildNodes();
                int n5 = n = object == null ? 0 : object.getLength();
                if (n > 0) {
                    writer.write(62);
                    int n6 = 0;
                    while (n6 < n) {
                        DOMSerializer.serialize(object.item(n6), writer);
                        ++n6;
                    }
                    writer.write("</");
                    writer.write(node.getNodeName());
                    writer.write(62);
                    break;
                }
                writer.write("/>");
                break;
            }
            case 5: {
                writer.write(38);
                writer.write(node.getNodeName());
                writer.write(59);
                break;
            }
            case 4: {
                writer.write("<![CDATA[");
                writer.write(node.getNodeValue());
                writer.write("]]>");
                break;
            }
            case 3: {
                writer.write(DOMSerializer.escapeString(node.getNodeValue()));
                break;
            }
            case 8: {
                writer.write("<!--");
                writer.write(node.getNodeValue());
                writer.write("-->");
                break;
            }
            case 7: {
                writer.write("<?");
                writer.write(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    writer.write(32);
                    writer.write(string);
                }
                writer.write("?>");
            }
        }
    }

    public static String escapeString(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\n': {
                    int n3;
                    int n4 = n3 = n2 > 0 ? (int)string.charAt(n2 - 1) : 32;
                    if (n3 != 13) {
                        stringBuffer.append(LINE_SEPARATOR);
                        break;
                    }
                    stringBuffer.append('\n');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return new String(stringBuffer);
    }
}

