/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.core;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class Cookies {
    private boolean _debug = false;
    private TreeMap _cookies = new TreeMap();
    private static final String _PATH = "Path";
    private static final String _PORT = "Port";
    private static final String _DOMAIN = "Domain";
    private static final String _DISCARD = "Discard";
    private static final String _MAX_AGE = "Max-Age";
    private static final String _COMMENT = "Comment";
    private static final String _COMMENT_URL = "CommentURL";

    public Map getCookies() {
        return this._cookies;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this._cookies.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Cookie cookie = (Cookie)entry.getValue();
            stringBuffer.append(cookie.getCookieString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        return new String(stringBuffer);
    }

    public void readCookieInfo(String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        int n = 0;
        String string2 = null;
        String string3 = null;
        boolean bl = true;
        while (true) {
            Cookie cookie;
            String string4;
            int n2 = string.indexOf(61, n);
            int n3 = string.indexOf(59, n);
            if (n3 != -1 && n3 < n2) {
                string4 = string.substring(n, n3);
                treeMap.put(string4, string4);
                n = string.indexOf(44, n);
                if (n == -1) break;
                n = n3 + 1;
                continue;
            }
            if (n2 == -1) break;
            string4 = string.substring(n, n2);
            String string5 = null;
            int n4 = n2 + 1;
            int n5 = -1;
            n5 = string.charAt(n4) == '\"' ? string.indexOf(34, ++n4) : string.indexOf(59, n4);
            if (n5 == -1) {
                n5 = string.length();
            }
            string5 = string.substring(n4, n5);
            if (bl) {
                string2 = string4;
                string3 = string5;
                bl = false;
            }
            if (this._debug) {
                System.out.println("cName=" + string4);
                System.out.println("cVal=" + string5);
            }
            treeMap.put(string4, string5);
            n = n5;
            n = string.indexOf(44, n);
            if (n == -1) {
                n = n5;
            } else {
                cookie = new Cookie(string2, string3, treeMap);
                if (!cookie.discard()) {
                    this._cookies.put(cookie.getKey(), cookie);
                }
                treeMap = new TreeMap();
            }
            n = string.indexOf(59, n);
            if (n == -1) {
                cookie = new Cookie(string2, string3, treeMap);
                if (cookie.discard()) break;
                this._cookies.put(cookie.getKey(), cookie);
                break;
            }
            ++n;
        }
    }

    private static class Cookie {
        private String _name;
        private String _value;
        private String _path;
        private String _domain;
        private String _port;
        private String _comment;
        private String _commentURL;
        private boolean _discard;
        private double _maxAge = -1.0;
        private long _ageStart;

        private Cookie(String string, String string2, Map map) {
            this._name = string;
            this._value = string2;
            this._path = (String)map.get(Cookies._PATH);
            if (this._path != null) {
                this._path = this._path.toLowerCase();
            }
            this._domain = (String)map.get(Cookies._DOMAIN);
            if (this._domain != null) {
                this._domain = this._domain.toLowerCase();
            }
            this._port = (String)map.get(Cookies._PORT);
            this._comment = (String)map.get(Cookies._COMMENT);
            this._commentURL = (String)map.get(Cookies._COMMENT_URL);
            this._discard = (String)map.get(Cookies._DISCARD) != null;
            String string3 = (String)map.get(Cookies._MAX_AGE);
            if (string3 != null) {
                this._maxAge = Double.parseDouble(string3);
                this._ageStart = new Date().getTime();
            }
        }

        private String getKey() {
            return this._name + this._path + this._domain;
        }

        private boolean discard() {
            if (this._discard) {
                return true;
            }
            if (this._maxAge == 0.0) {
                return true;
            }
            if (this._ageStart != 0L) {
                Date date = new Date();
                if ((double)(date.getTime() - this._ageStart) > this._maxAge) {
                    return true;
                }
            }
            return false;
        }

        private String getCookieString() {
            return this.toString();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this._name);
            stringBuffer.append('=');
            stringBuffer.append(this._value);
            stringBuffer.append(';');
            if (this._path != null) {
                stringBuffer.append('$');
                stringBuffer.append(Cookies._PATH);
                stringBuffer.append('=');
                stringBuffer.append(this._path);
                stringBuffer.append(';');
            }
            if (this._domain != null) {
                stringBuffer.append('$');
                stringBuffer.append(Cookies._DOMAIN);
                stringBuffer.append('=');
                stringBuffer.append(this._domain);
                stringBuffer.append(';');
            }
            if (this._comment != null) {
                stringBuffer.append('$');
                stringBuffer.append(Cookies._COMMENT);
                stringBuffer.append('=');
                stringBuffer.append(this._comment);
                stringBuffer.append(';');
            }
            if (this._commentURL != null) {
                stringBuffer.append('$');
                stringBuffer.append(Cookies._COMMENT_URL);
                stringBuffer.append('=');
                stringBuffer.append(this._commentURL);
                stringBuffer.append(';');
            }
            return new String(stringBuffer);
        }
    }
}

