/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.core;

import com.sssw.jbroker.web.Binding;
import com.sssw.jbroker.web.QName;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.ServiceObject;
import com.sssw.jbroker.web.core.MessageHandlerInvoker;
import com.sssw.jbroker.web.core.Provider;
import com.sssw.jbroker.web.portable.ApplicationException;
import com.sssw.jbroker.web.portable.ClientRequest;
import com.sssw.jbroker.web.portable.ClientResponse;
import com.sssw.jbroker.web.portable.Delegate;
import com.sssw.jbroker.web.portable.Stub;
import com.sssw.jbroker.web.spi.ProtocolHandler;
import com.sssw.jbroker.web.spi.TransportHandler;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.rpc.handler.HandlerChain;

public class DelegateImpl
implements Delegate {
    private static final String _SOAP = "soap";
    private transient Binding _binding;
    private transient Provider _provider;
    private transient TransportHandler.TransportEndpoint _endpoint;
    private transient ProtocolHandler _protocolHandler;
    private transient HashMap _properties = new HashMap<Object, Object>(Provider.DEFAULT_PROPS);
    private transient HandlerChain _handlerChain;
    private ServiceObject _stub;
    private static final ArrayList _propertyNames = new ArrayList();

    public DelegateImpl() {
        this.initializeProvider(false);
    }

    public void setStub(Stub stub) {
        this._stub = stub;
    }

    public void setHandlerChain(HandlerChain handlerChain) {
        if (this._handlerChain != null) {
            this._handlerChain.destroy();
        }
        this._handlerChain = handlerChain;
    }

    public Object getProperty(String string) {
        Binding binding;
        if (string == null) {
            throw new IllegalArgumentException("Property name not specified");
        }
        if (!(_propertyNames.contains(string) || string.startsWith("jbroker") || string.startsWith("xmlrpc"))) {
            throw new IllegalArgumentException(string + " is an invalid Property");
        }
        if (string.equals("javax.xml.rpc.service.endpoint.address") && (binding = this._stub._getCurrentBinding()) != null) {
            this.setProperty(string, binding.getURLStr());
        }
        return this._properties.get(string);
    }

    public QName getOperationName() {
        return (QName)this._properties.get("xmlrpc.soap.operation.name");
    }

    public Map getProperties() {
        return this._properties;
    }

    public String setProperty(String string, String string2) {
        Object v = this._properties.get(string);
        this.setProperty(string, (Object)string2);
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    public void setProperty(String string, Object object) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Property name not specified");
        }
        if (!(_propertyNames.contains(string) || string.startsWith("jbroker") || string.startsWith("xmlrpc"))) {
            throw new IllegalArgumentException(string + " is an invalid Property");
        }
        if (string.equals("javax.xml.rpc.service.endpoint.address") && object instanceof String) {
            Binding binding = this._stub._getCurrentBinding();
            String string2 = binding == null ? _SOAP : binding.getProtocol();
            try {
                this._stub._setCurrentBinding(new Binding(string2, (String)object));
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                throw new IllegalArgumentException("invalid endpoint address: " + object + " (" + malformedURLException.getMessage() + ")");
            }
        }
        this._properties.put(string, object);
        if (string.equals("xmlrpc.provider")) {
            this.initializeProvider(true);
        }
        if (this._endpoint != null) {
            this._endpoint.setProperty(string, object);
        }
    }

    public Iterator getPropertyNames() {
        return ((AbstractList)_propertyNames).iterator();
    }

    public ClientRequest request(String string, boolean bl, String string2, boolean bl2, String string3) {
        Properties properties = (Properties)this.getProperty("xmlrpc.soap.mime.headers");
        return this.request(string, bl, string2, bl2, string3, properties);
    }

    public ClientRequest request(String string, boolean bl, String string2, boolean bl2, String string3, String string4) {
        Properties properties = (Properties)this.getProperty("xmlrpc.soap.mime.headers");
        return this.request(string, bl, string2, bl2, string3, properties, string4);
    }

    public ClientRequest request(String string, boolean bl, String string2, boolean bl2, String string3, Properties properties) {
        return this.request(string, bl, string2, bl2, string3, properties, null);
    }

    public ClientRequest request(String string, boolean bl, String string2, boolean bl2, String string3, Properties properties, String string4) {
        if (this._protocolHandler == null) {
            throw new ServiceException("no binding set on stub");
        }
        return this._protocolHandler.createRequest(this._stub, string, bl, string2, bl2, string3, properties, string4);
    }

    public ClientRequest soapRequest(HashMap hashMap) {
        this._protocolHandler = this._provider.getProtocolHandler(_SOAP);
        return this._protocolHandler.createRequest(hashMap);
    }

    public ClientResponse invoke(ClientRequest clientRequest) throws ApplicationException {
        ClientResponse clientResponse = null;
        this._protocolHandler.endRequest(clientRequest);
        try {
            try {
                clientResponse = MessageHandlerInvoker.invokeClientMessageHandlers(clientRequest, this._handlerChain, this._endpoint, this);
                try {
                    clientResponse.lookForException();
                }
                catch (ApplicationException applicationException) {
                    if (this.getProperty("version") == null) {
                        Throwable throwable = (Throwable)clientResponse.readObject(null, null);
                        throw new ServiceException(throwable);
                    }
                    throw applicationException;
                }
                Object var6_6 = null;
                this._properties.remove("xmlrpc.soap.mime.headers");
            }
            catch (IOException iOException) {
                throw new ServiceException(iOException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this._properties.remove("xmlrpc.soap.mime.headers");
            throw throwable;
        }
        return clientResponse;
    }

    public void releaseResponse(ClientResponse clientResponse) {
    }

    public void setCurrentBinding(Binding binding) throws MalformedURLException {
        this._binding = binding;
        if (this._binding == null) {
            throw new MalformedURLException("null binding");
        }
        String string = binding.getProtocol();
        this._protocolHandler = this._provider.getProtocolHandler(string);
        if (this._protocolHandler == null) {
            throw new ServiceException("unable to find \"" + this._provider.getName() + "\" protocol handler for \"" + string + "\"");
        }
        String string2 = DelegateImpl.getURLScheme(binding.getURLStr());
        TransportHandler transportHandler = this._provider.getTransportHandler(string2);
        if (transportHandler == null) {
            throw new ServiceException("unable to find \"" + this._provider.getName() + "\" transport handler for \"" + string2 + "\"");
        }
        this._endpoint = this._provider.getTransportHandler(string2).createEndpoint(binding);
        if (this._endpoint != null) {
            Iterator iterator = this._properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!(entry.getValue() instanceof String)) continue;
                this._endpoint.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
    }

    void initializeProvider(boolean bl) {
        String string = (String)this.getProperty("xmlrpc.provider");
        if (this._provider != null && this._provider.getName().equals(string)) {
            return;
        }
        this._provider = Provider.getProvider(string);
        if (this._provider == null) {
            throw new ServiceException("no provider \"" + string + "\"");
        }
        if (bl) {
            try {
                Binding binding = this._stub._getCurrentBinding();
                if (binding != null) {
                    this.setCurrentBinding(binding);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static String getURLScheme(String string) {
        int n = string.indexOf(58);
        int n2 = string.indexOf(47);
        return n > 0 && (n2 == -1 || n < n2) ? string.substring(0, n) : string;
    }

    static {
        _propertyNames.add("cookie");
        _propertyNames.add("set-cookie");
        _propertyNames.add("set-cookie2");
        _propertyNames.add("javax.xml.rpc.security.auth.username");
        _propertyNames.add("javax.xml.rpc.security.auth.password");
        _propertyNames.add("javax.xml.rpc.service.endpoint.address");
        _propertyNames.add("javax.xml.rpc.session.maintain");
        _propertyNames.add("javax.xml.rpc.soap.operation.style");
        _propertyNames.add("javax.xml.rpc.soap.http.soapaction.use");
        _propertyNames.add("javax.xml.rpc.soap.http.soapaction.uri");
        _propertyNames.add("javax.xml.rpc.encodingstyle.namespace.uri");
        _propertyNames.add("xmlrpc.schema.uri");
        _propertyNames.add("http://www.w3.org/1999/XMLSchema");
        _propertyNames.add("xmlrpc.soap.operation.name");
        _propertyNames.add("xmlrpc.soap.operation.twoWay");
        _propertyNames.add("xmlrpc.soap.operation.isDocument");
        _propertyNames.add("xmlrpc.soap.mime.headers");
        _propertyNames.add("version");
        _propertyNames.add("soapAction");
        _propertyNames.add("user.id");
        _propertyNames.add("user.password");
        _propertyNames.add("http.content.type");
        _propertyNames.add("http.content.location");
        _propertyNames.add("root");
        _propertyNames.add("content-type");
        _propertyNames.add("content-id");
        _propertyNames.add("xmlrpc.provider");
        _propertyNames.add("xmlrpc.provider.properties");
        _propertyNames.add("xmlrpc.wsdl");
        Provider.configure();
    }
}

