/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.core;

import com.sssw.jbroker.saaj.DataSourceImpl;
import com.sssw.jbroker.saaj.handlers.DataContentHandlerFactoryImpl;
import com.sssw.jbroker.util.xml.HREFNotFound;
import com.sssw.jbroker.web.QName;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.core.MultipartRequest;
import com.sssw.jbroker.web.core.Provider;
import com.sssw.jbroker.web.core.XMLReaderImpl;
import com.sssw.jbroker.web.encoding.DefaultTypeMappingRegistry;
import com.sssw.jbroker.web.encoding.TypeMappingRegistry;
import com.sssw.jbroker.web.mapping.TypeMapper;
import com.sssw.jbroker.web.portable.InputStream;
import com.sssw.jbroker.web.spi.EncodingStyle;
import com.sssw.jbroker.web.spi.InputStreamContext;
import com.sssw.jbroker.web.spi.XMLReader;
import com.sssw.jbroker.web.spi.XMLScrap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.activation.DataContentHandlerFactory;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.xml.sax.Attributes;

public class InputStreamImpl
implements InputStream {
    private static final boolean _debug = false;
    protected final XMLReaderImpl _reader;
    protected final Context _context;
    protected TypeMappingRegistry _mapper;
    protected EncodingStyle _encoding;
    protected QName _qname;
    protected boolean _isDocument;
    protected Map _mimeParts;
    private static final String _href = "href";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$javax$xml$transform$Source;
    static /* synthetic */ Class class$javax$activation$DataHandler;

    public InputStreamImpl(Reader reader, EncodingStyle encodingStyle, boolean bl) {
        this(new XMLReaderImpl(reader), encodingStyle, bl);
    }

    public InputStreamImpl(Reader reader, EncodingStyle encodingStyle, boolean bl, Map map) {
        this(new XMLReaderImpl(reader), encodingStyle, bl);
        this._mimeParts = map;
    }

    public InputStreamImpl(XMLReader xMLReader, EncodingStyle encodingStyle, boolean bl) {
        this._reader = (XMLReaderImpl)xMLReader;
        this._encoding = encodingStyle;
        this._mapper = new DefaultTypeMappingRegistry();
        this._context = new Context(this, this._mapper, this._reader);
        this._isDocument = bl;
    }

    public byte readByte() throws IOException {
        try {
            return this._encoding.readByte(this._context);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException instanceof ServiceException ? (ServiceException)runtimeException : new ServiceException(runtimeException);
        }
    }

    public byte readByte(String string) throws IOException {
        try {
            return this._encoding.readByte(this._context, string);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException instanceof ServiceException ? (ServiceException)runtimeException : new ServiceException(runtimeException);
        }
    }

    public char readChar() throws IOException {
        return ((String)this.readObject(class$java$lang$String == null ? (class$java$lang$String = InputStreamImpl.class$("java.lang.String")) : class$java$lang$String)).charAt(0);
    }

    public char readChar(String string) throws IOException {
        return ((String)this.readObject(class$java$lang$String == null ? (class$java$lang$String = InputStreamImpl.class$("java.lang.String")) : class$java$lang$String, string)).charAt(0);
    }

    public boolean readBoolean() throws IOException {
        try {
            return this._encoding.readBoolean(this._context);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException instanceof ServiceException ? (ServiceException)runtimeException : new ServiceException(runtimeException);
        }
    }

    public boolean readBoolean(String string) throws IOException {
        try {
            return this._encoding.readBoolean(this._context, string);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException instanceof ServiceException ? (ServiceException)runtimeException : new ServiceException(runtimeException);
        }
    }

    public int readInt() throws IOException {
        try {
            return this._encoding.readInt(this._context);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException instanceof ServiceException ? (ServiceException)runtimeException : new ServiceException(runtimeException);
        }
    }

    public int readInt(String string) throws IOException {
        try {
            return this._encoding.readInt(this._context, string);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException instanceof ServiceException ? (ServiceException)runtimeException : new ServiceException(runtimeException);
        }
    }

    public short readShort() throws IOException {
        try {
            return this._encoding.readShort(this._context);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException instanceof ServiceException ? (ServiceException)runtimeException : new ServiceException(runtimeException);
        }
    }

    public short readShort(String string) throws IOException {
        try {
            return this._encoding.readShort(this._context, string);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException instanceof ServiceException ? (ServiceException)runtimeException : new ServiceException(runtimeException);
        }
    }

    public long readLong() throws IOException {
        try {
            return this._encoding.readLong(this._context);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException instanceof ServiceException ? (ServiceException)runtimeException : new ServiceException(runtimeException);
        }
    }

    public long readLong(String string) throws IOException {
        try {
            return this._encoding.readLong(this._context, string);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException instanceof ServiceException ? (ServiceException)runtimeException : new ServiceException(runtimeException);
        }
    }

    public float readFloat() throws IOException {
        try {
            return this._encoding.readFloat(this._context);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException instanceof ServiceException ? (ServiceException)runtimeException : new ServiceException(runtimeException);
        }
    }

    public float readFloat(String string) throws IOException {
        try {
            return this._encoding.readFloat(this._context, string);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException instanceof ServiceException ? (ServiceException)runtimeException : new ServiceException(runtimeException);
        }
    }

    public double readDouble() throws IOException {
        try {
            return this._encoding.readDouble(this._context);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException instanceof ServiceException ? (ServiceException)runtimeException : new ServiceException(runtimeException);
        }
    }

    public double readDouble(String string) throws IOException {
        try {
            return this._encoding.readDouble(this._context, string);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException instanceof ServiceException ? (ServiceException)runtimeException : new ServiceException(runtimeException);
        }
    }

    public Object readObject() throws IOException {
        return this.readObject(null);
    }

    public Object readObject(Class clazz) throws IOException {
        return this._encoding.readObject((InputStreamContext)this._context, clazz);
    }

    public Object readObject(Class clazz, String string) throws IOException {
        return this._encoding.readObject(this._context, clazz, string);
    }

    public Object readObject(Class clazz, String string, String string2) throws IOException {
        return this._encoding.readObject(this._context, clazz, string, string2);
    }

    public Object readObject(Class clazz, String string, String string2, String string3, String string4) throws IOException {
        return this._encoding.readObject(this._context, clazz, string, string2, string3, string4);
    }

    public QName getQName() {
        return this._qname;
    }

    public QName peek() throws IOException {
        XMLScrap xMLScrap = this._reader.peek();
        if (xMLScrap.type() != 2) {
            return null;
        }
        return new QName(xMLScrap.getURI(), xMLScrap.getLocalName());
    }

    public String readContent() throws IOException {
        XMLScrap xMLScrap = this._reader.peek();
        if (xMLScrap.type() == 4) {
            xMLScrap = this._reader.next(4);
            return xMLScrap.getContent();
        }
        return null;
    }

    private String readAttachmentRef(String string, String string2) throws IOException {
        XMLScrap xMLScrap = null;
        String string3 = null;
        try {
            xMLScrap = this._reader.next();
        }
        catch (HREFNotFound hREFNotFound) {
            string3 = hREFNotFound.getHREF();
        }
        if (this._encoding.isNil(xMLScrap)) {
            return null;
        }
        string3 = xMLScrap.getValue(null, _href);
        try {
            this._reader.next();
        }
        catch (HREFNotFound hREFNotFound) {
            string3 = hREFNotFound.getHREF();
        }
        xMLScrap = this._reader.next();
        if (string3 == null) {
            throw new IOException("Invalid MIME reference:" + xMLScrap);
        }
        if (string3.startsWith("cid:")) {
            string3 = string3.substring(4);
        }
        return string3;
    }

    public Object readAttachment(String string, String string2, Class clazz) throws IOException {
        if (clazz.isArray() && clazz != (array$B == null ? (array$B = InputStreamImpl.class$("[B")) : array$B)) {
            return this._encoding.readAttachmentArray(this._context, clazz, string, string2);
        }
        String string3 = this.readAttachmentRef(string, string2);
        if (string3 == null) {
            return null;
        }
        MultipartRequest.MIMEContent mIMEContent = (MultipartRequest.MIMEContent)this._mimeParts.get(string3);
        boolean bl = false;
        if (mIMEContent.getContentType().startsWith("text/xml") && !(class$javax$xml$transform$Source == null ? (class$javax$xml$transform$Source = InputStreamImpl.class$("javax.xml.transform.Source")) : class$javax$xml$transform$Source).isAssignableFrom(clazz)) {
            bl = true;
        }
        DataHandler dataHandler = new DataHandler((DataSource)new DataSourceImpl(new ByteArrayInputStream(mIMEContent.getBytes()), null, mIMEContent.getContentType(), null));
        if ((class$javax$activation$DataHandler == null ? (class$javax$activation$DataHandler = InputStreamImpl.class$("javax.activation.DataHandler")) : class$javax$activation$DataHandler).isAssignableFrom(clazz)) {
            return dataHandler;
        }
        if (bl) {
            return this.readMimeXml(mIMEContent, clazz);
        }
        return dataHandler.getContent();
    }

    private Object readMimeXml(MultipartRequest.MIMEContent mIMEContent, Class clazz) throws IOException {
        XMLReaderImpl xMLReaderImpl = new XMLReaderImpl(mIMEContent.getReader());
        InputStreamImpl inputStreamImpl = new InputStreamImpl(xMLReaderImpl, this._encoding, false);
        inputStreamImpl.setTypeMappingRegistry(this._mapper);
        Context context = new Context(inputStreamImpl, this._mapper, xMLReaderImpl);
        return this._encoding.readObject((InputStreamContext)context, clazz);
    }

    public String setEncodingStyleURI(String string) {
        String string2 = this._encoding.getURI();
        Provider provider = Provider.getProvider();
        EncodingStyle encodingStyle = provider.getEncodingStyle(string);
        this.setEncodingStyle(encodingStyle);
        return string2;
    }

    public String getEncodingStyleURI() {
        return this._encoding.getURI();
    }

    public void setTypeMapper(TypeMapper typeMapper) {
        throw new IllegalArgumentException("use setTypeMappingRegistry(TypeMappingRegistry);");
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this._mapper = typeMappingRegistry;
        this._context._mapper = this._mapper;
    }

    public Attributes getAttributes() throws IOException {
        return (Attributes)((Object)this._reader.current());
    }

    public void setMixedContent(boolean bl) throws IOException {
        this._reader.setAllowedMixedContent(bl);
    }

    public EncodingStyle setEncodingStyle(EncodingStyle encodingStyle) {
        EncodingStyle encodingStyle2 = this._encoding;
        this._encoding = encodingStyle;
        return encodingStyle2;
    }

    public InputStreamContext getInputStreamContext() {
        return this._context;
    }

    protected TypeMapper getTypeMapper() {
        throw new IllegalArgumentException("use getTypeMappingRegistry()");
    }

    protected TypeMappingRegistry getTypeMappingRegistry() {
        return this._mapper;
    }

    public boolean isDocument() {
        return this._isDocument;
    }

    public Map getMIMEParts() {
        return this._mimeParts;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            DataHandler.setDataContentHandlerFactory((DataContentHandlerFactory)new DataContentHandlerFactoryImpl());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class Context
    implements InputStreamContext {
        private TypeMappingRegistry _mapper;
        private final XMLReader _reader;
        private final InputStream _is;

        Context(InputStream inputStream, TypeMappingRegistry typeMappingRegistry, XMLReader xMLReader) {
            this._is = inputStream;
            this._mapper = typeMappingRegistry;
            this._reader = xMLReader;
        }

        public XMLReader getXMLReader() {
            return this._reader;
        }

        void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
            this._mapper = typeMappingRegistry;
        }

        public TypeMappingRegistry getTypeMappingRegistry() {
            return this._mapper;
        }

        public TypeMapper getTypeMapper() {
            throw new IllegalArgumentException("use getTypeMappingRegistry()");
        }

        public InputStream getInputStream() {
            return this._is;
        }
    }
}

