/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.core;

import com.sssw.jbroker.web.ServiceObject;
import com.sssw.jbroker.web.core.MessageHandlerInvoker;
import com.sssw.jbroker.web.core.Provider;
import com.sssw.jbroker.web.core.Util;
import com.sssw.jbroker.web.portable.InvokeHandler;
import com.sssw.jbroker.web.portable.MDBSkeleton;
import com.sssw.jbroker.web.portable.ServerResponse;
import com.sssw.jbroker.web.portable.Stub;
import com.sssw.jbroker.web.xml.rpc.handler.HandlerChainImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.ejb.MessageDrivenContext;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.TopicPublisher;
import javax.servlet.ServletException;
import javax.xml.rpc.handler.HandlerChain;

public class MDBDelegateImpl
implements MDBSkeleton.MDBDelegate {
    private InvokeHandler _handler;
    private Provider _provider;
    private Properties _properties;
    private transient HandlerChain _handlerChain;
    private static final String DEFAULT_PROVIDER = "jBroker";
    private static final boolean _debug = true;

    public void setHandler(InvokeHandler invokeHandler) {
        this._handler = invokeHandler;
    }

    public Stub getStub() throws ClassNotFoundException {
        return Util.loadStub((MDBSkeleton)this._handler);
    }

    public Properties getProperties() {
        if (this._properties == null) {
            MDBDelegateImpl mDBDelegateImpl = this;
            synchronized (mDBDelegateImpl) {
                if (this._properties == null) {
                    this._properties = new Properties(Provider.DEFAULT_PROPS);
                }
            }
        }
        return this._properties;
    }

    public void ejbCreate() {
        this.initProvider();
        try {
            ((MDBSkeleton)this._handler).init();
        }
        catch (ServletException servletException) {
            throw new RuntimeException("failed to initialize message driven bean: " + servletException.getMessage());
        }
    }

    public void ejbRemove() {
    }

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) {
    }

    public void initProvider() {
        String string = (String)((ServiceObject)((Object)this._handler))._getProperty("xmlrpc.provider");
        if (string == null) {
            string = DEFAULT_PROVIDER;
        }
        this._provider = Provider.getProvider(string);
    }

    public void onMessage(Message message) {
        System.out.println("got " + message);
        try {
            Object object;
            Object object2;
            Enumeration enumeration = message.getPropertyNames();
            Properties properties = new Properties();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                ((Hashtable)properties).put(object2, message.getObjectProperty((String)object2));
            }
            object2 = null;
            if (message instanceof TextMessage) {
                object = ((TextMessage)message).getText();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes());
                object2 = this.invoke(properties, byteArrayInputStream);
            }
            if ((object = message.getJMSReplyTo()) != null) {
                int n;
                int n2 = n = object instanceof Queue ? 0 : 1;
                if (message instanceof TextMessage) {
                    Session session = ((MDBSkeleton)this._handler).getSession(n);
                    MessageProducer messageProducer = ((MDBSkeleton)this._handler).getProducer((Destination)object, n);
                    String string = new String(object2.toByteArray());
                    TextMessage textMessage = session.createTextMessage(string);
                    System.out.println("sending reply to " + object + ": " + string);
                    String string2 = message.getJMSCorrelationID();
                    if (string2 != null) {
                        textMessage.setJMSCorrelationID(string2);
                    }
                    if (n == 0) {
                        ((QueueSender)messageProducer).send((Message)textMessage);
                    } else {
                        ((TopicPublisher)messageProducer).publish((Message)textMessage);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ServerResponse invoke(Properties properties, InputStream inputStream) throws IOException {
        if (this._provider == null) {
            this.initProvider();
        }
        ServerResponse serverResponse = MessageHandlerInvoker.invokeServerMessageHandlers(inputStream, properties, this._handlerChain, this._provider, this._handler);
        ((Hashtable)properties).clear();
        String string = (String)serverResponse._getProperties().get("http.content.type");
        if (string != null) {
            properties.setProperty("content-type", string);
        }
        ((Hashtable)properties).put("content-length", String.valueOf(serverResponse.size()));
        return serverResponse;
    }

    public void setHandlerChain(List list) {
        if (this._handlerChain != null) {
            this._handlerChain.destroy();
        }
        this._handlerChain = new HandlerChainImpl(list);
    }

    public void _setHandlerChain(HandlerChain handlerChain) {
    }

    static {
        Provider.configure();
    }
}

