/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.core;

import com.sssw.jbroker.saaj.soap.SOAPMessageImpl;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.core.Cookies;
import com.sssw.jbroker.web.core.MultipartRequest;
import com.sssw.jbroker.web.core.OutputStreamImpl;
import com.sssw.jbroker.web.core.Provider;
import com.sssw.jbroker.web.core.XMLReaderImpl;
import com.sssw.jbroker.web.portable.ClientRequest;
import com.sssw.jbroker.web.portable.ClientResponse;
import com.sssw.jbroker.web.portable.Delegate;
import com.sssw.jbroker.web.portable.InvokeHandler;
import com.sssw.jbroker.web.portable.OutputStream;
import com.sssw.jbroker.web.portable.ServerResponse;
import com.sssw.jbroker.web.spi.ProtocolHandler;
import com.sssw.jbroker.web.spi.TransportHandler;
import com.sssw.jbroker.web.spi.XMLReader;
import com.sssw.jbroker.web.xml.rpc.handler.soap.SOAPMessageContextImpl;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public final class MessageHandlerInvoker {
    private static final boolean _debug = false;
    private static final String HTTP_CONTENT_TYPE = "Content-Type";
    private static final String HTTP_CONTENT_LOC = "Content-Location";
    private static final String TEXT_XML = "text/xml";
    private static final MimeHeaders _httpHeaders = new MimeHeaders();
    private static final String _MustUnderstand = "MustUnderstand";
    private static final String _CHARSET = "charset";

    public static ClientResponse invokeClientMessageHandlers(ClientRequest clientRequest, HandlerChain handlerChain, TransportHandler.TransportEndpoint transportEndpoint, Delegate delegate) throws IOException {
        try {
            if (handlerChain == null || handlerChain.size() == 0) {
                Properties properties = new Properties();
                MessageHandlerInvoker.transferHTTPHeaders(clientRequest, properties);
                MessageHandlerInvoker.transferHTTPHeaders(delegate, properties);
                InputStream inputStream = transportEndpoint.invoke(clientRequest, properties);
                MessageHandlerInvoker.transferHTTPHeaders(properties, delegate);
                return MessageHandlerInvoker.getClientResponse(inputStream, properties, clientRequest);
            }
            Object var4_5 = null;
            Object[] objectArray = new SOAPMessage[1];
            boolean bl = MessageHandlerInvoker.invokeRequestMessageHandlers(clientRequest, handlerChain, objectArray);
            if (!bl) {
                return MessageHandlerInvoker.getClientResponse((SOAPMessage)objectArray[0], clientRequest);
            }
            if (objectArray[0] != null) {
                MessageHandlerInvoker.transferBytes((SOAPMessage)objectArray[0], clientRequest);
            }
            Properties properties = new Properties();
            MessageHandlerInvoker.transferHTTPHeaders(clientRequest, properties);
            MessageHandlerInvoker.transferHTTPHeaders(delegate, properties);
            InputStream inputStream = transportEndpoint.invoke(clientRequest, properties);
            MessageHandlerInvoker.transferHTTPHeaders(properties, delegate);
            objectArray[0] = null;
            objectArray[0] = MessageHandlerInvoker.getSOAPMessage(properties, inputStream);
            objectArray[0] = MessageHandlerInvoker.checkForMustUnderstand((SOAPMessage)objectArray[0], handlerChain);
            MessageHandlerInvoker.invokeResponseMessageHandlers((SOAPMessage)objectArray[0], handlerChain);
            ((SOAPMessage)objectArray[0]).saveChanges();
            return MessageHandlerInvoker.getClientResponse((SOAPMessage)objectArray[0], clientRequest);
        }
        catch (SOAPException sOAPException) {
            throw new ServiceException(sOAPException);
        }
    }

    private static boolean hasFault(SOAPMessage sOAPMessage) throws SOAPException {
        return sOAPMessage.getSOAPPart().getEnvelope().getBody().hasFault();
    }

    public static SOAPMessage checkForMustUnderstand(SOAPMessage sOAPMessage, HandlerChain handlerChain) throws SOAPException {
        Set set = MessageHandlerInvoker.getMUHeaderNames(sOAPMessage);
        Set set2 = MessageHandlerInvoker.getUnderstoodHeaders(handlerChain);
        set.removeAll(set2);
        if (set.size() != 0) {
            return MessageHandlerInvoker.createMustUnderstandFault(set);
        }
        return sOAPMessage;
    }

    public static Set getUnderstoodHeaders(HandlerChain handlerChain) {
        HashSet hashSet = new HashSet();
        int n = handlerChain.size();
        int n2 = 0;
        while (n2 < n) {
            Handler handler = (Handler)handlerChain.get(n2);
            QName[] qNameArray = handler.getHeaders();
            if (qNameArray != null) {
                int n3 = 0;
                while (n3 < qNameArray.length) {
                    hashSet.remove(qNameArray[n3]);
                    ++n3;
                }
            }
            ++n2;
        }
        return hashSet;
    }

    public static Set getMUHeaderNames(SOAPMessage sOAPMessage) throws SOAPException {
        HashSet<QName> hashSet = new HashSet<QName>();
        SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
        SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
        SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
        Iterator iterator = sOAPHeader.getChildElements();
        while (iterator.hasNext()) {
            SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator.next();
            if (!sOAPHeaderElement.getMustUnderstand()) continue;
            hashSet.add(new QName(sOAPHeaderElement.getElementName().getURI(), sOAPHeaderElement.getElementName().getLocalName()));
        }
        return hashSet;
    }

    public static SOAPMessage createMustUnderstandFault(Set set) throws SOAPException {
        SOAPMessageImpl sOAPMessageImpl = new SOAPMessageImpl();
        SOAPPart sOAPPart = ((SOAPMessage)sOAPMessageImpl).getSOAPPart();
        SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
        SOAPBody sOAPBody = sOAPEnvelope.getBody();
        SOAPFault sOAPFault = sOAPBody.addFault();
        sOAPFault.setFaultCode(_MustUnderstand);
        sOAPFault.setFaultString(set.iterator().next().toString());
        ((SOAPMessage)sOAPMessageImpl).saveChanges();
        return sOAPMessageImpl;
    }

    static boolean invokeRequestMessageHandlers(OutputStream outputStream, HandlerChain handlerChain, Object[] objectArray) throws IOException, SOAPException {
        if (handlerChain == null) {
            return true;
        }
        if (handlerChain.size() == 0) {
            return true;
        }
        SOAPMessageContext sOAPMessageContext = MessageHandlerInvoker.getMessageContext(outputStream);
        return MessageHandlerInvoker.invokeRequestMessageHandlers(sOAPMessageContext, handlerChain, objectArray);
    }

    static boolean invokeRequestMessageHandlers(InputStream inputStream, MimeHeaders mimeHeaders, HandlerChain handlerChain, Object[] objectArray) throws IOException, SOAPException {
        if (handlerChain == null) {
            return true;
        }
        if (handlerChain.size() == 0) {
            return true;
        }
        SOAPMessageContext sOAPMessageContext = MessageHandlerInvoker.getMessageContext(mimeHeaders, inputStream);
        objectArray[0] = sOAPMessageContext.getMessage();
        return MessageHandlerInvoker.invokeRequestMessageHandlers(sOAPMessageContext, handlerChain, objectArray);
    }

    static boolean invokeRequestMessageHandlers(MimeHeaders mimeHeaders, HandlerChain handlerChain, SOAPMessage[] sOAPMessageArray) throws IOException, SOAPException {
        if (handlerChain == null) {
            return true;
        }
        if (handlerChain.size() == 0) {
            return true;
        }
        SOAPMessageContext sOAPMessageContext = MessageHandlerInvoker.getMessageContext(sOAPMessageArray[0]);
        return MessageHandlerInvoker.invokeRequestMessageHandlers(sOAPMessageContext, handlerChain, (Object[])sOAPMessageArray);
    }

    static boolean invokeRequestMessageHandlers(SOAPMessageContext sOAPMessageContext, HandlerChain handlerChain, Object[] objectArray) throws IOException, SOAPException {
        Object var3_3 = null;
        boolean bl = true;
        try {
            bl = handlerChain.handleRequest(sOAPMessageContext);
        }
        catch (JAXRPCException jAXRPCException) {
            throw new SOAPException(jAXRPCException);
        }
        SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
        sOAPMessage.saveChanges();
        objectArray[0] = sOAPMessage;
        return bl;
    }

    public static byte[] getBytes(SOAPMessage sOAPMessage) throws IOException, SOAPException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        sOAPMessage.writeTo(byteArrayOutputStream);
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] getBytes(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(outputStream.size());
        outputStream.writeTo(byteArrayOutputStream);
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static ClientResponse getClientResponse(SOAPMessage sOAPMessage, ClientRequest clientRequest) throws IOException, SOAPException {
        byte[] byArray = MessageHandlerInvoker.getBytes(sOAPMessage);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        String string = MessageHandlerInvoker.makeSingleLine(MessageHandlerInvoker.getContentType(sOAPMessage.getMimeHeaders()));
        String string2 = MessageHandlerInvoker.getContentLocation(sOAPMessage.getMimeHeaders());
        String string3 = null;
        if (string != null) {
            Properties properties = MultipartRequest.getAttributes(string, ";");
            string3 = properties.getProperty(_CHARSET);
        }
        return MessageHandlerInvoker.getClientResponse(byteArrayInputStream, clientRequest, string, string2);
    }

    public static ClientResponse getClientResponse(InputStream inputStream, Properties properties, ClientRequest clientRequest) throws IOException, SOAPException {
        String string = properties.getProperty("content-type");
        String string2 = properties.getProperty("content-location");
        String string3 = null;
        if (string != null) {
            Properties properties2 = MultipartRequest.getAttributes(string, ";");
            string3 = properties2.getProperty(_CHARSET);
        }
        return MessageHandlerInvoker.getClientResponse(inputStream, clientRequest, string, string2);
    }

    public static ClientResponse getClientResponse(InputStream inputStream, ClientRequest clientRequest, String string, String string2) throws IOException, SOAPException {
        Reader reader = null;
        HashMap hashMap = null;
        boolean bl = MultipartRequest.isMultipart(string);
        if (bl) {
            MultipartRequest multipartRequest = MultipartRequest.createMultipartRequest(inputStream, string, string2);
            reader = multipartRequest.getRoot();
            hashMap = multipartRequest.getMIMEParts();
        } else {
            String string3 = MessageHandlerInvoker.getCharset(string);
            reader = string3 == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string3);
        }
        return clientRequest.createResponse(reader, hashMap);
    }

    public static ServerResponse invokeServerMessageHandlers(InputStream inputStream, Properties properties, HandlerChain handlerChain, Provider provider, InvokeHandler invokeHandler) throws IOException {
        try {
            if (handlerChain == null || handlerChain.size() == 0) {
                return MessageHandlerInvoker.invokeServerEndPoint(properties, inputStream, provider, invokeHandler, null);
            }
            ServerResponse serverResponse = null;
            Object[] objectArray = new SOAPMessage[1];
            MimeHeaders mimeHeaders = MessageHandlerInvoker.getMimeHeaders(properties);
            ProtocolHandler protocolHandler = provider.getProtocolHandler("soap");
            objectArray[0] = MessageHandlerInvoker.getSOAPMessage(mimeHeaders, inputStream);
            Set set = MessageHandlerInvoker.getMUHeaderNames(objectArray[0]);
            Set set2 = MessageHandlerInvoker.getUnderstoodHeaders(handlerChain);
            set.removeAll(set2);
            if (set.size() != 0) {
                SOAPMessage sOAPMessage = MessageHandlerInvoker.createMustUnderstandFault(set);
                String string = properties.getProperty("content-type");
                String string2 = MessageHandlerInvoker.getCharset(string);
                if (string2 == null) {
                    string2 = "utf-8";
                }
                return protocolHandler.createServerResponse(MessageHandlerInvoker.getBytes(sOAPMessage), string2);
            }
            boolean bl = MessageHandlerInvoker.invokeRequestMessageHandlers(mimeHeaders, handlerChain, (SOAPMessage[])objectArray);
            Object object = objectArray[0];
            ((SOAPMessage)object).saveChanges();
            MessageHandlerInvoker.transferHeaders(mimeHeaders, properties);
            if (!bl) {
                String string = properties.getProperty("content-type");
                String string3 = MessageHandlerInvoker.getCharset(string);
                if (string3 == null) {
                    string3 = "utf-8";
                }
                return protocolHandler.createServerResponse(MessageHandlerInvoker.getBytes((SOAPMessage)object), string3);
            }
            mimeHeaders = ((SOAPMessage)object).getMimeHeaders();
            byte[] byArray = MessageHandlerInvoker.getBytes((SOAPMessage)object);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            serverResponse = MessageHandlerInvoker.invokeServerEndPoint(properties, byteArrayInputStream, provider, invokeHandler, set2);
            MessageHandlerInvoker.transferHTTPHeaders(serverResponse, properties);
            objectArray[0] = null;
            MessageHandlerInvoker.invokeResponseMessageHandlers(serverResponse, handlerChain, objectArray);
            object = objectArray[0];
            MessageHandlerInvoker.transferHeaders(((SOAPMessage)object).getMimeHeaders(), properties);
            MessageHandlerInvoker.transferBytes((SOAPMessage)object, serverResponse);
            return serverResponse;
        }
        catch (SOAPException sOAPException) {
            throw new ServiceException(sOAPException);
        }
    }

    static String getCharset(String string) {
        String string2 = null;
        if (string != null) {
            Properties properties = MultipartRequest.getAttributes(string, ";");
            string2 = properties.getProperty(_CHARSET);
        }
        return string2;
    }

    public static ServerResponse invokeServerEndPoint(Properties properties, InputStream inputStream, Provider provider, InvokeHandler invokeHandler, Set set) throws IOException {
        Object object;
        String string = properties.getProperty("content-type");
        String string2 = properties.getProperty("content-location");
        HashMap hashMap = null;
        Reader reader = null;
        String string3 = null;
        boolean bl = MultipartRequest.isMultipart(string);
        if (bl) {
            object = MultipartRequest.createMultipartRequest(inputStream, string, string2);
            reader = ((MultipartRequest)object).getRoot();
            hashMap = ((MultipartRequest)object).getMIMEParts();
            string3 = MessageHandlerInvoker.getCharset(string);
        } else {
            if (string != null) {
                string3 = MessageHandlerInvoker.getCharset(string);
            }
            Reader reader2 = reader = string3 == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string3);
        }
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        object = new XMLReaderImpl(reader);
        String string4 = "soap";
        String string5 = properties.getProperty("soapaction");
        if (string5 == null) {
            string5 = MessageHandlerInvoker.extractSoapAction(string);
        }
        boolean bl2 = invokeHandler.isDocument(string5);
        ProtocolHandler protocolHandler = provider.getProtocolHandler("soap");
        if (string3 == null) {
            string3 = "utf-8";
        }
        ServerResponse serverResponse = protocolHandler.invoke(invokeHandler, (XMLReader)object, string4, bl2, string5, hashMap, set, string3);
        return serverResponse;
    }

    public static boolean invokeResponseMessageHandlers(Properties properties, InputStream inputStream, HandlerChain handlerChain, Object[] objectArray) throws IOException, SOAPException {
        MimeHeaders mimeHeaders = MessageHandlerInvoker.getMimeHeaders(properties);
        boolean bl = MessageHandlerInvoker.invokeResponseMessageHandlers(mimeHeaders, inputStream, handlerChain, objectArray);
        MessageHandlerInvoker.transferHeaders(mimeHeaders, properties);
        return bl;
    }

    public static boolean invokeResponseMessageHandlers(ServerResponse serverResponse, HandlerChain handlerChain, Object[] objectArray) throws IOException, SOAPException {
        SOAPMessage sOAPMessage = MessageHandlerInvoker.getSOAPMessage(serverResponse);
        objectArray[0] = sOAPMessage;
        SOAPMessageContextImpl sOAPMessageContextImpl = new SOAPMessageContextImpl();
        sOAPMessageContextImpl.setMessage(sOAPMessage);
        boolean bl = MessageHandlerInvoker.invokeResponseMessageHandlers(sOAPMessageContextImpl, handlerChain);
        objectArray[0] = sOAPMessageContextImpl.getMessage();
        return bl;
    }

    public static boolean invokeResponseMessageHandlers(MimeHeaders mimeHeaders, InputStream inputStream, HandlerChain handlerChain, Object[] objectArray) throws IOException, SOAPException {
        SOAPMessage sOAPMessage = MessageHandlerInvoker.getSOAPMessage(mimeHeaders, inputStream);
        objectArray[0] = sOAPMessage;
        SOAPMessageContextImpl sOAPMessageContextImpl = new SOAPMessageContextImpl();
        sOAPMessageContextImpl.setMessage(sOAPMessage);
        boolean bl = MessageHandlerInvoker.invokeResponseMessageHandlers(sOAPMessageContextImpl, handlerChain);
        objectArray[0] = sOAPMessageContextImpl.getMessage();
        return bl;
    }

    public static boolean invokeResponseMessageHandlers(SOAPMessage sOAPMessage, HandlerChain handlerChain) throws IOException, SOAPException {
        return MessageHandlerInvoker.invokeResponseMessageHandlers(MessageHandlerInvoker.getMessageContext(sOAPMessage), handlerChain);
    }

    public static boolean invokeResponseMessageHandlers(SOAPMessageContext sOAPMessageContext, HandlerChain handlerChain) throws IOException, SOAPException {
        if (handlerChain == null) {
            return true;
        }
        if (handlerChain.size() == 0) {
            return true;
        }
        try {
            return handlerChain.handleResponse(sOAPMessageContext);
        }
        catch (JAXRPCException jAXRPCException) {
            throw new SOAPException(jAXRPCException);
        }
        catch (SOAPFaultException sOAPFaultException) {
            sOAPFaultException.printStackTrace();
            throw new ServiceException(sOAPFaultException.getMessage());
        }
    }

    public static void invokeServerResponseMessageHandlers(OutputStream outputStream, HandlerChain handlerChain) throws IOException {
        try {
            Object[] objectArray = new Object[1];
            boolean bl = MessageHandlerInvoker.invokeRequestMessageHandlers(outputStream, handlerChain, objectArray);
            if (!bl) {
                byte[] byArray = MessageHandlerInvoker.getBytes((SOAPMessage)objectArray[0]);
                ((OutputStreamImpl)outputStream).reset(byArray);
            }
        }
        catch (SOAPException sOAPException) {
            throw new ServiceException(sOAPException);
        }
    }

    private static SOAPMessageContext getMessageContext(OutputStream outputStream) throws IOException, SOAPException {
        SOAPMessage sOAPMessage = MessageHandlerInvoker.getSOAPMessage(outputStream);
        SOAPMessageContextImpl sOAPMessageContextImpl = new SOAPMessageContextImpl();
        sOAPMessageContextImpl.setMessage(sOAPMessage);
        return sOAPMessageContextImpl;
    }

    private static SOAPMessageContext getMessageContext(SOAPMessage sOAPMessage) throws IOException, SOAPException {
        SOAPMessageContextImpl sOAPMessageContextImpl = new SOAPMessageContextImpl();
        sOAPMessageContextImpl.setMessage(sOAPMessage);
        return sOAPMessageContextImpl;
    }

    private static SOAPMessage getSOAPMessage(OutputStream outputStream) throws IOException, SOAPException {
        Properties properties = new Properties();
        MessageHandlerInvoker.transferHTTPHeaders(outputStream, properties);
        MimeHeaders mimeHeaders = MessageHandlerInvoker.getMimeHeaders(properties);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(outputStream.size());
        outputStream.writeTo(byteArrayOutputStream);
        byteArrayOutputStream.flush();
        return MessageHandlerInvoker.getSOAPMessage(mimeHeaders, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    private static SOAPMessageContext getMessageContext(MimeHeaders mimeHeaders, InputStream inputStream) throws IOException, SOAPException {
        SOAPMessage sOAPMessage = MessageHandlerInvoker.getSOAPMessage(mimeHeaders, inputStream);
        SOAPMessageContextImpl sOAPMessageContextImpl = new SOAPMessageContextImpl();
        sOAPMessageContextImpl.setMessage(sOAPMessage);
        return sOAPMessageContextImpl;
    }

    private static SOAPMessage getSOAPMessage(MimeHeaders mimeHeaders, InputStream inputStream) throws IOException, SOAPException {
        return new SOAPMessageImpl(mimeHeaders, inputStream);
    }

    private static SOAPMessage getSOAPMessage(Properties properties, InputStream inputStream) throws IOException, SOAPException {
        MimeHeaders mimeHeaders = MessageHandlerInvoker.getMimeHeaders(properties);
        return new SOAPMessageImpl(mimeHeaders, inputStream);
    }

    public static void transferBytes(SOAPMessage sOAPMessage, OutputStream outputStream) throws IOException, SOAPException {
        byte[] byArray = MessageHandlerInvoker.getBytes(sOAPMessage);
        ((OutputStreamImpl)outputStream).reset(byArray);
        String string = MessageHandlerInvoker.makeSingleLine(MessageHandlerInvoker.getContentType(sOAPMessage.getMimeHeaders()));
        if (string != null) {
            outputStream._getProperties().put("http.content.type", string);
        }
    }

    public static String getContentType(MimeHeaders mimeHeaders) {
        return MessageHandlerInvoker.getHeader(mimeHeaders, "content-type");
    }

    public static String getContentLocation(MimeHeaders mimeHeaders) {
        return MessageHandlerInvoker.getHeader(mimeHeaders, "content-location");
    }

    public static String getSOAPAction(MimeHeaders mimeHeaders) {
        return MessageHandlerInvoker.getHeader(mimeHeaders, "soapaction");
    }

    public static String getHeader(MimeHeaders mimeHeaders, String string) {
        String[] stringArray = mimeHeaders.getHeader(string);
        if (stringArray == null) {
            return null;
        }
        return stringArray.length == 0 ? null : stringArray[0];
    }

    public static MimeHeaders getMimeHeaders(Properties properties) {
        MimeHeaders mimeHeaders = new MimeHeaders();
        Iterator iterator = ((Hashtable)properties).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getValue();
            if (string == null) continue;
            mimeHeaders.setHeader((String)entry.getKey(), string);
        }
        return mimeHeaders;
    }

    public static void transferHeaders(MimeHeaders mimeHeaders, Properties properties) {
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            String string = mimeHeader.getValue();
            if (string == null) continue;
            properties.setProperty(mimeHeader.getName(), MessageHandlerInvoker.makeSingleLine(string));
        }
    }

    public static String makeSingleLine(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c != '\n' && c != '\r') {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return new String(stringBuffer);
    }

    public static void transferHTTPHeaders(OutputStream outputStream, Properties properties) {
        String string = (String)outputStream._getProperties().get("http.content.type");
        if (string == null) {
            string = (String)outputStream._getProperties().get("content-type");
        }
        if (string == null) {
            string = TEXT_XML;
        }
        ((Hashtable)properties).put("content-type", string);
        String string2 = (String)outputStream._getProperties().get("soapaction");
        if (string2 != null) {
            ((Hashtable)properties).put("soapaction", string2);
        }
    }

    private static void transferHTTPHeaders(Delegate delegate, Properties properties) {
        Cookies cookies;
        Boolean bl = (Boolean)delegate.getProperty("javax.xml.rpc.session.maintain");
        if (bl == null) {
            return;
        }
        if (bl.booleanValue() && (cookies = (Cookies)delegate.getProperty("cookie")) != null) {
            properties.setProperty("cookie", cookies.toString());
        }
    }

    private static void transferHTTPHeaders(Properties properties, Delegate delegate) {
        Boolean bl = (Boolean)delegate.getProperty("javax.xml.rpc.session.maintain");
        if (bl == null) {
            return;
        }
        if (bl.booleanValue()) {
            String string;
            Cookies cookies = (Cookies)delegate.getProperty("cookie");
            if (cookies == null) {
                cookies = new Cookies();
            }
            if ((string = properties.getProperty("set-cookie2")) != null) {
                cookies.readCookieInfo(string);
            }
            if ((string = properties.getProperty("set-cookie")) != null) {
                cookies.readCookieInfo(string);
            }
            delegate.setProperty("cookie", cookies);
        }
    }

    private static String extractSoapAction(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase();
        int n = string2.indexOf("soapaction");
        if (n == -1) {
            return null;
        }
        int n2 = string2.indexOf(";", n = string2.indexOf("=", n));
        if (n2 == -1) {
            n2 = string2.length();
        }
        return string.substring(n + 1, n2);
    }

    static {
        _httpHeaders.addHeader(HTTP_CONTENT_TYPE, TEXT_XML);
    }
}

