/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class MultipartRequest {
    private static final boolean _debug = false;
    private static final String _CID = "content-id";
    private static final String _LOC = "content-location";
    private static final String _ENCODING = "content-transfer-encoding";
    private static final String _BOUNDARY = "boundary";
    private static final String _START = "start";
    private static final String _ROOT = "root";
    private static final String _boundary_start = "--";
    private final String _start;
    private String _boundary;
    private String _end_boundary;
    private boolean _done;
    private final InputStream _bis;
    private static final String _CHARSET = "charset";
    private final HashMap _mimeParts = new HashMap();
    private final StringBuffer _line = new StringBuffer();

    public static MultipartRequest createMultipartRequest(URLConnection uRLConnection) throws IOException {
        String string = uRLConnection.getContentType();
        if (!MultipartRequest.isMultipart(string)) {
            throw new IllegalArgumentException("Content-Type is not MIME!");
        }
        String string2 = uRLConnection.getHeaderField(_LOC);
        return new MultipartRequest(uRLConnection.getInputStream(), string, string2);
    }

    public static boolean isMultipart(String string) {
        if (string == null) {
            return false;
        }
        return string.toLowerCase().startsWith("multipart/related");
    }

    public static MultipartRequest createMultipartRequest(InputStream inputStream, String string, String string2) throws IOException {
        if (!MultipartRequest.isMultipart(string)) {
            throw new IllegalArgumentException("Content-Type is not MIME!");
        }
        return new MultipartRequest(inputStream, string, string2);
    }

    private MultipartRequest(InputStream inputStream, String string, String string2) throws IOException {
        MIMEContent mIMEContent;
        this._bis = new BufferedInputStream(inputStream);
        Properties properties = MultipartRequest.extractMIMEInfo(string);
        this._boundary = properties.getProperty(_BOUNDARY);
        if (this._boundary == null) {
            throw new IOException("MIME boundary not specified");
        }
        this._boundary = _boundary_start + this._boundary;
        this._end_boundary = this._boundary + _boundary_start;
        this._start = this.getLocFromID(properties.getProperty(_START));
        String string3 = this.readLine(this._bis);
        if (string3 == null) {
            throw new IOException("data corrupt, premature ending");
        }
        if (!string3.startsWith(this._boundary)) {
            throw new IOException("data corrupt, no leading boundary:" + this._boundary + "\n" + string3);
        }
        int n = 0;
        while ((mIMEContent = this.readNextPart()) != null) {
            String string4;
            String string5 = this.getLocFromID(mIMEContent.getHeaders().getProperty(_CID));
            if (this._start == null && n == 0) {
                this._mimeParts.put(_ROOT, mIMEContent);
            }
            if ((string4 = mIMEContent.getHeaders().getProperty(_LOC)) == null) {
                if (string5 == null) {
                    if (n != 0) {
                        throw new IOException("no content-id or content-location for mime part");
                    }
                } else {
                    this._mimeParts.put(string5, mIMEContent);
                    if (string5.equals(this._start)) {
                        this._mimeParts.put(_ROOT, mIMEContent);
                    }
                }
            } else {
                this._mimeParts.put(string4, mIMEContent);
                if (string5 != null) {
                    this._mimeParts.put(string5, mIMEContent);
                }
            }
            ++n;
        }
        mIMEContent = this._mimeParts.get(_ROOT);
        if (mIMEContent != null) {
            return;
        }
        if (this._start == null) {
            return;
        }
        mIMEContent = this._mimeParts.get(this._start);
        if (mIMEContent == null) {
            throw new IOException("root mime part referred by start not found:" + this._start);
        }
        this._mimeParts.put(_ROOT, mIMEContent);
    }

    private String getLocFromID(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        int n = string.length() - 1;
        if (string.charAt(0) == '\"' && string.charAt(n) == '\"') {
            string = string.substring(1, n);
        }
        n = string.length() - 1;
        if (string.charAt(0) == '<' && string.charAt(n) == '>') {
            string = string.substring(1, n);
        }
        return string;
    }

    private static Properties extractMIMEInfo(String string) {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = (string2 = string2.trim()).indexOf(61);
            if (n < 0) continue;
            String string3 = string2.substring(0, n).trim().toLowerCase();
            int n2 = n + 1;
            int n3 = string2.length();
            if (string2.charAt(n2) == '\"') {
                ++n2;
            }
            if (string2.charAt(n3 - 1) == '\"') {
                --n3;
            }
            String string4 = string2.substring(n2, n3);
            properties.setProperty(string3, string4);
        }
        return properties;
    }

    public HashMap getMIMEParts() {
        return this._mimeParts;
    }

    public Reader getRoot() {
        return ((MIMEContent)this._mimeParts.get(_ROOT)).getReader();
    }

    private MIMEContent readNextPart() throws IOException {
        Properties properties = this.extractHeaders();
        if (properties == null) {
            return null;
        }
        String string = properties.getProperty("content-type");
        Properties properties2 = MultipartRequest.getAttributes(string, ";");
        String string2 = properties2.getProperty(_CHARSET);
        byte[] byArray = this.readContent();
        InputStreamReader inputStreamReader = string2 == null ? new InputStreamReader(new ByteArrayInputStream(byArray)) : new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), string2);
        return new MIMEContent(properties, inputStreamReader, byArray);
    }

    private Properties extractHeaders() throws IOException {
        char c = (char)this._bis.read();
        char c2 = (char)this._bis.read();
        if (c == '-' && c == c2) {
            return null;
        }
        String string = this.readLine(this._bis);
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        string = "" + c + c2 + string;
        Properties properties = new Properties();
        do {
            int n;
            if ((n = string.indexOf(58)) < 0) {
                throw new IOException("invalid mime header:" + string);
            }
            String string2 = string.substring(0, n).trim().toLowerCase();
            String string3 = string.substring(n + 1).trim();
            properties.setProperty(string2, string3);
            string = this.readLine(this._bis);
            if (string != null) continue;
            throw new IOException("data corrupt, premature ending");
        } while (string.length() != 0);
        return properties;
    }

    private byte[] readContent() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this._boundary.length();
        byte[] byArray = null;
        boolean bl = false;
        while ((n = this._bis.read()) != -1) {
            stringBuffer.append((char)n);
            byteArrayOutputStream.write(n);
            if (stringBuffer.length() > n2) {
                stringBuffer.deleteCharAt(0);
            }
            if (stringBuffer.toString().indexOf(this._boundary) != 0) continue;
            bl = true;
            break;
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        int n3 = bl ? byArray2.length - n2 - 1 : byArray2.length;
        byArray = new byte[n3];
        System.arraycopy(byArray2, 0, byArray, 0, n3);
        return byArray;
    }

    public static Properties getAttributes(String string, String string2) {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "=");
            String string4 = null;
            String string5 = null;
            if (stringTokenizer2.hasMoreTokens()) {
                string4 = stringTokenizer2.nextToken();
            }
            if (stringTokenizer2.hasMoreTokens()) {
                string5 = stringTokenizer2.nextToken();
            }
            if (string4 == null || string5 == null) continue;
            ((Hashtable)properties).put(string4, MultipartRequest.unq(string5));
        }
        return properties;
    }

    private static String unq(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return string;
        }
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private String readLine(InputStream inputStream) throws IOException {
        this._line.delete(0, this._line.length());
        int n = -1;
        while (true) {
            n = inputStream.read();
            inputStream.mark(1);
            if (n == 13) {
                n = inputStream.read();
                if (n == 10) break;
                inputStream.reset();
                break;
            }
            if (n == 10) break;
            if (n == -1) {
                if (this._line.length() == 0) {
                    return null;
                }
                inputStream.reset();
                break;
            }
            this._line.append((char)n);
        }
        return this._line.toString();
    }

    public static class MIMEContent {
        private Properties _headers;
        private Reader _reader;
        private byte[] _bytes;

        public Properties getHeaders() {
            return this._headers;
        }

        public Reader getReader() {
            return this._reader;
        }

        public byte[] getBytes() {
            return this._bytes;
        }

        MIMEContent(Properties properties, Reader reader, byte[] byArray) {
            this._headers = properties;
            this._reader = reader;
            this._bytes = byArray;
        }

        public String getContentType() {
            return this._headers.getProperty("content-type");
        }
    }
}

