/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.core;

import com.sssw.jbroker.saaj.handlers.DataContentHandlerFactoryImpl;
import com.sssw.jbroker.util.IntHashtable;
import com.sssw.jbroker.web.core.InputStreamImpl;
import com.sssw.jbroker.web.encoding.DefaultTypeMappingRegistry;
import com.sssw.jbroker.web.encoding.TypeMappingRegistry;
import com.sssw.jbroker.web.mapping.TypeMapper;
import com.sssw.jbroker.web.portable.InputStream;
import com.sssw.jbroker.web.spi.EncodingStyle;
import com.sssw.jbroker.web.spi.OutputStreamContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataContentHandlerFactory;
import javax.activation.DataHandler;
import javax.mail.Multipart;

public class OutputStreamImpl
implements com.sssw.jbroker.web.portable.OutputStream {
    protected int _idGen;
    protected int _size;
    protected Writer _writer;
    protected TypeMappingRegistry _mapper;
    protected EncodingStyle _encodingStyle;
    protected ByteArrayOutputStream _bytesOS;
    protected Context _context;
    protected String _schemaURI;
    protected String _soapURI;
    protected boolean _isDocument;
    protected final Map _props = new HashMap();
    private final ArrayList _attachments = new ArrayList();
    private static final String _ATTACHMENT = "attachment_";
    private static final String _mimeBoundary = "--MIME_boundary";
    private static final String _contentID = "Content-ID";
    private static final String _contentType = "Content-Type";
    private static boolean _debug = false;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$javax$xml$transform$Source;
    static /* synthetic */ Class class$javax$activation$DataHandler;
    static /* synthetic */ Class class$javax$mail$Multipart;

    protected OutputStreamImpl(byte[] byArray, String string) throws IOException {
        this._bytesOS = new ByteArrayOutputStream(byArray.length);
        this._bytesOS.write(byArray);
        this._writer = new OutputStreamWriter((OutputStream)this._bytesOS, string);
    }

    public OutputStreamImpl(boolean bl, Properties properties, String string) {
        this(1024, bl, properties, string);
    }

    protected OutputStreamImpl(HashMap hashMap, boolean bl, Properties properties, String string) {
        this(1024, hashMap, bl, properties, string);
    }

    protected OutputStreamImpl(int n, HashMap hashMap, boolean bl, Properties properties, String string) {
        this(n, bl, properties, string);
        this._context.setU2PMap(hashMap);
        this._context = new Context(this._context);
    }

    public OutputStreamImpl(int n, boolean bl, Properties properties, String string) {
        try {
            this._isDocument = bl;
            this._bytesOS = new ByteArrayOutputStream(n);
            this._mapper = new DefaultTypeMappingRegistry();
            if (properties != null) {
                this._writer = new OutputStreamWriter((OutputStream)this._bytesOS, "UTF-8");
                this.writeMIMEBoundary(_mimeBoundary);
                this._writer.write(10);
                this.writeHeaders(properties);
                this._writer.write(10);
                this._writer.flush();
            } else {
                this._writer = new OutputStreamWriter((OutputStream)this._bytesOS, string);
            }
            this._context = new Context(this, this._writer, this._mapper, null);
        }
        catch (Exception exception) {
            throw new Error(exception.getMessage());
        }
    }

    public void writeContent(String string) throws IOException {
        if (string != null) {
            this._writer.write(string);
        }
    }

    public void writeByte(byte by) throws IOException {
        this.writeByte(by, "b" + ++this._idGen);
    }

    public void writeByte(byte by, String string) throws IOException {
        this._encodingStyle.writeByte(this._context, by, string);
    }

    public void writeChar(char c) throws IOException {
        this.writeChar(c, "c" + ++this._idGen);
    }

    public void writeChar(char c, String string) throws IOException {
        this.writeObject(new String(new char[]{c}), string);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.writeBoolean(bl, "b" + ++this._idGen);
    }

    public void writeBoolean(boolean bl, String string) throws IOException {
        this._encodingStyle.writeBoolean(this._context, bl, string);
    }

    public void writeInt(int n) throws IOException {
        this.writeInt(n, "i" + ++this._idGen);
    }

    public void writeInt(int n, String string) throws IOException {
        this._encodingStyle.writeInt(this._context, n, string);
    }

    public void writeShort(short s) throws IOException {
        this.writeShort(s, "s" + ++this._idGen);
    }

    public void writeShort(short s, String string) throws IOException {
        this._encodingStyle.writeShort(this._context, s, string);
    }

    public void writeLong(long l) throws IOException {
        this.writeLong(l, "l" + ++this._idGen);
    }

    public void writeLong(long l, String string) throws IOException {
        this._encodingStyle.writeLong(this._context, l, string);
    }

    public void writeFloat(float f) throws IOException {
        this.writeFloat(f, "f" + ++this._idGen);
    }

    public void writeFloat(float f, String string) throws IOException {
        this._encodingStyle.writeFloat(this._context, f, string);
    }

    public void writeDouble(double d) throws IOException {
        this.writeDouble(d, "d" + ++this._idGen);
    }

    public void writeDouble(double d, String string) throws IOException {
        this._encodingStyle.writeDouble(this._context, d, string);
    }

    public void writeObject(Object object) throws IOException {
        this.writeObject(object, "o" + ++this._idGen);
    }

    public void writeObject(Object object, String string) throws IOException {
        this._context = new Context(this._context);
        try {
            this._encodingStyle.writeObject(this._context, object, string);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._context = this._context._prev;
            throw throwable;
        }
        this._context = this._context._prev;
    }

    public void writeObject(Object object, String string, String string2) throws IOException {
        this._context = new Context(this._context);
        try {
            this._encodingStyle.writeObject(this._context, object, string, string2);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._context = this._context._prev;
            throw throwable;
        }
        this._context = this._context._prev;
    }

    public void writeObject(Object object, String string, String string2, String string3, String string4) throws IOException {
        this._context = new Context(this._context);
        try {
            this._encodingStyle.writeObject(this._context, object, string, string2, string3, string4);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this._context = this._context._prev;
            throw throwable;
        }
        this._context = this._context._prev;
    }

    public void writeObject(Object object, String string, String string2, String string3) throws IOException {
        this._context = new Context(this._context);
        try {
            this._encodingStyle.writeObject(this._context, object, string, string2, string3);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this._context = this._context._prev;
            throw throwable;
        }
        this._context = this._context._prev;
    }

    public boolean isDocument() {
        return this._isDocument;
    }

    protected Context newContext() {
        return new Context(this._context);
    }

    public void writeObject(String string, Object object, String string2) throws IOException {
        if (string == null) {
            this.writeObject(object, string2);
        } else {
            EncodingStyle encodingStyle = this._encodingStyle;
            try {
                this.setEncodingStyleURI(string);
                this.writeObject(object, string2);
                Object var6_5 = null;
                this._encodingStyle = encodingStyle;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this._encodingStyle = encodingStyle;
                throw throwable;
            }
        }
    }

    public String setEncodingStyleURI(String string) {
        throw new Error("setEncodingStyleURI not implemented");
    }

    public String getEncodingStyleURI() {
        return this._encodingStyle.getURI();
    }

    public String getSchemaURI() {
        return this._schemaURI;
    }

    public InputStream createInputStream() throws IOException {
        return this.createInputStream(this.getReader(), null);
    }

    public InputStream createInputStream(Reader reader, Map map) throws IOException {
        return new InputStreamImpl(reader, this._encodingStyle, this._isDocument, map);
    }

    public Reader createInputStreamReader() throws IOException {
        return this.getReader();
    }

    public int size() throws IOException {
        this._writer.flush();
        return this._bytesOS.size();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this._bytesOS.flush();
        if (_debug) {
            byte[] byArray = this._bytesOS.toByteArray();
            System.out.println(new String(byArray));
        }
        this._bytesOS.writeTo(outputStream);
    }

    public byte[] toByteArray() throws IOException {
        this._bytesOS.flush();
        byte[] byArray = this._bytesOS.toByteArray();
        if (_debug) {
            System.out.println(new String(byArray));
        }
        return byArray;
    }

    public Map _getProperties() {
        return this._props;
    }

    public void writeAttachment(Object object, String string, String string2, String string3) throws IOException {
        if (object == null) {
            this._attachments.add(null);
            this._encodingStyle.writeObject(this._context, object, string, string2);
            return;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray() && clazz != (array$B == null ? (array$B = OutputStreamImpl.class$("[B")) : array$B)) {
            this._encodingStyle.writeAttachmentArray(this._context, object, string, string2, string3);
            return;
        }
        int n = this._attachments.size();
        String string4 = _ATTACHMENT + n;
        this.writeAttachmentRef(string, string2, string4);
        boolean bl = false;
        if (string3.startsWith("text/xml") && !(class$javax$xml$transform$Source == null ? (class$javax$xml$transform$Source = OutputStreamImpl.class$("javax.xml.transform.Source")) : class$javax$xml$transform$Source).isAssignableFrom(clazz)) {
            bl = true;
        }
        this._attachments.add(new MIMEPart(string3, string4, object, bl));
        this._writer.flush();
    }

    private void writeAttachmentRef(String string, String string2, String string3) throws IOException {
        String string4 = null;
        boolean bl = false;
        if (string == null) {
            bl = false;
        } else {
            string4 = this._context.getPrefix(string);
            if (string4 == null) {
                string4 = this._context.createPrefix(string);
                bl = true;
            }
        }
        this._writer.write(60);
        if (bl) {
            this._writer.write(string4);
            this._writer.write(58);
        }
        this._writer.write(string2);
        this._writer.write(32);
        this._writer.write("href=\"cid:");
        this._writer.write(string3);
        this._writer.write(34);
        this._writer.write(32);
        this._writer.write("xmlns");
        if (bl) {
            this._writer.write(":" + string4);
        }
        this._writer.write(61);
        this._writer.write(34);
        if (bl) {
            this._writer.write(string);
        }
        this._writer.write(34);
        this._writer.write(32);
        this._writer.write(47);
        this._writer.write(62);
    }

    protected void writeMIMEParts() throws IOException {
        int n = this._attachments.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.writeMIMEPart((MIMEPart)this._attachments.get(n2));
            ++n2;
        }
        this._writer.write(10);
        this.writeMIMEBoundary(_mimeBoundary);
        this._writer.write(45);
        this._writer.write(45);
        this._writer.flush();
    }

    private void writeMIMEPart(MIMEPart mIMEPart) throws IOException {
        Class<?> clazz;
        if (mIMEPart == null) {
            return;
        }
        DataHandler dataHandler = null;
        if ((class$javax$activation$DataHandler == null ? (class$javax$activation$DataHandler = OutputStreamImpl.class$("javax.activation.DataHandler")) : class$javax$activation$DataHandler).isAssignableFrom(clazz = mIMEPart.getObject().getClass())) {
            dataHandler = (DataHandler)mIMEPart.getObject();
            mIMEPart.setContentType(dataHandler.getContentType());
        } else if (!mIMEPart.isMimeXml()) {
            dataHandler = new DataHandler(mIMEPart.getObject(), mIMEPart.getContentType());
            if ((class$javax$mail$Multipart == null ? (class$javax$mail$Multipart = OutputStreamImpl.class$("javax.mail.Multipart")) : class$javax$mail$Multipart).isAssignableFrom(clazz)) {
                mIMEPart.setContentType(((Multipart)mIMEPart.getObject()).getContentType());
            }
        }
        this._writer.write(10);
        this.writeMIMEBoundary(_mimeBoundary);
        this._writer.write(10);
        this.writeHeaders(mIMEPart);
        this._writer.write(10);
        this._writer.flush();
        if (mIMEPart.isMimeXml()) {
            Context context = new Context(this, this._writer, this._mapper, null);
            this._encodingStyle.writeObject(context, mIMEPart.getObject(), null, "mimeXml");
        } else {
            dataHandler.writeTo((OutputStream)this._bytesOS);
        }
        this._bytesOS.flush();
    }

    private void writeHeaders(MIMEPart mIMEPart) throws IOException {
        this._writer.write("content-type");
        this._writer.write(58);
        this._writer.write(32);
        this._writer.write(mIMEPart.getContentType());
        this._writer.write(10);
        this._writer.write("content-id");
        this._writer.write(58);
        this._writer.write(32);
        this._writer.write(mIMEPart.getContentID());
        this._writer.write(10);
    }

    private void writeHeaders(Properties properties) throws IOException {
        Iterator iterator = ((Hashtable)properties).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this._writer.write((String)entry.getKey());
            this._writer.write(58);
            this._writer.write(32);
            this._writer.write((String)entry.getValue());
            this._writer.write(10);
        }
    }

    public void writeMIMEBoundary(String string) throws IOException {
        this._writer.write(string);
    }

    private void writeHeader(String string, String string2) throws IOException {
        this._writer.write(string);
        this._writer.write(58);
        this._writer.write(string2);
        this._writer.write(10);
    }

    public void reset(byte[] byArray) throws IOException {
        this._bytesOS.reset();
        this._bytesOS.write(byArray);
    }

    protected Reader getReader() throws IOException {
        this._writer.flush();
        byte[] byArray = this._bytesOS.toByteArray();
        if (_debug) {
            System.out.println(new String(byArray));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return new InputStreamReader(byteArrayInputStream);
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this._mapper = typeMappingRegistry;
        this._context._mapper = this._mapper;
    }

    protected TypeMappingRegistry getTypeMappingRegistry() {
        return this._mapper;
    }

    public void setTypeMapper(TypeMapper typeMapper) {
        this._mapper = new DefaultTypeMappingRegistry(typeMapper);
        this._context._mapper = this._mapper;
    }

    protected TypeMapper getTypeMapper() {
        throw new Error("call getTypeMappingRegistry() instead!");
    }

    public void write(OutputStream outputStream) throws IOException {
        this._bytesOS.writeTo(outputStream);
        this._writer.flush();
    }

    public void setEncodingStyle(EncodingStyle encodingStyle) {
        if (encodingStyle == null) {
            throw new NullPointerException("encoding style can't be null");
        }
        this._encodingStyle = encodingStyle;
    }

    public void setSchemaURI(String string) {
        this._schemaURI = string;
    }

    public OutputStreamContext getContext() {
        return this._context;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (System.getProperty("SOAP_DEBUG") != null) {
            _debug = true;
        }
        try {
            DataHandler.setDataContentHandlerFactory((DataContentHandlerFactory)new DataContentHandlerFactoryImpl());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static class MIMEPart {
        private String _contentID;
        private String _contentType;
        private Object _object;
        private boolean _isMimeXml;

        public String getContentID() {
            return this._contentID;
        }

        public String getContentType() {
            return this._contentType;
        }

        public void setContentType(String string) {
            this._contentType = string;
        }

        public Object getObject() {
            return this._object;
        }

        public boolean isMimeXml() {
            return this._isMimeXml;
        }

        MIMEPart(String string, String string2, Object object, boolean bl) {
            this._contentType = string;
            this._contentID = string2;
            this._object = object;
            this._isMimeXml = bl;
        }
    }

    static final class Context
    implements OutputStreamContext {
        private int _nsGen;
        private TypeMappingRegistry _mapper;
        private final Writer _writer;
        private final com.sssw.jbroker.web.portable.OutputStream _os;
        private HashMap _uri2Prefix;
        private HashMap _prefix2URI;
        private final Context _prev;
        private String _currentURI;
        private String _currentPrefix;
        private final IntHashtable _table;

        Context(Context context) {
            this(context._os, context._writer, context._mapper, context);
        }

        Context(Context context, HashMap hashMap, HashMap hashMap2) {
            this(context);
            this._uri2Prefix = hashMap;
            this._prefix2URI = hashMap2;
        }

        Context(com.sssw.jbroker.web.portable.OutputStream outputStream, Writer writer, TypeMappingRegistry typeMappingRegistry, Context context) {
            this._os = outputStream;
            this._prev = context;
            this._writer = writer;
            this._mapper = typeMappingRegistry;
            if (this._prev != null) {
                this._nsGen = this._prev._nsGen;
                this._currentURI = this._prev._currentURI;
                this._currentPrefix = this._prev._currentPrefix;
                this._table = context._table;
            } else {
                this._table = new IntHashtable();
            }
        }

        void setU2PMap(HashMap hashMap) {
            this._uri2Prefix = hashMap;
        }

        void setP2UMap(HashMap hashMap) {
            this._prefix2URI = hashMap;
        }

        public Writer getWriter() {
            return this._writer;
        }

        public TypeMappingRegistry getTypeMappingRegistry() {
            return this._mapper;
        }

        void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
            this._mapper = typeMappingRegistry;
        }

        public TypeMapper getTypeMapper() {
            throw new Error("call getTypeMappingRegistry()");
        }

        public com.sssw.jbroker.web.portable.OutputStream getOutputStream() {
            return this._os;
        }

        public String getNamespace() {
            return this._currentURI;
        }

        public String getPrefix() {
            return this._currentPrefix;
        }

        public String getPrefix(String string) {
            String string2 = null;
            if (this._uri2Prefix != null) {
                string2 = (String)this._uri2Prefix.get(string);
            }
            string2 = string2 == null && this._prev != null ? this._prev.getPrefix(string) : string2;
            return string2;
        }

        public String getNamespaceURI(String string) {
            String string2 = null;
            if (this._prefix2URI != null) {
                string2 = (String)this._prefix2URI.get(string);
            }
            string2 = string2 == null && this._prev != null ? this._prev.getNamespaceURI(string) : string2;
            return string2;
        }

        public String createPrefix(String string) {
            String string2 = "ns" + ++this._nsGen;
            this.createPrefix(string2, string);
            return string2;
        }

        public void createPrefix(String string, String string2) {
            if (this._uri2Prefix == null) {
                this._uri2Prefix = new HashMap();
            }
            if (this._uri2Prefix.get(string2) != null) {
                throw new IllegalArgumentException("prefix already defined:" + string);
            }
            this._uri2Prefix.put(string2, string);
            if (this._prefix2URI == null) {
                this._prefix2URI = new HashMap();
            }
            if (this._prefix2URI.get(string) != null) {
                throw new IllegalArgumentException("uri already defined:" + string2);
            }
            this._prefix2URI.put(string, string2);
        }

        public void setNamespace(String string, String string2) {
            this._currentURI = string;
            this._currentPrefix = string2;
        }

        public IntHashtable getIdTable() {
            return this._table;
        }
    }
}

