/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.core;

import com.sssw.jbroker.util.Configurator;
import com.sssw.jbroker.web.QName;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.spi.EncodingStyle;
import com.sssw.jbroker.web.spi.ProtocolHandler;
import com.sssw.jbroker.web.spi.TransportHandler;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class Provider
extends Properties {
    static final String JBROKER = "jBroker";
    static final String APACHE = "Apache";
    static final String PROVIDER_PROPERTY = "xmlrpc.provider";
    static final String PROVIDER_RESOURCE = "xmlrpc.provider.properties";
    static final String WSDL_PROPERTY = "xmlrpc.wsdl";
    private static final boolean _debug = false;
    private final String _name;
    private static Provider _defaultProvider;
    private static Configurator _configurator;
    private static final String PROTOCOL_PROP = "xmlrpc.protocol.handler";
    private static final String ENCODING_PROP = "xmlrpc.encoding.style";
    private static final String TRANSPORT_PROP = "xmlrpc.transport.handler";
    private static final int PROTOCOL_PROP_LEN;
    private static final int ENCODING_PROP_LEN;
    private static final int TRANSPORT_PROP_LEN;
    private static final String[] PROPS;
    private static final int[] LENGTHS;
    private final Object[] CONSTRUCTOR_PARMS = new Object[]{this};
    private static final Class[] CONSTRUCTOR_SIGNATURE;
    private final Hashtable _protocols = new Hashtable(5);
    private final Hashtable _encodings = new Hashtable(8);
    private final Hashtable _transports = new Hashtable(8);
    private final Hashtable[] _componentRegistry = new Hashtable[]{this._protocols, this._encodings, this._transports};
    static final Properties DEFAULT_PROPS;
    private static Map _encURIs;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$Provider;

    private Provider(String string) {
        this._name = string;
    }

    public String toString() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }

    public TransportHandler getTransportHandler(String string) {
        return (TransportHandler)this._transports.get(string.toLowerCase());
    }

    public Enumeration getTransportProtocols() {
        return this._transports.keys();
    }

    public EncodingStyle getEncodingStyle(String string) {
        return (EncodingStyle)this._encodings.get(this.getEncodingName(string));
    }

    private String getEncodingName(String string) {
        String string2 = (String)_encURIs.get(string);
        if (string2 != null) {
            return string2;
        }
        return string.toLowerCase();
    }

    public Enumeration getEncodingStyleNames() {
        return this._encodings.keys();
    }

    public ProtocolHandler getProtocolHandler(String string) {
        return (ProtocolHandler)this._protocols.get(string.toLowerCase());
    }

    public ProtocolHandler getProtocolHandler(QName qName) {
        return (ProtocolHandler)this._protocols.get(qName);
    }

    public Enumeration getProtocols() {
        return this._protocols.keys();
    }

    public static Provider getProvider() {
        if (_defaultProvider == null) {
            Class clazz = class$com$sssw$jbroker$web$core$Provider == null ? (class$com$sssw$jbroker$web$core$Provider = Provider.class$("com.sssw.jbroker.web.core.Provider")) : class$com$sssw$jbroker$web$core$Provider;
            synchronized (clazz) {
                if (_defaultProvider == null) {
                    _defaultProvider = Provider.getProvider(JBROKER);
                }
            }
        }
        return _defaultProvider;
    }

    public static Provider getProvider(String string) {
        Provider.configure();
        Provider provider = (Provider)_configurator.getConfiguration(string);
        if (provider == null) {
            throw new ServiceException("no provider \"" + string + "\" found");
        }
        return provider;
    }

    public Object setProperty(String string, String string2) {
        return super.setProperty(string, string2);
    }

    private void initialize() throws Exception {
        String string;
        Enumeration<Object> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.parseProperty(string, this.getProperty(string));
        }
        enumeration = this._protocols.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            ProtocolHandler protocolHandler = (ProtocolHandler)this._protocols.get(string);
            this._protocols.put(protocolHandler.getEnvelopeQName(), protocolHandler);
        }
    }

    private void parseProperty(String string, String string2) throws Exception {
        int n = 0;
        while (n < PROPS.length) {
            if (string.startsWith(PROPS[n])) {
                String string3 = string.substring(LENGTHS[n]);
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(string2, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        clazz = Class.forName(string2);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        if (string2 != null && string2.indexOf("HttpsHandler") == -1) {
                            System.err.println("unable to instantiate " + string2 + "; please check your CLASSPATH");
                        }
                        if (System.getProperty("JBWDebug") != null) {
                            classNotFoundException2.printStackTrace();
                        }
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    if (string2 != null && string2.indexOf("HttpsHandler") == -1) {
                        String string4 = noClassDefFoundError.getMessage();
                        if (string4 != null && string4.length() > 0) {
                            System.err.println("unable to instantiate " + string2 + "; please ensure that " + string4 + " is available from you CLASSPATH");
                        } else {
                            System.err.println("unable to instantiate " + string2 + "; please check your CLASSPATH");
                        }
                    }
                    if (System.getProperty("JBWDebug") != null) {
                        noClassDefFoundError.printStackTrace();
                    }
                    throw noClassDefFoundError;
                }
                Constructor<?> constructor = clazz.getConstructor(CONSTRUCTOR_SIGNATURE);
                Object obj = constructor.newInstance(this.CONSTRUCTOR_PARMS);
                this._componentRegistry[n].put(string3.toLowerCase(), obj);
                return;
            }
            ++n;
        }
    }

    public static synchronized void configure() {
        if (_configurator == null) {
            _configurator = new Configurator(PROVIDER_RESOURCE, new Configurator.ConfigurationFactory(){

                public Properties create(String string) {
                    return new Provider(string);
                }
            });
            _configurator.loadConfiguration((class$com$sssw$jbroker$web$core$Provider == null ? (class$com$sssw$jbroker$web$core$Provider = Provider.class$("com.sssw.jbroker.web.core.Provider")) : class$com$sssw$jbroker$web$core$Provider).getClassLoader());
            Provider provider = (Provider)_configurator.getConfiguration(JBROKER);
            if (provider == null) {
                provider = new Provider(JBROKER);
                Provider.addStaticJBrokerConfig(provider);
                _configurator.addConfiguration(JBROKER, provider);
            }
            Enumeration enumeration = _configurator.getConfigurations();
            while (enumeration.hasMoreElements()) {
                Provider provider2 = (Provider)enumeration.nextElement();
                try {
                    provider2.initialize();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    static final void addStaticJBrokerConfig(Properties properties) {
        properties.setProperty("xmlrpc.encoding.style.soap", "com.sssw.jbroker.web.soap.SOAPEncodingStyle");
        properties.setProperty("xmlrpc.encoding.style.literal", "com.sssw.jbroker.web.soap.LiteralEncodingStyle");
        properties.setProperty("xmlrpc.protocol.handler.soap", "com.sssw.jbroker.web.soap.SOAPHandler");
        properties.setProperty("xmlrpc.transport.handler.http", "com.sssw.jbroker.web.transport.http.HttpHandler");
        properties.setProperty("xmlrpc.transport.handler.https", "com.sssw.jbroker.web.transport.http.HttpsHandler");
        properties.setProperty("xmlrpc.transport.handler.local", "com.sssw.jbroker.web.transport.local.LoopBackHandler");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        PROTOCOL_PROP_LEN = PROTOCOL_PROP.length() + 1;
        ENCODING_PROP_LEN = ENCODING_PROP.length() + 1;
        TRANSPORT_PROP_LEN = TRANSPORT_PROP.length() + 1;
        PROPS = new String[]{PROTOCOL_PROP, ENCODING_PROP, TRANSPORT_PROP};
        LENGTHS = new int[]{PROTOCOL_PROP_LEN, ENCODING_PROP_LEN, TRANSPORT_PROP_LEN};
        CONSTRUCTOR_SIGNATURE = new Class[]{class$java$util$Properties == null ? (class$java$util$Properties = Provider.class$("java.util.Properties")) : class$java$util$Properties};
        DEFAULT_PROPS = new Properties();
        DEFAULT_PROPS.setProperty(PROVIDER_PROPERTY, JBROKER);
        _encURIs = new HashMap();
        _encURIs.put("http://schemas.xmlsoap.org/soap/encoding/", "soap11");
        _encURIs.put("http://www.w3.org/2002/06/soap-encoding", "soap12");
    }
}

