/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.core;

import com.sssw.jbroker.web.ServiceObject;
import com.sssw.jbroker.web.core.GetSupport;
import com.sssw.jbroker.web.core.MessageHandlerInvoker;
import com.sssw.jbroker.web.core.MultipartRequest;
import com.sssw.jbroker.web.core.Provider;
import com.sssw.jbroker.web.core.Util;
import com.sssw.jbroker.web.portable.InvokeHandler;
import com.sssw.jbroker.web.portable.ServerResponse;
import com.sssw.jbroker.web.portable.ServletSkeleton;
import com.sssw.jbroker.web.portable.Stub;
import com.sssw.jbroker.web.xml.rpc.handler.HandlerChainImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.xml.rpc.handler.HandlerChain;

public class ServletDelegateImpl
implements ServletSkeleton.ServletDelegate {
    private InvokeHandler _handler;
    private Provider _provider;
    private Properties _properties;
    private transient HandlerChain _handlerChain;
    private static final String DEFAULT_PROVIDER = "jBroker";
    private static final String CONTENT_TYPE = "text/xml";
    private static final String HTTP_CONTENT_TYPE = "content-type";
    private static final String SOAP_ACTION = "SOAPAction";

    public void setHandler(InvokeHandler invokeHandler) {
        this._handler = invokeHandler;
    }

    public Stub getStub() throws ClassNotFoundException {
        return Util.loadStub((ServletSkeleton)this._handler);
    }

    public Properties getProperties() {
        if (this._properties == null) {
            ServletDelegateImpl servletDelegateImpl = this;
            synchronized (servletDelegateImpl) {
                if (this._properties == null) {
                    this._properties = new Properties(Provider.DEFAULT_PROPS);
                }
            }
        }
        return this._properties;
    }

    public void init() throws ServletException {
        this.initProvider();
    }

    public void initProvider() {
        String string = (String)((ServiceObject)((Object)this._handler))._getProperty("xmlrpc.provider");
        if (string == null) {
            string = DEFAULT_PROVIDER;
        }
        this._provider = Provider.getProvider(string);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getQueryString();
        String string2 = httpServletRequest.getRequestURI();
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string3 = null;
        try {
            string3 = httpServletRequest.getRequestURL().toString();
        }
        catch (Throwable throwable) {
            string3 = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString();
        }
        GetSupport.doGet(httpServletRequest.getReader(), this._handler, string, string2, printWriter, string3);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        int n = httpServletRequest.getContentLength();
        if (n < 0) {
            httpServletResponse.sendError(400, "content length not specified:" + n);
            return;
        }
        String string = httpServletRequest.getContentType();
        if (string == null) {
            return;
        }
        if (string != null) {
            string = string.trim();
        }
        boolean bl = MultipartRequest.isMultipart(string);
        if (!string.startsWith(CONTENT_TYPE) && !bl) {
            httpServletResponse.sendError(400, "invalid Content-Type:" + string);
            return;
        }
        String string2 = httpServletRequest.getHeader(SOAP_ACTION);
        String string3 = (String)((Hashtable)this.getProperties()).get("version");
        if (string3 == null) {
            string2 = null;
        }
        Properties properties = new Properties();
        properties.setProperty(HTTP_CONTENT_TYPE, string);
        if (string2 != null) {
            properties.setProperty("soapaction", string2);
        }
        ServerResponse serverResponse = this.invoke(properties, (InputStream)httpServletRequest.getInputStream());
        String string4 = properties.getProperty(HTTP_CONTENT_TYPE);
        if (string4 == null) {
            string4 = CONTENT_TYPE;
            String string5 = MessageHandlerInvoker.getCharset(string);
            if (string5 != null) {
                string4 = string4 + "; charset=" + string5;
            }
        }
        httpServletResponse.addHeader("Content-Type", string4);
        int n2 = Integer.parseInt(properties.getProperty("content-length"));
        httpServletResponse.setContentLength(serverResponse.size());
        serverResponse.writeTo((OutputStream)httpServletResponse.getOutputStream());
    }

    public ServerResponse invoke(Properties properties, InputStream inputStream) throws IOException {
        if (this._provider == null) {
            this.initProvider();
        }
        ServerResponse serverResponse = MessageHandlerInvoker.invokeServerMessageHandlers(inputStream, properties, this._handlerChain, this._provider, this._handler);
        ((Hashtable)properties).clear();
        String string = (String)serverResponse._getProperties().get("http.content.type");
        if (string != null) {
            properties.setProperty(HTTP_CONTENT_TYPE, string);
        }
        ((Hashtable)properties).put("content-length", String.valueOf(serverResponse.size()));
        return serverResponse;
    }

    public void setHandlerChain(List list) {
        if (this._handlerChain != null) {
            this._handlerChain.destroy();
        }
        this._handlerChain = new HandlerChainImpl(list);
    }

    static {
        Provider.configure();
    }
}

