/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.core;

import com.sssw.jbroker.util.Base64Encoder;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.core.GenericStub;
import com.sssw.jbroker.web.portable.MDBSkeleton;
import com.sssw.jbroker.web.portable.ServletSkeleton;
import com.sssw.jbroker.web.portable.Skeleton;
import com.sssw.jbroker.web.portable.Stub;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;

public final class Util {
    private static boolean _hasProxySupport;
    private static final boolean _debug = false;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$com$sssw$jbroker$web$portable$ServletSkeleton;
    static /* synthetic */ Class class$com$sssw$jbroker$web$portable$MDBSkeleton;
    static /* synthetic */ Class class$com$sssw$jbroker$web$portable$Stub;

    private Util() {
    }

    public static boolean hasProxySupport() {
        return _hasProxySupport;
    }

    public static boolean isJDK13() {
        return _hasProxySupport;
    }

    public static byte[] serializeAsBytes(Object object) {
        return WSObjectOutputStream.serializeAsBytes(object);
    }

    public static String serialize(Object object) {
        return WSObjectOutputStream.serialize(object);
    }

    public static Object deserialize(String string) {
        return WSObjectInputStream.deserialize(string);
    }

    public static Class getRemoteInterfaceForClass(Class clazz) {
        Class<?> clazz2 = null;
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            if ((class$java$rmi$Remote == null ? Util.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(classArray[n])) {
                clazz2 = classArray[n];
                break;
            }
            ++n;
        }
        return clazz2;
    }

    public static String getRemoteInterfaceName(Object object) {
        return object instanceof GenericStub ? ((GenericStub)object).getInterfaceName() : Util.getRemoteInterface(object).getName();
    }

    public static Class getRemoteInterface(Object object) {
        Class<?> clazz = object.getClass();
        if (!Util.hasProxySupport() || !Proxy.isProxyClass(clazz)) {
            Class clazz2 = object instanceof ServletSkeleton ? (class$com$sssw$jbroker$web$portable$ServletSkeleton == null ? (class$com$sssw$jbroker$web$portable$ServletSkeleton = Util.class$("com.sssw.jbroker.web.portable.ServletSkeleton")) : class$com$sssw$jbroker$web$portable$ServletSkeleton) : (object instanceof MDBSkeleton ? (class$com$sssw$jbroker$web$portable$MDBSkeleton == null ? (class$com$sssw$jbroker$web$portable$MDBSkeleton = Util.class$("com.sssw.jbroker.web.portable.MDBSkeleton")) : class$com$sssw$jbroker$web$portable$MDBSkeleton) : (class$com$sssw$jbroker$web$portable$Stub == null ? (class$com$sssw$jbroker$web$portable$Stub = Util.class$("com.sssw.jbroker.web.portable.Stub")) : class$com$sssw$jbroker$web$portable$Stub));
            while (clazz.getSuperclass() != clazz2) {
                clazz = clazz.getSuperclass();
            }
        }
        return Util.getRemoteInterfaceForClass(clazz);
    }

    public static Stub loadStub(Skeleton skeleton) throws ClassNotFoundException {
        return (Stub)GenericStub._loadStub(skeleton, Util.getRemoteInterface(skeleton), false);
    }

    public static String getStubName(String string, String string2) {
        int n = string.lastIndexOf(46);
        String string3 = n == -1 ? "_" + string : string.substring(0, n) + "._" + string.substring(n + 1);
        return string3 + string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            _hasProxySupport = Class.forName("java.lang.reflect.Proxy") != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class WSObjectInputStream
    extends ObjectInputStream {
        private final ByteArrayInputStream _bis;

        public WSObjectInputStream(byte[] byArray) throws IOException, StreamCorruptedException {
            this(new ByteArrayInputStream(byArray));
        }

        private WSObjectInputStream(ByteArrayInputStream byteArrayInputStream) throws IOException, StreamCorruptedException {
            super(byteArrayInputStream);
            this._bis = byteArrayInputStream;
            this.enableResolveObject(true);
        }

        public static Object deserialize(String string) {
            Object object = null;
            try {
                WSObjectInputStream wSObjectInputStream = new WSObjectInputStream(Base64Encoder.decode(string));
                object = wSObjectInputStream.readObject();
                wSObjectInputStream.close();
            }
            catch (Exception exception) {
                throw new ServiceException(exception);
            }
            return object;
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            Class<?> clazz = null;
            try {
                clazz = super.resolveClass(objectStreamClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName(objectStreamClass.getName(), true, Thread.currentThread().getContextClassLoader());
            }
            if (clazz == null) {
                throw new ClassNotFoundException(objectStreamClass.getName());
            }
            return clazz;
        }
    }

    private static class WSObjectOutputStream
    extends ObjectOutputStream {
        private final ByteArrayOutputStream _bos;

        public WSObjectOutputStream() throws IOException {
            this(new ByteArrayOutputStream());
        }

        private WSObjectOutputStream(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
            super(byteArrayOutputStream);
            this._bos = byteArrayOutputStream;
            this.enableReplaceObject(true);
        }

        protected Object replaceObject(Object object) throws IOException {
            if (object instanceof ServletSkeleton) {
                return ((ServletSkeleton)object)._getStub();
            }
            if (object instanceof MDBSkeleton) {
                return ((MDBSkeleton)object)._getStub();
            }
            return object;
        }

        public static byte[] serializeAsBytes(Object object) {
            try {
                WSObjectOutputStream wSObjectOutputStream = new WSObjectOutputStream();
                wSObjectOutputStream.writeObject(object);
                wSObjectOutputStream.close();
                return wSObjectOutputStream._bos.toByteArray();
            }
            catch (Exception exception) {
                throw new ServiceException(exception);
            }
        }

        public static String serialize(Object object) {
            return Base64Encoder.encode(WSObjectOutputStream.serializeAsBytes(object));
        }
    }
}

