/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.core;

import com.sssw.jbroker.util.xml.BufferedXmlPullParser;
import com.sssw.jbroker.util.xml.HREFNotFound;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.core.XMLScrapImpl;
import com.sssw.jbroker.web.spi.XMLReader;
import com.sssw.jbroker.web.spi.XMLScrap;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gjt.xpp.XmlPullParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class XMLReaderImpl
implements XMLReader {
    private int _markSubTree;
    private Reader _reader;
    private BufferedXmlPullParser _parser;
    private XMLScrapImpl _scrap;
    private boolean _peeked = false;
    private static final boolean _debug = false;
    private static final boolean _debug_EOF = false;
    private static final boolean _print = false;

    public XMLReaderImpl(char[] cArray) {
        this._parser = new BufferedXmlPullParser(cArray);
        this._scrap = new XMLScrapImpl(this);
    }

    public XMLReaderImpl(Reader reader, boolean bl) {
        this._reader = reader;
        if (bl) {
            this._parser = new BufferedXmlPullParser(reader);
        }
        this._scrap = new XMLScrapImpl(this);
    }

    public XMLReaderImpl(Reader reader) {
        this(reader, true);
    }

    public BufferedXmlPullParser getXmlPullParser() {
        return this._parser;
    }

    public Reader getReader() {
        return this._reader;
    }

    public void setReader(Reader reader) {
        try {
            this._parser.setInput(reader);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new RuntimeException("error initializing pull parser");
        }
        this._peeked = false;
    }

    XMLScrapImpl peekLI(int n) throws IOException {
        this.peek();
        if (this._scrap._type != n) {
            throw new EOFException("unexpected tag " + this._scrap._type + "(" + this._scrap + ")");
        }
        this._peeked = true;
        return this._scrap;
    }

    XMLScrapImpl peekI(int n) throws IOException {
        this.peek();
        if (n != this._scrap._type) {
            this._peeked = false;
            --this._markSubTree;
            throw new EOFException();
        }
        return this._scrap;
    }

    public XMLScrap peek(int n) throws IOException {
        this.peek();
        if (this._scrap._type != n) {
            throw new IOException("unexpected tag " + this._scrap._type);
        }
        return this._scrap;
    }

    public XMLScrap next(int n) throws IOException {
        this.peek();
        if (this._scrap._type != n) {
            String string = "got " + XMLReaderImpl.type2str(this._scrap._type) + " (" + this._scrap + "), expected " + XMLReaderImpl.type2str(n);
            throw new EOFException(string);
        }
        this.next();
        return this._scrap;
    }

    private static final String type2str(int n) {
        if (n == 2) {
            return "ELEMENT_START";
        }
        if (n == 3) {
            return "ELEMENT_END";
        }
        if (n == 4) {
            return "CONTENT";
        }
        if (n == 1) {
            return "DOCUMENT_END";
        }
        return "UNKNOWN";
    }

    public int startSubTree() {
        this._markSubTree = this._parser.getDepth();
        return this._markSubTree;
    }

    public void endSubTree(int n) {
        this._markSubTree = n;
    }

    public XMLScrap current() {
        return this._scrap;
    }

    public XMLScrap peek() throws IOException {
        if (this._peeked) {
            return this._scrap;
        }
        this.next();
        this._peeked = true;
        return this._scrap;
    }

    void readEndTag(XMLScrap xMLScrap) {
        try {
            this._parser.readEndTag(this._scrap._endTag);
            this._scrap._tagRead = true;
        }
        catch (Throwable throwable) {
            throw new ServiceException(throwable.getMessage());
        }
    }

    void readStartTag(XMLScrap xMLScrap) {
        try {
            this._parser.readStartTag(this._scrap._startTag);
            this._scrap._tagRead = true;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new ServiceException(xmlPullParserException.getMessage());
        }
    }

    public XMLScrap next() throws IOException {
        if (this._peeked) {
            this._peeked = false;
            return this._scrap;
        }
        try {
            byte by = this._parser.next();
            switch (by) {
                case 2: {
                    this._scrap._type = 2;
                    this._scrap._tagRead = false;
                    break;
                }
                case 4: {
                    this._scrap._type = 4;
                    this._scrap._content = this._parser.readContent();
                    break;
                }
                case 3: {
                    this._scrap._type = 3;
                    if (this._markSubTree > this._parser.getDepth()) {
                        this._peeked = true;
                        throw new EOFException("reading beyond the subtree");
                    }
                    this._scrap._tagRead = false;
                    break;
                }
                case 1: {
                    this._scrap._type = 1;
                }
            }
            return this._scrap;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (HREFNotFound hREFNotFound) {
            throw hREFNotFound;
        }
        catch (Throwable throwable) {
            String string = throwable.getMessage();
            if (string == null || string.length() == 0) {
                string = throwable.toString();
            }
            throw new IOException(string);
        }
    }

    public Element nextAsElement() throws IOException {
        if (this._scrap._type != 2) {
            throw new IOException("last scrap read was not an element start");
        }
        this._peeked = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (n != 0) {
            this.next();
            if (this._scrap._type == 2) {
                ++n;
                continue;
            }
            if (this._scrap._type != 3) continue;
            --n;
        }
        StringReader stringReader = new StringReader(new String(stringBuffer));
        InputSource inputSource = new InputSource(stringReader);
        try {
            DocumentBuilder documentBuilder = XMLReaderImpl.getParser();
            Document document = documentBuilder.parse(inputSource);
            return document.getDocumentElement();
        }
        catch (Exception exception) {
            throw new IOException("parsing exception" + exception);
        }
    }

    private static DocumentBuilder getParser() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ServiceException("failed to instantiate parser: " + parserConfigurationException);
        }
    }

    public QName getQName(String string) throws IOException {
        try {
            return new QName(this._parser.getQNameUri(string), this._parser.getQNameLocal(string));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IOException(throwable.getMessage());
        }
    }

    public void setNamespaceAttributesReporting(boolean bl) throws IOException {
        try {
            this._parser.setNamespaceAttributesReporting(bl);
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
    }

    public boolean isNamespaceAttributesReporting() {
        return this._parser.isNamespaceAttributesReporting();
    }

    public void setAllowedMixedContent(boolean bl) throws IOException {
        try {
            this._parser.setAllowedMixedContent(bl);
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
    }
}

