/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.core.mapping;

import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.core.mapping.TypeMappingBase;
import com.sssw.jbroker.web.encoding.Attribute;
import com.sssw.jbroker.web.portable.InputStream;
import com.sssw.jbroker.web.portable.OutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import java.util.Vector;
import javax.xml.namespace.QName;

public class ListMapping
extends TypeMappingBase {
    private static final String STACK = "Stack";
    private static final String VECTOR = "Vector";
    private static final String ARRAYLIST = "ArrayList";
    private static final String LINKEDLIST = "LinkedList";
    private static final Attribute[] _stackAttrs = new Attribute[]{new Attribute(new QName("http://schemas.silverstream.com/jBroker", "instance"), "Stack")};
    private static final Attribute[] _vectorAttrs = new Attribute[]{new Attribute(new QName("http://schemas.silverstream.com/jBroker", "instance"), "Vector")};
    private static final Attribute[] _arrayListAttrs = new Attribute[]{new Attribute(new QName("http://schemas.silverstream.com/jBroker", "instance"), "ArrayList")};
    private static final Attribute[] _linkedListAttrs = new Attribute[]{new Attribute(new QName("http://schemas.silverstream.com/jBroker", "instance"), "LinkedList")};
    public static final Class[] _classes = new Class[]{class$java$util$Collection == null ? (class$java$util$Collection = ListMapping.class$("java.util.Collection")) : class$java$util$Collection, class$java$util$List == null ? (class$java$util$List = ListMapping.class$("java.util.List")) : class$java$util$List, class$java$util$Vector == null ? (class$java$util$Vector = ListMapping.class$("java.util.Vector")) : class$java$util$Vector, class$java$util$ArrayList == null ? (class$java$util$ArrayList = ListMapping.class$("java.util.ArrayList")) : class$java$util$ArrayList, class$java$util$LinkedList == null ? (class$java$util$LinkedList = ListMapping.class$("java.util.LinkedList")) : class$java$util$LinkedList, class$java$util$Stack == null ? (class$java$util$Stack = ListMapping.class$("java.util.Stack")) : class$java$util$Stack};
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$LinkedList;
    static /* synthetic */ Class class$java$util$Stack;

    public ListMapping() {
        super(_classes, "http://schemas.silverstream.com/jBroker", "List", TypeMappingBase.getLocation("List"));
    }

    public Attribute[] getAttributes(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.equals(class$java$util$Vector == null ? (class$java$util$Vector = ListMapping.class$("java.util.Vector")) : class$java$util$Vector)) {
            return _vectorAttrs;
        }
        if (clazz.equals(class$java$util$ArrayList == null ? (class$java$util$ArrayList = ListMapping.class$("java.util.ArrayList")) : class$java$util$ArrayList)) {
            return _arrayListAttrs;
        }
        if (clazz.equals(class$java$util$LinkedList == null ? (class$java$util$LinkedList = ListMapping.class$("java.util.LinkedList")) : class$java$util$LinkedList)) {
            return _linkedListAttrs;
        }
        if (clazz.equals(class$java$util$Stack == null ? (class$java$util$Stack = ListMapping.class$("java.util.Stack")) : class$java$util$Stack)) {
            return _linkedListAttrs;
        }
        if ((class$java$util$Collection == null ? (class$java$util$Collection = ListMapping.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
            return _arrayListAttrs;
        }
        throw new ServiceException("unsupported list type: " + clazz);
    }

    public void serialize(OutputStream outputStream, Object object) throws IOException {
        Collection collection = (Collection)object;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            outputStream.writeObject(iterator.next(), "element");
        }
    }

    public Object deserialize(InputStream inputStream, Class clazz) throws IOException {
        AbstractList abstractList = null;
        String string = inputStream.getAttributes().getValue("http://schemas.silverstream.com/jBroker", "instance");
        if (string == null) {
            abstractList = new Vector<Object>();
        } else if (string.equals(VECTOR)) {
            abstractList = new Vector();
        } else if (string.equals(ARRAYLIST)) {
            abstractList = new ArrayList();
        } else if (string.equals(LINKEDLIST)) {
            abstractList = new LinkedList();
        } else if (string.equals(STACK)) {
            abstractList = new Stack();
        } else {
            throw new ServiceException("unsupported list type: " + string);
        }
        try {
            while (true) {
                abstractList.add(inputStream.readObject());
            }
        }
        catch (EOFException eOFException) {
            return abstractList;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

