/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.core.mapping;

import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.core.mapping.TypeMappingBase;
import com.sssw.jbroker.web.encoding.Attribute;
import com.sssw.jbroker.web.portable.InputStream;
import com.sssw.jbroker.web.portable.OutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;

public class MapMapping
extends TypeMappingBase {
    private static final String HASHMAP = "HashMap";
    private static final String TREEMAP = "TreeMap";
    private static final String HASHTABLE = "Hashtable";
    private static final String WEAKHMAP = "WeakHashMap";
    private static final String PROPERTIES = "Properties";
    private static final Attribute[] _hashMapAttrs = new Attribute[]{new Attribute(new QName("http://schemas.silverstream.com/jBroker", "instance"), "HashMap")};
    private static final Attribute[] _hashTableAttrs = new Attribute[]{new Attribute(new QName("http://schemas.silverstream.com/jBroker", "instance"), "Hashtable")};
    private static final Attribute[] _treeMapAttrs = new Attribute[]{new Attribute(new QName("http://schemas.silverstream.com/jBroker", "instance"), "TreeMap")};
    private static final Attribute[] _weakHMapAttrs = new Attribute[]{new Attribute(new QName("http://schemas.silverstream.com/jBroker", "instance"), "WeakHashMap")};
    private static final Attribute[] _propertiesAttrs = new Attribute[]{new Attribute(new QName("http://schemas.silverstream.com/jBroker", "instance"), "Properties")};
    public static final Class[] _classes = new Class[]{class$java$util$Map == null ? (class$java$util$Map = MapMapping.class$("java.util.Map")) : class$java$util$Map, class$java$util$Hashtable == null ? (class$java$util$Hashtable = MapMapping.class$("java.util.Hashtable")) : class$java$util$Hashtable, class$java$util$WeakHashMap == null ? (class$java$util$WeakHashMap = MapMapping.class$("java.util.WeakHashMap")) : class$java$util$WeakHashMap, class$java$util$TreeMap == null ? (class$java$util$TreeMap = MapMapping.class$("java.util.TreeMap")) : class$java$util$TreeMap, class$java$util$Properties == null ? (class$java$util$Properties = MapMapping.class$("java.util.Properties")) : class$java$util$Properties, class$java$util$HashMap == null ? (class$java$util$HashMap = MapMapping.class$("java.util.HashMap")) : class$java$util$HashMap, class$java$util$SortedMap == null ? (class$java$util$SortedMap = MapMapping.class$("java.util.SortedMap")) : class$java$util$SortedMap, class$java$util$AbstractMap == null ? (class$java$util$AbstractMap = MapMapping.class$("java.util.AbstractMap")) : class$java$util$AbstractMap};
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$util$WeakHashMap;
    static /* synthetic */ Class class$java$util$TreeMap;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$SortedMap;
    static /* synthetic */ Class class$java$util$AbstractMap;

    public MapMapping() {
        super(_classes, "http://schemas.silverstream.com/jBroker", "Map", TypeMappingBase.getLocation("Map"));
    }

    public Attribute[] getAttributes(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.equals(class$java$util$Hashtable == null ? (class$java$util$Hashtable = MapMapping.class$("java.util.Hashtable")) : class$java$util$Hashtable)) {
            return null;
        }
        if (clazz.equals(class$java$util$TreeMap == null ? (class$java$util$TreeMap = MapMapping.class$("java.util.TreeMap")) : class$java$util$TreeMap)) {
            return _treeMapAttrs;
        }
        if (clazz.equals(class$java$util$HashMap == null ? (class$java$util$HashMap = MapMapping.class$("java.util.HashMap")) : class$java$util$HashMap)) {
            return _hashMapAttrs;
        }
        if (clazz.equals(class$java$util$WeakHashMap == null ? (class$java$util$WeakHashMap = MapMapping.class$("java.util.WeakHashMap")) : class$java$util$WeakHashMap)) {
            return _weakHMapAttrs;
        }
        if (clazz.equals(class$java$util$Properties == null ? (class$java$util$Properties = MapMapping.class$("java.util.Properties")) : class$java$util$Properties)) {
            return _propertiesAttrs;
        }
        throw new ServiceException("unsupported map type: " + object.getClass());
    }

    public void serialize(OutputStream outputStream, Object object) throws IOException {
        Map map = (Map)object;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            MapEntry mapEntry = new MapEntry(iterator.next());
            outputStream.writeObject(mapEntry, "item");
        }
    }

    public Object deserialize(InputStream inputStream, Class clazz) throws IOException {
        Map<Object, Object> map = null;
        String string = inputStream.getAttributes().getValue("http://schemas.silverstream.com/jBroker", "instance");
        if (string == null) {
            map = new Hashtable(17);
        } else if (string.equals(PROPERTIES)) {
            map = new Properties();
        } else if (string.equals(HASHMAP)) {
            map = new HashMap();
        } else if (string.equals(TREEMAP)) {
            map = new TreeMap();
        } else if (string.equals(WEAKHMAP)) {
            map = new WeakHashMap();
        } else {
            throw new ServiceException("unsupported map type: " + string);
        }
        try {
            while (true) {
                MapEntry mapEntry = (MapEntry)inputStream.readObject();
                map.put(mapEntry.getKey(), mapEntry.getValue());
            }
        }
        catch (EOFException eOFException) {
            return map;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class MapEntry
    implements Map.Entry {
        private Object _key;
        private Object _value;

        MapEntry(Map.Entry entry) {
            this(entry.getKey(), entry.getValue());
        }

        MapEntry(Object object, Object object2) {
            this._key = object;
            this._value = object2;
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        public Object setValue(Object object) {
            Object object2 = this._value;
            this._value = object;
            return object2;
        }

        public boolean equals(Object object) {
            try {
                MapEntry mapEntry = (MapEntry)object;
                return this._key.equals(mapEntry._key) && this._value.equals(mapEntry._value);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public String toString() {
            return this._key.toString() + "->" + this._value;
        }
    }
}

