/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.core.mapping;

import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.core.mapping.TypeMappingBase;
import com.sssw.jbroker.web.encoding.Attribute;
import com.sssw.jbroker.web.portable.InputStream;
import com.sssw.jbroker.web.portable.OutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class SetMapping
extends TypeMappingBase {
    private static final String HASHSET = "HashSet";
    private static final String TREESET = "TreeSet";
    private static final Attribute[] _hashSetAttrs = new Attribute[]{new Attribute(new QName("http://schemas.silverstream.com/jBroker", "instance"), "HashSet")};
    private static final Attribute[] _treeSetAttrs = new Attribute[]{new Attribute(new QName("http://schemas.silverstream.com/jBroker", "instance"), "TreeSet")};
    public static final Class[] _classes = new Class[]{class$java$util$Set == null ? (class$java$util$Set = SetMapping.class$("java.util.Set")) : class$java$util$Set, class$java$util$TreeSet == null ? (class$java$util$TreeSet = SetMapping.class$("java.util.TreeSet")) : class$java$util$TreeSet, class$java$util$Collection == null ? (class$java$util$Collection = SetMapping.class$("java.util.Collection")) : class$java$util$Collection, class$java$util$HashSet == null ? (class$java$util$HashSet = SetMapping.class$("java.util.HashSet")) : class$java$util$HashSet, class$java$util$SortedSet == null ? (class$java$util$SortedSet = SetMapping.class$("java.util.SortedSet")) : class$java$util$SortedSet, class$java$util$AbstractSet == null ? (class$java$util$AbstractSet = SetMapping.class$("java.util.AbstractSet")) : class$java$util$AbstractSet};
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$TreeSet;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$util$AbstractSet;

    public SetMapping() {
        super(_classes, "http://schemas.silverstream.com/jBroker", "Set", TypeMappingBase.getLocation("Set"));
    }

    public Attribute[] getAttributes(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.equals(class$java$util$HashSet == null ? (class$java$util$HashSet = SetMapping.class$("java.util.HashSet")) : class$java$util$HashSet)) {
            return _hashSetAttrs;
        }
        if (clazz.equals(class$java$util$TreeSet == null ? (class$java$util$TreeSet = SetMapping.class$("java.util.TreeSet")) : class$java$util$TreeSet)) {
            return _treeSetAttrs;
        }
        throw new ServiceException("unsupported set type: " + clazz);
    }

    public void serialize(OutputStream outputStream, Object object) throws IOException {
        Set set = (Set)object;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            outputStream.writeObject(iterator.next(), "member");
        }
    }

    public Object deserialize(InputStream inputStream, Class clazz) throws IOException {
        AbstractSet abstractSet = null;
        String string = inputStream.getAttributes().getValue("http://schemas.silverstream.com/jBroker", "instance");
        if (string == null) {
            abstractSet = new HashSet<Object>();
        }
        if (string.equals(HASHSET)) {
            abstractSet = new HashSet();
        } else if (string.equals(TREESET)) {
            abstractSet = new TreeSet();
        } else {
            throw new ServiceException("unsupported set type");
        }
        try {
            while (true) {
                abstractSet.add(inputStream.readObject());
            }
        }
        catch (EOFException eOFException) {
            return abstractSet;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

