/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.encoding;

import com.sssw.jbroker.web.QName;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.encoding.Attribute;
import com.sssw.jbroker.web.encoding.Marshaler;
import com.sssw.jbroker.web.portable.InputStream;
import com.sssw.jbroker.web.portable.OutputStream;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Method;

public class BeanMarshaler
implements Marshaler {
    private final Class _javaType;
    private final PropertyDescriptor[] _propDescs;
    private static final Object[] READ_ARGS = new Object[0];
    private static final boolean _debug = false;

    public BeanMarshaler() {
        this(null, null);
    }

    public BeanMarshaler(Class clazz) {
        this(clazz, BeanMarshaler.getPropertyDescriptor(clazz));
    }

    private BeanMarshaler(Class clazz, PropertyDescriptor[] propertyDescriptorArray) {
        this._javaType = clazz;
        this._propDescs = propertyDescriptorArray;
    }

    public String getMechanismType() {
        return null;
    }

    public Attribute[] getAttributes(Object object) {
        return null;
    }

    public void serialize(OutputStream outputStream, Object object) throws IOException {
        try {
            Class<?> clazz = object.getClass();
            PropertyDescriptor[] propertyDescriptorArray = clazz != this._javaType ? BeanMarshaler.getPropertyDescriptor(clazz) : this._propDescs;
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                if (BeanMarshaler.isReadWrite(propertyDescriptorArray[n])) {
                    Method method = propertyDescriptorArray[n].getReadMethod();
                    String string = propertyDescriptorArray[n].getName();
                    Object object2 = method.invoke(object, READ_ARGS);
                    outputStream.writeObject(object2, string);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new ServiceException(exception);
        }
    }

    public Object deserialize(InputStream inputStream, Class clazz) throws IOException {
        try {
            Object t = clazz.newInstance();
            String string = null;
            Class<?> clazz2 = null;
            QName qName = null;
            Object object = null;
            while ((qName = inputStream.peek()) != null) {
                PropertyDescriptor propertyDescriptor;
                string = qName.getLocalPart();
                try {
                    propertyDescriptor = new PropertyDescriptor(string, clazz);
                }
                catch (IntrospectionException introspectionException) {
                    throw new IOException("encountered " + string + " which is not a bean property in " + clazz);
                }
                clazz2 = propertyDescriptor.getPropertyType();
                try {
                    object = inputStream.readObject(clazz2, string);
                }
                catch (EOFException eOFException) {
                    break;
                }
                Method method = propertyDescriptor.getWriteMethod();
                method.invoke(t, object);
            }
            return t;
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new ServiceException(exception);
        }
    }

    private PropertyDescriptor getPropertyDescriptor(PropertyDescriptor[] propertyDescriptorArray, String string, int n) throws IOException {
        if (propertyDescriptorArray[n].getName().equals(string)) {
            return propertyDescriptorArray[n];
        }
        int n2 = 0;
        while (n2 < propertyDescriptorArray.length) {
            if (propertyDescriptorArray[n2].getName().equals(string)) {
                return propertyDescriptorArray[n2];
            }
            ++n2;
        }
        throw new IOException("no property with name " + string);
    }

    private static boolean isReadWrite(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getReadMethod() != null && propertyDescriptor.getWriteMethod() != null && propertyDescriptor.getName() != "class";
    }

    private static PropertyDescriptor[] getPropertyDescriptor(Class clazz) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            return beanInfo.getPropertyDescriptors();
        }
        catch (Exception exception) {
            throw new ServiceException("unable to get property descriptor for bean class \"" + clazz.getName() + "\"");
        }
    }
}

