/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.encoding;

import com.sssw.jbroker.web.encoding.DefaultDeserializerFactory;
import com.sssw.jbroker.web.encoding.DefaultSerializerFactory;
import com.sssw.jbroker.web.encoding.Deserializer;
import com.sssw.jbroker.web.encoding.Serializer;
import com.sssw.jbroker.web.encoding.XMLType;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;

public class TypeMap {
    private Class _javaType;
    private XMLType _xmlType;
    private SerializerFactory _serFactory;
    private DeserializerFactory _deserFactory;

    public TypeMap(Class clazz, Serializer serializer, Deserializer deserializer, QName qName) {
        this(clazz, serializer, deserializer, new XMLType(qName, null));
    }

    public TypeMap(Class clazz, Serializer serializer, Deserializer deserializer, XMLType xMLType) {
        this._javaType = clazz;
        this._xmlType = xMLType;
        this._serFactory = new DefaultSerializerFactory(serializer);
        this._deserFactory = new DefaultDeserializerFactory(deserializer);
    }

    public TypeMap(Class clazz, SerializerFactory serializerFactory, DeserializerFactory deserializerFactory, QName qName) {
        this(clazz, serializerFactory, deserializerFactory, new XMLType(qName, null));
    }

    public TypeMap(Class clazz, SerializerFactory serializerFactory, DeserializerFactory deserializerFactory, XMLType xMLType) {
        this._javaType = clazz;
        this._xmlType = xMLType;
        this._serFactory = serializerFactory;
        this._deserFactory = deserializerFactory;
    }

    public Class getJavaType() {
        return this._javaType;
    }

    public QName getQName() {
        return this._xmlType.getQName();
    }

    public XMLType getXMLType() {
        return this._xmlType;
    }

    public SerializerFactory getSerializerFactory() {
        return this._serFactory;
    }

    public DeserializerFactory getDeserializerFactory() {
        return this._deserFactory;
    }

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this._serFactory = serializerFactory;
    }

    public void setDeserializerFactory(DeserializerFactory deserializerFactory) {
        this._deserFactory = deserializerFactory;
    }

    public Serializer getSerializer() {
        Serializer serializer = null;
        serializer = (Serializer)this._serFactory.getSerializerAs(null);
        return serializer;
    }

    public Deserializer getDeserializer() {
        Deserializer deserializer = null;
        deserializer = (Deserializer)this._deserFactory.getDeserializerAs(null);
        return deserializer;
    }

    public Serializer getSerializerAs(String string) {
        Serializer serializer = null;
        serializer = (Serializer)this._serFactory.getSerializerAs(string);
        return serializer;
    }

    public Deserializer getDeserializerAs(String string) {
        Deserializer deserializer = null;
        deserializer = (Deserializer)this._deserFactory.getDeserializerAs(string);
        return deserializer;
    }

    public String toString() {
        return this._javaType.getName() + "," + this._xmlType.toString();
    }
}

