/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.encoding;

import com.sssw.jbroker.util.XMLUtil;
import com.sssw.jbroker.web.QName;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.encoding.Attribute;
import com.sssw.jbroker.web.encoding.Deserializer;
import com.sssw.jbroker.web.encoding.Marshaler;
import com.sssw.jbroker.web.encoding.Serializer;
import com.sssw.jbroker.web.encoding.TypeMap;
import com.sssw.jbroker.web.portable.InputStream;
import com.sssw.jbroker.web.portable.OutputStream;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ValueTypeMarshaler
implements Marshaler {
    private Class _javaType;
    private PropertyDescriptor[] _propDescs;
    private Field[] _fields;
    private static final Object[] READ_ARGS = new Object[0];
    private static final boolean _debug = false;
    private static Class _stackTraceElementClass = null;
    static /* synthetic */ Class class$java$rmi$Remote;

    public ValueTypeMarshaler() {
    }

    public ValueTypeMarshaler(Class clazz) {
        this(clazz, ValueTypeMarshaler.getPropertyDescriptor(clazz), clazz.getFields());
    }

    public ValueTypeMarshaler(Class clazz, PropertyDescriptor[] propertyDescriptorArray, Field[] fieldArray) {
        this._javaType = clazz;
        this._propDescs = propertyDescriptorArray;
        this._fields = fieldArray;
    }

    public String getMechanismType() {
        return null;
    }

    public Attribute[] getAttributes(Object object) {
        return null;
    }

    public void serialize(OutputStream outputStream, Object object) throws IOException {
        try {
            Object object2;
            Object object3;
            Class<?> clazz = object.getClass();
            PropertyDescriptor[] propertyDescriptorArray = clazz != this._javaType ? ValueTypeMarshaler.getPropertyDescriptor(clazz) : this._propDescs;
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                if (ValueTypeMarshaler.isReadWrite(propertyDescriptorArray[n])) {
                    object3 = propertyDescriptorArray[n].getReadMethod();
                    String string = propertyDescriptorArray[n].getName();
                    object2 = ((Method)object3).invoke(object, READ_ARGS);
                    outputStream.writeObject(object2, string);
                }
                ++n;
            }
            object3 = clazz.getFields();
            int n2 = 0;
            while (n2 < ((Field[])object3).length) {
                object2 = object3[n2];
                Object object4 = ((Field)object2).get(object);
                outputStream.writeObject(object4, ((Field)object2).getName());
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new ServiceException(exception);
        }
    }

    public Object deserialize(InputStream inputStream, Class clazz) throws IOException {
        try {
            Object t = clazz.newInstance();
            String string = null;
            Class<?> clazz2 = null;
            QName qName = null;
            Object object = null;
            PropertyDescriptor propertyDescriptor = null;
            Field field = null;
            while ((qName = inputStream.peek()) != null) {
                string = qName.getLocalPart();
                propertyDescriptor = null;
                field = null;
                try {
                    propertyDescriptor = new PropertyDescriptor(string, clazz);
                    clazz2 = propertyDescriptor.getPropertyType();
                }
                catch (IntrospectionException introspectionException) {
                    try {
                        field = clazz.getField(string);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        throw new IOException("encountered " + string + " which is neither a bean property nor a public field in " + clazz);
                    }
                    clazz2 = field.getType();
                }
                try {
                    object = inputStream.readObject(clazz2, string);
                }
                catch (EOFException eOFException) {
                    break;
                }
                if (propertyDescriptor != null) {
                    Method method = propertyDescriptor.getWriteMethod();
                    method.invoke(t, object);
                    continue;
                }
                if (field == null) continue;
                field.set(t, object);
            }
            return t;
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new ServiceException(exception);
        }
    }

    private PropertyDescriptor getPropertyDescriptor(PropertyDescriptor[] propertyDescriptorArray, String string, int n) throws IOException {
        if (propertyDescriptorArray[n].getName().equals(string)) {
            return propertyDescriptorArray[n];
        }
        int n2 = 0;
        while (n2 < propertyDescriptorArray.length) {
            if (propertyDescriptorArray[n2].getName().equals(string)) {
                return propertyDescriptorArray[n2];
            }
            ++n2;
        }
        throw new IOException("no property with name " + string);
    }

    private static boolean isReadWrite(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getReadMethod() != null && propertyDescriptor.getWriteMethod() != null && propertyDescriptor.getName() != "class" && !ValueTypeMarshaler.isStackTraceElement(propertyDescriptor);
    }

    private static boolean isStackTraceElement(PropertyDescriptor propertyDescriptor) {
        return _stackTraceElementClass != null && propertyDescriptor.getPropertyType().isArray() && propertyDescriptor.getPropertyType().getComponentType().equals(_stackTraceElementClass) && propertyDescriptor.getName().equals("stackTrace");
    }

    private static PropertyDescriptor[] getPropertyDescriptor(Class clazz) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            return beanInfo.getPropertyDescriptors();
        }
        catch (Exception exception) {
            throw new ServiceException("unable to get property descriptor for bean class " + clazz + ": " + exception.getMessage());
        }
    }

    public static boolean isJAXRPCValueType(Class clazz) {
        if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = ValueTypeMarshaler.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz)) {
            return false;
        }
        if (clazz.isInterface()) {
            return false;
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return true;
    }

    public static TypeMap getTypeMap(Class clazz) {
        ValueTypeMarshaler valueTypeMarshaler = new ValueTypeMarshaler(clazz);
        javax.xml.namespace.QName qName = new javax.xml.namespace.QName(XMLUtil.getPackageNS(clazz), XMLUtil.getClassName(clazz));
        return new TypeMap(clazz, (Serializer)valueTypeMarshaler, (Deserializer)valueTypeMarshaler, qName);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            _stackTraceElementClass = Class.forName("java.lang.StackTraceElement");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

