/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.mapping;

import com.sssw.jbroker.web.QName;
import com.sssw.jbroker.web.mapping.Deserializer;
import com.sssw.jbroker.web.mapping.DeserializerDelegate;
import com.sssw.jbroker.web.mapping.Serializer;
import com.sssw.jbroker.web.mapping.SerializerDelegate;
import com.sssw.jbroker.web.mapping.TypeMapping;
import com.sssw.jbroker.web.mapping.TypeMappingException;
import com.sssw.jbroker.web.mapping.XMLType;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.Servlet;
import javax.servlet.ServletException;

public class TypeMapper
implements Serializable {
    private boolean _readOnly;
    private final HashMap _registry;
    private final TypeMapper _delegate;
    private static final boolean _debug = false;
    private static TypeMapper _defaultMapper = new TypeMapper(null);
    private static HashMap _typeMaps = new HashMap();

    public TypeMapper() {
        this(TypeMapper.getDefault());
    }

    public TypeMapper(TypeMapper typeMapper) {
        this._delegate = typeMapper;
        this._registry = new HashMap();
    }

    public TypeMapper getDelegate() {
        return this._delegate;
    }

    public static TypeMapper getDefault() {
        return _defaultMapper;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public void setReadOnly() {
        this._readOnly = true;
    }

    public void put(TypeMapping typeMapping) throws TypeMappingException {
        this.checkUpdate();
        this.checkXMLType(typeMapping.getXMLType());
        this.checkJavaType(typeMapping.getJavaType());
        this.checkMarshalers(typeMapping.getSerializer(), typeMapping.getDeserializer());
        this._registry.put(typeMapping.getJavaType(), typeMapping);
        this._registry.put(typeMapping.getXMLType().getQName(), typeMapping);
    }

    private static synchronized TypeMapper getTypeMapper(ClassLoader classLoader) throws TypeMappingException {
        TypeMapper typeMapper = (TypeMapper)_typeMaps.get(classLoader);
        if (typeMapper != null) {
            return typeMapper;
        }
        typeMapper = new TypeMapper();
        try {
            Enumeration<URL> enumeration = classLoader.getResources("xmlrpc.type.mappings");
            while (enumeration.hasMoreElements()) {
                Properties properties = new Properties();
                URL uRL = enumeration.nextElement();
                if (!(uRL instanceof URL)) continue;
                properties.load(uRL.openStream());
                typeMapper.importMappings(properties, classLoader);
            }
            _typeMaps.put(classLoader, typeMapper);
            return typeMapper;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new TypeMappingException(throwable.getMessage());
        }
    }

    public void importMappings(String string, ClassLoader classLoader) throws TypeMappingException, IOException {
        Properties properties = new Properties();
        properties.load(classLoader.getResourceAsStream(string));
        this.importMappings(properties, classLoader);
    }

    public void importMappings(String string, Servlet servlet) throws TypeMappingException, ServletException, IOException {
        this.importMappings(string, servlet, Thread.currentThread().getContextClassLoader());
    }

    public void importMappings(String string, Servlet servlet, ClassLoader classLoader) throws TypeMappingException, ServletException, IOException {
        Properties properties = new Properties();
        properties.load(servlet.getServletConfig().getServletContext().getResourceAsStream(string));
        this.importMappings(properties, classLoader);
    }

    public void importMappings(String string) throws TypeMappingException, IOException {
        this.importMappings(string, Thread.currentThread().getContextClassLoader());
    }

    public void importMappings(Properties properties, ClassLoader classLoader) throws TypeMappingException {
        Iterator iterator = ((Hashtable)properties).values().iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                this.importMapping(string, classLoader);
            }
            catch (TypeMappingException typeMappingException) {
                throw typeMappingException;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new TypeMappingException(throwable.getMessage());
            }
        }
    }

    public void importMappings(Properties properties) throws TypeMappingException {
        this.importMappings(properties, Thread.currentThread().getContextClassLoader());
    }

    private void importMapping(String string, ClassLoader classLoader) throws Throwable {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() != 6) {
            throw new TypeMappingException("#tokens != 6");
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        String string7 = stringTokenizer.nextToken();
        Class<?> clazz = Class.forName(string2, true, classLoader);
        Class<?> clazz2 = Class.forName(string3, true, classLoader);
        Object obj = clazz2.newInstance();
        Serializer serializer = null;
        serializer = obj instanceof com.sssw.jbroker.web.encoding.Serializer ? new SerializerDelegate((com.sssw.jbroker.web.encoding.Serializer)obj) : (Serializer)obj;
        Class<?> clazz3 = Class.forName(string4, true, classLoader);
        Object obj2 = clazz3.newInstance();
        Deserializer deserializer = null;
        deserializer = obj2 instanceof com.sssw.jbroker.web.encoding.Deserializer ? new DeserializerDelegate((com.sssw.jbroker.web.encoding.Deserializer)obj2) : (Deserializer)obj2;
        XMLType xMLType = new XMLType(new QName(string5, string6), string7);
        this.put(new TypeMapping(clazz, serializer, deserializer, xMLType));
    }

    public TypeMapping get(QName qName) {
        return this.get(qName, true);
    }

    public TypeMapping get(QName qName, boolean bl) {
        TypeMapping typeMapping = this._delegate != null && bl ? this._delegate.get(qName) : null;
        return typeMapping == null ? (TypeMapping)this._registry.get(qName) : typeMapping;
    }

    public TypeMapping get(Class clazz) {
        return this.get(clazz, true);
    }

    public TypeMapping get(Class clazz, boolean bl) {
        TypeMapping typeMapping = this._delegate != null && bl ? this._delegate.get(clazz) : null;
        return typeMapping == null ? (TypeMapping)this._registry.get(clazz) : typeMapping;
    }

    public Iterator iterator() {
        return this._registry.values().iterator();
    }

    private void checkUpdate() throws TypeMappingException {
        if (this._readOnly) {
            throw new TypeMappingException("update not allowed");
        }
    }

    private void checkJavaType(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("null java type specified");
        }
    }

    private void checkXMLType(XMLType xMLType) throws TypeMappingException {
        if (xMLType == null) {
            throw new NullPointerException("null XML type specified");
        }
        if (xMLType.getQName() == null) {
            throw new NullPointerException("XML type has a null QName");
        }
    }

    private void checkMarshalers(Serializer serializer, Deserializer deserializer) {
        if (serializer == null && deserializer == null) {
            throw new NullPointerException("both serializer and deserializer are null");
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("com.sssw.jbroker.web.core.Provider");
            Method method = clazz.getDeclaredMethod("configure", null);
            method.invoke(null, null);
        }
        catch (Throwable throwable) {
            System.out.println("unable to initialize providers");
            throwable.printStackTrace();
        }
    }
}

