/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.portable;

import com.sssw.jbroker.web.Binding;
import com.sssw.jbroker.web.QName;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.encoding.DefaultTypeMappingRegistry;
import com.sssw.jbroker.web.mapping.TypeMapper;
import com.sssw.jbroker.web.portable.InvokeHandler;
import com.sssw.jbroker.web.portable.ServerRequest;
import com.sssw.jbroker.web.portable.ServerResponse;
import com.sssw.jbroker.web.portable.Skeleton;
import com.sssw.jbroker.web.portable.Stub;
import com.sssw.jbroker.web.portable.annotation.ClassInfo;
import com.sssw.jms.api.JMQQueueConnectionFactory;
import com.sssw.jms.api.JMQTopicConnectionFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Properties;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.servlet.ServletException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerChain;

public abstract class MDBSkeleton
implements MessageDrivenBean,
MessageListener,
Skeleton {
    private final QName _portType;
    private final MDBDelegate _delegate;
    private Stub _stub;
    private Binding _binding;
    private ClassInfo _info;
    private List _handlerChain;
    private TypeMappingRegistry _typeMappingRegistry;
    public static final int QUEUE = 0;
    public static final int TOPIC = 1;
    private static final Class[] _factoryClz = new Class[]{class$javax$jms$QueueConnectionFactory == null ? (class$javax$jms$QueueConnectionFactory = MDBSkeleton.class$("javax.jms.QueueConnectionFactory")) : class$javax$jms$QueueConnectionFactory, class$javax$jms$TopicConnectionFactory == null ? (class$javax$jms$TopicConnectionFactory = MDBSkeleton.class$("javax.jms.TopicConnectionFactory")) : class$javax$jms$TopicConnectionFactory};
    private static final Class[] _connClz = new Class[]{class$javax$jms$QueueConnection == null ? (class$javax$jms$QueueConnection = MDBSkeleton.class$("javax.jms.QueueConnection")) : class$javax$jms$QueueConnection, class$javax$jms$TopicConnection == null ? (class$javax$jms$TopicConnection = MDBSkeleton.class$("javax.jms.TopicConnection")) : class$javax$jms$TopicConnection};
    private static final Class[] _sessionClz = new Class[]{class$javax$jms$QueueSession == null ? (class$javax$jms$QueueSession = MDBSkeleton.class$("javax.jms.QueueSession")) : class$javax$jms$QueueSession, class$javax$jms$TopicSession == null ? (class$javax$jms$TopicSession = MDBSkeleton.class$("javax.jms.TopicSession")) : class$javax$jms$TopicSession};
    private static final Class[] _producerClz = new Class[]{class$javax$jms$QueueSender == null ? (class$javax$jms$QueueSender = MDBSkeleton.class$("javax.jms.QueueSender")) : class$javax$jms$QueueSender, class$javax$jms$TopicPublisher == null ? (class$javax$jms$TopicPublisher = MDBSkeleton.class$("javax.jms.TopicPublisher")) : class$javax$jms$TopicPublisher};
    private static final boolean _debug = false;
    private static final String DEFAULT_DELEGATE = "com.sssw.jbroker.web.core.MDBDelegateImpl";
    protected ConnectionFactory _factory;
    protected Connection _connection;
    protected Session _session;
    protected MessageProducer _producer;
    static /* synthetic */ Class class$javax$jms$QueueConnectionFactory;
    static /* synthetic */ Class class$javax$jms$TopicConnectionFactory;
    static /* synthetic */ Class class$javax$jms$QueueConnection;
    static /* synthetic */ Class class$javax$jms$TopicConnection;
    static /* synthetic */ Class class$javax$jms$QueueSession;
    static /* synthetic */ Class class$javax$jms$TopicSession;
    static /* synthetic */ Class class$javax$jms$QueueSender;
    static /* synthetic */ Class class$javax$jms$TopicPublisher;

    protected MDBSkeleton(QName qName) {
        this._portType = qName;
        MDBDelegate mDBDelegate = null;
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName(DEFAULT_DELEGATE, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName(DEFAULT_DELEGATE);
            }
            mDBDelegate = (MDBDelegate)clazz.newInstance();
            mDBDelegate.setHandler(this);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this._delegate = mDBDelegate;
    }

    public abstract void init() throws ServletException;

    public Stub _getStub() {
        if (this._stub == null) {
            MDBSkeleton mDBSkeleton = this;
            synchronized (mDBSkeleton) {
                if (this._stub == null) {
                    try {
                        this._stub = this._delegate.getStub();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new ServiceException(classNotFoundException.getMessage());
                    }
                }
            }
        }
        return this._stub;
    }

    public Reference getReference() throws NamingException {
        return this._getStub().getReference();
    }

    public TypeMapper _getTypeMapper() {
        throw new Error("use getTypeMappingRegistry()");
    }

    public void _setTypeMapper(TypeMapper typeMapper) {
        this._typeMappingRegistry = new DefaultTypeMappingRegistry(typeMapper);
    }

    public TypeMappingRegistry _getTypeMappingRegistry() {
        return this._typeMappingRegistry;
    }

    public void _setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this._typeMappingRegistry = typeMappingRegistry;
    }

    public QName _getPortType() {
        return this._portType;
    }

    public Binding[] _getBindings() {
        return new Binding[]{this._getCurrentBinding()};
    }

    public Binding _getCurrentBinding() throws ServiceException {
        if (this._binding == null) {
            MDBSkeleton mDBSkeleton = this;
            synchronized (mDBSkeleton) {
                if (this._binding == null) {
                    this._binding = new Binding("jms", "");
                }
            }
        }
        return this._binding;
    }

    public void _setCurrentBinding(Binding binding) throws MalformedURLException {
        throw new Error("not allowed to change binding on skeleton");
    }

    public Object _getProperty(String string) {
        return this._delegate.getProperties().getProperty(string);
    }

    public String _setProperty(String string, String string2) {
        return (String)this._delegate.getProperties().setProperty(string, string2);
    }

    public void _setHandlerChain(List list) {
        this._handlerChain = list;
        this._delegate.setHandlerChain(list);
    }

    public List _getHandlerChain() {
        return this._handlerChain;
    }

    public void _setHandlerChain(HandlerChain handlerChain) {
    }

    public void _setClassInfo(ClassInfo classInfo) {
    }

    public ClassInfo _getClassInfo() {
        return null;
    }

    public QName _getOperationName() {
        return null;
    }

    public ServerResponse _invoke(Properties properties, InputStream inputStream) throws IOException {
        return this._delegate.invoke(properties, inputStream);
    }

    public void ejbCreate() {
        this._delegate.ejbCreate();
    }

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) {
        this._delegate.setMessageDrivenContext(messageDrivenContext);
    }

    public void onMessage(Message message) {
        this._delegate.onMessage(message);
    }

    public void ejbRemove() {
        this._delegate.ejbRemove();
    }

    public synchronized ConnectionFactory getConnectionFactory(int n) throws JMSException {
        if (this._factory != null && _factoryClz[n].isAssignableFrom(this._factory.getClass())) {
            return this._factory;
        }
        this._factory = n == 0 ? new JMQQueueConnectionFactory() : new JMQTopicConnectionFactory();
        return this._factory;
    }

    public synchronized Connection getConnection(int n) throws JMSException {
        if (this._connection != null && _connClz[n].isAssignableFrom(this._connection.getClass())) {
            return this._connection;
        }
        this._factory = this.getConnectionFactory(n);
        this._connection = n == 0 ? ((QueueConnectionFactory)this._factory).createQueueConnection() : ((TopicConnectionFactory)this._factory).createTopicConnection();
        return this._connection;
    }

    public synchronized Session getSession(int n) throws JMSException {
        if (this._session != null && _sessionClz[n].isAssignableFrom(this._session.getClass())) {
            return this._session;
        }
        this._connection = this.getConnection(n);
        this._session = n == 0 ? ((QueueConnection)this._connection).createQueueSession(false, 1) : ((TopicConnection)this._connection).createTopicSession(false, 1);
        return this._session;
    }

    public synchronized MessageProducer getProducer(Destination destination, int n) throws JMSException {
        Topic topic;
        Queue queue;
        if (this._producer != null && _producerClz[n].isAssignableFrom(this._producer.getClass()) && (n == 0 ? (queue = ((QueueSender)this._producer).getQueue()).getQueueName().equals(((Queue)destination).getQueueName()) : (topic = ((TopicPublisher)this._producer).getTopic()).getTopicName().equals(((Topic)destination).getTopicName()))) {
            return this._producer;
        }
        if (this._producer != null) {
            this._producer.close();
        }
        this._session = this.getSession(n);
        this._producer = n == 0 ? ((QueueSession)this._session).createSender((Queue)destination) : ((TopicSession)this._session).createPublisher((Topic)destination);
        return this._producer;
    }

    public abstract boolean isDocument(String var1);

    public abstract ServerResponse _invoke(ServerRequest var1) throws IOException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface MDBDelegate {
        public void setHandler(InvokeHandler var1);

        public Stub getStub() throws ClassNotFoundException;

        public void ejbCreate();

        public void ejbRemove();

        public void setMessageDrivenContext(MessageDrivenContext var1);

        public void onMessage(Message var1);

        public Properties getProperties();

        public void setHandlerChain(List var1);

        public void _setHandlerChain(HandlerChain var1);

        public ServerResponse invoke(Properties var1, InputStream var2) throws IOException;
    }
}

