/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.portable;

import com.sssw.jbroker.web.Binding;
import com.sssw.jbroker.web.QName;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.encoding.DefaultTypeMappingRegistry;
import com.sssw.jbroker.web.mapping.TypeMapper;
import com.sssw.jbroker.web.portable.InvokeHandler;
import com.sssw.jbroker.web.portable.ServerRequest;
import com.sssw.jbroker.web.portable.ServerResponse;
import com.sssw.jbroker.web.portable.Skeleton;
import com.sssw.jbroker.web.portable.Stub;
import com.sssw.jbroker.web.portable.annotation.ClassInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.Principal;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.server.ServletEndpointContext;

public abstract class ServletSkeleton
extends HttpServlet
implements Skeleton {
    private Stub _stub;
    private String _urlStr;
    private Binding _binding;
    private TypeMappingRegistry _typeMappingRegistry;
    private final ServletEndpointContextImpl _endpointContext = new ServletEndpointContextImpl();
    private final QName _portType;
    private final ServletDelegate _delegate;
    private ClassInfo _info;
    private List _handlerChain;
    private static final boolean _debug = false;
    private static final String DEFAULT_DELEGATE = "com.sssw.jbroker.web.core.ServletDelegateImpl";

    protected ServletSkeleton(QName qName) {
        this._portType = qName;
        ServletDelegate servletDelegate = null;
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName(DEFAULT_DELEGATE, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName(DEFAULT_DELEGATE);
            }
            servletDelegate = (ServletDelegate)clazz.newInstance();
            servletDelegate.setHandler(this);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this._delegate = servletDelegate;
    }

    public TypeMapper _getTypeMapper() {
        throw new Error("use getTypeMappingRegistry()");
    }

    public void _setTypeMapper(TypeMapper typeMapper) {
        this._typeMappingRegistry = new DefaultTypeMappingRegistry(typeMapper);
    }

    public TypeMappingRegistry _getTypeMappingRegistry() {
        return this._typeMappingRegistry;
    }

    public void _setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this._typeMappingRegistry = typeMappingRegistry;
    }

    public Stub _getStub() {
        if (this._stub == null) {
            ServletSkeleton servletSkeleton = this;
            synchronized (servletSkeleton) {
                if (this._stub == null) {
                    try {
                        this._stub = this._delegate.getStub();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new ServiceException(classNotFoundException.getMessage());
                    }
                }
            }
        }
        return this._stub;
    }

    public Reference getReference() throws NamingException {
        return this._getStub().getReference();
    }

    public QName _getPortType() {
        return this._portType;
    }

    public Binding[] _getBindings() {
        return new Binding[]{this._getCurrentBinding()};
    }

    public Binding _getCurrentBinding() throws ServiceException {
        if (this._binding == null) {
            ServletSkeleton servletSkeleton = this;
            synchronized (servletSkeleton) {
                if (this._binding == null) {
                    if (this._urlStr == null) {
                        throw new ServiceException("servlet not activated yet");
                    }
                    this._binding = new Binding("soap", this._urlStr);
                }
            }
        }
        return this._binding;
    }

    public void _setCurrentBinding(Binding binding) throws MalformedURLException {
        throw new Error("not allowed to change binding on skeleton");
    }

    public Object _getProperty(String string) {
        return this._delegate.getProperties().getProperty(string);
    }

    public String _setProperty(String string, String string2) {
        return (String)this._delegate.getProperties().setProperty(string, string2);
    }

    private void setURL(HttpServletRequest httpServletRequest) {
        if (this._urlStr == null) {
            ServletSkeleton servletSkeleton = this;
            synchronized (servletSkeleton) {
                if (this._urlStr == null) {
                    this._urlStr = new String(HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest));
                }
            }
        }
    }

    public void init() throws ServletException {
        this._delegate.init();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.setURL(httpServletRequest);
        this._delegate.doGet(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this._endpointContext.setRequest(httpServletRequest);
        this.setURL(httpServletRequest);
        this._delegate.doPost(httpServletRequest, httpServletResponse);
    }

    public boolean isDocument(String string) {
        return false;
    }

    public void _setHandlerChain(List list) {
        this._handlerChain = list;
        this._delegate.setHandlerChain(list);
    }

    public List _getHandlerChain() {
        return this._handlerChain;
    }

    public ServerResponse _invoke(Properties properties, InputStream inputStream) throws IOException {
        return this._delegate.invoke(properties, inputStream);
    }

    public void _setClassInfo(ClassInfo classInfo) {
    }

    public ClassInfo _getClassInfo() {
        return null;
    }

    public QName _getOperationName() {
        return null;
    }

    protected ServletEndpointContext getEndpointContext() {
        return this._endpointContext;
    }

    public void _setHandlerChain(HandlerChain handlerChain) {
    }

    public abstract ServerResponse _invoke(ServerRequest var1) throws IOException;

    private static final class ServletEndpointContextImpl
    implements ServletEndpointContext {
        private HttpServletRequest _request;

        private ServletEndpointContextImpl() {
        }

        public MessageContext getMessageContext() {
            return null;
        }

        public Principal getUserPrincipal() {
            return this._request.getUserPrincipal();
        }

        public HttpSession getHttpSession() {
            return this._request.getSession();
        }

        public ServletContext getServletContext() {
            return this._request.getSession().getServletContext();
        }

        public void setRequest(HttpServletRequest httpServletRequest) {
            this._request = httpServletRequest;
        }
    }

    public static interface ServletDelegate {
        public void setHandler(InvokeHandler var1);

        public Stub getStub() throws ClassNotFoundException;

        public void init() throws ServletException;

        public void doGet(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

        public void doPost(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

        public Properties getProperties();

        public void setHandlerChain(List var1);

        public ServerResponse invoke(Properties var1, InputStream var2) throws IOException;
    }
}

