/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.portable;

import com.sssw.jbroker.web.Binding;
import com.sssw.jbroker.web.QName;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.ServiceObject;
import com.sssw.jbroker.web.encoding.DefaultTypeMappingRegistry;
import com.sssw.jbroker.web.mapping.TypeMapper;
import com.sssw.jbroker.web.portable.ApplicationException;
import com.sssw.jbroker.web.portable.ClientRequest;
import com.sssw.jbroker.web.portable.ClientResponse;
import com.sssw.jbroker.web.portable.Delegate;
import com.sssw.jbroker.web.portable.Util;
import com.sssw.jbroker.web.portable.annotation.ClassInfo;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerChain;

public abstract class Stub
implements ServiceObject,
javax.xml.rpc.Stub {
    private final Delegate _delegate;
    private final Binding[] _bindings;
    private final QName _portType;
    private Binding _currentBinding;
    private ClassInfo _info;
    private transient TypeMappingRegistry _typeMappingRegistry;
    private static final String DEFAULT_DELEGATE = "com.sssw.jbroker.web.core.DelegateImpl";
    public static final String PARAM_INOUT = "jbroker.web.parameter.inout";
    public static final String SOAP_ACTION = "jbroker.web.soap.action";
    public static final String PARAM_NAME = "jbroker.web.parameter.name";
    public static final String AUTH_SCHEME = "jbroker.web.http.auth.scheme";
    public static final String AUTH_SCHEME_HANDLER = "jbroker.web.http.auth.scheme.handler";
    public static final Integer BASIC_AUTH_SCHEME = new Integer(1);
    public static final Integer DIGEST_AUTH_SCHEME = new Integer(2);
    public static final Integer NTLM_AUTH_SCHEME = new Integer(3);
    public static final Integer OTHER_AUTH_SCHEME = new Integer(-1);
    public static final String USERNAME = "javax.xml.rpc.security.auth.username";
    public static final String PASSWORD = "javax.xml.rpc.security.auth.password";
    public static final String NTLM_HOST = "jbroker.web.ntlm.host";
    public static final String NTLM_DOMAIN = "jbroker.web.ntlm.domain";
    public static final String ENDPOINT = "javax.xml.rpc.service.endpoint.address";
    public static final String SESSION_MAINTAIN = "javax.xml.rpc.session.maintain";
    public static final String OPERATION_STYLE = "javax.xml.rpc.soap.operation.style";
    public static final String SOAP_ACTION_USE = "javax.xml.rpc.soap.http.soapaction.use";
    public static final String SOAP_ACTION_URI = "javax.xml.rpc.soap.http.soapaction.uri";
    public static final String ENCODING_STYLE_URI = "javax.xml.rpc.encodingstyle.namespace.uri";
    public static final String JMS_TOPIC_FACTORY = "jms.topic.factory";
    public static final String JMS_TOPIC_FACTORY_JNDI = "jms.topic.factory.jndi";
    public static final String JMS_TOPIC_FACTORY_CLASS = "jms.topic.factory.class";
    public static final String JMS_QUEUE_FACTORY = "jms.queue.factory";
    public static final String JMS_QUEUE_FACTORY_JNDI = "jms.queue.factory.jndi";
    public static final String JMS_QUEUE_FACTORY_CLASS = "jms.queue.factory.class";
    public static final String JMS_TOPIC = "jms.topic";
    public static final String JMS_TOPIC_JNDI = "jms.topic.jndi";
    public static final String JMS_TOPIC_REPLY = "jms.topic.reply";
    public static final String JMS_TOPIC_REPLY_JNDI = "jms.topic.reply.jndi";
    public static final String JMS_TOPIC_DURABLE_NAME = "jms.topic.durable";
    public static final String JMS_QUEUE = "jms.queue";
    public static final String JMS_QUEUE_JNDI = "jms.queue.jndi";
    public static final String JMS_QUEUE_REPLY = "jms.queue.reply";
    public static final String JMS_QUEUE_REPLY_JNDI = "jms.queue.reply.jndi";
    public static final String JMS_REPLY_TIMEOUT = "jms.reply.timeout";
    public static final String JMS_REPLY_SELECTOR = "jms.reply.selector";
    public static final String JMS_USE_REQUESTOR = "jms.use.requestor";
    public static final String JMS_USE_CORRELATION_ID = "jms.use.correlation.id";
    public static final String JMS_JNDI_ENVIRONMENT = "jms.jndi.environment";
    public static final String JMS_JNDI_INITIAL_CONTEXT = "jms.jndi.initial.context";

    protected Stub(QName qName, Binding[] bindingArray) {
        this._portType = qName;
        this._bindings = bindingArray;
        Delegate delegate = null;
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName(DEFAULT_DELEGATE, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName(DEFAULT_DELEGATE);
            }
            delegate = (Delegate)clazz.newInstance();
            delegate.setStub(this);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this._delegate = delegate;
    }

    public String toString() {
        Binding binding;
        StringBuffer stringBuffer = new StringBuffer();
        if (this._portType != null) {
            stringBuffer.append("PortType=");
            stringBuffer.append(this._portType.toString());
        }
        if ((binding = this._getCurrentBinding()) != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(";");
            }
            stringBuffer.append("Binding=");
            stringBuffer.append(binding.toString());
        }
        return new String(stringBuffer);
    }

    public Binding[] _getBindings() {
        return this._bindings;
    }

    public QName _getPortType() {
        return this._portType;
    }

    public QName _getOperationName() {
        return this._getDelegate().getOperationName();
    }

    public Binding _getCurrentBinding() {
        if (this._currentBinding != null) {
            return this._currentBinding;
        }
        return this._bindings.length > 0 ? this._bindings[0] : null;
    }

    public void _setCurrentBinding(Binding binding) throws MalformedURLException {
        this._currentBinding = binding;
        if (this._currentBinding != null) {
            this._getDelegate().setCurrentBinding(this._currentBinding);
        }
    }

    public Object _getProperty(String string) {
        return this._getDelegate().getProperty(string);
    }

    public String _setProperty(String string, String string2) {
        return this._getDelegate().setProperty(string, string2);
    }

    public void _setProperty(String string, Object object) throws IllegalArgumentException {
        this._getDelegate().setProperty(string, object);
    }

    public Iterator _getPropertyNames() {
        return this._getDelegate().getPropertyNames();
    }

    public TypeMapper _getTypeMapper() {
        throw new Error("use _getTypeMappingRegistry();");
    }

    public void _setTypeMapper(TypeMapper typeMapper) {
        this._typeMappingRegistry = new DefaultTypeMappingRegistry(typeMapper);
    }

    public TypeMappingRegistry _getTypeMappingRegistry() {
        return this._typeMappingRegistry;
    }

    public void _setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this._typeMappingRegistry = typeMappingRegistry;
    }

    public void _setClassInfo(ClassInfo classInfo) {
        this._info = classInfo;
    }

    public ClassInfo _getClassInfo() {
        return this._info;
    }

    public Delegate _getDelegate() {
        return this._delegate;
    }

    protected ClientRequest _request(String string, boolean bl) throws ServiceException {
        return this._getDelegate().request(string, bl, "soap", false, null);
    }

    protected ClientRequest _request(String string, boolean bl, String string2, boolean bl2, String string3) throws ServiceException {
        return this._getDelegate().request(string, bl, string2, bl2, string3);
    }

    protected ClientRequest _request(String string, boolean bl, String string2, boolean bl2, String string3, String string4) throws ServiceException {
        return this._getDelegate().request(string, bl, string2, bl2, string3, string4);
    }

    protected ClientResponse _invoke(ClientRequest clientRequest) throws ServiceException, ApplicationException {
        return this._getDelegate().invoke(clientRequest);
    }

    protected void _releaseResponse(ClientResponse clientResponse) {
        this._getDelegate().releaseResponse(clientResponse);
    }

    public void _setHandlerChain(HandlerChain handlerChain) {
        this._getDelegate().setHandlerChain(handlerChain);
    }

    public Reference getReference() throws NamingException {
        try {
            return StubObjectFactory.getReference(this);
        }
        catch (Exception exception) {
            throw new NamingException(exception.getMessage());
        }
    }

    public static class StubObjectFactory
    implements ObjectFactory {
        private static final String BYTES_ADDR = "xmlrpc.portable.stub";
        static /* synthetic */ Class class$com$sssw$jbroker$web$portable$Stub$StubObjectFactory;

        static final Reference getReference(Stub stub) throws Exception {
            Reference reference = new Reference(stub.getClass().getName(), (class$com$sssw$jbroker$web$portable$Stub$StubObjectFactory == null ? (class$com$sssw$jbroker$web$portable$Stub$StubObjectFactory = StubObjectFactory.class$("com.sssw.jbroker.web.portable.Stub$StubObjectFactory")) : class$com$sssw$jbroker$web$portable$Stub$StubObjectFactory).getName(), null);
            reference.add(new BinaryRefAddr(BYTES_ADDR, Util.serialize(stub)));
            return reference;
        }

        public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
            try {
                Reference reference = (Reference)object;
                BinaryRefAddr binaryRefAddr = (BinaryRefAddr)reference.get(BYTES_ADDR);
                return (Stub)Util.deserialize((byte[])binaryRefAddr.getContent());
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

