/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.portable.annotation;

import com.sssw.jbroker.web.portable.annotation.ClassInfo;
import com.sssw.jbroker.web.portable.annotation.ParamInfo;
import java.lang.reflect.Method;
import java.util.HashMap;

public final class MethodInfo {
    private final Method _method;
    private final HashMap _props = new HashMap();
    private final ParamInfo[] _params;
    private final ParamInfo _result;
    private final HashMap _exceptions = new HashMap();

    public MethodInfo(Method method) {
        this._method = method;
        this._result = new ParamInfo(this._method.getReturnType());
        Class<?>[] classArray = this._method.getParameterTypes();
        this._params = new ParamInfo[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            this._params[n] = new ParamInfo(classArray[n]);
            ++n;
        }
        classArray = this._method.getExceptionTypes();
        int n2 = 0;
        while (n2 < classArray.length) {
            if (!classArray[n2].getName().equals("java.rmi.RemoteException") && !classArray[n2].getName().equals("java.lang.InterruptedException")) {
                this._exceptions.put(classArray[n2], new ClassInfo(classArray[n2]));
            }
            ++n2;
        }
    }

    public Method getMethodObject() {
        return this._method;
    }

    public Object getProperty(String string) {
        return this._props.get(string);
    }

    public void setProperty(String string, Object object) {
        this._props.put(string, object);
    }

    public int getParameterCount() {
        return this._params == null ? 0 : this._params.length;
    }

    public ParamInfo getParameterTypeInfo(int n) {
        return this._params[n];
    }

    public ParamInfo getReturnTypeInfo() {
        return this._result;
    }

    public ClassInfo getExceptionTypeInfo(Class clazz) {
        return (ClassInfo)this._exceptions.get(clazz);
    }
}

