/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.server;

import com.sssw.jbroker.web.portable.InvokeHandler;
import com.sssw.jbroker.web.portable.ServletSkeleton;
import com.sssw.jbroker.web.server.Deploy_ServiceSkeleton;
import com.sssw.jbroker.web.server.Server;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DeployImpl
extends Deploy_ServiceSkeleton {
    private static final String _name = "jBroker Web 2.1 Deployment Web Service";
    private static final String _desc = "The deployment service allows you to deploy, undeploy, and list the Web Services running inside a very simple jBroker Web server container.";
    static final String _websvcs = "websvcs/";
    static final String _webinf = "WEB-INF/";
    private final Map _files = new HashMap();
    private final Map _services = new HashMap();

    public DeployImpl() {
        Service service = new Service(this, _name, _desc, null, null);
        this._services.put("/", service);
        File file = new File(_websvcs);
        if (!file.exists()) {
            Server.info(Server._messages.get("jwserver.verbose.creating.websvcs.dir", _websvcs));
            file.mkdir();
        } else {
            if (!file.isDirectory()) {
                Server.error(Server._messages.get("jwserver.error.websvcs.file", _websvcs));
                System.exit(1);
            }
            FilenameFilter filenameFilter = new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".war");
                }
            };
            String[] stringArray = file.list(filenameFilter);
            int n = 0;
            while (n < stringArray.length) {
                try {
                    this.deployWar(_websvcs + stringArray[n]);
                }
                catch (IOException iOException) {
                    if (System.getProperty("JBWDebug") != null) {
                        iOException.printStackTrace();
                    }
                    Server.warn(Server._messages.get("jwserver.error.deploy.warfile", stringArray[n], iOException.getMessage()));
                }
                ++n;
            }
        }
    }

    public void deploy(String string, byte[] byArray) throws RemoteException {
        String string2 = string;
        if (!string2.toLowerCase().endsWith(".war")) {
            string2 = string2 + ".war";
        }
        if (string2.startsWith(File.separator)) {
            string2 = string2.substring(1);
        }
        string2 = _websvcs + string2;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
            this.deployWar(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("deploy failed: " + iOException.getMessage());
        }
    }

    public void undeploy(String string) throws RemoteException {
        Service service = (Service)this._services.remove(string.toLowerCase());
        if (service != null) {
            File file = service.getFileLocation();
            DeployImpl.delete(file.listFiles());
            file.delete();
            Server.info(Server._messages.get("jwserver.verbose.deleted.file", file.toString()));
        }
    }

    private static void delete(File[] fileArray) {
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                DeployImpl.delete(fileArray[n].listFiles());
            }
            fileArray[n].delete();
            ++n;
        }
    }

    public String[] list() throws RemoteException {
        String[] stringArray = new String[this._services.size()];
        Iterator iterator = this._services.keySet().iterator();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    Service get(String string) {
        return (Service)this._services.get(string.toLowerCase());
    }

    void addFile(String string, String string2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string2);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        if (string.charAt(0) != '/') {
            string = '/' + string;
        }
        this._files.put(string, byArray);
        Server.info(Server._messages.get("jwserver.verbose.deploy.file", string2, string));
    }

    byte[] getFile(String string) {
        return (byte[])this._files.get(string);
    }

    Map deployWar(String string) throws IOException {
        Object object;
        String string2;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        if (!string.toLowerCase().endsWith(".war")) {
            throw new IOException("file " + string + " does not have " + "mandatory .war extension");
        }
        JarFile jarFile = new JarFile(string);
        File file = new File(_websvcs);
        File file2 = File.createTempFile("jbw", null, file);
        file2.delete();
        file2.mkdir();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory()) {
                object11 = new File(file2, jarEntry.getName());
                ((File)object11).mkdir();
                continue;
            }
            object11 = new File(file2, jarEntry.getName());
            FileOutputStream fileOutputStream = new FileOutputStream((File)object11);
            object10 = jarFile.getInputStream(jarEntry);
            object9 = new byte[1024];
            int n = 0;
            while ((n = ((InputStream)object10).read((byte[])object9)) != -1) {
                fileOutputStream.write((byte[])object9, 0, n);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            object8 = jarEntry.getName();
            if (!((String)object8).startsWith("WEB-INF/lib") || !((String)object8).endsWith(".jar") && !((String)object8).endsWith(".zip")) continue;
            arrayList.add(((File)object11).toURL());
        }
        Server.info(Server._messages.get("jwserver.verbose.extracted.file", string, file2));
        int n = arrayList.size();
        object11 = new URL[n + 1];
        int n2 = 0;
        while (n2 < n) {
            object11[n2 + 1] = (URL)arrayList.get(n2);
            ++n2;
        }
        object10 = new File(file2, _webinf);
        object11[0] = new File((File)object10, "classes").toURL();
        object9 = new URLClassLoader((URL[])object11);
        Thread.currentThread().setContextClassLoader((ClassLoader)object9);
        HashMap<String, Service> hashMap = new HashMap<String, Service>();
        object8 = null;
        try {
            object7 = (JarEntry)jarFile.getEntry("WEB-INF/web.xml");
            object6 = jarFile.getInputStream((ZipEntry)object7);
            object8 = DeployImpl.getParser().parse((InputStream)object6);
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("WEB-INF/web.xml not found in WAR");
        }
        catch (SAXException sAXException) {
            throw new IOException("failed to parse web.xml: " + sAXException.toString());
        }
        object7 = object8.getDocumentElement();
        object6 = "none";
        try {
            object6 = DeployImpl.getStringValue((Element)object7, "display-name");
        }
        catch (IOException iOException) {
            int n3 = string.lastIndexOf(File.separator);
            if (n3 == -1) {
                n3 = 0;
            }
            object6 = string.substring(n3, string.length() - 4);
            Server.warn(Server._messages.get("jwserver.warning.display.name.missing", object6));
        }
        String string3 = "none";
        try {
            string3 = DeployImpl.getStringValue((Element)object7, "description");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashMap<Object, String> hashMap2 = new HashMap<Object, String>();
        NodeList nodeList = object8.getElementsByTagName("context-param");
        int n4 = nodeList.getLength();
        int n5 = 0;
        while (n5 < n4) {
            object5 = (Element)nodeList.item(n5);
            object4 = DeployImpl.getStringValue((Element)object5, "param-name");
            String string4 = "";
            try {
                string4 = DeployImpl.getStringValue((Element)object5, "param-value");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            hashMap2.put(object4, string4);
            ++n5;
        }
        object5 = new SimpleServletContext(hashMap2);
        object4 = object7.getElementsByTagName("servlet-mapping");
        int n6 = object4.getLength();
        if (n6 == 0) {
            throw new IOException("failed to parse web.xml: missing servlet-mapping entry");
        }
        int n7 = 0;
        while (n7 < n6) {
            object3 = (Element)object4.item(n7);
            String string5 = DeployImpl.getStringValue((Element)object3, "servlet-name");
            String string6 = DeployImpl.getStringValue((Element)object3, "url-pattern").toLowerCase();
            if (string6.charAt(0) != '/') {
                string6 = '/' + string6;
            }
            object2 = new SimpleServletConfig(string5, (ServletContext)object5);
            hashMap.put(string6, new Service(null, string5, null, file2, (SimpleServletConfig)object2));
            ++n7;
        }
        object3 = object8.getElementsByTagName("servlet");
        int n8 = object3.getLength();
        if (n8 == 0) {
            throw new IOException("failed to parse web.xml: missing servlet entry");
        }
        int n9 = 0;
        while (n9 < n8) {
            block36: {
                Object object12;
                object2 = (Element)object3.item(n9);
                string2 = DeployImpl.getStringValue((Element)object2, "servlet-name");
                object = null;
                try {
                    object = DeployImpl.getStringValue((Element)object2, "servlet-class");
                }
                catch (IOException iOException) {
                    System.out.println("servlet " + string2 + " has no servlet class, skipping ...");
                    break block36;
                }
                HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
                NodeList nodeList2 = object2.getElementsByTagName("init-param");
                int n10 = nodeList2.getLength();
                int n11 = 0;
                while (n11 < n10) {
                    Element element = (Element)nodeList2.item(n11);
                    String string7 = DeployImpl.getStringValue(element, "param-name");
                    object12 = DeployImpl.getStringValue(element, "param-value");
                    hashMap3.put(string7, object12);
                    ++n11;
                }
                int n12 = hashMap.size();
                object12 = hashMap.keySet().iterator();
                int n13 = 0;
                while (n13 < n12) {
                    String string8 = (String)object12.next();
                    Service service = (Service)hashMap.get(string8);
                    if (string2.equals(service.getDisplayName())) {
                        service.setDescription(string3);
                        service.getServletConfig().setInitParameters(hashMap3);
                        try {
                            Class<?> clazz = Class.forName((String)object, true, (ClassLoader)object9);
                            InvokeHandler invokeHandler = (InvokeHandler)clazz.newInstance();
                            if (invokeHandler instanceof ServletSkeleton) {
                                ((ServletSkeleton)invokeHandler).init();
                                if (service.getServletConfig() != null) {
                                    ((ServletSkeleton)invokeHandler).init(service.getServletConfig());
                                }
                            }
                            service.setInvokeHandler(invokeHandler);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            Server.warn("class " + (String)object + " not found");
                        }
                        catch (Throwable throwable) {
                            if (Server._verbose) {
                                throwable.printStackTrace();
                            }
                            Server.warn("failed to instantiate class: " + throwable.toString());
                        }
                        break;
                    }
                    ++n13;
                }
                if (n13 == n12) {
                    Server.warn(Server._messages.get("jwserver.warning.deploy.skipping", string2, object));
                }
            }
            ++n9;
        }
        object2 = hashMap.keySet().iterator();
        while (object2.hasNext()) {
            string2 = (String)object2.next();
            object = (Service)hashMap.get(string2);
            if (((Service)object).getInvokeHandler() == null) {
                object2.remove();
                continue;
            }
            Server.info(Server._messages.get("jwserver.verbose.deploy.servlet", ((Service)object).getDisplayName(), string2));
        }
        this._services.putAll(hashMap);
        if (hashMap.size() == 0) {
            Server.warn(Server._messages.get("jwserver.warning.deploy.nothing", string));
        }
        return hashMap;
    }

    private static DocumentBuilder getParser() throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("failed to instantiate parser: " + parserConfigurationException);
        }
    }

    private static String getStringValue(Element element, String string) throws IOException {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            throw new IOException("no tag found for " + string + " in web.xml");
        }
        Node node = nodeList.item(0);
        if (!node.hasChildNodes()) {
            throw new IOException("element " + string + " has no value in web.xml");
        }
        return node.getFirstChild().getNodeValue();
    }

    public static class SimpleServletContext
    implements ServletContext {
        private final Hashtable _params;
        private final Hashtable _attrs = new Hashtable();

        SimpleServletContext(Map map) {
            this._params = new Hashtable(map);
        }

        public String getInitParameter(String string) {
            return (String)this._params.get(string);
        }

        public Enumeration getInitParameterNames() {
            return this._params.keys();
        }

        public ServletContext getContext(String string) {
            return null;
        }

        public int getMajorVersion() {
            return 2;
        }

        public int getMinorVersion() {
            return 2;
        }

        public String getMimeType(String string) {
            return null;
        }

        public Set getResourcePaths(String string) {
            return null;
        }

        public URL getResource(String string) throws MalformedURLException {
            return null;
        }

        public InputStream getResourceAsStream(String string) {
            return null;
        }

        public RequestDispatcher getRequestDispatcher(String string) {
            return null;
        }

        public RequestDispatcher getNamedDispatcher(String string) {
            return null;
        }

        public Servlet getServlet(String string) throws ServletException {
            return null;
        }

        public Enumeration getServlets() {
            return null;
        }

        public Enumeration getServletNames() {
            return null;
        }

        public void log(String string) {
        }

        public void log(Exception exception, String string) {
        }

        public void log(String string, Throwable throwable) {
        }

        public String getRealPath(String string) {
            return null;
        }

        public String getServerInfo() {
            return null;
        }

        public Object getAttribute(String string) {
            return this._attrs.get(string);
        }

        public Enumeration getAttributeNames() {
            return this._attrs.keys();
        }

        public void setAttribute(String string, Object object) {
            this._attrs.put(string, object);
        }

        public void removeAttribute(String string) {
            this._attrs.remove(string);
        }

        public String getServletContextName() {
            return null;
        }
    }

    public static class SimpleServletConfig
    implements ServletConfig {
        private Hashtable _params;
        private final String _name;
        private final ServletContext _context;

        SimpleServletConfig(String string, ServletContext servletContext) {
            this._name = string;
            this._context = servletContext;
        }

        public String getInitParameter(String string) {
            return (String)this._params.get(string);
        }

        public Enumeration getInitParameterNames() {
            return this._params.keys();
        }

        public ServletContext getServletContext() {
            return this._context;
        }

        private void setInitParameters(Map map) {
            this._params = new Hashtable(map);
        }

        public String getServletName() {
            return this._name;
        }
    }

    public static class Service {
        private final String _displayName;
        private final File _location;
        private final SimpleServletConfig _config;
        private InvokeHandler _handler;
        private String _description;

        public Service(InvokeHandler invokeHandler, String string, String string2, File file, SimpleServletConfig simpleServletConfig) {
            this._handler = invokeHandler;
            this._displayName = string;
            this._description = string2;
            this._location = file;
            this._config = simpleServletConfig;
        }

        public SimpleServletConfig getServletConfig() {
            return this._config;
        }

        public InvokeHandler getInvokeHandler() {
            return this._handler;
        }

        public void setInvokeHandler(InvokeHandler invokeHandler) {
            this._handler = invokeHandler;
        }

        public String getDisplayName() {
            return this._displayName;
        }

        public String getDescription() {
            return this._description;
        }

        public void setDescription(String string) {
            this._description = string;
        }

        public File getFileLocation() {
            return this._location;
        }

        public String toString() {
            return this._displayName + "@" + this._location;
        }
    }
}

