/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.server;

import com.sssw.jbroker.util.CommandArg;
import com.sssw.jbroker.util.CommandLine;
import com.sssw.jbroker.util.Copyright;
import com.sssw.jbroker.util.Messages;
import com.sssw.jbroker.web.server.DeployImpl;
import com.sssw.jbroker.web.server.ServerConnection;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Vector;

public class Server
implements Runnable {
    private int _port = 9090;
    private ServerSocket _socket;
    private boolean _running;
    private static int _conNo;
    private DeployImpl _deploy;
    private CommandLine _cmdline;
    public static boolean _debug;
    public static boolean _verbose;
    public static boolean _nowarn;
    public static final Messages _messages;
    private static final String _usage;
    public static final int OK = 0;
    public static final int ERROR = 1;
    private final ThreadPool _pool = new ThreadPool(50, 10000);
    static /* synthetic */ Class class$com$sssw$jbroker$web$server$Server;

    public static void main(String[] stringArray) throws Exception {
        Server server = new Server();
        if (server.init(stringArray) == 1) {
            System.exit(1);
        }
        server.startServer();
    }

    public int init(String[] stringArray) {
        if (stringArray.length == 0) {
            return 0;
        }
        if (!this.parseArguments(stringArray)) {
            System.err.println(_usage);
            return 1;
        }
        Hashtable hashtable = this._cmdline.getArgs();
        Object var3_3 = null;
        Object v = hashtable.get("port");
        if (v != null) {
            try {
                if (v instanceof String) {
                    this.setPort(Integer.parseInt((String)v));
                } else {
                    this.setPort(Integer.parseInt(((String[])v)[0]));
                }
            }
            catch (NumberFormatException numberFormatException) {
                Server.warn(_messages.get("jwserver.warning.port.not.integer", Integer.toString(this._port)));
            }
        }
        _verbose = this._cmdline.getArg("verbose") != null;
        _debug = this._cmdline.getArg("debug") != null;
        _nowarn = this._cmdline.getArg("nowarn") != null;
        this._deploy = new DeployImpl();
        String[] stringArray2 = (String[])hashtable.get("urlfile");
        if (stringArray2 != null) {
            int n = 0;
            while (n < stringArray2.length) {
                try {
                    this._deploy.addFile(stringArray2[n], stringArray2[n + 1]);
                }
                catch (IOException iOException) {
                    Server.warn(_messages.get("jwserver.warning.file.not.found", stringArray2[n + 1], stringArray2[n]));
                }
                n += 2;
            }
        }
        String[] stringArray3 = this._cmdline.getTralingArguments();
        int n = 0;
        while (n < stringArray3.length) {
            try {
                this._deploy.deployWar(stringArray3[n]);
            }
            catch (IOException iOException) {
                Server.warn(_messages.get("jwserver.error.deploy.warfile", stringArray3[n], iOException.getMessage()));
            }
            ++n;
        }
        return 0;
    }

    boolean parseArguments(String[] stringArray) {
        CommandArg[] commandArgArray = new CommandArg[]{new CommandArg("help", false, 0, 0), new CommandArg("port", false, 1, 1), new CommandArg("verbose", false, 0, 0), new CommandArg("debug", false, 0, 0), new CommandArg("urlfile", false, 2, 2), new CommandArg("nowarn", false, 0, 0)};
        this._cmdline = new CommandLine("jwserver", commandArgArray, _usage, "-", false);
        this._cmdline.markAppendable("urlfile");
        boolean bl = this._cmdline.parse(stringArray, System.err);
        return bl;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int n) {
        if (this._running) {
            throw new RuntimeException("can't change port when server is running");
        }
        this._port = n;
    }

    public void startServer() {
        try {
            this._socket = new ServerSocket(this.getPort());
            this._port = this._socket.getLocalPort();
        }
        catch (Exception exception) {
            Server.error(_messages.get("jwserver.error.start.failed", exception.toString()));
            return;
        }
        Thread thread = new Thread((Runnable)this, "listen" + this._port);
        this._running = true;
        thread.start();
        Server.info(_messages.get("jwserver.verbose.started.port", Integer.toString(this._port)));
    }

    public void stopServer() {
        this._running = false;
    }

    /*
     * Loose catch block
     */
    public void run() {
        block9: {
            while (this._running) {
                Socket socket = this._socket.accept();
                this._pool.performWork(socket);
            }
            Object var3_3 = null;
            try {
                this._socket.close();
            }
            catch (Throwable throwable) {
                Server.error(_messages.get("jwserver.verbose.caught.exception", throwable.toString()));
            }
            break block9;
            {
                catch (Throwable throwable) {
                    Server.error(_messages.get("jwserver.verbose.caught.exception", throwable.toString()));
                    Object var3_4 = null;
                    try {
                        this._socket.close();
                    }
                    catch (Throwable throwable2) {
                        Server.error(_messages.get("jwserver.verbose.caught.exception", throwable2.toString()));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                try {
                    this._socket.close();
                }
                catch (Throwable throwable3) {
                    Server.error(_messages.get("jwserver.verbose.caught.exception", throwable3.toString()));
                }
                throw throwable;
            }
        }
    }

    static void error(String string) {
        System.err.println(string);
    }

    static void debug(String string) {
        if (_debug) {
            System.out.println(string);
        }
    }

    static void info(String string) {
        if (_verbose) {
            System.out.println(string);
        }
    }

    static void warn(String string) {
        if (!_nowarn) {
            System.out.println("warn: " + string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _debug = false;
        _verbose = false;
        _nowarn = false;
        _messages = new Messages(class$com$sssw$jbroker$web$server$Server == null ? (class$com$sssw$jbroker$web$server$Server = Server.class$("com.sssw.jbroker.web.server.Server")) : class$com$sssw$jbroker$web$server$Server);
        _usage = _messages.get("jwserver.usage") + Copyright._copyright + "\n";
    }

    public class WorkerThread
    extends Thread {
        private final ThreadPool _pool;
        private final int _timeout;
        private final ServerConnection _conn;
        private Socket _socket;

        public WorkerThread(ThreadPool threadPool, int n) {
            this._pool = threadPool;
            this._timeout = n;
            this._conn = new ServerConnection(Server.this._deploy);
        }

        public synchronized void assign(Socket socket) {
            this._socket = socket;
            this.notify();
        }

        /*
         * Loose catch block
         */
        public synchronized void run() {
            while (true) {
                block16: {
                    String string;
                    if (this._socket == null) {
                        try {
                            this.wait(this._timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this._socket != null) continue;
                        this._pool.removeWorker(this);
                        return;
                    }
                    this._conn.setSocket(this._socket);
                    this._conn.run();
                    Object var4_5 = null;
                    try {
                        this._socket.close();
                    }
                    catch (Throwable throwable2) {
                        string = throwable2.getMessage();
                        if (string == null || string.length() == 0) {
                            string = throwable2.toString();
                        }
                        Server.warn(_messages.get("jwserver.verbose.caught.exception", string));
                        throwable2.printStackTrace(System.err);
                    }
                    break block16;
                    {
                        catch (Throwable throwable) {
                            String string2 = throwable.getMessage();
                            if (string2 == null || string2.length() == 0) {
                                string2 = throwable.toString();
                            }
                            Server.warn(_messages.get("jwserver.verbose.caught.exception", string2));
                            throwable.printStackTrace(System.err);
                            var4_5 = null;
                            try {
                                this._socket.close();
                            }
                            catch (Throwable throwable2) {
                                string = throwable2.getMessage();
                                if (string == null || string.length() == 0) {
                                    string = throwable2.toString();
                                }
                                Server.warn(_messages.get("jwserver.verbose.caught.exception", string));
                                throwable2.printStackTrace(System.err);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        var4_5 = null;
                        try {
                            this._socket.close();
                        }
                        catch (Throwable throwable2) {
                            string = throwable2.getMessage();
                            if (string == null || string.length() == 0) {
                                string = throwable2.toString();
                            }
                            Server.warn(_messages.get("jwserver.verbose.caught.exception", string));
                            throwable2.printStackTrace(System.err);
                        }
                        throw throwable;
                    }
                }
                this._socket = null;
                this._pool.returnWorker(this);
            }
        }
    }

    public class ThreadPool {
        private final int _max;
        private final int _timeout;
        private final Vector _idle = new Vector();
        private int _num = 0;

        public ThreadPool(int n, int n2) {
            this._max = n;
            this._timeout = n2;
        }

        /*
         * Unable to fully structure code
         */
        public synchronized void performWork(Socket var1_1) {
            block4: {
                block3: {
                    if (this._idle.size() <= 0) break block3;
                    var2_2 = (WorkerThread)this._idle.elementAt(0);
                    this._idle.removeElementAt(0);
                    var2_2.assign(var1_1);
                    break block4;
                }
                if (this._max != 0 && this._num >= this._max) ** GOTO lbl18
                var2_3 = new WorkerThread(this, this._timeout);
                ++this._num;
                var2_3.assign(var1_1);
                var2_3.start();
                break block4;
lbl-1000:
                // 1 sources

                {
                    try {
                        this.wait();
                        continue;
                    }
                    catch (InterruptedException var2_4) {
                        // empty catch block
                    }
lbl18:
                    // 3 sources

                    ** while (this._idle.size() == 0)
                }
lbl19:
                // 1 sources

                var2_5 = (WorkerThread)this._idle.elementAt(0);
                this._idle.removeElementAt(0);
                var2_5.assign(var1_1);
            }
        }

        public synchronized void returnWorker(WorkerThread workerThread) {
            this._idle.addElement(workerThread);
            this.notify();
        }

        public synchronized void removeWorker(WorkerThread workerThread) {
            --this._num;
            this._idle.removeElement(workerThread);
        }
    }
}

