/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.server;

import com.sssw.jbroker.web.core.GetSupport;
import com.sssw.jbroker.web.core.MultipartRequest;
import com.sssw.jbroker.web.core.XMLReaderImpl;
import com.sssw.jbroker.web.portable.InvokeHandler;
import com.sssw.jbroker.web.portable.ServerResponse;
import com.sssw.jbroker.web.server.DeployImpl;
import com.sssw.jbroker.web.server.Server;
import com.sssw.jbroker.web.server.ServerException;
import com.sssw.jbroker.web.soap.SOAPHandler;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class ServerConnection
implements Runnable {
    private Socket _socket;
    private InputStream _is;
    private OutputStream _os;
    private SOAPHandler _protHandler;
    private XMLReaderImpl _xmlReader;
    private final ByteArrayOutputStream _bab;
    private String serverName;
    private int serverPort;
    private final DeployImpl _deploy;
    private static final String DEFAULT_CHARSET = "iso-8859-1";
    private static final String _deployLoc = "/__deploy";
    private static final String _undeployLoc = "/__undeploy";
    private static final boolean _debug = false;
    private static final String CONTENT_TYPE = "content-type";
    private static final String _CHARSET = "charset";

    public ServerConnection(DeployImpl deployImpl) {
        this._deploy = deployImpl;
        this._protHandler = new SOAPHandler(null);
        this._bab = new ByteArrayOutputStream(2048);
    }

    public void setSocket(Socket socket) {
        this._socket = socket;
    }

    /*
     * Loose catch block
     */
    public void run() {
        block21: {
            this._is = this._socket.getInputStream();
            this._os = this._socket.getOutputStream();
            this.serverName = this._socket.getLocalAddress().getHostName();
            this.serverPort = this._socket.getLocalPort();
            this.process();
            Object var5_1 = null;
            try {
                this._is.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this._os.close();
            }
            catch (Throwable throwable) {}
            break block21;
            {
                catch (ServerException serverException) {
                    Server.info(Server._messages.get("jwserver.verbose.caught.exception", serverException.getMessage()));
                    this.error(serverException.getMessage());
                    Object var5_2 = null;
                    try {
                        this._is.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        this._os.close();
                    }
                    catch (Throwable throwable) {}
                    break block21;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Server.info(Server._messages.get("jwserver.verbose.caught.exception", iOException.getMessage()));
                    this.error("" + iOException.getMessage());
                    Object var5_3 = null;
                    try {
                        this._is.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        this._os.close();
                    }
                    catch (Throwable throwable) {}
                    break block21;
                }
                catch (Exception exception) {
                    if (Server._debug) {
                        exception.printStackTrace(System.err);
                    }
                    this.error("" + exception.getMessage());
                    Object var5_4 = null;
                    try {
                        this._is.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        this._os.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    this._is.close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    this._os.close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void process() throws IOException, ServerException {
        boolean bl = false;
        LineReader lineReader = new LineReader(this._is);
        do {
            Object object;
            Object object2;
            String string;
            int n = -1;
            String string2 = null;
            try {
                while ((string2 = lineReader.readLine()) != null && string2.length() == 0) {
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            if (string2 == null) break;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            String string3 = null;
            String string4 = null;
            String string5 = null;
            try {
                string3 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken();
            }
            catch (Exception exception) {
                throw new ServerException("malformed request: " + string2);
            }
            if ("HTTP/1.1".equalsIgnoreCase(string5)) {
                bl = true;
            }
            String string6 = null;
            String string7 = null;
            String string8 = null;
            while ((string = lineReader.readLine()) != null && string.length() != 0) {
                int n2 = string.indexOf(58);
                if (n2 == -1 || n2 == string.length()) continue;
                String string9 = string.substring(0, n2);
                if (string9.equalsIgnoreCase("content-length")) {
                    n = Integer.parseInt(string.substring(n2 + 1).trim());
                    continue;
                }
                if (string9.equalsIgnoreCase(CONTENT_TYPE)) {
                    string6 = string.substring(n2 + 1).trim();
                    continue;
                }
                if (string9.equalsIgnoreCase("connection")) {
                    if (string.toLowerCase().indexOf("keep-alive") == -1) continue;
                    bl = true;
                    continue;
                }
                if (string9.equalsIgnoreCase("soapaction")) {
                    string8 = string.substring(n2 + 1).trim();
                    continue;
                }
                if (!string9.equalsIgnoreCase("content-location")) continue;
                string7 = string.substring(n2 + 1).trim();
            }
            string = ServerConnection.getContentTypeCharset(string6, DEFAULT_CHARSET);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n3 = 200;
            String string10 = "text/html";
            boolean bl2 = false;
            Properties properties = null;
            if (string3.equalsIgnoreCase("post")) {
                if (string4.equals(_deployLoc)) {
                    object2 = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string);
                    n3 = this.deploy(lineReader, (Writer)object2);
                } else if (string4.equals(_undeployLoc)) {
                    object2 = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string);
                    n3 = this.undeploy(lineReader, (Writer)object2);
                } else {
                    object2 = new InputStreamReader((InputStream)lineReader, string);
                    object2 = new BufferedReader((Reader)object2);
                    object = this._deploy.getFile(string4);
                    if (object != null) {
                        n3 = this.doFile((Reader)object2, n);
                        byteArrayOutputStream.write((byte[])object);
                        byteArrayOutputStream.flush();
                        byteArrayOutputStream.close();
                        bl2 = true;
                    } else {
                        properties = this.doPost(lineReader, byteArrayOutputStream, string4, string8, string6, string7, n);
                    }
                    string10 = "text/xml";
                }
            } else if (string3.equalsIgnoreCase("get") || string3.equalsIgnoreCase("head")) {
                String string11;
                object2 = new InputStreamReader((InputStream)lineReader, string);
                object2 = new BufferedReader((Reader)object2);
                int n4 = string4.indexOf("?");
                String string12 = string11 = n4 > 0 ? string4.substring(n4 + 1) : null;
                if (string11 != null && string11.equals("wsdl")) {
                    string10 = "text/xml";
                    string = "utf-8";
                }
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string);
                this.doGet((Reader)object2, outputStreamWriter, string4);
            } else {
                throw new ServerException("unsupported method " + string3);
            }
            object2 = byteArrayOutputStream.toByteArray();
            this._bab.reset();
            if (!bl2) {
                string10 = string10 + "; charset=\"" + string + "\"";
                object = this.getHeaders(n3, string10, ((Object)object2).length, bl, properties);
                this._bab.write(object.getBytes("utf-8"));
            }
            if (!string3.equalsIgnoreCase("head")) {
                this._bab.write((byte[])object2);
            }
            this._bab.flush();
            this._os.write(this._bab.toByteArray());
            this._os.flush();
        } while (bl);
    }

    public String getHeaders(int n, String string, int n2, boolean bl, Properties properties) {
        String string2;
        CharSequence charSequence;
        if (properties != null) {
            charSequence = properties.getProperty("errCode");
            if (charSequence != null) {
                n = Integer.parseInt((String)charSequence);
            }
            if ((string2 = properties.getProperty(CONTENT_TYPE)) != null) {
                string = string2;
            }
        }
        charSequence = new StringBuffer();
        string2 = "";
        if (n == 200) {
            string2 = "OK";
        } else if (n == 500) {
            string2 = "Error processing request.";
        }
        ((StringBuffer)charSequence).append("HTTP/1.0 ").append(n).append(" ").append(string2).append("\r\n");
        ((StringBuffer)charSequence).append("Content-Type: ").append(string).append("\r\n");
        ((StringBuffer)charSequence).append("Content-length: ").append(n2).append("\r\n");
        if (bl) {
            ((StringBuffer)charSequence).append("Connection: Keep-Alive\r\n");
        }
        ((StringBuffer)charSequence).append("\r\n");
        return ((StringBuffer)charSequence).toString();
    }

    public int doFile(Reader reader, int n) throws IOException {
        char[] cArray = new char[n];
        reader.read(cArray);
        return 200;
    }

    public Properties doPost(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, String string, String string2, String string3, String string4, int n) throws IOException {
        Object object;
        byte[] byArray = new byte[n];
        inputStream.read(byArray);
        inputStream = new ByteArrayInputStream(byArray);
        String string5 = null;
        if (string3 != null) {
            object = MultipartRequest.getAttributes(string3, ";");
            string5 = ((Properties)object).getProperty(_CHARSET);
        }
        object = null;
        object = string5 == null ? new InputStreamReader(new ByteArrayInputStream(byArray)) : new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), string5);
        DeployImpl.Service service = this._deploy.get(string);
        if (service == null) {
            throw new IOException("nothing deployed at " + string);
        }
        Properties properties = new Properties();
        properties.setProperty(CONTENT_TYPE, string3);
        if (string4 != null) {
            properties.setProperty("content-location", string4);
        }
        if (string2 != null) {
            properties.setProperty("soapaction", string2);
        }
        properties.setProperty("content-length", "" + n);
        InvokeHandler invokeHandler = service.getInvokeHandler();
        ServerResponse serverResponse = invokeHandler._invoke(properties, inputStream);
        if (serverResponse != null) {
            serverResponse.size();
            serverResponse.writeTo(byteArrayOutputStream);
            byteArrayOutputStream.flush();
        }
        ((Hashtable)properties).clear();
        properties = new Properties();
        String string6 = (String)serverResponse._getProperties().get("http.content.type");
        if (string6 != null) {
            properties.setProperty(CONTENT_TYPE, string6);
        }
        return properties;
    }

    public int deploy(LineReader lineReader, Writer writer) throws IOException {
        Object object;
        Object object2;
        Object object3;
        int n;
        String string = null;
        String string2 = "default.war";
        boolean bl = false;
        String string3 = null;
        try {
            while ((string3 = lineReader.readLine()) != null && string3.length() == 0) {
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string3.startsWith("----------")) {
            string3 = lineReader.readLine();
        }
        if ((n = string3.indexOf("filename=")) == -1) {
            bl = true;
            string = "File name not present in form data";
        } else {
            string2 = string3.substring(n + 9);
            if (string2.charAt(0) == '\"') {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (!string2.toLowerCase().endsWith(".war")) {
                bl = true;
                string = "Uploaded file does not have mandatory .war extension";
            }
            if ((string2 = string2.replace('\\', '/')).indexOf("/") != -1) {
                string2 = string2.substring(string2.lastIndexOf("/"));
            }
        }
        int n2 = 0;
        if (!bl) {
            if (string2.startsWith(File.separator)) {
                string2 = string2.substring(1);
            }
            string2 = "websvcs/" + string2;
            object3 = new FileOutputStream(string2);
            object2 = "------------------";
            object = null;
            try {
                object = lineReader.readPart(((String)object2).getBytes());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object == null) {
                bl = true;
                string = "Uploaded data seems corrupted";
            }
            if (!bl) {
                n2 = ((byte[])object).length;
                ((FileOutputStream)object3).write((byte[])object);
                ((OutputStream)object3).flush();
                ((FileOutputStream)object3).close();
                Server.info(Server._messages.get("jwserver.verbose.write.file", Integer.toString(n2), string2));
            }
        }
        object3 = null;
        if (!bl) {
            try {
                object3 = this._deploy.deployWar(string2);
            }
            catch (IOException iOException) {
                bl = true;
                string = iOException.getMessage();
            }
        }
        object2 = new PrintWriter(writer);
        GetSupport.header("Deploy Status", (PrintWriter)object2);
        if (bl) {
            ((PrintWriter)object2).println("<h1>Deploy failed</h1>");
            ((PrintWriter)object2).println("<p>Message: " + string + "</p>");
            ((PrintWriter)object2).print("<p>Please try to re-deploy from the ");
            ((PrintWriter)object2).println("<a href=\"..\">root</a> page.</p>");
        } else {
            ((PrintWriter)object2).println("<h1>Deploy successfull</h1>");
            ((PrintWriter)object2).println("<ul>");
            ((PrintWriter)object2).println("<li>File name: " + string2);
            ((PrintWriter)object2).println("<li>File size: " + n2);
            if (object3.size() == 1) {
                object = (String)object3.keySet().iterator().next();
                ((PrintWriter)object2).print("<li>Location: <a href=\"" + (String)object);
                ((PrintWriter)object2).println("\">" + (String)object + "</a>");
            } else {
                ((PrintWriter)object2).println("<ul>");
                object = object3.keySet().iterator();
                while (object.hasNext()) {
                    String string4 = (String)object.next();
                    ((PrintWriter)object2).print("<li>Location: <a href=\"" + string4);
                    ((PrintWriter)object2).println(">\"" + string4 + "</a>");
                    ((PrintWriter)object2).println("</ul>");
                }
            }
            ((PrintWriter)object2).println("</ul>");
            ((PrintWriter)object2).print("<p>Click <a href=\"..\">here</a>");
            ((PrintWriter)object2).println(" to return to the root page.</p>");
        }
        GetSupport.footer((PrintWriter)object2);
        writer.flush();
        return 200;
    }

    public int undeploy(LineReader lineReader, Writer writer) throws IOException {
        Object object;
        int n;
        String string = null;
        boolean bl = false;
        String string2 = null;
        try {
            while ((string2 = lineReader.readLine()) != null && string2.length() == 0) {
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        int n2 = n = string2 != null ? string2.indexOf("location=") : -1;
        if (n != -1) {
            Object object2;
            object = string2.substring(n + "location=".length());
            while ((n = ((String)object).indexOf("%2F")) != -1) {
                object2 = new StringBuffer((String)object);
                ((StringBuffer)object2).replace(n, n + 3, "/");
                object = ((StringBuffer)object2).toString();
            }
            object2 = this._deploy.get((String)object);
            if (object2 == null) {
                bl = true;
                string = "Nothing seems to be deployed at " + (String)object;
            } else if (((DeployImpl.Service)object2).getInvokeHandler() == this._deploy) {
                bl = true;
                string = "Can't un-deploy the deploy service!";
            } else {
                this._deploy.undeploy((String)object);
                Server.info(Server._messages.get("jwserver.verbose.undeploy.location", object));
            }
        } else {
            bl = true;
            string = "Form data did not contain expected location string";
        }
        object = new PrintWriter(writer);
        GetSupport.header("Deploy Status", (PrintWriter)object);
        if (bl) {
            ((PrintWriter)object).println("<h1>Un-deploy failed</h1>");
            ((PrintWriter)object).println("<p>Message: " + string + "</p>");
            ((PrintWriter)object).print("<p>Please try to refresh the <a href=\"..\">root</a>");
            ((PrintWriter)object).println(" page as deployment information may have changed.</p>");
        } else {
            ((PrintWriter)object).println("<h1>Un-deploy successfull</h1>");
            ((PrintWriter)object).print("<p>Click <a href=\"..\">here</a>");
            ((PrintWriter)object).println(" to return to the root page.</p>");
        }
        GetSupport.footer((PrintWriter)object);
        writer.flush();
        return 200;
    }

    public void error(String string) {
        try {
            byte[] byArray = string.getBytes();
            int n = byArray.length;
            String string2 = this.getHeaders(500, "text/html", n, false, null);
            this._os.write(string2.getBytes("utf-8"));
            this._os.write(byArray);
            this._os.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void doGet(Reader reader, Writer writer, String string) throws IOException {
        byte[] byArray = this._deploy.getFile(string);
        if (byArray != null) {
            char[] cArray = new char[1024];
            while (reader.read(cArray) != -1) {
            }
            writer.write(new String(byArray));
            return;
        }
        PrintWriter printWriter = new PrintWriter(writer);
        int n = string.indexOf("?");
        String string2 = n > 0 ? string.substring(n + 1) : null;
        string = n > 0 ? string.substring(0, n) : string;
        DeployImpl.Service service = this._deploy.get(string);
        if (service != null && (string2 != null || service.getInvokeHandler() != this._deploy)) {
            GetSupport.doGet(reader, service.getInvokeHandler(), string2, string, printWriter, "http://" + this.serverName + ":" + this.serverPort + string);
            return;
        }
        GetSupport.header("jBroker Web 2.1 Deployment Web Service", printWriter);
        if (_deployLoc.equals(string)) {
            printWriter.print("<p>This page is reserved for posting new WAR files ");
            printWriter.print("from a browser client.</p><p>Please deploy from the ");
            printWriter.print("<a href=\"..\">root</a> page.<p>");
        } else if (_undeployLoc.equals(string)) {
            printWriter.print("<p>This page is reserved for posting un-deploy ");
            printWriter.print("commands from a browser client.</p><p>Please un-deploy ");
            printWriter.print("by selecting a service from the ");
            printWriter.println("<a href=\"..\">root</a> page.<p>");
        } else if (service == null) {
            printWriter.println("<p>Nothing deployed at " + string + "</p>");
            printWriter.println("<p>List of all services:</p>");
            String[] stringArray = this._deploy.list();
            int n2 = 0;
            while (n2 < stringArray.length) {
                DeployImpl.Service service2 = this._deploy.get(stringArray[n2]);
                if (service2.getInvokeHandler() != this._deploy) {
                    printWriter.print(" <li> " + service2.getDisplayName());
                    printWriter.print(" (<a href=\"" + stringArray[n2] + "\">" + stringArray[n2] + "</a>)");
                }
                ++n2;
            }
            printWriter.println("</ul>");
            printWriter.print("<p>You can deploy services from the ");
            printWriter.println("<a href=\"..\">root</a> page.</p>");
        } else if (service.getInvokeHandler() == this._deploy) {
            printWriter.println("<h1>" + service.getDisplayName() + "</h1>");
            printWriter.println("<p>" + service.getDescription() + "</p>");
            printWriter.println(GetSupport.getServiceList(service.getInvokeHandler(), string));
            String[] stringArray = this._deploy.list();
            if (stringArray.length > 1) {
                printWriter.println("<p>Below is a list of currently deployed services:</p>");
            }
            printWriter.println("<blockquote>");
            printWriter.println("<table border=\"0\">");
            int n3 = 0;
            while (n3 < stringArray.length) {
                DeployImpl.Service service3 = this._deploy.get(stringArray[n3]);
                if (service3.getInvokeHandler() != this._deploy) {
                    printWriter.println("<tr>");
                    printWriter.print("<td>" + service3.getDisplayName());
                    printWriter.print(" (<a href=\"" + stringArray[n3] + "\">" + stringArray[n3] + "</a>)");
                    printWriter.println("</td><td>");
                    printWriter.print("<form method=\"POST\" action=\"");
                    printWriter.println("/__undeploy\">");
                    printWriter.println("<input type=\"submit\" value=\"Undeploy\">");
                    printWriter.print("<input type=\"hidden\" name=\"location\"");
                    printWriter.println(" value=\"" + stringArray[n3] + "\"></td>");
                    printWriter.println("</form>");
                    printWriter.println("</tr>");
                }
                ++n3;
            }
            printWriter.println("</table>");
            printWriter.println("</blockquote>");
            printWriter.println("<h1>Deploy New Web Service:</h1>");
            printWriter.print("<form ENCTYPE=\"multipart/form-data\" method=\"POST\" action=\"/__deploy\">");
            printWriter.print("<p><nobr>\nWeb archive: <input type=\"file\"");
            printWriter.println("name=\"warfile\">\n</nobr></p>");
            printWriter.println("<p><input type=\"submit\" value=\"Deploy\"></p>");
            printWriter.println("</form>");
            printWriter.println("<p>Please be patient after pressing deploy - depending of the size of your WAR file, it may take a few moments to upload it.</p>");
        }
        printWriter.println("<p>Back to <a href=\"#top\">top</a>.</p>");
        GetSupport.trailer(string, printWriter);
        GetSupport.footer(printWriter);
        writer.flush();
    }

    public static String getContentTypeCharset(String string, String string2) {
        int n;
        if (string != null && (n = string.indexOf("charset=")) != -1) {
            char c = string.charAt(n += "charset=".length());
            if (c == '\'' || c == '\"') {
                int n2 = string.indexOf(c, n + 1);
                if (n2 == -1) {
                    return null;
                }
                return string.substring(n + 1, n2);
            }
            int n3 = string.indexOf(";", n + 1);
            if (n3 == -1) {
                n3 = string.length();
            }
            return string.substring(n, n3);
        }
        return string2;
    }

    private void writeHeaders(Properties properties, OutputStream outputStream) throws IOException {
        Iterator iterator = ((Hashtable)properties).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            outputStream.write(((String)entry.getKey()).getBytes());
            outputStream.write(58);
            outputStream.write(32);
            outputStream.write(((String)entry.getValue()).getBytes());
            outputStream.write(10);
        }
    }

    private static final class LineReader
    extends InputStream {
        private final InputStream _is;
        private boolean _eof = false;

        public LineReader(InputStream inputStream) {
            this._is = inputStream;
        }

        public int available() throws IOException {
            return this._is.available();
        }

        public void close() throws IOException {
            this._eof = true;
            this._is.close();
        }

        public void mark(int n) {
            this._is.mark(n);
        }

        public boolean markSupported() {
            return this._is.markSupported();
        }

        public int read() throws IOException {
            return this._is.read();
        }

        public int read(byte[] byArray) throws IOException {
            return this._is.read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this._is.read(byArray, n, n2);
        }

        public void reset() throws IOException {
            this._is.reset();
        }

        public long skip(long l) throws IOException {
            return this._is.skip(l);
        }

        public String readLine() throws IOException {
            if (this._eof) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                int n;
                if ((n = this._is.read()) == -1) {
                    this._eof = true;
                    return stringBuffer.length() == 0 ? null : stringBuffer.toString();
                }
                if (n == 10) {
                    return stringBuffer.toString();
                }
                if (n == 13) continue;
                stringBuffer.append((char)n);
            }
        }

        public byte[] readPart(byte[] byArray) throws IOException {
            if (this._eof) {
                return null;
            }
            int n = 0;
            byte[] byArray2 = new byte[]{};
            int n2;
            byte[] byArray3;
            int n3;
            block0: while ((n3 = this._is.read(byArray3 = new byte[n2 = this._is.available()])) != -1) {
                int n4;
                if (n3 + n > byArray2.length) {
                    n4 = byArray2.length * 2;
                    if (n3 + n > n4) {
                        n4 = n3 + n;
                    }
                    byte[] byArray4 = new byte[n4];
                    System.arraycopy(byArray2, 0, byArray4, 0, n);
                    byArray2 = byArray4;
                }
                System.arraycopy(byArray3, 0, byArray2, n, n3);
                n += n3;
                n4 = 0;
                while (true) {
                    if (n4 >= n - byArray.length) continue block0;
                    int n5 = 0;
                    while (n5 < byArray.length) {
                        if (byArray2[n4 + n5] != byArray[n5]) break;
                        ++n5;
                    }
                    if (n5 == byArray.length) {
                        return this.fix(byArray2, n4);
                    }
                    ++n4;
                }
                break;
            }
            return this.fix(byArray2, n);
        }

        /*
         * Unable to fully structure code
         */
        private byte[] fix(byte[] var1_1, int var2_2) {
            if (var2_2 != 0) ** GOTO lbl4
            return null;
lbl-1000:
            // 1 sources

            {
                --var2_2;
lbl4:
                // 2 sources

                ** while (var1_1[var2_2 - 1] == 13 || var1_1[var2_2 - 1] == 10)
            }
lbl5:
            // 1 sources

            var3_3 = 0;
            while (var1_1[var3_3] != 80 && var1_1[var3_3 + 1] != 75) {
                ++var3_3;
            }
            var4_4 = new byte[var2_2 - var3_3];
            System.arraycopy(var1_1, var3_3, var4_4, 0, var2_2 - var3_3);
            return var4_4;
        }
    }
}

