/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.servlet;

import com.sssw.jbroker.tools.rmi2soap.Main;
import com.sssw.jbroker.tools.wsdl2java.CodeGenerator;
import com.sssw.jbroker.tools.wsdlast.ASTBinding;
import com.sssw.jbroker.tools.wsdlast.ASTDocument;
import com.sssw.jbroker.tools.wsdlast.ASTPort;
import com.sssw.jbroker.tools.wsdlast.ASTPortType;
import com.sssw.jbroker.tools.wsdlast.ASTService;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBinding;
import com.sssw.jbroker.web.core.GetSupport;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;

public class Invoker
extends HttpServlet {
    public static final String CLASSPATH = "jbroker.web.invoker.classpath";
    private static final String TEMP_DIR = ".jbw";
    private String _classpath;
    private InitialContext _ctx;
    private final Map _docs = new HashMap();
    private static final boolean _debug = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ServletContext servletContext = servletConfig.getServletContext();
        this._classpath = servletContext.getInitParameter(CLASSPATH);
        if (File.pathSeparatorChar == ':') {
            this._classpath = this._classpath.replace(';', File.pathSeparatorChar);
        } else if (File.pathSeparatorChar == ';') {
            this._classpath = this._classpath.replace(':', File.pathSeparatorChar);
        }
        String string = System.getProperty("java.class.path");
        int n = string.indexOf("tools.jar");
        if (n == -1) {
            String string2 = System.getProperty("java.home");
            if (string2 == null) throw new ServletException("The JDK lib/tools.jar must be in your CLASSPATH to compile generated code");
            File file = new File(string2).getParentFile();
            File file2 = new File(file, "lib");
            File file3 = new File(file2, "tools.jar");
            if (!file3.exists() || !file3.canRead()) throw new ServletException("The JDK lib/tools.jar must be in your CLASSPATH to compile generated code");
            try {
                this._classpath = this._classpath == null ? file3.getCanonicalPath() : this._classpath + File.pathSeparatorChar + file3.getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new ServletException("Failed to initialize servlet: " + iOException.getMessage(), (Throwable)iOException);
            }
        }
        try {
            this._ctx = new InitialContext();
            return;
        }
        catch (NamingException namingException) {
            throw new ServletException("Failed to initialize servlet: " + namingException.getMessage(), (Throwable)namingException);
        }
    }

    private DocHolder parseDocument(String string) throws Exception {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string2 = System.getProperty("user.home");
        File file = new File(string2, TEMP_DIR);
        long l = System.currentTimeMillis();
        File file2 = new File(file, Long.toString(l));
        hashtable.put("d", new String[]{file2.getCanonicalPath()});
        hashtable.put("notie", Boolean.TRUE);
        hashtable.put("noskel", Boolean.TRUE);
        hashtable.put("nowarn", Boolean.TRUE);
        String string3 = System.getProperty("java.class.path");
        if (this._classpath != null) {
            string3 = string3 + File.pathSeparatorChar + this._classpath;
        }
        hashtable.put("classpath", new String[]{string3});
        ASTDocument aSTDocument = com.sssw.jbroker.tools.wsdl2java.Main.compile(new CodeGenerator(new Vector()), string, hashtable);
        aSTDocument.setWSDLDocument(file2.toURL());
        if (!aSTDocument.getStatus()) {
            throw new Exception("Failed to compile Java classes. This error usually occurs when the CLASSPATH setting  is insufficient. Please set the jbroker.web.invoker.classpath parameter in the servlet configuration.");
        }
        ASTDocument[] aSTDocumentArray = new ASTDocument[]{aSTDocument};
        Main.compile(aSTDocumentArray, Main.getCodeGenerator("generic"), hashtable);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL[] uRLArray = new URL[]{aSTDocument.getWSDLDocument()};
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, classLoader);
        DocHolder docHolder = new DocHolder(aSTDocument, uRLClassLoader, l);
        return docHolder;
    }

    private static Map adjust(Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String[] stringArray = (String[])entry.getValue();
            hashMap.put(entry.getKey(), stringArray[0]);
        }
        return hashMap;
    }

    private synchronized void scavenge() {
        long l = System.currentTimeMillis();
        long l2 = l - 600000L;
        Iterator iterator = this._docs.values().iterator();
        while (iterator.hasNext()) {
            DocHolder docHolder = (DocHolder)iterator.next();
            if (docHolder.lastUsed() >= l2) continue;
            try {
                File file = new File(System.getProperty("user.home"), TEMP_DIR);
                File file2 = new File(file, Long.toString(docHolder.getTimestamp()));
                Invoker.delete(file2.listFiles());
                file2.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            iterator.remove();
        }
    }

    private static void delete(File[] fileArray) throws Exception {
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                Invoker.delete(fileArray[n].listFiles());
            }
            fileArray[n].delete();
            ++n;
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string = httpServletRequest.getQueryString();
        if ("jbroker.gif".equals(string)) {
            GetSupport.logo(printWriter);
            printWriter.flush();
            return;
        }
        this.scavenge();
        String string2 = httpServletRequest.getRequestURI();
        String string3 = httpServletRequest.getParameter("url");
        GetSupport.header("jBroker Web Invoker", printWriter);
        if (string != null && string.startsWith("test")) {
            Map map = Invoker.adjust(httpServletRequest.getParameterMap());
            int n = GetSupport.getIntProperty(map, "test", Integer.MAX_VALUE);
            DocHolder docHolder = (DocHolder)this._docs.get(string3);
            if (docHolder == null) {
                try {
                    docHolder = this.parseDocument(string3);
                    this._docs.put(string3, docHolder);
                }
                catch (Exception exception) {
                    printWriter.println("<p>Failed to parse WSDL: " + exception.getMessage() + "</p>");
                }
            }
            if (docHolder != null) {
                docHolder.markUse();
                ASTDocument aSTDocument = docHolder.getDocument();
                if (aSTDocument.hasPortTypes()) {
                    String string4 = aSTDocument.getPortTypes()[0].getName();
                    String string5 = null;
                    try {
                        string5 = httpServletRequest.getRequestURL().toString();
                    }
                    catch (Throwable throwable) {
                        string5 = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString();
                    }
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("url", string3);
                    Thread.currentThread().setContextClassLoader(docHolder.getLoader());
                    GetSupport.testi(aSTDocument, string4, string2, n, map, string5, hashMap, printWriter);
                    return;
                }
                printWriter.println("<p>WSDL has no port types</p>");
            }
        } else if (string != null && string.startsWith("invoke")) {
            DocHolder docHolder = (DocHolder)this._docs.get(string3);
            if (docHolder == null) {
                try {
                    docHolder = this.parseDocument(string3);
                    this._docs.put(string3, docHolder);
                }
                catch (Exception exception) {
                    printWriter.println("<p>Failed to parse WSDL: " + exception.getMessage() + "</p>");
                }
            }
            if (docHolder != null) {
                docHolder.markUse();
                ASTDocument aSTDocument = docHolder.getDocument();
                if (aSTDocument.hasPortTypes()) {
                    Object object;
                    Object object2;
                    String string6 = aSTDocument.getPortTypes()[0].getName();
                    Map map = Invoker.adjust(httpServletRequest.getParameterMap());
                    Thread.currentThread().setContextClassLoader(docHolder.getLoader());
                    ASTService aSTService = null;
                    String string7 = null;
                    ASTService[] aSTServiceArray = aSTDocument.getServices();
                    if (aSTServiceArray != null) {
                        int n = 0;
                        while (n < aSTServiceArray.length) {
                            if (aSTService != null) break;
                            object2 = aSTServiceArray[n].getPorts();
                            if (object2 != null) {
                                int n2 = 0;
                                while (n2 < ((ASTPort[])object2).length) {
                                    object = object2[n2].getBinding();
                                    if (object != null && object instanceof ASTSoapBinding && ((ASTBinding)object).getPortTypeName().equals(string6)) {
                                        string7 = ((ASTPort)object2[n2]).getLocalName();
                                        aSTService = aSTServiceArray[n];
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            ++n;
                        }
                    }
                    if (aSTService == null) {
                        printWriter.println("<p>Didn't find service for port type " + string6 + "<p>");
                    } else {
                        try {
                            String string8 = "xmlrpc:soap:" + aSTService.getName();
                            object2 = (Service)this._ctx.lookup(string8);
                            String string9 = "get" + string7;
                            object = object2.getClass().getMethod(string9, new Class[0]);
                            Stub stub = (Stub)((Method)object).invoke(object2, new Object[0]);
                            GetSupport.invoke(aSTDocument, stub, string2, map, printWriter);
                            return;
                        }
                        catch (Exception exception) {
                            printWriter.println("<p>Failed to instantiate stub: " + exception.getMessage() + "</p>");
                        }
                    }
                } else {
                    printWriter.println("<p>WSDL has no port types</p>");
                }
            }
        } else {
            if (string != null && string.startsWith("error")) {
                Map map = Invoker.adjust(httpServletRequest.getParameterMap());
                GetSupport.error(map, string2, printWriter);
                return;
            }
            if (string3 != null && string3.length() > 0) {
                DocHolder docHolder = (DocHolder)this._docs.get(string3);
                if (docHolder == null) {
                    try {
                        docHolder = this.parseDocument(string3);
                        this._docs.put(string3, docHolder);
                    }
                    catch (Exception exception) {
                        printWriter.println("<p>Failed to parse WSDL: " + exception.getMessage() + "</p>");
                    }
                }
                if (docHolder != null) {
                    docHolder.markUse();
                    ASTDocument aSTDocument = docHolder.getDocument();
                    if (aSTDocument.hasPortTypes()) {
                        ASTPortType[] aSTPortTypeArray = aSTDocument.getPortTypes();
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("url", string3);
                        GetSupport.test(aSTDocument, aSTPortTypeArray[0].getName(), string2, hashMap, printWriter);
                        return;
                    }
                    printWriter.println("<p>WSDL has no port types</p>");
                }
            } else {
                printWriter.println("<h1>jBroker Web Invoker</h1>");
                printWriter.println("<p>Enter the URL for a WSDL to inspect and invoke:</p>");
                printWriter.println("<form ENCTYPE=\"multipart/form-data\" method=\"GET\" action=\"\">");
                printWriter.println("<p>URL: <input type=\"text\" size=\"60\" name=\"url\"></p>");
                printWriter.println("<p><input type=\"submit\" value=\"Analyze\"></p>");
                printWriter.println("</form>");
            }
        }
        GetSupport.trailer(string2, printWriter);
        GetSupport.footer(printWriter);
        printWriter.flush();
    }

    private static final class DocHolder {
        private final ASTDocument _document;
        private final ClassLoader _loader;
        private final long _timestamp;
        private long _lastUsed;

        public DocHolder(ASTDocument aSTDocument, ClassLoader classLoader, long l) {
            this._document = aSTDocument;
            this._loader = classLoader;
            this._timestamp = l;
        }

        public ASTDocument getDocument() {
            return this._document;
        }

        public ClassLoader getLoader() {
            return this._loader;
        }

        public long getTimestamp() {
            return this._timestamp;
        }

        public void markUse() {
            this._lastUsed = System.currentTimeMillis();
        }

        public long lastUsed() {
            return this._lastUsed;
        }
    }
}

