/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.servlet;

import com.sssw.jbroker.web.core.GetSupport;
import com.sssw.jbroker.web.transport.jms.JmsHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.omg.CORBA.ORB;

public class JMSRouter
extends HttpServlet {
    private Properties _props;
    private InitialContext _ctx;
    private ConnectionFactory _factory;
    private Destination _dest;
    private Destination _replyTo;
    private boolean _requestor;
    private boolean _correlate;
    private Session _session;
    private Session _rsession;
    private MessageProducer _producer;
    private MessageConsumer _consumer;
    private int _timeout;
    private String _ident;
    private long _numBytes;
    private long _numSent;
    private long _numRecv;
    private long _errorCount;
    private final TreeMap _errors = new TreeMap();
    private static final int MAX_ERRORS = 50;
    private static final boolean _debug = true;
    static /* synthetic */ Class class$javax$jms$Queue;
    static /* synthetic */ Class class$javax$jms$Topic;

    private boolean getBooleanProperty(String string) {
        return Boolean.valueOf(this._props.getProperty(string));
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        Object object;
        super.init(servletConfig);
        this._props = new Properties();
        ServletContext servletContext = servletConfig.getServletContext();
        Enumeration enumeration = servletContext.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            ((Hashtable)this._props).put(object, servletContext.getInitParameter((String)object));
        }
        try {
            Object object2;
            String string;
            Object object3;
            Object object4;
            if ("com.sun.jndi.cosnaming.CNCtxFactory".equals(this._props.getProperty("java.naming.factory.initial"))) {
                object = ((Hashtable)this._props).entrySet().iterator();
                while (object.hasNext()) {
                    object4 = (Map.Entry)object.next();
                    object3 = (String)object4.getKey();
                    string = (String)object4.getValue();
                    System.setProperty((String)object3, string);
                }
                object4 = ORB.init((String[])null, (Properties)this._props);
                object3 = new Hashtable<Object, Object>(this._props);
                ((Hashtable)object3).put("java.naming.corba.orb", object4);
                System.out.println("creating initial context with " + object3);
                this._ctx = new InitialContext((Hashtable<?, ?>)object3);
            } else {
                this._ctx = new InitialContext(this._props);
            }
            object = this._props.getProperty("jms.queue.factory.jndi");
            if (object == null || ((String)object).length() == 0) {
                object = this._props.getProperty("jms.topic.factory.jndi");
            }
            if (object == null || ((String)object).length() == 0) {
                throw new ServletException("property jms.topic.factory.jndi or jms.queue.factory.jndi missing from servlet configuration");
            }
            this._factory = (ConnectionFactory)this._ctx.lookup((String)object);
            object4 = this._props.getProperty("jms.queue.jndi");
            if (object4 == null || ((String)object4).length() == 0) {
                object4 = this._props.getProperty("jms.topic.jndi");
            }
            if (object4 == null || ((String)object4).length() == 0) {
                throw new ServletException("property jms.topic.jndi or jms.queue.jndi missing from servlet configuration");
            }
            this._dest = (Destination)this._ctx.lookup((String)object4);
            String string2 = this._ident = this._dest instanceof Topic ? "Topic " + ((Topic)this._dest).getTopicName() : "Queue " + ((Queue)this._dest).getQueueName();
            if (this._dest instanceof Topic && this._factory instanceof QueueConnectionFactory) {
                throw new ServletException("can't connect to topic using queue connection factory");
            }
            if (this._dest instanceof Queue && this._factory instanceof TopicConnectionFactory) {
                throw new ServletException("can't connect to queue using topic connection factory");
            }
            object3 = this._props.getProperty("javax.xml.rpc.security.auth.username");
            string = this._props.getProperty("javax.xml.rpc.security.auth.password");
            if (this._factory instanceof QueueConnectionFactory) {
                object2 = object3 != null && ((String)object3).length() > 0 && string != null && string.length() > 0 ? ((QueueConnectionFactory)this._factory).createQueueConnection((String)object3, string) : ((QueueConnectionFactory)this._factory).createQueueConnection();
                this._session = object2.createQueueSession(false, 1);
                this._producer = ((QueueSession)this._session).createSender((Queue)this._dest);
                object2.start();
            } else {
                object2 = object3 != null && ((String)object3).length() > 0 && string != null && string.length() > 0 ? ((TopicConnectionFactory)this._factory).createTopicConnection((String)object3, string) : ((TopicConnectionFactory)this._factory).createTopicConnection();
                this._session = object2.createTopicSession(false, 1);
                this._producer = ((TopicSession)this._session).createPublisher((Topic)this._dest);
                object2.start();
            }
            this._requestor = this.getBooleanProperty("jms.use.requestor");
            this._correlate = this.getBooleanProperty("jms.use.correlation.id");
            object2 = this._props.getProperty("jms.queue.reply.jndi");
            if (object2 == null || ((String)object2).length() == 0) {
                object2 = this._props.getProperty("jms.topic.reply.jndi");
            }
            if (this._requestor) {
                object2 = null;
            }
            this.createReplySession();
            if (object2 != null && ((String)object2).length() > 0) {
                this._replyTo = (Destination)this._ctx.lookup((String)object2);
                if (!this._correlate) {
                    this._consumer = this.createConsumer(this._replyTo);
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof ServletException) {
                throw (ServletException)((Object)exception);
            }
            exception.printStackTrace();
            throw new ServletException("failed to initialize JMS router: " + exception.getMessage());
        }
    }

    private void createReplySession() throws JMSException, NamingException {
        Class clazz;
        if (this._replyTo != null) {
            clazz = this._replyTo.getClass();
        } else if (this._producer instanceof QueueSender) {
            clazz = class$javax$jms$Queue == null ? (class$javax$jms$Queue = JMSRouter.class$("javax.jms.Queue")) : class$javax$jms$Queue;
        } else {
            Class clazz2 = clazz = class$javax$jms$Topic == null ? (class$javax$jms$Topic = JMSRouter.class$("javax.jms.Topic")) : class$javax$jms$Topic;
        }
        if (this._dest.getClass().isAssignableFrom(clazz)) {
            this._rsession = this._session;
        } else {
            String string = this._props.getProperty("javax.xml.rpc.security.auth.username");
            String string2 = this._props.getProperty("javax.xml.rpc.security.auth.password");
            if ((class$javax$jms$Topic == null ? (class$javax$jms$Topic = JMSRouter.class$("javax.jms.Topic")) : class$javax$jms$Topic).isAssignableFrom(clazz)) {
                String string3 = this._props.getProperty("jms.topic.factory.jndi");
                if (string3 == null || string3.length() == 0) {
                    throw new JMSException("property jms.topic.factory.jndi for reply topic  is missing from servlet configuration");
                }
                TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)this._ctx.lookup(string3);
                TopicConnection topicConnection = string != null && string.length() > 0 && string2 != null && string2.length() > 0 ? topicConnectionFactory.createTopicConnection(string, string2) : topicConnectionFactory.createTopicConnection();
                this._rsession = topicConnection.createTopicSession(false, 1);
            } else {
                String string4 = this._props.getProperty("jms.queue.factory.jndi");
                if (string4 == null || string4.length() == 0) {
                    throw new JMSException("property jms.queue.factory.jndi for reply queue  is missing from servlet configuration");
                }
                QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)this._ctx.lookup(string4);
                QueueConnection queueConnection = string != null && string.length() > 0 && string2 != null && string2.length() > 0 ? queueConnectionFactory.createQueueConnection(string, string2) : queueConnectionFactory.createQueueConnection();
                this._rsession = queueConnection.createQueueSession(false, 1);
            }
        }
    }

    private MessageConsumer createConsumer(Destination destination) throws JMSException {
        String string;
        String string2 = this._props.getProperty("jms.reply.selector");
        String string3 = this._props.getProperty("jms.reply.timeout");
        String string4 = this._props.getProperty("jms.topic.durable");
        if (string3 != null && string3.length() > 0) {
            try {
                this._timeout = Integer.valueOf(string3);
                if (this._timeout < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new JMSException("value of property jms.reply.timeout is illegal: " + string3);
            }
        }
        if (this._correlate) {
            string = "JMSCorrelationID = '" + System.currentTimeMillis() + "'";
            string2 = string2 == null || string2.length() == 0 ? string : string + " and " + string2;
        }
        string = destination instanceof Topic ? (string4 != null && string4.length() > 0 ? (string2 != null && string2.length() > 0 ? ((TopicSession)this._rsession).createDurableSubscriber((Topic)destination, string4, string2, false) : ((TopicSession)this._rsession).createDurableSubscriber((Topic)destination, string4)) : (string2 != null && string2.length() > 0 ? ((TopicSession)this._rsession).createSubscriber((Topic)destination, string2, false) : ((TopicSession)this._rsession).createSubscriber((Topic)destination))) : (string2 != null && string2.length() > 0 ? ((QueueSession)this._rsession).createReceiver((Queue)destination, string2) : ((QueueSession)this._rsession).createReceiver((Queue)destination));
        return string;
    }

    private void getError(PrintWriter printWriter, String string) {
        try {
            Long l = Long.valueOf(string);
            Exception exception = (Exception)this._errors.get(l);
            if (exception == null) {
                printWriter.println("<p>Information about this error has expired.</p>");
            } else {
                printWriter.println("<blockquote><pre>");
                exception.printStackTrace(printWriter);
                printWriter.println("</pre></blockquote>");
            }
        }
        catch (NumberFormatException numberFormatException) {
            printWriter.println("<p>Invalid error identifier: " + string + ".</p>");
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string = httpServletRequest.getQueryString();
        String string2 = httpServletRequest.getRequestURI();
        String string3 = httpServletRequest.getParameter("error");
        if ("jbroker.gif".equals(string)) {
            GetSupport.logo(printWriter);
            printWriter.flush();
            return;
        }
        GetSupport.header("jBroker Web JMS Router", printWriter);
        if (string != null && string.startsWith("errors")) {
            printWriter.println("<h1>List of Recent Errors</h1>");
            printWriter.println("<blockquote>");
            if (this._errors.size() == 0) {
                printWriter.println("<p>No errors have occurred in the router.</p>");
            } else {
                printWriter.println("<p>The table below contains a list of recent errors that have occurred in the JMS router:</p>");
                printWriter.println("<table border=1 cellspacing=0 cellpadding=3>");
                printWriter.println("<tr>");
                printWriter.println("<td bgcolor=\"#E4E4E4\"><b>Identifier</b></td>");
                printWriter.println("<td bgcolor=\"#E4E4E4\"><b>Message</b></td>");
                printWriter.println("</tr>");
                Iterator iterator = this._errors.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Exception exception = (Exception)entry.getValue();
                    printWriter.println("<tr>");
                    printWriter.println("<td><a href=\"" + string2 + "?error=" + entry.getKey() + "\">" + entry.getKey() + "</a></td>");
                    printWriter.println("<td>" + exception.getMessage() + "</td>");
                    printWriter.println("</tr>");
                }
                printWriter.println("</table>");
            }
            printWriter.println("</blockquote>");
        } else if (string3 != null) {
            this.getError(printWriter, string3);
        } else if (string != null && string.startsWith("config")) {
            printWriter.println("<h1>Router Configuration</h1>");
            printWriter.println("<blockquote>");
            printWriter.println("<p>The table below shows the JMS router configuration:</p>");
            printWriter.println("<table border=1 cellspacing=0 cellpadding=3>");
            printWriter.println("<tr>");
            printWriter.println("<td bgcolor=\"#E4E4E4\"><b>Name</b></td>");
            printWriter.println("<td bgcolor=\"#E4E4E4\"><b>Value</b></td>");
            printWriter.println("</tr>");
            Iterator iterator = ((Hashtable)this._props).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                printWriter.println("<tr>");
                printWriter.println("<td>" + entry.getKey() + "</td>");
                printWriter.println("<td>" + entry.getValue() + "</td>");
                printWriter.println("</tr>");
            }
            printWriter.println("</table>");
            printWriter.println("</blockquote>");
        } else {
            printWriter.println("<h1>jBroker Web JMS Router for " + this._ident + "</h1>");
            printWriter.println("<ul>");
            printWriter.println("<li><a href=\"" + string2 + "?config" + "\">View Router Configuration</a></li>");
            printWriter.println("<li><a href=\"" + string2 + "?errors" + "\">View Recent Errors</a></li>");
            printWriter.println("</ul>");
            printWriter.println("<blockquote>");
            printWriter.println("<p>The table below shows JMS router statistics:</p>");
            printWriter.println("<table border=1 cellspacing=0 cellpadding=3>");
            printWriter.println("<tr>");
            printWriter.println("<td>Bytes Sent</td>");
            printWriter.println("<td>" + this._numBytes + "</td>");
            printWriter.println("</tr>");
            printWriter.println("<tr>");
            printWriter.println("<td>Messages Sent</td>");
            printWriter.println("<td>" + this._numSent + "</td>");
            printWriter.println("</tr>");
            printWriter.println("<tr>");
            printWriter.println("<td>Message Received</td>");
            printWriter.println("<td>" + this._numRecv + "</td>");
            printWriter.println("</tr>");
            printWriter.println("</table>");
            printWriter.println("</blockquote>");
        }
        GetSupport.trailer(string2, printWriter);
        GetSupport.footer(printWriter);
        printWriter.flush();
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        int n = httpServletRequest.getContentLength();
        if (n < 0) {
            httpServletResponse.sendError(400, "content length not specified: " + n);
            return;
        }
        this._numBytes += (long)n;
        httpServletResponse.setContentType(httpServletRequest.getContentType());
        byte[] byArray = new byte[n];
        httpServletRequest.getInputStream().read(byArray);
        String string = new String(byArray);
        try {
            TextMessage textMessage = this._session.createTextMessage(string);
            Object object = null;
            MessageConsumer messageConsumer = null;
            if (this._requestor) {
                object = this._producer instanceof QueueSender ? ((QueueSession)this._rsession).createTemporaryQueue() : ((TopicSession)this._rsession).createTemporaryTopic();
                messageConsumer = this.createConsumer((Destination)object);
            } else if (this._replyTo != null) {
                MessageConsumer messageConsumer2 = messageConsumer = this._correlate ? this.createConsumer(this._replyTo) : this._consumer;
            }
            if (this._producer instanceof QueueSender) {
                ((QueueSender)this._producer).send((Message)textMessage);
            } else {
                ((TopicPublisher)this._producer).publish((Message)textMessage);
            }
            ++this._numSent;
            if (messageConsumer != null) {
                Message message;
                Message message2 = message = this._timeout > 0 ? messageConsumer.receive((long)this._timeout) : messageConsumer.receive();
                if (message == null) {
                    throw new Exception("didn't get reply message");
                }
                ++this._numRecv;
                byte[] byArray2 = ((TextMessage)message).getText().getBytes();
                httpServletResponse.setContentLength(byArray2.length);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                servletOutputStream.write(byArray2);
                servletOutputStream.flush();
                if (this._consumer == null) {
                    messageConsumer.close();
                }
            } else {
                httpServletResponse.setContentLength(JmsHandler._voidBytes.length);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                servletOutputStream.write(JmsHandler._voidBytes);
                servletOutputStream.flush();
            }
        }
        catch (Exception exception) {
            this.addError(exception);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<SOAP-ENV:Envelope");
            stringBuffer.append(" xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/'>\n");
            stringBuffer.append(" <SOAP-ENV:Body>\n");
            stringBuffer.append("  <SOAP-ENV:Fault>\n");
            stringBuffer.append("   <faultcode>SOAP-ENV:Server</faultcode>\n");
            stringBuffer.append("   <faultstring>" + exception.getMessage() + "</faultstring>\n");
            stringBuffer.append("  </SOAP-ENV:Fault>\n");
            stringBuffer.append(" </SOAP-ENV:Body>\n");
            stringBuffer.append("</Envelope>");
            httpServletResponse.setContentLength(stringBuffer.length());
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.write(stringBuffer.toString().getBytes());
            servletOutputStream.flush();
        }
    }

    private synchronized void addError(Exception exception) {
        if (this._errors.size() > 50) {
            this._errors.remove(this._errors.firstKey());
        }
        this._errors.put(new Long(this._errorCount++), exception);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

