/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.soap;

import com.sssw.jbroker.web.QName;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.core.OutputStreamImpl;
import com.sssw.jbroker.web.portable.ClientRequest;
import com.sssw.jbroker.web.portable.ClientResponse;
import com.sssw.jbroker.web.portable.InputStream;
import com.sssw.jbroker.web.portable.RequestProperty;
import com.sssw.jbroker.web.soap.ClientResponseImpl;
import com.sssw.jbroker.web.soap.Constants;
import com.sssw.jbroker.web.soap.ServerRequestImpl;
import com.sssw.jbroker.web.spi.EncodingStyle;
import com.sssw.jbroker.web.spi.OutputStreamContext;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

class ClientRequestImpl
extends OutputStreamImpl
implements ClientRequest,
Constants {
    protected final QName _qname;
    protected final String _method;
    protected final String _action;
    protected final String _methodURI;
    protected final boolean _twoWay;
    protected String _mPrefix;
    protected boolean _footerWritten;
    protected String _charset;
    private static final boolean _debug = false;
    protected static final String _ES_DECL = " SOAP-ENV:encodingStyle='";
    private static final String _header1 = "<SOAP-ENV:Envelope xmlns:SOAP-ENV='";
    private static final String _XSI_DECL = "' xmlns:xsi='";
    private static final String _SOAP_ENC_DECL = "' xmlns:SOAP-ENC='";
    private static final String _header3 = "'><SOAP-ENV:Body>";
    private static final String _footer = "</SOAP-ENV:Body></SOAP-ENV:Envelope>";
    private static final HashMap _headers = new HashMap();
    private static final String _hdr99 = ClientRequestImpl.createHdr(Constants.XSD_URI_1999, Constants.XSI_URI_1999, "http://schemas.xmlsoap.org/soap/envelope/", "http://schemas.xmlsoap.org/soap/encoding/");
    private static final String _hdr00 = ClientRequestImpl.createHdr(Constants.XSD_URI_2000, Constants.XSI_URI_2000, "http://schemas.xmlsoap.org/soap/envelope/", "http://schemas.xmlsoap.org/soap/encoding/");
    private static final String _hdr01 = ClientRequestImpl.createHdr(Constants.XSD_URI_2001, Constants.XSI_URI_2001, "http://schemas.xmlsoap.org/soap/envelope/", "http://schemas.xmlsoap.org/soap/encoding/");
    private static final HashMap _uriMaps = new HashMap();
    private static final HashMap _uris99 = ClientRequestImpl.createMap(Constants.XSD_URI_1999, Constants.XSI_URI_1999);
    private static final HashMap _uris00 = ClientRequestImpl.createMap(Constants.XSD_URI_2000, Constants.XSI_URI_2000);
    private static final HashMap _uris01 = ClientRequestImpl.createMap(Constants.XSD_URI_2001, Constants.XSI_URI_2001);

    protected ClientRequestImpl(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        this._charset = string;
        this._qname = null;
        this._method = null;
        this._action = null;
        this._methodURI = null;
        this._twoWay = true;
    }

    ClientRequestImpl(QName qName, boolean bl, EncodingStyle encodingStyle, String string, boolean bl2, String string2, Properties properties, String string3, String string4) {
        super(1024, ClientRequestImpl.getBuitlInURIs(string), bl2, properties, string4);
        this._charset = string4;
        this._qname = qName;
        this._action = string2;
        this._twoWay = bl;
        this._method = this._qname != null ? this._qname.getLocalPart() : null;
        this._methodURI = this._qname != null ? this._qname.getNamespaceURI() : null;
        this._schemaURI = string;
        this._soapURI = string3;
        this.setEncodingStyle(encodingStyle);
        this.writeHeader();
        if (ClientRequestImpl.isSOAP11(this._soapURI)) {
            this._getProperties().put("soapaction", this._action);
        }
    }

    public boolean responseExpected() {
        return this._twoWay;
    }

    public ClientResponse createResponse(Reader reader) throws IOException {
        return this.createResponse(reader, null);
    }

    public ClientResponse createResponse(Reader reader, Map map) throws IOException {
        return new ClientResponseImpl(reader, this._encodingStyle, this.getTypeMappingRegistry(), this._isDocument, map, this._charset);
    }

    public void setProperties(RequestProperty[] requestPropertyArray) {
        if (requestPropertyArray == null) {
            return;
        }
        int n = 0;
        while (n < requestPropertyArray.length) {
            if (requestPropertyArray[n] != null) {
                this._props.put(requestPropertyArray[n].getKey(), requestPropertyArray[n].getValue());
            }
            ++n;
        }
    }

    public void _setProperties(Map map) {
        if (map == null) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this._props.put(entry.getKey(), entry.getValue());
        }
    }

    public RequestProperty[] getProperties() {
        Object object;
        if (this._props == null || this._props.isEmpty()) {
            return null;
        }
        boolean bl = false;
        Iterator iterator = this._props.entrySet().iterator();
        ArrayList<RequestProperty> arrayList = new ArrayList<RequestProperty>(this._props.size());
        while (iterator.hasNext()) {
            object = iterator.next();
            Object k = object.getKey();
            Object v = object.getValue();
            if (!(k instanceof String) || !(v instanceof String)) continue;
            arrayList.add(new RequestProperty((String)k, (String)v));
        }
        object = new RequestProperty[arrayList.size()];
        return (RequestProperty[])arrayList.toArray((T[])object);
    }

    public Map _getProperties() {
        return this._props;
    }

    public boolean isDocument() {
        return this._isDocument;
    }

    private void writeHeader() {
        try {
            this._writer.write(ClientRequestImpl.getHeader(this._schemaURI, this._soapURI, this._encodingStyle.getURI()));
            OutputStreamContext outputStreamContext = this.getContext();
            outputStreamContext.setNamespace(null, null);
            if (this._isDocument) {
                return;
            }
            if (this._qname != null) {
                this._mPrefix = outputStreamContext.createPrefix(this._methodURI);
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append('<');
                stringBuffer.append(this._mPrefix);
                stringBuffer.append(':');
                stringBuffer.append(this._method);
                stringBuffer.append(_ES_DECL);
                stringBuffer.append(this._encodingStyle.getURI());
                stringBuffer.append("' xmlns='");
                stringBuffer.append("'");
                stringBuffer.append(" xmlns:");
                stringBuffer.append(this._mPrefix);
                stringBuffer.append("='");
                stringBuffer.append(this._methodURI);
                stringBuffer.append("'>");
                this._writer.write(new String(stringBuffer));
            }
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
    }

    public Reader createInputStreamReader() throws IOException {
        this.writeFooter();
        return super.createInputStreamReader();
    }

    void writeFooter() {
        if (!this._footerWritten) {
            this._footerWritten = true;
            try {
                if (!this._isDocument && this._qname != null) {
                    this._writer.write("</" + this._mPrefix + ":" + this._method + ">");
                }
                this._writer.write(_footer);
                this.writeMIMEParts();
                this._writer.flush();
            }
            catch (IOException iOException) {
                throw new ServiceException(iOException);
            }
        }
    }

    public InputStream createInputStream() throws IOException {
        return this.createInputStream(this.getReader(), null);
    }

    public InputStream createInputStream(Reader reader, Map map) throws IOException {
        this.writeFooter();
        ServerRequestImpl serverRequestImpl = new ServerRequestImpl(reader, this._encodingStyle, this.getTypeMappingRegistry(), this._isDocument, new QName(this._methodURI, this._action), map, null, this._charset);
        serverRequestImpl.setTypeMappingRegistry(this.getTypeMappingRegistry());
        serverRequestImpl.setSchemaURI(this._schemaURI);
        return serverRequestImpl;
    }

    public String getMethod() {
        return this._method;
    }

    private static final String getHeader(String string, String string2, String string3) {
        String string4;
        HashMap<String, String> hashMap;
        HashMap hashMap2 = (HashMap)_headers.get(string);
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            _headers.put(string, hashMap2);
        }
        if ((hashMap = (HashMap<String, String>)hashMap2.get(string2)) == null) {
            hashMap = new HashMap<String, String>();
            hashMap2.put(string2, hashMap);
        }
        if ((string4 = (String)hashMap.get(string3)) == null) {
            string4 = ClientRequestImpl.createHdr(string, string + "-instance", string2, string3);
            hashMap.put(string3, string4);
        }
        return string4;
    }

    private static final String createHdr(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(_header1);
        stringBuffer.append(string3);
        stringBuffer.append("' xmlns:xsd='");
        stringBuffer.append(string);
        stringBuffer.append(_XSI_DECL);
        stringBuffer.append(string2);
        if (string4 != null) {
            stringBuffer.append(_SOAP_ENC_DECL);
            stringBuffer.append(string4);
        }
        stringBuffer.append(_header3);
        return new String(stringBuffer);
    }

    private static final HashMap getBuitlInURIs(String string) {
        if (string == Constants.XSD_URI_1999) {
            return _uris99;
        }
        if (string == Constants.XSD_URI_2000) {
            return _uris00;
        }
        if (string == Constants.XSD_URI_2001) {
            return _uris01;
        }
        HashMap hashMap = (HashMap)_uriMaps.get(string);
        if (hashMap == null) {
            hashMap = ClientRequestImpl.createMap(string, string + "-instance");
            _uriMaps.put(string, hashMap);
        }
        return hashMap;
    }

    private static final HashMap createMap(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(7);
        hashMap.put(string, "xsd");
        hashMap.put(string2, "xsi");
        hashMap.put("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV");
        hashMap.put("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC");
        return hashMap;
    }

    protected static boolean isSOAP11(String string) {
        return string.equalsIgnoreCase("http://schemas.xmlsoap.org/soap/envelope/");
    }

    protected static boolean isSOAP12(String string) {
        return string.equalsIgnoreCase("http://www.w3.org/2002/06/soap-envelope");
    }
}

