/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.soap;

import com.sssw.jbroker.web.QName;
import com.sssw.jbroker.web.encoding.TypeMappingRegistry;
import com.sssw.jbroker.web.portable.ApplicationException;
import com.sssw.jbroker.web.portable.ClientResponse;
import com.sssw.jbroker.web.soap.ServerRequestImpl;
import com.sssw.jbroker.web.spi.EncodingStyle;
import com.sssw.jbroker.web.spi.XMLScrap;
import java.io.IOException;
import java.io.Reader;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.util.Map;

class ClientResponseImpl
extends ServerRequestImpl
implements ClientResponse {
    private static final boolean _debug = false;
    private String _faultCode;
    private String _faultString;
    private static final QName _RPC_RESULT = new QName("http://www.w3.org/2002/06/soap-rpc", "result");

    ClientResponseImpl(Reader reader, EncodingStyle encodingStyle, TypeMappingRegistry typeMappingRegistry, boolean bl, Map map, String string) throws IOException {
        super(reader, encodingStyle, typeMappingRegistry, true, null, map, null, string);
        this._isDocument = bl;
    }

    public void lookForException() throws ApplicationException, IOException {
        XMLScrap xMLScrap = this._reader.peek();
        if (xMLScrap.type() != 2) {
            this.readMethodStart();
            return;
        }
        if (xMLScrap.getLocalName().equalsIgnoreCase("Fault")) {
            this.readExceptionInfo();
        } else {
            this.readMethodStart();
        }
    }

    void readMethodStart() throws IOException {
        super.readMethodStart();
        if (this._isDocument) {
            return;
        }
        QName qName = this.peek();
        if (qName == null) {
            return;
        }
        if (qName.equals(_RPC_RESULT)) {
            this._reader.next(2);
            this._reader.next(4);
            this._reader.next(3);
        }
    }

    public void readExceptionInfo() throws ApplicationException, IOException {
        String string;
        int n;
        XMLScrap xMLScrap = this._reader.next();
        this._reader.next(2);
        boolean bl = this.isSOAP12();
        if (bl) {
            xMLScrap = this._reader.next(2);
        }
        if ((n = (string = (xMLScrap = this._reader.next(4)).getContent()).indexOf(58)) != -1) {
            string = string.substring(n + 1);
        }
        xMLScrap = this._reader.next(3);
        if (bl) {
            while ((xMLScrap = this._reader.next()) == null || xMLScrap.type() != 3 || !xMLScrap.getLocalName().equalsIgnoreCase("Code")) {
            }
        }
        xMLScrap = this._reader.next(2);
        xMLScrap = this._reader.next(4);
        String string2 = xMLScrap.getContent();
        xMLScrap = this._reader.next(3);
        xMLScrap = this._reader.peek();
        if (xMLScrap.type() == 2 && xMLScrap.getLocalName().equals("faultactor")) {
            int n2 = 1;
            while (n2 != 0) {
                xMLScrap = this._reader.next();
                switch (xMLScrap.type()) {
                    case 2: {
                        ++n2;
                        break;
                    }
                    case 3: {
                        --n2;
                    }
                }
            }
        }
        Object var6_7 = null;
        xMLScrap = this._reader.peek();
        if (xMLScrap.type() == 2 && xMLScrap.getLocalName().equalsIgnoreCase("detail")) {
            xMLScrap = this._reader.next(2);
            QName qName = this.peek();
            ApplicationException applicationException = new ApplicationException(string2, string, qName, this);
            throw applicationException;
        }
        if (string.equals("Server")) {
            throw new RemoteException("unknown exception at the server: " + string2);
        }
        if (string.equals("Server.Error")) {
            Error error = var6_7 != null ? (Error)var6_7 : new Error(string2);
            throw new ServerError("error at server", error);
        }
        if (string.equals("Server.Exception")) {
            throw var6_7 != null ? new ServerException(string2) : new ServerException(string2, var6_7);
        }
        if (string.equals("Server.RuntimeException")) {
            throw new RuntimeException("unknown runtime exception at server: " + string2);
        }
        throw new RemoteException("unknown exception: " + string + ":" + string2);
    }

    private boolean isSOAP12() {
        return this._soap_env_uri.equalsIgnoreCase("http://www.w3.org/2002/06/soap-envelope");
    }
}

