/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.soap;

import com.sssw.jbroker.web.QName;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.core.mapping.ListMapping;
import com.sssw.jbroker.web.core.mapping.TypeMappingBase;
import com.sssw.jbroker.web.encoding.Attribute;
import com.sssw.jbroker.web.encoding.DefaultTypeMappingRegistry;
import com.sssw.jbroker.web.encoding.Deserializer;
import com.sssw.jbroker.web.encoding.MarshalerNotFoundException;
import com.sssw.jbroker.web.encoding.Serializer;
import com.sssw.jbroker.web.encoding.TypeMap;
import com.sssw.jbroker.web.encoding.ValueTypeMarshaler;
import com.sssw.jbroker.web.portable.InputStream;
import com.sssw.jbroker.web.soap.Constants;
import com.sssw.jbroker.web.soap.PrimitiveTypeMapper;
import com.sssw.jbroker.web.soap.mapping.ElementMapping;
import com.sssw.jbroker.web.spi.EncodingStyle;
import com.sssw.jbroker.web.spi.InputStreamContext;
import com.sssw.jbroker.web.spi.OutputStreamContext;
import com.sssw.jbroker.web.spi.XMLReader;
import com.sssw.jbroker.web.spi.XMLScrap;
import java.io.EOFException;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Properties;

public final class LiteralEncodingStyle
implements EncodingStyle,
Constants {
    private static final PrimitiveTypeMapper _primitiveMapper = PrimitiveTypeMapper.getSingleton();
    private static final boolean _debug = false;
    private static final TypeMap _elementMapping = new ElementMapping().getTypeMappings()[0];
    private DefaultTypeMappingRegistry _defaultMapper;
    private static Class[] _nonPrimtiveMappings = new Class[]{class$com$sssw$jbroker$web$core$mapping$SetMapping == null ? (class$com$sssw$jbroker$web$core$mapping$SetMapping = LiteralEncodingStyle.class$("com.sssw.jbroker.web.core.mapping.SetMapping")) : class$com$sssw$jbroker$web$core$mapping$SetMapping, class$com$sssw$jbroker$web$core$mapping$ListMapping == null ? (class$com$sssw$jbroker$web$core$mapping$ListMapping = LiteralEncodingStyle.class$("com.sssw.jbroker.web.core.mapping.ListMapping")) : class$com$sssw$jbroker$web$core$mapping$ListMapping, class$com$sssw$jbroker$web$core$mapping$MapMapping == null ? (class$com$sssw$jbroker$web$core$mapping$MapMapping = LiteralEncodingStyle.class$("com.sssw.jbroker.web.core.mapping.MapMapping")) : class$com$sssw$jbroker$web$core$mapping$MapMapping, class$com$sssw$jbroker$web$core$mapping$MapEntryMapping == null ? (class$com$sssw$jbroker$web$core$mapping$MapEntryMapping = LiteralEncodingStyle.class$("com.sssw.jbroker.web.core.mapping.MapEntryMapping")) : class$com$sssw$jbroker$web$core$mapping$MapEntryMapping, class$com$sssw$jbroker$web$core$mapping$ClassMapping == null ? (class$com$sssw$jbroker$web$core$mapping$ClassMapping = LiteralEncodingStyle.class$("com.sssw.jbroker.web.core.mapping.ClassMapping")) : class$com$sssw$jbroker$web$core$mapping$ClassMapping, class$com$sssw$jbroker$web$core$mapping$QNameMapping == null ? (class$com$sssw$jbroker$web$core$mapping$QNameMapping = LiteralEncodingStyle.class$("com.sssw.jbroker.web.core.mapping.QNameMapping")) : class$com$sssw$jbroker$web$core$mapping$QNameMapping, class$com$sssw$jbroker$web$core$mapping$BindingMapping == null ? (class$com$sssw$jbroker$web$core$mapping$BindingMapping = LiteralEncodingStyle.class$("com.sssw.jbroker.web.core.mapping.BindingMapping")) : class$com$sssw$jbroker$web$core$mapping$BindingMapping, class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping == null ? (class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping = LiteralEncodingStyle.class$("com.sssw.jbroker.web.core.mapping.ServiceObjectMapping")) : class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping, class$com$sssw$jbroker$web$soap$mapping$ElementMapping == null ? (class$com$sssw$jbroker$web$soap$mapping$ElementMapping = LiteralEncodingStyle.class$("com.sssw.jbroker.web.soap.mapping.ElementMapping")) : class$com$sssw$jbroker$web$soap$mapping$ElementMapping, class$com$sssw$jbroker$web$soap$mapping$StackTraceMapping == null ? (class$com$sssw$jbroker$web$soap$mapping$StackTraceMapping = LiteralEncodingStyle.class$("com.sssw.jbroker.web.soap.mapping.StackTraceMapping")) : class$com$sssw$jbroker$web$soap$mapping$StackTraceMapping};
    private static String XSI_NIL = "nil";
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$com$sssw$jbroker$web$ServiceObject;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$SetMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$ListMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$MapMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$MapEntryMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$ClassMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$QNameMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$BindingMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$soap$mapping$ElementMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$soap$mapping$StackTraceMapping;

    public LiteralEncodingStyle(Properties properties) {
        try {
            this._defaultMapper = new DefaultTypeMappingRegistry();
            int n = 0;
            while (n < _nonPrimtiveMappings.length) {
                TypeMappingBase typeMappingBase = (TypeMappingBase)_nonPrimtiveMappings[n].newInstance();
                TypeMap[] typeMapArray = typeMappingBase.getTypeMappings();
                int n2 = 0;
                while (n2 < typeMapArray.length) {
                    this._defaultMapper.put(typeMapArray[n2]);
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getURI() {
        return null;
    }

    public DefaultTypeMappingRegistry getDefaultTypeMappingRegistry() {
        return this._defaultMapper;
    }

    private boolean validateName(InputStreamContext inputStreamContext, String string, String string2) throws IOException {
        XMLScrap xMLScrap = inputStreamContext.getXMLReader().peek();
        if (xMLScrap.type() != 2) {
            throw new EOFException("found " + xMLScrap + " instead of element " + string + ":" + string2);
        }
        boolean bl = false;
        String string3 = xMLScrap.getURI();
        bl = string == null ? string3 == null : string.equals(string3);
        if (bl) {
            return this.validateName(xMLScrap, string2);
        }
        return false;
    }

    private boolean validateName(InputStreamContext inputStreamContext, String string) throws IOException {
        XMLScrap xMLScrap = inputStreamContext.getXMLReader().peek();
        if (xMLScrap.type() != 2) {
            throw new EOFException("found " + xMLScrap + " instead of element " + string);
        }
        return this.validateName(xMLScrap, string);
    }

    private boolean validateName(XMLScrap xMLScrap, String string) throws IOException {
        String string2 = xMLScrap.getLocalName();
        return string.equalsIgnoreCase(string2);
    }

    public String readString(InputStreamContext inputStreamContext) throws IOException {
        XMLScrap xMLScrap = inputStreamContext.getXMLReader().next(2);
        xMLScrap = inputStreamContext.getXMLReader().next(4);
        String string = xMLScrap.getContent();
        xMLScrap = inputStreamContext.getXMLReader().next(3);
        return string;
    }

    public byte readByte(InputStreamContext inputStreamContext) throws IOException {
        throw new Error("Not to be called for Literal Encoding!");
    }

    public byte readByte(InputStreamContext inputStreamContext, String string) throws IOException {
        if (!this.validateName(inputStreamContext, string)) {
            throw new EOFException("primitive " + string + " not found");
        }
        String string2 = this.readString(inputStreamContext);
        byte by = Byte.parseByte(string2);
        return by;
    }

    public boolean readBoolean(InputStreamContext inputStreamContext) throws IOException {
        throw new Error("Not to be called for Literal Encoding!");
    }

    public boolean readBoolean(InputStreamContext inputStreamContext, String string) throws IOException {
        if (!this.validateName(inputStreamContext, string)) {
            throw new EOFException("primitive " + string + " not found");
        }
        String string2 = this.readString(inputStreamContext);
        boolean bl = string2.charAt(0) == '1' || Boolean.valueOf(string2) != false;
        return bl;
    }

    public int readInt(InputStreamContext inputStreamContext) throws IOException {
        throw new Error("Not to be called for Literal Encoding!");
    }

    public int readInt(InputStreamContext inputStreamContext, String string) throws IOException {
        if (!this.validateName(inputStreamContext, string)) {
            throw new EOFException("primitive " + string + " not found");
        }
        String string2 = this.readString(inputStreamContext);
        return Integer.parseInt(string2);
    }

    public short readShort(InputStreamContext inputStreamContext) throws IOException {
        throw new Error("Not to be called for Literal Encoding!");
    }

    public short readShort(InputStreamContext inputStreamContext, String string) throws IOException {
        if (!this.validateName(inputStreamContext, string)) {
            throw new EOFException("primitive " + string + " not found");
        }
        String string2 = this.readString(inputStreamContext);
        return Short.parseShort(string2);
    }

    public long readLong(InputStreamContext inputStreamContext) throws IOException {
        throw new Error("Not to be called for Literal Encoding!");
    }

    public long readLong(InputStreamContext inputStreamContext, String string) throws IOException {
        if (!this.validateName(inputStreamContext, string)) {
            throw new EOFException("primitive " + string + " not found");
        }
        String string2 = this.readString(inputStreamContext);
        return Long.parseLong(string2);
    }

    public float readFloat(InputStreamContext inputStreamContext) throws IOException {
        throw new Error("Not to be called for Literal Encoding!");
    }

    public float readFloat(InputStreamContext inputStreamContext, String string) throws IOException {
        if (!this.validateName(inputStreamContext, string)) {
            throw new EOFException("primitive " + string + " not found");
        }
        String string2 = this.readString(inputStreamContext);
        return Float.parseFloat(string2);
    }

    public double readDouble(InputStreamContext inputStreamContext) throws IOException {
        throw new Error("Not to be called for Literal Encoding!");
    }

    public double readDouble(InputStreamContext inputStreamContext, String string) throws IOException {
        if (!this.validateName(inputStreamContext, string)) {
            throw new EOFException("primitive " + string + " not found");
        }
        String string2 = this.readString(inputStreamContext);
        return Double.parseDouble(string2);
    }

    public Object readObject(InputStreamContext inputStreamContext) throws IOException {
        throw new Error("Not to be called for Literal Encoding!");
    }

    public Object readObject(InputStreamContext inputStreamContext, String string) throws IOException {
        throw new Error("Not to be called for Literal Encoding!");
    }

    public Object readObject(InputStreamContext inputStreamContext, Class clazz) throws IOException {
        throw new Error("Not to be called for Literal Encoding!");
    }

    public Object readObject(InputStreamContext inputStreamContext, Class clazz, String string, String string2) throws IOException {
        if (!this.validateName(inputStreamContext, string, string2)) {
            return null;
        }
        return this.readObject(inputStreamContext, clazz, string2, null, null);
    }

    public Object readObject(InputStreamContext inputStreamContext, Class clazz, String string) throws IOException {
        return this.readObject(inputStreamContext, clazz, string, null, null);
    }

    public Object readObject(InputStreamContext inputStreamContext, Class clazz, String string, String string2, String string3, String string4) throws IOException {
        if (!this.validateName(inputStreamContext, string, string2)) {
            return null;
        }
        return this.readObject(inputStreamContext, clazz, string2, string3, string4);
    }

    public Object readObject(InputStreamContext inputStreamContext, Class clazz, String string, String string2, String string3) throws IOException {
        if (!this.validateName(inputStreamContext, string)) {
            return null;
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = LiteralEncodingStyle.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.readObject(inputStreamContext, _elementMapping);
        }
        if (clazz == (class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = LiteralEncodingStyle.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element)) {
            return this.readObject(inputStreamContext, _elementMapping);
        }
        XMLReader xMLReader = inputStreamContext.getXMLReader();
        XMLScrap xMLScrap = xMLReader.peek(2);
        if (this.isNil(xMLScrap)) {
            if (clazz.isPrimitive()) {
                throw new ServiceException("nil value found for primitive");
            }
            xMLScrap = xMLReader.next(2);
            xMLScrap = xMLReader.peek();
            if (xMLScrap.type() == 4) {
                xMLReader.next(4);
            }
            xMLScrap = xMLReader.next(3);
            return null;
        }
        String string4 = LiteralEncodingStyle.getXSIType(xMLScrap);
        if (clazz.isArray() && clazz != (array$B == null ? (array$B = LiteralEncodingStyle.class$("[B")) : array$B)) {
            return this.readArray(inputStreamContext, clazz, string, string2, string3);
        }
        javax.xml.namespace.QName qName = null;
        if (string4 != null) {
            qName = xMLReader.getQName(string4);
        }
        if (qName == null && string3 != null) {
            qName = new javax.xml.namespace.QName(string2, string3);
        }
        return this.readObject(inputStreamContext, clazz, qName);
    }

    private Object readObject(InputStreamContext inputStreamContext, Class clazz, javax.xml.namespace.QName qName) throws IOException {
        XMLReader xMLReader = inputStreamContext.getXMLReader();
        XMLScrap xMLScrap = xMLReader.next(2);
        DefaultTypeMappingRegistry defaultTypeMappingRegistry = (DefaultTypeMappingRegistry)inputStreamContext.getTypeMappingRegistry();
        TypeMap typeMap = this.getTypeMapping(clazz, qName, defaultTypeMappingRegistry);
        if (typeMap == null) {
            throw new MarshalerNotFoundException(clazz);
        }
        Object object = this.readObject(inputStreamContext, typeMap);
        xMLScrap = xMLReader.peek();
        if (xMLScrap.type() == 4) {
            xMLReader.next(4);
        }
        xMLScrap = xMLReader.next(3);
        return object;
    }

    private Object readObject(InputStreamContext inputStreamContext, TypeMap typeMap) throws IOException {
        Deserializer deserializer = typeMap.getDeserializer();
        if (deserializer == null) {
            throw new ServiceException("null deserializer for " + typeMap.getQName());
        }
        Class clazz = typeMap.getJavaType();
        return deserializer.deserialize(inputStreamContext.getInputStream(), clazz);
    }

    private Object readArray(InputStreamContext inputStreamContext, Class clazz, String string, String string2, String string3) throws IOException {
        QName qName;
        Class<?> clazz2 = clazz.getComponentType();
        InputStream inputStream = inputStreamContext.getInputStream();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while ((qName = inputStream.peek()) != null && string.equalsIgnoreCase(qName.getLocalPart())) {
            Object object = this.readObject(inputStreamContext, clazz2, string, string2, string3);
            arrayList.add(object);
        }
        int n = arrayList.size();
        Object object = Array.newInstance(clazz2, n);
        int n2 = 0;
        while (n2 < n) {
            Array.set(object, n2, arrayList.get(n2));
            ++n2;
        }
        return object;
    }

    public Object readAttachmentArray(InputStreamContext inputStreamContext, Class clazz, String string, String string2) throws IOException {
        QName qName;
        Class<?> clazz2 = clazz.getComponentType();
        InputStream inputStream = inputStreamContext.getInputStream();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while ((qName = inputStream.peek()) != null && string2.equalsIgnoreCase(qName.getLocalPart())) {
            Object object = inputStreamContext.getInputStream().readAttachment(string, string2, clazz2);
            arrayList.add(object);
        }
        int n = arrayList.size();
        Object object = Array.newInstance(clazz2, n);
        int n2 = 0;
        while (n2 < n) {
            Array.set(object, n2, arrayList.get(n2));
            ++n2;
        }
        return object;
    }

    public void writeByte(OutputStreamContext outputStreamContext, byte by, String string) throws IOException {
        string = this.getTagName(string, _primitiveMapper.get(Byte.TYPE), outputStreamContext);
        Writer writer = outputStreamContext.getWriter();
        writer.write(60);
        writer.write(string);
        writer.write(62);
        writer.write(Byte.toString(by));
        writer.write("</");
        writer.write(string);
        writer.write(62);
    }

    public void writeBoolean(OutputStreamContext outputStreamContext, boolean bl, String string) throws IOException {
        string = this.getTagName(string, _primitiveMapper.get(Boolean.TYPE), outputStreamContext);
        Writer writer = outputStreamContext.getWriter();
        writer.write(60);
        writer.write(string);
        writer.write(62);
        writer.write(bl ? "1" : "0");
        writer.write("</");
        writer.write(string);
        writer.write(62);
    }

    public void writeChar(OutputStreamContext outputStreamContext, char c, String string) throws IOException {
        this.writeObject(outputStreamContext, new Character(c), string);
    }

    public void writeInt(OutputStreamContext outputStreamContext, int n, String string) throws IOException {
        string = this.getTagName(string, _primitiveMapper.get(Integer.TYPE), outputStreamContext);
        Writer writer = outputStreamContext.getWriter();
        writer.write(60);
        writer.write(string);
        writer.write(62);
        writer.write(Integer.toString(n));
        writer.write("</");
        writer.write(string);
        writer.write(62);
    }

    public void writeShort(OutputStreamContext outputStreamContext, short s, String string) throws IOException {
        string = this.getTagName(string, _primitiveMapper.get(Short.TYPE), outputStreamContext);
        Writer writer = outputStreamContext.getWriter();
        writer.write(60);
        writer.write(string);
        writer.write(62);
        writer.write(Short.toString(s));
        writer.write("</");
        writer.write(string);
        writer.write(62);
    }

    public void writeLong(OutputStreamContext outputStreamContext, long l, String string) throws IOException {
        string = this.getTagName(string, _primitiveMapper.get(Long.TYPE), outputStreamContext);
        Writer writer = outputStreamContext.getWriter();
        writer.write(60);
        writer.write(string);
        writer.write(62);
        writer.write(Long.toString(l));
        writer.write("</");
        writer.write(string);
        writer.write(62);
    }

    public void writeFloat(OutputStreamContext outputStreamContext, float f, String string) throws IOException {
        string = this.getTagName(string, _primitiveMapper.get(Float.TYPE), outputStreamContext);
        Writer writer = outputStreamContext.getWriter();
        writer.write(60);
        writer.write(string);
        writer.write(62);
        if (f == Float.POSITIVE_INFINITY) {
            writer.write("INF");
        } else if (f == Float.NEGATIVE_INFINITY) {
            writer.write("-INF");
        } else {
            writer.write(Float.toString(f));
        }
        writer.write("</");
        writer.write(string);
        writer.write(62);
    }

    public void writeDouble(OutputStreamContext outputStreamContext, double d, String string) throws IOException {
        string = this.getTagName(string, _primitiveMapper.get(Double.TYPE), outputStreamContext);
        Writer writer = outputStreamContext.getWriter();
        writer.write(60);
        writer.write(string);
        writer.write(62);
        if (d == Double.POSITIVE_INFINITY) {
            writer.write("INF");
        } else if (d == Double.NEGATIVE_INFINITY) {
            writer.write("-INF");
        } else {
            writer.write(Double.toString(d));
        }
        writer.write("</");
        writer.write(string);
        writer.write(62);
    }

    public String getTagName(String string, TypeMap typeMap, OutputStreamContext outputStreamContext) {
        if (string == null) {
            javax.xml.namespace.QName qName = typeMap.getQName();
            String string2 = qName.getNamespaceURI();
            String string3 = outputStreamContext.getPrefix(string2);
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(string3);
            stringBuffer.append(":");
            stringBuffer.append(qName.getLocalPart());
            string = new String(stringBuffer);
        }
        return string;
    }

    public void writeObject(OutputStreamContext outputStreamContext, Object object, String string, String string2) throws IOException {
        this.writeObject(outputStreamContext, object, string, string2, null, null);
    }

    public void writeObject(OutputStreamContext outputStreamContext, Object object, String string, String string2, String string3) throws IOException {
        this.writeObject(outputStreamContext, object, outputStreamContext.getNamespace(), string, string2, string3);
    }

    public void writeObject(OutputStreamContext outputStreamContext, Object object, String string, String string2, String string3, String string4) throws IOException {
        Writer writer = outputStreamContext.getWriter();
        if (object == null) {
            this.writeNull(outputStreamContext, string, string2);
            return;
        }
        Class clazz = object.getClass();
        if (clazz.isArray() && clazz != (array$B == null ? (array$B = LiteralEncodingStyle.class$("[B")) : array$B)) {
            this.writeArray(outputStreamContext, object, string, string2, null, null);
            return;
        }
        String string5 = outputStreamContext.getOutputStream().getSchemaURI();
        TypeMap typeMap = null;
        boolean bl = false;
        if (string4 != null) {
            typeMap = _primitiveMapper.get(clazz, string3, string4);
            if (typeMap == null) {
                typeMap = _primitiveMapper.get(clazz, string5);
            }
        } else {
            typeMap = _primitiveMapper.get(clazz, string5);
        }
        if (typeMap != null) {
            this.writeObject(outputStreamContext, object, string, string2, typeMap);
            return;
        }
        if ((class$com$sssw$jbroker$web$ServiceObject == null ? (class$com$sssw$jbroker$web$ServiceObject = LiteralEncodingStyle.class$("com.sssw.jbroker.web.ServiceObject")) : class$com$sssw$jbroker$web$ServiceObject).isAssignableFrom(clazz)) {
            clazz = class$com$sssw$jbroker$web$ServiceObject == null ? (class$com$sssw$jbroker$web$ServiceObject = LiteralEncodingStyle.class$("com.sssw.jbroker.web.ServiceObject")) : class$com$sssw$jbroker$web$ServiceObject;
        } else if ((class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = LiteralEncodingStyle.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element).isAssignableFrom(clazz)) {
            clazz = class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = LiteralEncodingStyle.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element;
            typeMap = _elementMapping;
        }
        if (typeMap == null) {
            DefaultTypeMappingRegistry defaultTypeMappingRegistry = (DefaultTypeMappingRegistry)outputStreamContext.getTypeMappingRegistry();
            if (string4 != null) {
                typeMap = defaultTypeMappingRegistry.get(clazz, string3, string4);
                if (typeMap == null) {
                    typeMap = defaultTypeMappingRegistry.get(clazz);
                }
            } else {
                typeMap = defaultTypeMappingRegistry.get(clazz);
            }
            if (typeMap == null) {
                typeMap = bl ? this._defaultMapper.get(clazz, string3, string4) : this._defaultMapper.get(clazz);
                if (typeMap == null && (class$java$util$Collection == null ? (class$java$util$Collection = LiteralEncodingStyle.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
                    ListMapping listMapping = new ListMapping();
                    typeMap = listMapping.getTypeMappings()[0];
                    defaultTypeMappingRegistry.put(typeMap);
                }
                if (typeMap == null) {
                    if (ValueTypeMarshaler.isJAXRPCValueType(clazz)) {
                        typeMap = ValueTypeMarshaler.getTypeMap(clazz);
                        defaultTypeMappingRegistry.put(typeMap);
                    }
                    if (typeMap == null) {
                        throw new MarshalerNotFoundException(clazz);
                    }
                }
            }
        }
        this.writeObject(outputStreamContext, object, string, string2, typeMap);
    }

    private void writeObject(OutputStreamContext outputStreamContext, Object object, String string, String string2, TypeMap typeMap) throws IOException {
        boolean bl;
        if (object == null) {
            this.writeNull(outputStreamContext, string, string2);
            return;
        }
        Serializer serializer = typeMap.getSerializer();
        if (serializer == null) {
            throw new ServiceException("null serializer registered for " + object.getClass().getName() + ".class");
        }
        boolean bl2 = bl = typeMap == _elementMapping;
        if (bl) {
            serializer.serialize(outputStreamContext.getOutputStream(), object);
            return;
        }
        Writer writer = outputStreamContext.getWriter();
        TagName tagName = this.getTagName(outputStreamContext, string, string2);
        writer.write(60);
        writer.write(tagName.name);
        if (tagName.prefixes != null) {
            writer.write(tagName.prefixes);
        }
        writer.write(this.getAttributes(outputStreamContext, object, typeMap));
        writer.write(62);
        serializer.serialize(outputStreamContext.getOutputStream(), object);
        writer.write("</");
        writer.write(tagName.name);
        writer.write(62);
    }

    private void writeNull(OutputStreamContext outputStreamContext, String string, String string2) throws IOException {
        Writer writer = outputStreamContext.getWriter();
        TagName tagName = this.getTagName(outputStreamContext, string, string2);
        writer.write(60);
        writer.write(tagName.name);
        if (tagName.prefixes != null) {
            writer.write(tagName.prefixes);
        }
        writer.write(" xsi:nil=\"1\"");
        writer.write("/>");
    }

    private String getAttributes(OutputStreamContext outputStreamContext, Object object, TypeMap typeMap) {
        Serializer serializer;
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer(128);
        javax.xml.namespace.QName qName = typeMap.getQName();
        String string3 = qName.getNamespaceURI();
        if ("".equals(string3)) {
            string3 = null;
        }
        if ((string2 = outputStreamContext.getPrefix(string3)) == null && string3 != null) {
            string2 = outputStreamContext.createPrefix(string3);
            stringBuffer.append(" xmlns:");
            stringBuffer.append(string2);
            stringBuffer.append('=');
            stringBuffer.append('\"');
            stringBuffer.append(string3);
            stringBuffer.append('\"');
        }
        if ((string = this.getAnnotation(outputStreamContext, (serializer = typeMap.getSerializer()).getAttributes(object))) != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        return new String(stringBuffer);
    }

    private TagName getTagName(OutputStreamContext outputStreamContext, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(32);
        StringBuffer stringBuffer2 = new StringBuffer(128);
        String string3 = null;
        String string4 = outputStreamContext.getNamespace();
        if (string == null || string.length() == 0) {
            outputStreamContext.setNamespace(null, null);
            return new TagName(string2, " xmlns=\"\"");
        }
        if (string4 == null ? string == null : string4.equals(string)) {
            return new TagName(string2, null);
        }
        string3 = outputStreamContext.getPrefix(string);
        if (string3 == null) {
            string3 = outputStreamContext.createPrefix(string);
            stringBuffer.append(string3);
            stringBuffer.append(':');
            stringBuffer.append(string2);
            stringBuffer2.append(" xmlns");
            stringBuffer2.append('=');
            stringBuffer2.append('\"');
            stringBuffer2.append(string);
            stringBuffer2.append('\"');
            outputStreamContext.setNamespace(string, string3);
            stringBuffer2.append(" xmlns:");
            stringBuffer2.append(string3);
            stringBuffer2.append('=');
            stringBuffer2.append('\"');
            stringBuffer2.append(string);
            stringBuffer2.append('\"');
        } else {
            stringBuffer.append(string3);
            stringBuffer.append(':');
            stringBuffer.append(string2);
        }
        return new TagName(new String(stringBuffer), new String(stringBuffer2));
    }

    public void writeObject(OutputStreamContext outputStreamContext, Object object, String string) throws IOException {
        this.writeObject(outputStreamContext, object, null, string);
    }

    private void writeArray(OutputStreamContext outputStreamContext, Object object, String string, String string2, String string3, String string4) throws IOException {
        int n = Array.getLength(object);
        int n2 = 0;
        while (n2 < n) {
            Object object2 = Array.get(object, n2);
            if (object2 != null) {
                outputStreamContext.getOutputStream().writeObject(object2, string, string2, string3, string4);
            }
            ++n2;
        }
    }

    public void writeAttachmentArray(OutputStreamContext outputStreamContext, Object object, String string, String string2, String string3) throws IOException {
        int n = Array.getLength(object);
        int n2 = 0;
        while (n2 < n) {
            Object object2 = Array.get(object, n2);
            if (object2 != null) {
                outputStreamContext.getOutputStream().writeAttachment(object2, string, string2, string3);
            }
            ++n2;
        }
    }

    private String getEndTag(String string, String string2, String string3) {
        if (string == null) {
            Thread.dumpStack();
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("</");
        if (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(':');
        }
        stringBuffer.append(string);
        stringBuffer.append('>');
        return new String(stringBuffer);
    }

    private String getStartTag(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append('<');
        if (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(':');
        }
        stringBuffer.append(string);
        if (bl2) {
            stringBuffer.append(" xmlns='");
            stringBuffer.append(string4);
            stringBuffer.append("'");
        }
        if (bl) {
            stringBuffer.append(" xmlns:");
            stringBuffer.append(string3);
            stringBuffer.append("='");
            stringBuffer.append(string4);
            stringBuffer.append("'");
        }
        if (string5 != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string5);
        }
        if (string6 != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string6);
        }
        stringBuffer.append('>');
        return new String(stringBuffer);
    }

    private String getAnnotation(OutputStreamContext outputStreamContext, Attribute[] attributeArray) {
        String string = null;
        if (attributeArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < attributeArray.length) {
                javax.xml.namespace.QName qName = attributeArray[n].getName();
                javax.xml.namespace.QName qName2 = attributeArray[n].getValue();
                String string2 = qName.getLocalPart();
                String string3 = qName.getNamespaceURI();
                String string4 = qName2.getLocalPart();
                String string5 = qName2.getNamespaceURI();
                if ("".equals(string5)) {
                    string5 = null;
                }
                String string6 = this.getOrCreatePrefix(outputStreamContext, stringBuffer, string3);
                String string7 = this.getOrCreatePrefix(outputStreamContext, stringBuffer, string5);
                stringBuffer.append(' ');
                if (string6 != null) {
                    stringBuffer.append(string6);
                    stringBuffer.append(':');
                }
                stringBuffer.append(string2);
                stringBuffer.append("='");
                if (string7 != null) {
                    stringBuffer.append(string7);
                    stringBuffer.append(':');
                }
                stringBuffer.append(string4);
                stringBuffer.append("'");
                ++n;
            }
            string = new String(stringBuffer);
        }
        return string;
    }

    private String getOrCreatePrefix(OutputStreamContext outputStreamContext, StringBuffer stringBuffer, String string) {
        String string2 = null;
        if (string != null && string.length() > 0 && (string2 = outputStreamContext.getPrefix(string)) == null) {
            string2 = outputStreamContext.createPrefix(string);
            stringBuffer.append(" xmlns:");
            stringBuffer.append(string2);
            stringBuffer.append("='");
            stringBuffer.append(string);
            stringBuffer.append("'");
        }
        return string2;
    }

    public boolean isNil(XMLScrap xMLScrap) {
        int n = xMLScrap.getLength();
        int n2 = 0;
        while (n2 < n) {
            if (xMLScrap.getLocalName(n2).equals(XSI_NIL)) {
                String string = xMLScrap.getURI(n2);
                if (string.startsWith("http://www.w3.org/") && string.endsWith("-instance") && xMLScrap.getValue(n2).equals("true")) {
                    return true;
                }
                if (xMLScrap.getValue(n2).equals("1")) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private TypeMap getTypeMapping(Class clazz, javax.xml.namespace.QName qName, DefaultTypeMappingRegistry defaultTypeMappingRegistry) {
        TypeMap typeMap = null;
        if (clazz == null) {
            typeMap = _primitiveMapper.get(qName);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = this._defaultMapper.get(qName);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = defaultTypeMappingRegistry.get(qName);
            if (typeMap != null) {
                return typeMap;
            }
            throw new MarshalerNotFoundException(qName);
        }
        if (qName != null) {
            typeMap = _primitiveMapper.get(clazz, qName);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = this._defaultMapper.get(clazz, qName);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = defaultTypeMappingRegistry.get(clazz, qName);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = _primitiveMapper.get(qName);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = this._defaultMapper.get(qName);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = defaultTypeMappingRegistry.get(qName);
            if (typeMap != null) {
                return typeMap;
            }
        } else {
            typeMap = _primitiveMapper.get(clazz);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = this._defaultMapper.get(clazz);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = defaultTypeMappingRegistry.get(clazz);
            if (typeMap != null) {
                return typeMap;
            }
        }
        if (clazz.getName().equals((class$java$lang$Object == null ? (class$java$lang$Object = LiteralEncodingStyle.class$("java.lang.Object")) : class$java$lang$Object).getName())) {
            throw new MarshalerNotFoundException(qName);
        }
        if (!ValueTypeMarshaler.isJAXRPCValueType(clazz)) {
            throw new MarshalerNotFoundException(clazz);
        }
        typeMap = ValueTypeMarshaler.getTypeMap(clazz);
        defaultTypeMappingRegistry.put(typeMap);
        return typeMap;
    }

    private static String getXSIType(XMLScrap xMLScrap) {
        int n = xMLScrap.getLength();
        int n2 = 0;
        while (n2 < n) {
            String string;
            if (xMLScrap.getLocalName(n2).equals("type") && (string = xMLScrap.getURI(n2)).startsWith("http://www.w3.org/") && string.endsWith("-instance")) {
                return xMLScrap.getValue(n2);
            }
            ++n2;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class TagName {
        public String name;
        public String prefixes;

        public TagName(String string, String string2) {
            this.name = string;
            this.prefixes = string2;
        }
    }
}

