/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.soap;

import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.core.mapping.ListMapping;
import com.sssw.jbroker.web.core.mapping.TypeMappingBase;
import com.sssw.jbroker.web.encoding.Attribute;
import com.sssw.jbroker.web.encoding.DefaultTypeMappingRegistry;
import com.sssw.jbroker.web.encoding.Deserializer;
import com.sssw.jbroker.web.encoding.MarshalerNotFoundException;
import com.sssw.jbroker.web.encoding.Serializer;
import com.sssw.jbroker.web.encoding.TypeMap;
import com.sssw.jbroker.web.encoding.ValueTypeMarshaler;
import com.sssw.jbroker.web.soap.Constants;
import com.sssw.jbroker.web.soap.PrimitiveTypeMapper;
import com.sssw.jbroker.web.soap.mapping.ElementMapping;
import com.sssw.jbroker.web.spi.EncodingStyle;
import com.sssw.jbroker.web.spi.InputStreamContext;
import com.sssw.jbroker.web.spi.OutputStreamContext;
import com.sssw.jbroker.web.spi.XMLReader;
import com.sssw.jbroker.web.spi.XMLScrap;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.namespace.QName;

public class SOAPEncodingStyle
implements EncodingStyle,
Constants {
    private static final boolean _debug = false;
    private static final PrimitiveTypeMapper _primitiveMapper = PrimitiveTypeMapper.getSingleton();
    private static final QName _arrayQName = new QName("http://schemas.xmlsoap.org/soap/encoding/", "Array");
    private static final TypeMap _elementMapping = new ElementMapping().getTypeMappings()[0];
    private static final TypeMap _byteArrMapping = _primitiveMapper.get(array$B == null ? (array$B = SOAPEncodingStyle.class$("[B")) : array$B, "http://schemas.xmlsoap.org/soap/encoding/");
    private DefaultTypeMappingRegistry _defaultMapper;
    private static Class[] _nonPrimtiveMappings = new Class[]{class$com$sssw$jbroker$web$core$mapping$SetMapping == null ? (class$com$sssw$jbroker$web$core$mapping$SetMapping = SOAPEncodingStyle.class$("com.sssw.jbroker.web.core.mapping.SetMapping")) : class$com$sssw$jbroker$web$core$mapping$SetMapping, class$com$sssw$jbroker$web$core$mapping$ListMapping == null ? (class$com$sssw$jbroker$web$core$mapping$ListMapping = SOAPEncodingStyle.class$("com.sssw.jbroker.web.core.mapping.ListMapping")) : class$com$sssw$jbroker$web$core$mapping$ListMapping, class$com$sssw$jbroker$web$core$mapping$MapMapping == null ? (class$com$sssw$jbroker$web$core$mapping$MapMapping = SOAPEncodingStyle.class$("com.sssw.jbroker.web.core.mapping.MapMapping")) : class$com$sssw$jbroker$web$core$mapping$MapMapping, class$com$sssw$jbroker$web$core$mapping$MapEntryMapping == null ? (class$com$sssw$jbroker$web$core$mapping$MapEntryMapping = SOAPEncodingStyle.class$("com.sssw.jbroker.web.core.mapping.MapEntryMapping")) : class$com$sssw$jbroker$web$core$mapping$MapEntryMapping, class$com$sssw$jbroker$web$core$mapping$ClassMapping == null ? (class$com$sssw$jbroker$web$core$mapping$ClassMapping = SOAPEncodingStyle.class$("com.sssw.jbroker.web.core.mapping.ClassMapping")) : class$com$sssw$jbroker$web$core$mapping$ClassMapping, class$com$sssw$jbroker$web$core$mapping$QNameMapping == null ? (class$com$sssw$jbroker$web$core$mapping$QNameMapping = SOAPEncodingStyle.class$("com.sssw.jbroker.web.core.mapping.QNameMapping")) : class$com$sssw$jbroker$web$core$mapping$QNameMapping, class$com$sssw$jbroker$web$core$mapping$BindingMapping == null ? (class$com$sssw$jbroker$web$core$mapping$BindingMapping = SOAPEncodingStyle.class$("com.sssw.jbroker.web.core.mapping.BindingMapping")) : class$com$sssw$jbroker$web$core$mapping$BindingMapping, class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping == null ? (class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping = SOAPEncodingStyle.class$("com.sssw.jbroker.web.core.mapping.ServiceObjectMapping")) : class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping, class$com$sssw$jbroker$web$soap$mapping$ElementMapping == null ? (class$com$sssw$jbroker$web$soap$mapping$ElementMapping = SOAPEncodingStyle.class$("com.sssw.jbroker.web.soap.mapping.ElementMapping")) : class$com$sssw$jbroker$web$soap$mapping$ElementMapping, class$com$sssw$jbroker$web$soap$mapping$StackTraceMapping == null ? (class$com$sssw$jbroker$web$soap$mapping$StackTraceMapping = SOAPEncodingStyle.class$("com.sssw.jbroker.web.soap.mapping.StackTraceMapping")) : class$com$sssw$jbroker$web$soap$mapping$StackTraceMapping};
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$com$sssw$jbroker$web$ServiceObject;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$SetMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$ListMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$MapMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$MapEntryMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$ClassMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$QNameMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$BindingMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$core$mapping$ServiceObjectMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$soap$mapping$ElementMapping;
    static /* synthetic */ Class class$com$sssw$jbroker$web$soap$mapping$StackTraceMapping;
    static /* synthetic */ Class class$java$lang$Object;

    public SOAPEncodingStyle(Properties properties) {
        try {
            this._defaultMapper = new DefaultTypeMappingRegistry();
            int n = 0;
            while (n < _nonPrimtiveMappings.length) {
                TypeMappingBase typeMappingBase = (TypeMappingBase)_nonPrimtiveMappings[n].newInstance();
                TypeMap[] typeMapArray = typeMappingBase.getTypeMappings();
                int n2 = 0;
                while (n2 < typeMapArray.length) {
                    this._defaultMapper.put(typeMapArray[n2]);
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getURI() {
        return "http://schemas.xmlsoap.org/soap/encoding/";
    }

    public DefaultTypeMappingRegistry getDefaultTypeMappingRegistry() {
        return this._defaultMapper;
    }

    public void writeByte(OutputStreamContext outputStreamContext, byte by, String string) throws IOException {
        Writer writer = outputStreamContext.getWriter();
        writer.write(60);
        writer.write(string);
        writer.write(" xsi:type='xsd:byte'");
        writer.write(62);
        writer.write(Byte.toString(by));
        writer.write("</");
        writer.write(string);
        writer.write(62);
    }

    public void writeBoolean(OutputStreamContext outputStreamContext, boolean bl, String string) throws IOException {
        Writer writer = outputStreamContext.getWriter();
        writer.write(60);
        writer.write(string);
        writer.write(" xsi:type='xsd:boolean'");
        writer.write(62);
        writer.write(bl ? "1" : "0");
        writer.write("</");
        writer.write(string);
        writer.write(62);
    }

    public void writeChar(OutputStreamContext outputStreamContext, char c, String string) throws IOException {
        this.writeObject(outputStreamContext, new Character(c), string);
    }

    public void writeInt(OutputStreamContext outputStreamContext, int n, String string) throws IOException {
        Writer writer = outputStreamContext.getWriter();
        writer.write(60);
        writer.write(string);
        writer.write(" xsi:type='xsd:int'");
        writer.write(62);
        writer.write(Integer.toString(n));
        writer.write("</");
        writer.write(string);
        writer.write(62);
    }

    public void writeShort(OutputStreamContext outputStreamContext, short s, String string) throws IOException {
        Writer writer = outputStreamContext.getWriter();
        writer.write(60);
        writer.write(string);
        writer.write(" xsi:type='xsd:short'");
        writer.write(62);
        writer.write(Short.toString(s));
        writer.write("</");
        writer.write(string);
        writer.write(62);
    }

    public void writeLong(OutputStreamContext outputStreamContext, long l, String string) throws IOException {
        Writer writer = outputStreamContext.getWriter();
        writer.write(60);
        writer.write(string);
        writer.write(" xsi:type='xsd:long'");
        writer.write(62);
        writer.write(Long.toString(l));
        writer.write("</");
        writer.write(string);
        writer.write(62);
    }

    public void writeFloat(OutputStreamContext outputStreamContext, float f, String string) throws IOException {
        Writer writer = outputStreamContext.getWriter();
        writer.write(60);
        writer.write(string);
        writer.write(" xsi:type='xsd:float'");
        writer.write(62);
        if (f == Float.POSITIVE_INFINITY) {
            writer.write("INF");
        } else if (f == Float.NEGATIVE_INFINITY) {
            writer.write("-INF");
        } else {
            writer.write(Float.toString(f));
        }
        writer.write("</");
        writer.write(string);
        writer.write(62);
    }

    public void writeDouble(OutputStreamContext outputStreamContext, double d, String string) throws IOException {
        Writer writer = outputStreamContext.getWriter();
        writer.write(60);
        writer.write(string);
        writer.write(" xsi:type='xsd:double'");
        writer.write(62);
        if (d == Double.POSITIVE_INFINITY) {
            writer.write("INF");
        } else if (d == Double.NEGATIVE_INFINITY) {
            writer.write("-INF");
        } else {
            writer.write(Double.toString(d));
        }
        writer.write("</");
        writer.write(string);
        writer.write(62);
    }

    public void writeObject(OutputStreamContext outputStreamContext, Object object, String string, String string2) throws IOException {
        this.writeObject(outputStreamContext, object, string, string2, null, null);
    }

    public void writeObject(OutputStreamContext outputStreamContext, Object object, String string, String string2, String string3) throws IOException {
        this.writeObject(outputStreamContext, object, outputStreamContext.getNamespace(), string, string2, string3);
    }

    public void writeObject(OutputStreamContext outputStreamContext, Object object, String string, String string2, String string3, String string4) throws IOException {
        if (object == null) {
            this.writeNull(outputStreamContext, string, string2);
            return;
        }
        Class clazz = object.getClass();
        if (clazz.isArray() && clazz != (array$B == null ? (array$B = SOAPEncodingStyle.class$("[B")) : array$B)) {
            this.writeArray(outputStreamContext, object, string, string2, null, null);
            return;
        }
        String string5 = outputStreamContext.getOutputStream().getSchemaURI();
        TypeMap typeMap = null;
        if (string4 == null) {
            typeMap = _primitiveMapper.get(clazz, string5);
        } else {
            typeMap = _primitiveMapper.get(clazz, string3, string4);
            if (typeMap == null) {
                typeMap = _primitiveMapper.get(clazz, string5);
            }
        }
        if (typeMap != null) {
            this.writeObject(outputStreamContext, object, string, string2, typeMap);
            return;
        }
        if ((class$com$sssw$jbroker$web$ServiceObject == null ? (class$com$sssw$jbroker$web$ServiceObject = SOAPEncodingStyle.class$("com.sssw.jbroker.web.ServiceObject")) : class$com$sssw$jbroker$web$ServiceObject).isAssignableFrom(clazz)) {
            clazz = class$com$sssw$jbroker$web$ServiceObject == null ? (class$com$sssw$jbroker$web$ServiceObject = SOAPEncodingStyle.class$("com.sssw.jbroker.web.ServiceObject")) : class$com$sssw$jbroker$web$ServiceObject;
        } else if ((class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = SOAPEncodingStyle.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element).isAssignableFrom(clazz)) {
            clazz = class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = SOAPEncodingStyle.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element;
            typeMap = _elementMapping;
        }
        if (typeMap == null) {
            DefaultTypeMappingRegistry defaultTypeMappingRegistry = (DefaultTypeMappingRegistry)outputStreamContext.getTypeMappingRegistry();
            if (string4 != null) {
                typeMap = defaultTypeMappingRegistry.get(clazz, string3, string4);
                if (typeMap == null) {
                    typeMap = defaultTypeMappingRegistry.get(clazz);
                }
            } else {
                typeMap = defaultTypeMappingRegistry.get(clazz);
            }
            if (typeMap == null) {
                TypeMap typeMap2 = typeMap = string4 != null ? this._defaultMapper.get(clazz, string3, string4) : this._defaultMapper.get(clazz);
                if (typeMap == null && (class$java$util$Collection == null ? (class$java$util$Collection = SOAPEncodingStyle.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
                    ListMapping listMapping = new ListMapping();
                    typeMap = listMapping.getTypeMappings()[0];
                    defaultTypeMappingRegistry.put(typeMap);
                }
                if (typeMap == null) {
                    if (ValueTypeMarshaler.isJAXRPCValueType(clazz)) {
                        typeMap = ValueTypeMarshaler.getTypeMap(clazz);
                        defaultTypeMappingRegistry.put(typeMap);
                    }
                    if (typeMap == null) {
                        if (string4 != null) {
                            throw new MarshalerNotFoundException(clazz, new QName(string3, string4));
                        }
                        throw new MarshalerNotFoundException(clazz);
                    }
                }
            }
        }
        this.writeObject(outputStreamContext, object, string, string2, typeMap);
    }

    public void writeObject(OutputStreamContext outputStreamContext, Object object, String string) throws IOException {
        this.writeObject(outputStreamContext, object, outputStreamContext.getNamespace(), string);
    }

    private void writeObject(OutputStreamContext outputStreamContext, Object object, String string, String string2, TypeMap typeMap) throws IOException {
        if (object == null) {
            this.writeNull(outputStreamContext, string, string2);
            return;
        }
        Serializer serializer = typeMap.getSerializer();
        if (serializer == null) {
            throw new ServiceException("null serializer registered for " + object.getClass().getName() + ".class");
        }
        if (typeMap == _elementMapping) {
            serializer.serialize(outputStreamContext.getOutputStream(), object);
            return;
        }
        Writer writer = outputStreamContext.getWriter();
        TagName tagName = this.getTagName(outputStreamContext, string, string2);
        writer.write(60);
        writer.write(tagName.name);
        if (tagName.prefixes != null) {
            writer.write(tagName.prefixes);
        }
        writer.write(this.getAttributes(outputStreamContext, object, typeMap));
        writer.write(62);
        serializer.serialize(outputStreamContext.getOutputStream(), object);
        writer.write("</");
        writer.write(tagName.name);
        writer.write(62);
    }

    private void writeNull(OutputStreamContext outputStreamContext, String string, String string2) throws IOException {
        Writer writer = outputStreamContext.getWriter();
        TagName tagName = this.getTagName(outputStreamContext, string, string2);
        writer.write(60);
        writer.write(tagName.name);
        if (tagName.prefixes != null) {
            writer.write(tagName.prefixes);
        }
        writer.write(" xsi:null=\"true\"");
        writer.write("/>");
    }

    private String getAttributes(OutputStreamContext outputStreamContext, Object object, TypeMap typeMap) {
        String string;
        Object object2;
        String string2;
        StringBuffer stringBuffer = new StringBuffer(128);
        QName qName = typeMap.getQName();
        String string3 = qName.getNamespaceURI();
        if ("".equals(string3)) {
            string3 = null;
        }
        if ((string2 = outputStreamContext.getPrefix(string3)) == null && string3 != null) {
            string2 = outputStreamContext.createPrefix(string3);
            stringBuffer.append(" xmlns:");
            stringBuffer.append(string2);
            stringBuffer.append('=');
            stringBuffer.append('\"');
            stringBuffer.append(string3);
            stringBuffer.append('\"');
        }
        stringBuffer.append(" xsi:type=");
        stringBuffer.append('\"');
        if (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(':');
        }
        stringBuffer.append(qName.getLocalPart());
        stringBuffer.append('\"');
        String string4 = outputStreamContext.getNamespaceURI("xsi");
        if (string4 == null) {
            object2 = outputStreamContext.getOutputStream().getSchemaURI();
            string4 = (String)object2 + "-instance";
            outputStreamContext.createPrefix("xsi", string4);
            stringBuffer.append(" xmlns:xsi='");
            stringBuffer.append(string4);
            stringBuffer.append('\'');
        }
        if ((string = this.getAnnotation(outputStreamContext, (object2 = typeMap.getSerializer()).getAttributes(object))) != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        return new String(stringBuffer);
    }

    private TagName getTagName(OutputStreamContext outputStreamContext, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(32);
        StringBuffer stringBuffer2 = new StringBuffer(128);
        String string3 = null;
        String string4 = outputStreamContext.getNamespace();
        if (string == null || string.length() == 0) {
            outputStreamContext.setNamespace(null, null);
            return new TagName(string2, " xmlns=\"\"");
        }
        if (string4 == null ? string == null : string4.equals(string)) {
            return new TagName(string2, null);
        }
        string3 = outputStreamContext.getPrefix(string);
        if (string3 == null) {
            string3 = outputStreamContext.createPrefix(string);
            stringBuffer.append(string3);
            stringBuffer.append(':');
            stringBuffer.append(string2);
            stringBuffer2.append(" xmlns");
            stringBuffer2.append('=');
            stringBuffer2.append('\"');
            stringBuffer2.append(string);
            stringBuffer2.append('\"');
            outputStreamContext.setNamespace(string, string3);
            stringBuffer2.append(" xmlns:");
            stringBuffer2.append(string3);
            stringBuffer2.append('=');
            stringBuffer2.append('\"');
            stringBuffer2.append(string);
            stringBuffer2.append('\"');
        } else {
            stringBuffer.append(string3);
            stringBuffer.append(':');
            stringBuffer.append(string2);
        }
        return new TagName(new String(stringBuffer), new String(stringBuffer2));
    }

    private String getAnnotation(OutputStreamContext outputStreamContext, Attribute[] attributeArray) {
        String string = null;
        if (attributeArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < attributeArray.length) {
                QName qName = attributeArray[n].getName();
                QName qName2 = attributeArray[n].getValue();
                String string2 = qName.getLocalPart();
                String string3 = qName.getNamespaceURI();
                String string4 = qName2.getLocalPart();
                String string5 = qName2.getNamespaceURI();
                if ("".equals(string5)) {
                    string5 = null;
                }
                String string6 = this.getOrCreatePrefix(outputStreamContext, stringBuffer, string3);
                String string7 = this.getOrCreatePrefix(outputStreamContext, stringBuffer, string5);
                stringBuffer.append(' ');
                if (string6 != null) {
                    stringBuffer.append(string6);
                    stringBuffer.append(':');
                }
                stringBuffer.append(string2);
                stringBuffer.append("='");
                if (string7 != null) {
                    stringBuffer.append(string7);
                    stringBuffer.append(':');
                }
                stringBuffer.append(string4);
                stringBuffer.append("'");
                ++n;
            }
            string = new String(stringBuffer);
        }
        return string;
    }

    private String getOrCreatePrefix(OutputStreamContext outputStreamContext, StringBuffer stringBuffer, String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        String string2 = null;
        string2 = outputStreamContext.getPrefix(string);
        if (string2 == null) {
            string2 = outputStreamContext.createPrefix(string);
            stringBuffer.append(" xmlns:");
            stringBuffer.append(string2);
            stringBuffer.append("='");
            stringBuffer.append(string);
            stringBuffer.append("'");
        }
        return string2;
    }

    private void writeArray(OutputStreamContext outputStreamContext, Object object, String string, String string2, String string3, String string4) throws IOException {
        QName qName;
        String string5;
        StringBuffer stringBuffer;
        String string6;
        Object object2;
        Writer writer = outputStreamContext.getWriter();
        Class clazz = object.getClass().getComponentType();
        if (clazz == Character.TYPE) {
            clazz = class$java$lang$Character == null ? (class$java$lang$Character = SOAPEncodingStyle.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if ((class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = SOAPEncodingStyle.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element).isAssignableFrom(clazz)) {
            throw new IOException("element array not supported");
        }
        int n = 1;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        String string7 = outputStreamContext.getOutputStream().getSchemaURI();
        TypeMap typeMap = null;
        if (string4 == null) {
            typeMap = _primitiveMapper.get(clazz, string7);
        } else {
            typeMap = _primitiveMapper.get(clazz, string3, string4);
            if (typeMap == null) {
                typeMap = _primitiveMapper.get(clazz, string7);
            }
        }
        if (typeMap == null) {
            object2 = (DefaultTypeMappingRegistry)outputStreamContext.getTypeMappingRegistry();
            if (string4 != null) {
                typeMap = ((DefaultTypeMappingRegistry)object2).get(clazz, string3, string4);
                if (typeMap == null) {
                    typeMap = ((DefaultTypeMappingRegistry)object2).get(clazz);
                }
            } else {
                typeMap = ((DefaultTypeMappingRegistry)object2).get(clazz);
            }
            if (typeMap == null) {
                TypeMap typeMap2 = typeMap = string4 != null ? this._defaultMapper.get(clazz, string3, string4) : this._defaultMapper.get(clazz);
                if (typeMap == null) {
                    if (ValueTypeMarshaler.isJAXRPCValueType(clazz)) {
                        typeMap = ValueTypeMarshaler.getTypeMap(clazz);
                        ((DefaultTypeMappingRegistry)object2).put(typeMap);
                    }
                    if (typeMap == null) {
                        throw new MarshalerNotFoundException(clazz);
                    }
                }
            }
        }
        object2 = this.getTagName(outputStreamContext, string, string2);
        writer.write(60);
        writer.write(((TagName)object2).name);
        writer.write(32);
        if (((TagName)object2).prefixes != null) {
            writer.write(((TagName)object2).prefixes);
            writer.write(32);
        }
        String string8 = (string6 = this.getOrCreatePrefix(outputStreamContext, stringBuffer = new StringBuffer(), string5 = (qName = typeMap.getQName()).getNamespaceURI())) == null ? qName.getLocalPart() : string6 + ":" + qName.getLocalPart();
        int n2 = Array.getLength(object);
        String string9 = this.getArrayHeader(object, string8);
        stringBuffer.append(string9);
        writer.write(new String(stringBuffer));
        writer.write(62);
        int n3 = 0;
        while (n3 < n2) {
            this.writeObject(outputStreamContext, Array.get(object, n3), null, "item" + n3, qName.getNamespaceURI(), qName.getLocalPart());
            ++n3;
        }
        writer.write("</");
        writer.write(((TagName)object2).name);
        writer.write(62);
    }

    public void writeAttachmentArray(OutputStreamContext outputStreamContext, Object object, String string, String string2, String string3) throws IOException {
        Writer writer = outputStreamContext.getWriter();
        Class clazz = object.getClass().getComponentType();
        if (clazz == Character.TYPE) {
            clazz = class$java$lang$Character == null ? (class$java$lang$Character = SOAPEncodingStyle.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if ((class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = SOAPEncodingStyle.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element).isAssignableFrom(clazz)) {
            throw new IOException("element array not supported");
        }
        int n = 1;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        TagName tagName = this.getTagName(outputStreamContext, string, string2);
        writer.write(60);
        writer.write(tagName.name);
        writer.write(32);
        if (tagName.prefixes != null) {
            writer.write(tagName.prefixes);
            writer.write(32);
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = outputStreamContext.getOutputStream().getSchemaURI();
        String string5 = this.getOrCreatePrefix(outputStreamContext, stringBuffer, string4);
        String string6 = string5 + ":" + "anyType";
        int n2 = Array.getLength(object);
        String string7 = this.getArrayHeader(object, string6);
        stringBuffer.append(string7);
        writer.write(new String(stringBuffer));
        writer.write(62);
        int n3 = 0;
        while (n3 < n2) {
            outputStreamContext.getOutputStream().writeAttachment(Array.get(object, n3), null, "item" + n3, string3);
            ++n3;
        }
        writer.write("</");
        writer.write(tagName.name);
        writer.write(62);
    }

    protected String getArrayHeader(Object object, String string) {
        Class<?> clazz = object.getClass().getComponentType();
        int n = 1;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        int n2 = Array.getLength(object);
        int n3 = 0;
        while (n3 < n - 1) {
            string = string + "[]";
            ++n3;
        }
        string = string + '[' + n2 + ']';
        return " xsi:type='SOAP-ENC:Array' SOAP-ENC:arrayType='" + string + '\'';
    }

    public byte readByte(InputStreamContext inputStreamContext, String string) throws IOException {
        return this.readByte(inputStreamContext);
    }

    public byte readByte(InputStreamContext inputStreamContext) throws IOException {
        XMLReader xMLReader = inputStreamContext.getXMLReader();
        XMLScrap xMLScrap = xMLReader.next(2);
        xMLScrap = xMLReader.next(4);
        byte by = Byte.parseByte(xMLScrap.getContent());
        xMLScrap = xMLReader.next(3);
        return by;
    }

    public boolean readBoolean(InputStreamContext inputStreamContext, String string) throws IOException {
        return this.readBoolean(inputStreamContext);
    }

    public boolean readBoolean(InputStreamContext inputStreamContext) throws IOException {
        XMLReader xMLReader = inputStreamContext.getXMLReader();
        XMLScrap xMLScrap = xMLReader.next(2);
        xMLScrap = xMLReader.next(4);
        boolean bl = xMLScrap.getContent().charAt(0) == '1' || Boolean.valueOf(xMLScrap.getContent()) != false;
        xMLScrap = xMLReader.next(3);
        return bl;
    }

    public char readChar(InputStreamContext inputStreamContext, String string) throws IOException {
        return this.readChar(inputStreamContext);
    }

    public char readChar(InputStreamContext inputStreamContext) throws IOException {
        return ((Character)this.readObject(inputStreamContext)).charValue();
    }

    public int readInt(InputStreamContext inputStreamContext, String string) throws IOException {
        return this.readInt(inputStreamContext);
    }

    public int readInt(InputStreamContext inputStreamContext) throws IOException {
        XMLReader xMLReader = inputStreamContext.getXMLReader();
        XMLScrap xMLScrap = xMLReader.next(2);
        xMLScrap = xMLReader.next(4);
        int n = Integer.parseInt(xMLScrap.getContent());
        xMLScrap = xMLReader.next(3);
        return n;
    }

    public short readShort(InputStreamContext inputStreamContext, String string) throws IOException {
        return this.readShort(inputStreamContext);
    }

    public short readShort(InputStreamContext inputStreamContext) throws IOException {
        XMLReader xMLReader = inputStreamContext.getXMLReader();
        XMLScrap xMLScrap = xMLReader.next(2);
        xMLScrap = xMLReader.next(4);
        short s = Short.parseShort(xMLScrap.getContent());
        xMLScrap = xMLReader.next(3);
        return s;
    }

    public long readLong(InputStreamContext inputStreamContext, String string) throws IOException {
        return this.readLong(inputStreamContext);
    }

    public long readLong(InputStreamContext inputStreamContext) throws IOException {
        XMLReader xMLReader = inputStreamContext.getXMLReader();
        XMLScrap xMLScrap = xMLReader.next(2);
        xMLScrap = xMLReader.next(4);
        long l = Long.parseLong(xMLScrap.getContent());
        xMLScrap = xMLReader.next(3);
        return l;
    }

    public float readFloat(InputStreamContext inputStreamContext, String string) throws IOException {
        return this.readFloat(inputStreamContext);
    }

    public float readFloat(InputStreamContext inputStreamContext) throws IOException {
        float f;
        XMLReader xMLReader = inputStreamContext.getXMLReader();
        XMLScrap xMLScrap = xMLReader.next(2);
        xMLScrap = xMLReader.next(4);
        String string = xMLScrap.getContent();
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF")) {
                f = Float.POSITIVE_INFINITY;
            }
            if (string.equals("-INF")) {
                f = Float.NEGATIVE_INFINITY;
            }
            if (string.equals("NaN")) {
                f = Float.NaN;
            }
            throw new IOException("unable to read float " + numberFormatException);
        }
        xMLScrap = xMLReader.next(3);
        return f;
    }

    public double readDouble(InputStreamContext inputStreamContext, String string) throws IOException {
        return this.readDouble(inputStreamContext);
    }

    public double readDouble(InputStreamContext inputStreamContext) throws IOException {
        double d;
        XMLReader xMLReader = inputStreamContext.getXMLReader();
        XMLScrap xMLScrap = xMLReader.next(2);
        xMLScrap = xMLReader.next(4);
        String string = xMLScrap.getContent();
        try {
            d = Double.parseDouble(xMLScrap.getContent());
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF")) {
                d = Double.POSITIVE_INFINITY;
            }
            if (string.equals("-INF")) {
                d = Double.NEGATIVE_INFINITY;
            }
            if (string.equals("NaN")) {
                d = Double.NaN;
            }
            throw new IOException("unable to read double " + numberFormatException);
        }
        xMLScrap = xMLReader.next(3);
        return d;
    }

    public Object readObject(InputStreamContext inputStreamContext, String string) throws IOException {
        return this.readObject(inputStreamContext, null, string);
    }

    public Object readObject(InputStreamContext inputStreamContext) throws IOException {
        return this.readObject(inputStreamContext, (Class)null);
    }

    private Object readObject(InputStreamContext inputStreamContext, TypeMap typeMap) throws IOException {
        Deserializer deserializer = typeMap.getDeserializer();
        if (deserializer == null) {
            throw new ServiceException("null deserializer for " + typeMap.getQName());
        }
        return deserializer.deserialize(inputStreamContext.getInputStream(), typeMap.getJavaType());
    }

    public Object readObject(InputStreamContext inputStreamContext, Class clazz, String string) throws IOException {
        return this.readObject(inputStreamContext, clazz);
    }

    public Object readObject(InputStreamContext inputStreamContext, Class clazz, String string, String string2) throws IOException {
        return this.readObject(inputStreamContext, clazz);
    }

    public Object readObject(InputStreamContext inputStreamContext, Class clazz, String string, String string2, String string3, String string4) throws IOException {
        return this.readObject(inputStreamContext, clazz);
    }

    public Object readObject(InputStreamContext inputStreamContext, Class clazz) throws IOException {
        String string;
        XMLReader xMLReader = inputStreamContext.getXMLReader();
        DefaultTypeMappingRegistry defaultTypeMappingRegistry = (DefaultTypeMappingRegistry)inputStreamContext.getTypeMappingRegistry();
        TypeMap typeMap = null;
        if (clazz != null && clazz.equals(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = SOAPEncodingStyle.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element)) {
            typeMap = _elementMapping;
            Object object = this.readObject(inputStreamContext, typeMap);
            return object;
        }
        XMLScrap xMLScrap = xMLReader.next(2);
        if (this.isNil(xMLScrap)) {
            xMLScrap = xMLReader.peek();
            if (xMLScrap.type() == 4) {
                xMLReader.next(4);
            }
            xMLReader.next(3);
            return null;
        }
        String string2 = SOAPEncodingStyle.getXSIType(xMLScrap);
        QName qName = null;
        if (string2 != null) {
            qName = xMLReader.getQName(string2);
        }
        if ((string = this.getArrayType(xMLScrap)) == null) {
            typeMap = this.getTypeMapping(clazz, qName, defaultTypeMappingRegistry);
            if (typeMap != null) {
                Object object = this.readObject(inputStreamContext, typeMap);
                xMLScrap = xMLReader.peek();
                if (xMLScrap.type() == 4) {
                    xMLReader.next(4);
                }
                xMLScrap = xMLReader.next(3);
                return object;
            }
        } else {
            Object object;
            QName qName2 = xMLReader.getQName(string);
            String string3 = qName2.getLocalPart();
            int n = this.getArrayDimensions(string3);
            QName qName3 = new QName(qName2.getNamespaceURI(), string3.substring(0, string3.indexOf(91)));
            Class clazz2 = null;
            if (clazz != null) {
                clazz2 = this.getElementType(clazz);
            }
            TypeMap typeMap2 = this.getTypeMapping(clazz2, qName3, defaultTypeMappingRegistry);
            int n2 = 0;
            int n3 = 0;
            while ((n2 = string3.indexOf(91, n2)) != -1) {
                ++n3;
                ++n2;
            }
            Class clazz3 = typeMap2.getJavaType();
            ArrayList arrayList = this.readArray(clazz3, n, xMLReader, inputStreamContext);
            xMLScrap = xMLReader.peek();
            if (xMLScrap.type() == 4) {
                xMLReader.next(4);
            }
            xMLScrap = xMLReader.next(3);
            int n4 = arrayList.size();
            if (n3 > 1) {
                int[] nArray = new int[n3];
                nArray[0] = n4;
                if (arrayList.size() == 0) {
                    int n5 = 0;
                    while (n5 < nArray.length - 1) {
                        nArray[n5 + 1] = 0;
                        ++n5;
                    }
                } else {
                    Object object2 = arrayList.get(0);
                    int n6 = 0;
                    while (n6 < nArray.length - 1) {
                        nArray[n6 + 1] = Array.getLength(object2);
                        object2 = Array.get(object2, 0);
                        ++n6;
                    }
                }
                object = Array.newInstance(clazz3, nArray);
            } else {
                object = Array.newInstance(clazz3, n4);
            }
            int n7 = 0;
            while (n7 < n4) {
                Array.set(object, n7, arrayList.get(n7));
                ++n7;
            }
            return object;
        }
        String string4 = xMLScrap.getValue("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
        if (string4 != null && string4.equals("http://xml.apache.org/xml-soap/literalxml")) {
            Object object = _elementMapping.getDeserializer().deserialize(inputStreamContext.getInputStream(), class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = SOAPEncodingStyle.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
            xMLScrap = xMLReader.next(3);
            return object;
        }
        throw new ServiceException("unable to read object " + xMLScrap);
    }

    protected String getArrayType(XMLScrap xMLScrap) {
        return xMLScrap.getValue("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
    }

    private static String getXSIType(XMLScrap xMLScrap) {
        int n = xMLScrap.getLength();
        int n2 = 0;
        while (n2 < n) {
            String string;
            if (xMLScrap.getLocalName(n2).equals("type") && (string = xMLScrap.getURI(n2)).startsWith("http://www.w3.org/") && string.endsWith("-instance")) {
                return xMLScrap.getValue(n2);
            }
            ++n2;
        }
        return null;
    }

    public boolean isNil(XMLScrap xMLScrap) {
        int n = xMLScrap.getLength();
        int n2 = 0;
        while (n2 < n) {
            String string;
            if (xMLScrap.getLocalName(n2).equals("null") && (string = xMLScrap.getURI(n2)).startsWith("http://www.w3.org/") && string.endsWith("-instance") && xMLScrap.getValue(n2).equals("true")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private ArrayList readArray(Class clazz, int n, XMLReader xMLReader, InputStreamContext inputStreamContext) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.readObject(inputStreamContext, clazz));
            ++n2;
        }
        return arrayList;
    }

    public Object readAttachmentArray(InputStreamContext inputStreamContext, Class clazz, String string, String string2) throws IOException {
        Object object;
        XMLReader xMLReader = inputStreamContext.getXMLReader();
        XMLScrap xMLScrap = xMLReader.next(2);
        if (this.isNil(xMLScrap)) {
            xMLScrap = xMLReader.peek();
            if (xMLScrap.type() == 4) {
                xMLReader.next(4);
            }
            xMLReader.next(3);
            return null;
        }
        String string3 = this.getArrayType(xMLScrap);
        QName qName = xMLReader.getQName(string3);
        String string4 = qName.getLocalPart();
        int n = this.getArrayDimensions(string4);
        QName qName2 = new QName(qName.getNamespaceURI(), string4.substring(0, string4.indexOf(91)));
        Class clazz2 = null;
        if (clazz != null) {
            clazz2 = this.getElementType(clazz);
        }
        int n2 = 0;
        int n3 = 0;
        while ((n2 = string4.indexOf(91, n2)) != -1) {
            ++n3;
            ++n2;
        }
        ArrayList arrayList = this.readAttachmentArray(clazz2, n, xMLReader, string, string2, inputStreamContext);
        xMLScrap = xMLReader.peek();
        if (xMLScrap.type() == 4) {
            xMLReader.next(4);
        }
        xMLScrap = xMLReader.next(3);
        int n4 = arrayList.size();
        if (n3 > 1) {
            int[] nArray = new int[n3];
            nArray[0] = n4;
            if (arrayList.size() == 0) {
                int n5 = 0;
                while (n5 < nArray.length - 1) {
                    nArray[n5 + 1] = 0;
                    ++n5;
                }
            } else {
                Object object2 = arrayList.get(0);
                int n6 = 0;
                while (n6 < nArray.length - 1) {
                    nArray[n6 + 1] = Array.getLength(object2);
                    object2 = Array.get(object2, 0);
                    ++n6;
                }
            }
            object = Array.newInstance(clazz2, nArray);
        } else {
            object = Array.newInstance(clazz2, n4);
        }
        int n7 = 0;
        while (n7 < n4) {
            Array.set(object, n7, arrayList.get(n7));
            ++n7;
        }
        return object;
    }

    private ArrayList readAttachmentArray(Class clazz, int n, XMLReader xMLReader, String string, String string2, InputStreamContext inputStreamContext) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(inputStreamContext.getInputStream().readAttachment(string, string2, clazz));
            ++n2;
        }
        return arrayList;
    }

    private int getArrayDimensions(String string) throws IOException {
        try {
            int n = string.lastIndexOf(91);
            int n2 = string.lastIndexOf(93);
            String string2 = string.substring(n + 1, n2);
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new IOException("unable to read array dimension: " + exception.getMessage());
        }
    }

    private int getArrayDimensions(Class clazz) {
        int n = 0;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        return n;
    }

    private Class getElementType(Class clazz) {
        if (clazz.isArray()) {
            return this.getElementType(clazz.getComponentType());
        }
        return clazz;
    }

    private TypeMap getTypeMapping(Class clazz, QName qName, DefaultTypeMappingRegistry defaultTypeMappingRegistry) {
        TypeMap typeMap = null;
        if (clazz == null) {
            typeMap = _primitiveMapper.get(qName);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = this._defaultMapper.get(qName);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = defaultTypeMappingRegistry.get(qName);
            if (typeMap != null) {
                return typeMap;
            }
            throw new MarshalerNotFoundException(qName);
        }
        if (qName != null) {
            typeMap = _primitiveMapper.get(clazz, qName);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = this._defaultMapper.get(clazz, qName);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = defaultTypeMappingRegistry.get(clazz, qName);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = _primitiveMapper.get(qName);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = this._defaultMapper.get(qName);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = defaultTypeMappingRegistry.get(qName);
            if (typeMap != null) {
                return typeMap;
            }
        } else {
            typeMap = _primitiveMapper.get(clazz);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = this._defaultMapper.get(clazz);
            if (typeMap != null) {
                return typeMap;
            }
            typeMap = defaultTypeMappingRegistry.get(clazz);
            if (typeMap != null) {
                return typeMap;
            }
        }
        if (clazz.getName().equals((class$java$lang$Object == null ? (class$java$lang$Object = SOAPEncodingStyle.class$("java.lang.Object")) : class$java$lang$Object).getName())) {
            throw new MarshalerNotFoundException(qName);
        }
        if (!ValueTypeMarshaler.isJAXRPCValueType(clazz)) {
            throw new MarshalerNotFoundException(clazz);
        }
        typeMap = ValueTypeMarshaler.getTypeMap(clazz);
        defaultTypeMappingRegistry.put(typeMap);
        return typeMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class TagName {
        public String name;
        public String prefixes;

        public TagName(String string, String string2) {
            this.name = string;
            this.prefixes = string2;
        }
    }
}

