/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.soap;

import com.sssw.jbroker.web.QName;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.ServiceObject;
import com.sssw.jbroker.web.core.PropertyNames;
import com.sssw.jbroker.web.core.Provider;
import com.sssw.jbroker.web.encoding.DefaultTypeMappingRegistry;
import com.sssw.jbroker.web.portable.ClientRequest;
import com.sssw.jbroker.web.portable.InvokeHandler;
import com.sssw.jbroker.web.portable.ServerResponse;
import com.sssw.jbroker.web.soap.ClientRequestImpl;
import com.sssw.jbroker.web.soap.Constants;
import com.sssw.jbroker.web.soap.ServerRequestImpl;
import com.sssw.jbroker.web.soap.ServerResponseImpl;
import com.sssw.jbroker.web.spi.EncodingStyle;
import com.sssw.jbroker.web.spi.ProtocolHandler;
import com.sssw.jbroker.web.spi.XMLReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SOAPHandler
implements ProtocolHandler,
Constants,
PropertyNames {
    private static final QName _qname = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
    private EncodingStyle _soapEncoding;

    public SOAPHandler(Properties properties) {
    }

    public QName getEnvelopeQName() {
        return _qname;
    }

    public ClientRequest createRequest(ServiceObject serviceObject, String string, boolean bl, String string2, boolean bl2, String string3) {
        return this.createRequest(serviceObject, string, bl, string2, bl2, string3, null);
    }

    public ClientRequest createRequest(ServiceObject serviceObject, String string, boolean bl, String string2, boolean bl2, String string3, Properties properties) {
        return this.createRequest(serviceObject, string, bl, string2, bl2, string3, null, null);
    }

    public ClientRequest createRequest(ServiceObject serviceObject, String string, boolean bl, String string2, boolean bl2, String string3, Properties properties, String string4) {
        String string5;
        String string6 = (String)serviceObject._getProperty("xmlrpc.schema.uri");
        EncodingStyle encodingStyle = this.getEncoding(string2);
        QName qName = serviceObject._getOperationName();
        if (qName == null) {
            qName = new QName(serviceObject._getPortType().getNamespaceURI(), string);
        }
        if (string4 == null) {
            string4 = "http://schemas.xmlsoap.org/soap/envelope/";
        }
        if ((string5 = (String)serviceObject._getProperty("jbroker.web.charset")) == null) {
            string5 = "utf-8";
        }
        ClientRequestImpl clientRequestImpl = new ClientRequestImpl(qName, bl, encodingStyle, string6, bl2, string3, properties, string4, string5);
        DefaultTypeMappingRegistry defaultTypeMappingRegistry = (DefaultTypeMappingRegistry)serviceObject._getTypeMappingRegistry();
        if (defaultTypeMappingRegistry != null) {
            clientRequestImpl.setTypeMappingRegistry(defaultTypeMappingRegistry);
        }
        return clientRequestImpl;
    }

    public ClientRequest createRequest(Map map) {
        String string = (String)map.get("xmlrpc.schema.uri");
        EncodingStyle encodingStyle = this.getEncoding((String)map.get("javax.xml.rpc.encodingstyle.namespace.uri"));
        javax.xml.namespace.QName qName = (javax.xml.namespace.QName)map.get("xmlrpc.soap.operation.name");
        QName qName2 = new QName(qName.getNamespaceURI(), qName.getLocalPart());
        Boolean bl = (Boolean)map.get("xmlrpc.soap.operation.twoWay");
        Boolean bl2 = (Boolean)map.get("xmlrpc.soap.operation.isDocument");
        String string2 = (String)map.get("javax.xml.rpc.soap.http.soapaction.uri");
        String string3 = (String)map.get("jbroker.web.charset");
        if (string3 == null) {
            string3 = "utf-8";
        }
        Properties properties = (Properties)map.get("xmlrpc.soap.mime.headers");
        ClientRequestImpl clientRequestImpl = new ClientRequestImpl(qName2, bl, encodingStyle, string, bl2, string2, properties, "http://schemas.xmlsoap.org/soap/envelope/", string3);
        return clientRequestImpl;
    }

    public void endRequest(ClientRequest clientRequest) {
        ((ClientRequestImpl)clientRequest).writeFooter();
    }

    public ServerResponse invoke(InvokeHandler invokeHandler, XMLReader xMLReader, String string, boolean bl, String string2) {
        return this.invoke(invokeHandler, xMLReader, string, bl, string2);
    }

    public ServerResponse invoke(InvokeHandler invokeHandler, XMLReader xMLReader, String string, boolean bl, String string2, Map map, Set set, String string3) {
        try {
            DefaultTypeMappingRegistry defaultTypeMappingRegistry;
            EncodingStyle encodingStyle = this.getEncoding(string);
            ServiceObject serviceObject = (ServiceObject)((Object)invokeHandler);
            QName qName = serviceObject._getOperationName();
            if (qName == null) {
                qName = serviceObject._getPortType();
            }
            ServerRequestImpl serverRequestImpl = new ServerRequestImpl(xMLReader, encodingStyle, bl, new QName(qName.getNamespaceURI(), string2), map, set, string3);
            ServerResponseImpl serverResponseImpl = null;
            String string4 = (String)serviceObject._getProperty("xmlrpc.soap.env.uri");
            if (string4 == null) {
                string4 = "http://schemas.xmlsoap.org/soap/envelope/";
            }
            if (!serverRequestImpl._soap_env_uri.equals(string4)) {
                serverResponseImpl = this.createVersionMismatchResponse(serverRequestImpl);
            } else if (serverRequestImpl._mustUnderstandFault != null) {
                serverResponseImpl = this.createMustUnderstandResponse(serverRequestImpl);
            }
            if (serverResponseImpl != null) {
                serverResponseImpl.writeFooter();
                return serverResponseImpl;
            }
            if (string2 != null) {
                serverRequestImpl.setAction(string2);
            }
            if ((defaultTypeMappingRegistry = (DefaultTypeMappingRegistry)serviceObject._getTypeMappingRegistry()) != null) {
                serverRequestImpl.setTypeMappingRegistry(defaultTypeMappingRegistry);
            }
            String string5 = (String)serviceObject._getProperty("xmlrpc.schema.uri");
            serverRequestImpl.setSchemaURI(string5);
            serverResponseImpl = (ServerResponseImpl)invokeHandler._invoke(serverRequestImpl);
            serverResponseImpl.writeFooter();
            return serverResponseImpl;
        }
        catch (Exception exception) {
            if (exception instanceof ServiceException) {
                throw (ServiceException)exception;
            }
            throw new ServiceException(exception);
        }
    }

    ServerResponseImpl createMustUnderstandResponse(ServerRequestImpl serverRequestImpl) throws IOException {
        ServerResponseImpl serverResponseImpl = (ServerResponseImpl)serverRequestImpl.createExceptionReply();
        serverResponseImpl.writeMustUnderstandFault(serverRequestImpl._mustUnderstandFault);
        return serverResponseImpl;
    }

    ServerResponseImpl createVersionMismatchResponse(ServerRequestImpl serverRequestImpl) throws IOException {
        ServerResponseImpl serverResponseImpl = (ServerResponseImpl)serverRequestImpl.createExceptionReply();
        serverResponseImpl.writeVersionMismatchFault(serverRequestImpl._soap_env_uri);
        return serverResponseImpl;
    }

    private EncodingStyle getSOAPEncoding() {
        if (this._soapEncoding == null) {
            SOAPHandler sOAPHandler = this;
            synchronized (sOAPHandler) {
                if (this._soapEncoding == null) {
                    Provider provider = Provider.getProvider();
                    this._soapEncoding = provider.getEncodingStyle("soap");
                }
            }
        }
        return this._soapEncoding;
    }

    private EncodingStyle getEncoding(String string) {
        if (string == null) {
            string = "LITERAL";
        }
        Provider provider = Provider.getProvider();
        return provider.getEncodingStyle(string);
    }

    public ServerResponse createServerResponse(byte[] byArray, String string) {
        try {
            return new ServerResponseImpl(byArray, string);
        }
        catch (Exception exception) {
            throw new ServiceException(exception);
        }
    }
}

