/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.soap;

import com.sssw.jbroker.web.QName;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.core.InputStreamImpl;
import com.sssw.jbroker.web.encoding.TypeMappingRegistry;
import com.sssw.jbroker.web.portable.ServerRequest;
import com.sssw.jbroker.web.portable.ServerResponse;
import com.sssw.jbroker.web.soap.Constants;
import com.sssw.jbroker.web.soap.ServerResponseImpl;
import com.sssw.jbroker.web.spi.EncodingStyle;
import com.sssw.jbroker.web.spi.XMLReader;
import com.sssw.jbroker.web.spi.XMLScrap;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class ServerRequestImpl
extends InputStreamImpl
implements ServerRequest,
Constants {
    protected QName _qname;
    protected String _method;
    protected String _methodURI;
    protected String _schemaURI;
    protected String _action;
    protected String _soap_env_uri;
    protected String _charset;
    protected javax.xml.namespace.QName _mustUnderstandFault;
    private static final boolean _debug = false;

    ServerRequestImpl(XMLReader xMLReader, EncodingStyle encodingStyle, boolean bl, QName qName, Map map, Set set, String string) throws IOException {
        super(xMLReader, encodingStyle, bl);
        this._charset = string;
        this._action = qName.getLocalPart();
        this._methodURI = qName.getNamespaceURI();
        this._mimeParts = map;
        this.initialize(set);
    }

    ServerRequestImpl(Reader reader, EncodingStyle encodingStyle, TypeMappingRegistry typeMappingRegistry, boolean bl, QName qName, Map map, Set set, String string) throws IOException {
        super(reader, encodingStyle, bl);
        this._charset = string;
        this.setTypeMappingRegistry(typeMappingRegistry);
        if (qName != null) {
            this._action = qName.getLocalPart();
            this._methodURI = qName.getNamespaceURI();
        }
        this._mimeParts = map;
        this.initialize(set);
    }

    private void initialize(Set hashSet) throws IOException {
        XMLScrap xMLScrap = this._reader.next();
        this._soap_env_uri = xMLScrap.getURI();
        xMLScrap = this._reader.next();
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        if (xMLScrap.getLocalName().equals("Header")) {
            int n = 1;
            while (n != 0) {
                xMLScrap = this._reader.next();
                switch (xMLScrap.type()) {
                    case 2: {
                        if (n == 1) {
                            this.lookForMustUnderstand(xMLScrap, hashSet);
                        }
                        ++n;
                        break;
                    }
                    case 3: {
                        --n;
                    }
                }
            }
        }
        xMLScrap = this.readTillBody(xMLScrap);
        this.readMethodStart();
    }

    private XMLScrap readTillBody(XMLScrap xMLScrap) throws IOException {
        while (true) {
            if (xMLScrap.type() != 2) {
                xMLScrap = this._reader.next();
                continue;
            }
            if (xMLScrap.getLocalName().equalsIgnoreCase("Body")) {
                if (this._soap_env_uri.equalsIgnoreCase(xMLScrap.getURI())) {
                    return xMLScrap;
                }
            } else if (xMLScrap.getLocalName().equals("Envelope")) {
                throw new IOException("encountered " + xMLScrap.getLocalName() + "; expected to find SOAP-ENV:Body");
            }
            xMLScrap = this._reader.next();
        }
    }

    private void lookForMustUnderstand(XMLScrap xMLScrap, Set set) {
        boolean bl = this.getMustUnderstand(xMLScrap);
        if (!bl) {
            return;
        }
        javax.xml.namespace.QName qName = new javax.xml.namespace.QName(xMLScrap.getURI(), xMLScrap.getLocalName());
        this._mustUnderstandFault = set.contains(qName) ? null : qName;
    }

    private boolean getMustUnderstand(XMLScrap xMLScrap) {
        String string = null;
        string = ServerRequestImpl.isSOAP12(this._soap_env_uri) ? xMLScrap.getValue("http://www.w3.org/2002/06/soap-envelope", "mustUnderstand") : xMLScrap.getValue("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
        if (string == null) {
            return false;
        }
        return string.charAt(0) == '1' || Boolean.valueOf(string) != false;
    }

    void readMethodStart() throws IOException {
        XMLScrap xMLScrap = null;
        if (this._isDocument) {
            boolean bl = this._reader.isNamespaceAttributesReporting();
            this._reader.setNamespaceAttributesReporting(true);
            xMLScrap = this._reader.peek();
            this._reader.setNamespaceAttributesReporting(bl);
        } else {
            xMLScrap = this._reader.next();
        }
        if (xMLScrap.type() == 2) {
            this._method = xMLScrap.getLocalName();
            this._methodURI = xMLScrap.getURI();
            this._qname = new QName(this._methodURI, this._method);
        }
    }

    public String getMethod() {
        return this._method;
    }

    public ServerResponse createReply() {
        return this.createReply(null);
    }

    public ServerResponse createReply(Properties properties) {
        QName qName = new QName(this._methodURI, this._method + "Response");
        try {
            ServerResponseImpl serverResponseImpl = new ServerResponseImpl(qName, this._encoding, false, this._schemaURI, this._isDocument, properties, this._soap_env_uri, this._charset);
            serverResponseImpl.setTypeMappingRegistry(this.getTypeMappingRegistry());
            return serverResponseImpl;
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException.getMessage());
        }
    }

    public ServerResponse createExceptionReply() {
        QName qName = new QName(this._methodURI, this._method + "Response");
        try {
            ServerResponseImpl serverResponseImpl = new ServerResponseImpl(qName, this._encoding, true, this._schemaURI, this._isDocument, null, this._soap_env_uri, this._charset);
            serverResponseImpl.setTypeMappingRegistry(this.getTypeMappingRegistry());
            return serverResponseImpl;
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException.getMessage());
        }
    }

    void setSchemaURI(String string) {
        this._schemaURI = string;
    }

    public String getAction() {
        return this._action;
    }

    void setAction(String string) {
        this._action = string;
    }

    protected static boolean isSOAP11(String string) {
        return string.equalsIgnoreCase("http://schemas.xmlsoap.org/soap/envelope/");
    }

    protected static boolean isSOAP12(String string) {
        return string.equalsIgnoreCase("http://www.w3.org/2002/06/soap-envelope");
    }
}

