/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.transport.http;

import com.sssw.jbroker.web.transport.http.HttpClientAuthenticator;
import com.sssw.jbroker.web.transport.http.HttpData;
import com.sssw.jbroker.web.transport.http.Util;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Map;
import java.util.Properties;

public class DigestAuthenticator
implements HttpClientAuthenticator {
    private static DigestAuthenticator _singleton;
    private static String _OPAQUE;
    private static String _QOP;
    private static String _AUTH;
    private static String _AUTH_INT;
    private static String _POST;
    private static String _DIGEST;
    private static String _USERNAME;
    private static String _PASSWORD;
    private static String _REALM;
    private static String _MD5;
    private static String _MD5_SESS;
    private static String _ALGORITHM;
    private static String _URI;
    private static String _NC;
    private static String _NC_FIXED;
    private static String _NONCE;
    private static String _CNONCE;
    private static String _CNONCE_FIXED;
    private static String _WWW_Authenticate;
    private static String _Authorization;
    static /* synthetic */ Class class$java$lang$Object;

    public static DigestAuthenticator getInstance() {
        if (_singleton != null) {
            return _singleton;
        }
        Class clazz = class$java$lang$Object == null ? (class$java$lang$Object = DigestAuthenticator.class$("java.lang.Object")) : class$java$lang$Object;
        synchronized (clazz) {
            _singleton = new DigestAuthenticator();
        }
        return _singleton;
    }

    private DigestAuthenticator() {
    }

    public HttpURLConnection authenticate(HttpData httpData, Map map) throws IOException {
        String string = (String)map.get("javax.xml.rpc.security.auth.username");
        String string2 = (String)map.get("javax.xml.rpc.security.auth.password");
        HttpURLConnection httpURLConnection = httpData.getConnection();
        httpData.writeTo(httpURLConnection);
        int n = httpURLConnection.getResponseCode();
        switch (n) {
            case 200: {
                return httpURLConnection;
            }
            case 401: 
            case 403: {
                String string3 = httpURLConnection.getHeaderField(_WWW_Authenticate);
                if (string3 == null) {
                    return httpURLConnection;
                }
                if (!DigestAuthenticator.startsWithIgnoreCase(string3 = string3.trim(), _DIGEST)) {
                    throw new RuntimeException("Resource not protected by Digest Authentication:" + httpData.getURL());
                }
                String string4 = DigestAuthenticator.getAuthroizationHeader(httpData, string, string2, string3);
                httpData.getHeaders().setProperty(_Authorization, string4);
                httpURLConnection = Util.getConnection(httpData.getURL(), httpData.getMethod());
                httpData.writeTo(httpURLConnection);
            }
        }
        return httpURLConnection;
    }

    private static String getAuthroizationHeader(HttpData httpData, String string, String string2, String string3) {
        string3 = string3.substring(_DIGEST.length()).trim();
        Properties properties = Util.getAttributes(string3);
        properties.setProperty(_USERNAME, string);
        properties.setProperty(_PASSWORD, string2);
        properties.setProperty(_URI, httpData.getURL().getPath());
        properties.setProperty(_NC, _NC_FIXED);
        properties.setProperty(_CNONCE, DigestAuthenticator.getDigest(_CNONCE_FIXED));
        String string4 = "Digest " + DigestAuthenticator.getDigestResponse(properties, httpData);
        return string4;
    }

    private static String getDigestResponse(Properties properties, HttpData httpData) {
        String string = properties.getProperty(_USERNAME);
        String string2 = properties.getProperty(_REALM);
        String string3 = properties.getProperty(_NONCE);
        String string4 = properties.getProperty(_URI);
        String string5 = DigestAuthenticator.getRequestDigest(properties, httpData);
        String string6 = properties.getProperty(_ALGORITHM);
        if (string6 == null) {
            string6 = "\"MD5\"";
        }
        String string7 = properties.getProperty(_CNONCE);
        String string8 = properties.getProperty(_OPAQUE);
        String string9 = properties.getProperty(_QOP);
        String string10 = properties.getProperty(_NC);
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("username=\"" + string + "\", ");
        if (string2 != null) {
            stringBuffer.append("realm=" + string2 + ", ");
        }
        if (string3 != null) {
            stringBuffer.append("nonce=" + string3 + ", ");
        }
        if (string4 != null) {
            stringBuffer.append("uri=\"" + string4 + "\", ");
        }
        if (string5 != null) {
            stringBuffer.append("response=" + string5 + ", ");
        }
        if (string6 != null) {
            stringBuffer.append("algorithm=" + string6 + ", ");
        }
        if (string7 != null) {
            stringBuffer.append("cnonce=\"" + string7 + "\", ");
        }
        if (string10 != null) {
            stringBuffer.append("nc=" + string10 + ", ");
        }
        if (string8 != null) {
            stringBuffer.append("opaque=" + string8 + ", ");
        }
        if (string9 != null) {
            stringBuffer.append("qop=" + string9 + ", ");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return new String(stringBuffer);
    }

    private static String getRequestDigest(Properties properties, HttpData httpData) {
        String string = DigestAuthenticator.getHA1Value(properties);
        String string2 = DigestAuthenticator.getHA2Value(properties, httpData);
        String string3 = null;
        String string4 = DigestAuthenticator.unq(properties.getProperty(_NONCE));
        String string5 = properties.getProperty(_QOP);
        if (string5 == null) {
            return DigestAuthenticator.getDigest(string + ":" + string4 + ":" + string2);
        }
        if ((string5 = string5.substring(1, string5.length() - 1)).equalsIgnoreCase("auth") || string5.equalsIgnoreCase("auth-int")) {
            String string6 = DigestAuthenticator.unq(properties.getProperty(_CNONCE));
            String string7 = properties.getProperty(_NC);
            String string8 = string + ":" + string4 + ":" + string7 + ":" + string6 + ":" + string5 + ":" + string2;
            string3 = "\"" + DigestAuthenticator.getDigest(string8) + "\"";
        }
        return string3;
    }

    private static String getHA1Value(Properties properties) {
        String string;
        String string2 = null;
        String string3 = properties.getProperty(_USERNAME);
        String string4 = properties.getProperty(_PASSWORD);
        String string5 = DigestAuthenticator.unq(properties.getProperty(_REALM));
        String string6 = properties.getProperty(_ALGORITHM);
        string2 = string3 + ":" + string5 + ":" + string4;
        if (string6 != null && !string6.equalsIgnoreCase(_MD5)) {
            if (string6.equalsIgnoreCase(_MD5_SESS)) {
                string = DigestAuthenticator.unq(properties.getProperty(_NONCE));
                String string7 = DigestAuthenticator.unq(properties.getProperty(_CNONCE));
                string2 = string2 + ":" + string + ":" + string7;
            } else {
                throw new RuntimeException("Invalid algorithm value:" + string6);
            }
        }
        string = DigestAuthenticator.getDigest(string2);
        return string;
    }

    private static String getHA2Value(Properties properties, HttpData httpData) {
        String string = null;
        String string2 = properties.getProperty(_URI);
        String string3 = properties.getProperty(_QOP);
        if (string3 == null) {
            return null;
        }
        if ((string3 = string3.substring(1, string3.length() - 1)).equals(_AUTH)) {
            string = _POST + ":" + string2;
        } else if (string3.equals(_AUTH_INT)) {
            string = _POST + ":" + string2 + ":" + DigestAuthenticator.getDigest(new String(httpData.getBody()));
        } else {
            throw new RuntimeException("Invalid qop value:" + string3);
        }
        String string4 = DigestAuthenticator.getDigest(string);
        return string4;
    }

    private static String unq(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return string;
        }
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static String getDigest(String string) {
        return Util.hexDigest(string);
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        if (string.length() >= string2.length()) {
            return string.startsWith(string2);
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _OPAQUE = "opaque";
        _QOP = "qop";
        _AUTH = "auth";
        _AUTH_INT = "auth-int";
        _POST = "POST";
        _DIGEST = "Digest";
        _USERNAME = "username";
        _PASSWORD = "password";
        _REALM = "realm";
        _MD5 = "MD5";
        _MD5_SESS = "MD5-sess";
        _ALGORITHM = "algorithm";
        _URI = "uri";
        _NC = "nc";
        _NC_FIXED = "00000001";
        _NONCE = "nonce";
        _CNONCE = "cnonce";
        _CNONCE_FIXED = "FFFFFFFF";
        _WWW_Authenticate = "WWW-Authenticate";
        _Authorization = "Authorization";
    }
}

