/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.transport.http;

import com.sssw.jbroker.util.Base64Encoder;
import com.sssw.jbroker.web.Binding;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.ServiceObject;
import com.sssw.jbroker.web.core.Constants;
import com.sssw.jbroker.web.core.MultipartRequest;
import com.sssw.jbroker.web.portable.ClientRequest;
import com.sssw.jbroker.web.portable.Stub;
import com.sssw.jbroker.web.spi.TransportHandler;
import com.sssw.jbroker.web.transport.http.DigestAuthenticator;
import com.sssw.jbroker.web.transport.http.HttpClientAuthenticator;
import com.sssw.jbroker.web.transport.http.HttpData;
import com.sssw.jbroker.web.transport.http.HttpsHandler;
import com.sssw.jbroker.web.transport.http.NTLMAuthenticator;
import com.sssw.jbroker.web.transport.http.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class HttpHandler
implements TransportHandler,
Constants {
    private static final String CONTENT_TYPE = "text/xml; charset=utf-8";
    private static final String RECV_CONTENT_TYPE = "text/xml";
    private static final String APPL_SOAP_XML = "application/soap+xml";
    private static final boolean _debug = false;

    public HttpHandler(Properties properties) {
        if (!Util.isJDK13()) {
            HttpURLConnection.setFollowRedirects(true);
        }
    }

    public String getProtocol() {
        return "http";
    }

    public TransportHandler.TransportEndpoint createEndpoint(ServiceObject serviceObject) throws MalformedURLException {
        return new HttpEndPoint(serviceObject._getCurrentBinding());
    }

    public TransportHandler.TransportEndpoint createEndpoint(Binding binding) throws MalformedURLException {
        return new HttpEndPoint(binding);
    }

    private static String getContent(InputStream inputStream) throws IOException {
        return HttpHandler.getContent(new InputStreamReader(inputStream));
    }

    private static String getContent(Reader reader) throws IOException {
        StringWriter stringWriter = new StringWriter();
        char[] cArray = new char[512];
        int n = reader.read(cArray, 0, 512);
        if (n == -1) {
            throw new IOException("no data available");
        }
        stringWriter.write(cArray, 0, n);
        if (reader.read(cArray, 0, 512) != -1) {
            stringWriter.getBuffer().append(" ...\n");
        }
        return stringWriter.toString();
    }

    private static class HttpEndPoint
    implements TransportHandler.TransportEndpoint {
        private final URL _url;
        private String _auth;
        private int _scheme = 1;
        private String _user;
        private String _pass;
        private static final int BASIC = 1;
        private static final int DIGEST = 2;
        private static final int NTLM = 3;
        private static final int OTHER = -1;
        private HashMap _properties = new HashMap();
        private static final String _USER_ID = "user.id";

        HttpEndPoint(Binding binding) throws MalformedURLException {
            String string = binding.getURLStr();
            if (string.length() > 5 && "https".equalsIgnoreCase(string.substring(0, 5))) {
                HttpsHandler.init();
            }
            this._url = new URL(string);
        }

        public void setProperty(String string, Object object) {
            this._properties.put(string, object);
        }

        public static void transferHttpHeaders(ClientRequest clientRequest, Properties properties) throws IOException {
            String string;
            Map map = clientRequest._getProperties();
            if (map != null) {
                string = (String)map.get("javax.xml.rpc.soap.http.soapaction.uri");
                if (string == null) {
                    string = (String)map.get("soapaction");
                }
                if (string != null) {
                    properties.setProperty("soapAction", string);
                }
            }
            string = null;
            if (map != null) {
                string = (String)map.get("http.content.type");
            }
            if (string == null) {
                string = HttpHandler.CONTENT_TYPE;
            }
            properties.setProperty("Content-Type", string);
            properties.setProperty("Content-Length", Integer.toString(clientRequest.size()));
        }

        private void setHeaders(HttpURLConnection httpURLConnection, Properties properties) {
            Iterator iterator = ((Hashtable)properties).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                httpURLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }

        private static boolean hasCredentials(Map map) {
            if (map.get("javax.xml.rpc.security.auth.username") != null) {
                return true;
            }
            return map.get(_USER_ID) != null;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public InputStream invoke(ClientRequest var1_1, Properties var2_2) {
            block25: {
                var3_3 = null;
                var4_4 = null;
                try {
                    try {
                        HttpEndPoint.transferHttpHeaders(var1_1, var2_2);
                        var4_4 = Util.getConnection(this._url, 1);
                        this.setHeaders(var4_4, var2_2);
                        var5_5 = (Integer)this._properties.get("jbroker.web.http.auth.scheme");
                        if (var5_5 == null && HttpEndPoint.hasCredentials(this._properties)) {
                            var5_5 = Stub.BASIC_AUTH_SCHEME;
                        }
                        if (var5_5 != null) {
                            switch (var5_5) {
                                case 1: {
                                    this.addBasicAuthentication(this._properties, var1_1, var4_4, var2_2);
                                    break;
                                }
                                case 2: {
                                    var4_4 = this.addDigestAuthentication(this._properties, var1_1, var4_4, var2_2);
                                    break;
                                }
                                case 3: {
                                    var4_4 = this.addNTLMAuthentication(this._properties, var1_1, var4_4, var2_2);
                                    break;
                                }
                                case -1: {
                                    var4_4 = this.addOtherAuthentication(this._properties, var1_1, var4_4, var2_2);
                                    break;
                                }
                                default: {
                                    var3_3 = var4_4.getOutputStream();
                                    var1_1.writeTo(var3_3);
                                    break;
                                }
                            }
                        } else {
                            var3_3 = var4_4.getOutputStream();
                            var1_1.writeTo(var3_3);
                        }
                        var6_7 = var4_4.getResponseCode();
                        switch (var6_7) {
                            case 200: {
                                var7_9 = this.createInputStream(var4_4, var2_2);
                                var10_10 = null;
                                break;
                            }
                            case 401: 
                            case 403: {
                                throw new ServiceException(new AccessException(this.getErrorMessage(var4_4, var6_7)));
                            }
                            case 404: {
                                throw new ServiceException(new NoSuchObjectException(this.getErrorMessage(var4_4, var6_7)));
                            }
                            case 500: {
                                if (var4_4.getErrorStream() == null) throw new ServiceException(new RemoteException(this.getErrorMessage(var4_4, var6_7)));
                                var8_16 = var4_4.getErrorStream();
                                break block25;
                            }
                            default: {
                                throw new ServiceException(new RemoteException(this.getErrorMessage(var4_4, var6_7)));
                            }
                        }
                    }
                    catch (RuntimeException var5_6) {
                        throw var5_6;
                    }
                    catch (Exception var6_8) {
                        throw new ServiceException(var6_8);
                    }
                }
                catch (Throwable var9_17) {
                    var10_12 = null;
                    try {
                        if (var3_3 == null) throw var9_17;
                        var3_3.close();
                        throw var9_17;
                    }
                    catch (Throwable var11_15) {
                        throw var9_17;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [3 : 415->426)] { 
lbl65:
                // 1 sources

                if (var3_3 == null) return var7_9;
                var3_3.close();
                return var7_9;
lbl68:
                // 1 sources

                catch (Throwable var11_13) {
                    // empty catch block
                }
                return var7_9;
            }
            var10_11 = null;
            ** try [egrp 2[TRYBLOCK] [3 : 415->426)] { 
lbl74:
            // 1 sources

            if (var3_3 == null) return var8_16;
            var3_3.close();
            return var8_16;
lbl77:
            // 1 sources

            catch (Throwable var11_14) {
                // empty catch block
            }
            return var8_16;
        }

        private void addBasicAuthentication(HashMap hashMap, ClientRequest clientRequest, HttpURLConnection httpURLConnection, Properties properties) throws IOException {
            Object object;
            String string = (String)hashMap.get("javax.xml.rpc.security.auth.username");
            String string2 = (String)hashMap.get("javax.xml.rpc.security.auth.password");
            if (string != null && string2 != null) {
                object = string + ":" + string2;
                String string3 = "Basic " + Base64Encoder.encode(((String)object).getBytes());
                httpURLConnection.setRequestProperty("Authorization", string3);
            }
            object = httpURLConnection.getOutputStream();
            clientRequest.writeTo((OutputStream)object);
        }

        private HttpURLConnection addDigestAuthentication(HashMap hashMap, ClientRequest clientRequest, HttpURLConnection httpURLConnection, Properties properties) throws IOException {
            HttpData httpData = new HttpData(this._url, httpURLConnection, 1, properties, clientRequest.toByteArray());
            DigestAuthenticator digestAuthenticator = DigestAuthenticator.getInstance();
            return digestAuthenticator.authenticate(httpData, hashMap);
        }

        private HttpURLConnection addNTLMAuthentication(HashMap hashMap, ClientRequest clientRequest, HttpURLConnection httpURLConnection, Properties properties) throws IOException {
            HttpData httpData = new HttpData(this._url, httpURLConnection, 1, properties, clientRequest.toByteArray());
            NTLMAuthenticator nTLMAuthenticator = NTLMAuthenticator.getInstance();
            return nTLMAuthenticator.authenticate(httpData, hashMap);
        }

        private HttpURLConnection addOtherAuthentication(HashMap hashMap, ClientRequest clientRequest, HttpURLConnection httpURLConnection, Properties properties) throws IOException {
            HttpClientAuthenticator httpClientAuthenticator = (HttpClientAuthenticator)hashMap.get("jbroker.web.http.auth.scheme.handler");
            HttpData httpData = new HttpData(this._url, httpURLConnection, 1, properties, clientRequest.toByteArray());
            return httpClientAuthenticator.authenticate(httpData, hashMap);
        }

        private String getErrorMessage(HttpURLConnection httpURLConnection, int n) throws IOException {
            return "HTTP " + n + " " + httpURLConnection.getResponseMessage();
        }

        private InputStream createInputStream(HttpURLConnection httpURLConnection, Properties properties) throws IOException {
            boolean bl = true;
            boolean bl2 = false;
            String string = httpURLConnection.getContentType();
            if (string != null) {
                string = string.trim();
                bl2 = MultipartRequest.isMultipart(string);
                if (string.startsWith(HttpHandler.RECV_CONTENT_TYPE) || bl2) {
                    bl = false;
                }
                if (bl) {
                    bl = !string.startsWith(HttpHandler.APPL_SOAP_XML);
                }
            } else {
                bl = true;
            }
            if (bl) {
                throw new IOException("bad content type = " + string + "; Received Content:\n" + HttpHandler.getContent(httpURLConnection.getInputStream()));
            }
            String string2 = "utf-8";
            int n = string.indexOf("charset=");
            if (n != -1) {
                string2 = string.substring(n + 8);
            }
            if (string2.charAt(0) == '\"' && (n = string2.indexOf(34, 1)) != -1) {
                string2 = string2.substring(1, n);
            }
            int n2 = httpURLConnection.getContentLength();
            if (properties != null) {
                ((Hashtable)properties).remove("content-type");
                ((Hashtable)properties).remove("Content-Type");
                ((Hashtable)properties).remove("content-type");
                properties.setProperty("content-type", string);
                String string3 = httpURLConnection.getHeaderField("content-location");
                if (string3 != null) {
                    properties.setProperty("content-location", string3);
                }
                if ((string3 = httpURLConnection.getHeaderField("set-cookie2")) != null) {
                    properties.setProperty("set-cookie2", string3);
                }
                if ((string3 = httpURLConnection.getHeaderField("set-cookie")) != null) {
                    properties.setProperty("set-cookie", string3);
                }
            }
            return httpURLConnection.getInputStream();
        }
    }
}

