/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.transport.http;

import com.sssw.jbroker.util.Base64Encoder;
import com.sssw.jbroker.web.transport.http.HttpClientAuthenticator;
import com.sssw.jbroker.web.transport.http.HttpData;
import com.sssw.jbroker.web.transport.http.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class NTLMAuthenticator
implements HttpClientAuthenticator {
    private static NTLMAuthenticator _singleton;
    private byte[] currResponse;
    private int pos = 0;
    private static String _POST;
    private static String _NTLM;
    private static String _HOST;
    private static String _NTLM_HOST;
    private static String _DOMAIN;
    private static String _NTLM_DOMAIN;
    private static String _USERNAME;
    private static String _PASSWORD;
    private static String _NONCE;
    private static String _Authenticate;
    private static String _Authorization;
    private static final boolean _debug = false;
    static /* synthetic */ Class class$java$lang$Object;

    public static NTLMAuthenticator getInstance() {
        if (_singleton != null) {
            return _singleton;
        }
        Class clazz = class$java$lang$Object == null ? (class$java$lang$Object = NTLMAuthenticator.class$("java.lang.Object")) : class$java$lang$Object;
        synchronized (clazz) {
            _singleton = new NTLMAuthenticator();
        }
        return _singleton;
    }

    private NTLMAuthenticator() {
    }

    public HttpURLConnection authenticate(HttpData httpData, Map map) throws IOException {
        String string = (String)map.get("javax.xml.rpc.security.auth.username");
        String string2 = (String)map.get("javax.xml.rpc.security.auth.password");
        String string3 = (String)map.get("jbroker.web.ntlm.host");
        String string4 = (String)map.get("jbroker.web.ntlm.domain");
        HttpURLConnection httpURLConnection = null;
        String string5 = this.getResponseFor(null, string, string2, string3, string4);
        String string6 = "NTLM " + string5;
        httpData.getHeaders().setProperty(_Authorization, string6);
        httpURLConnection = NTLMAuthenticator.sendNTLMRequest(httpData);
        int n = httpURLConnection.getContentLength();
        byte[] byArray = new byte[n];
        InputStream inputStream = httpURLConnection.getErrorStream();
        if (inputStream == null) {
            inputStream = httpURLConnection.getInputStream();
        }
        inputStream.read(byArray);
        String string7 = httpURLConnection.getHeaderField("WWW-Authenticate");
        string7 = string7.substring(5);
        String string8 = this.getResponseFor(string7, string, string2, string3, string4);
        string6 = "NTLM " + string8;
        httpData.getHeaders().setProperty(_Authorization, string6);
        httpURLConnection = Util.getConnection(httpData.getURL(), httpData.getMethod());
        httpData.writeTo(httpURLConnection);
        int n2 = httpURLConnection.getResponseCode();
        return httpURLConnection;
    }

    public final String getResponseFor(String string, String string2, String string3, String string4, String string5) throws UnsupportedEncodingException, IOException {
        String string6 = null;
        string6 = string == null || string.trim().equals("") ? this.getType1Message(string4, string5) : this.getType3Message(string2, string3, string4, string5, this.parseType2Message(string));
        return string6;
    }

    private Cipher getCipher(byte[] byArray) throws IOException {
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            byArray = this.setupKey(byArray);
            cipher.init(1, new SecretKeySpec(byArray, "DES"));
            return cipher;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("DES encryption is not available.");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("Invalid key for DES encryption.");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new IOException("NoPadding option for DES is not available.");
        }
    }

    private byte[] setupKey(byte[] byArray) {
        byte[] byArray2 = new byte[]{(byte)(byArray[0] >> 1 & 0xFF), (byte)(((byArray[0] & 1) << 6 | (byArray[1] & 0xFF) >> 2 & 0xFF) & 0xFF), (byte)(((byArray[1] & 3) << 5 | (byArray[2] & 0xFF) >> 3 & 0xFF) & 0xFF), (byte)(((byArray[2] & 7) << 4 | (byArray[3] & 0xFF) >> 4 & 0xFF) & 0xFF), (byte)(((byArray[3] & 0xF) << 3 | (byArray[4] & 0xFF) >> 5 & 0xFF) & 0xFF), (byte)(((byArray[4] & 0x1F) << 2 | (byArray[5] & 0xFF) >> 6 & 0xFF) & 0xFF), (byte)(((byArray[5] & 0x3F) << 1 | (byArray[6] & 0xFF) >> 7 & 0xFF) & 0xFF), (byte)(byArray[6] & 0x7F)};
        int n = 0;
        while (n < byArray2.length) {
            byArray2[n] = (byte)(byArray2[n] << 1);
            ++n;
        }
        return byArray2;
    }

    private byte[] encrypt(byte[] byArray, byte[] byArray2) throws IOException {
        Cipher cipher = this.getCipher(byArray);
        try {
            byte[] byArray3 = cipher.doFinal(byArray2);
            return byArray3;
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IOException("Invalid block size for DES encryption.");
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException("Data not padded correctly for DES encryption.");
        }
    }

    private void prepareResponse(int n) {
        this.currResponse = new byte[n];
        this.pos = 0;
    }

    private void addByte(byte by) {
        this.currResponse[this.pos] = by;
        ++this.pos;
    }

    private void addBytes(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            this.currResponse[this.pos] = byArray[n];
            ++this.pos;
            ++n;
        }
    }

    private String getResponse() throws UnsupportedEncodingException {
        byte[] byArray;
        if (this.currResponse.length > this.pos) {
            byte[] byArray2 = new byte[this.pos];
            int n = 0;
            while (n < this.pos) {
                byArray2[n] = this.currResponse[n];
                ++n;
            }
            byArray = byArray2;
        } else {
            byArray = this.currResponse;
        }
        return Base64Encoder.encode(byArray, "ASCII");
    }

    private String getType1Message(String string, String string2) throws UnsupportedEncodingException {
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        byte[] byArray = string.getBytes("ASCII");
        byte[] byArray2 = string2.getBytes("ASCII");
        int n = 32 + byArray.length + byArray2.length;
        this.prepareResponse(n);
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = "NTLMSSP".getBytes("ASCII");
        this.addBytes(byArray4);
        this.addByte((byte)0);
        this.addByte((byte)1);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addByte((byte)6);
        this.addByte((byte)82);
        this.addByte((byte)0);
        this.addByte((byte)0);
        int n2 = byArray2.length;
        byte[] byArray5 = this.convertShort(n2);
        this.addByte(byArray5[0]);
        this.addByte(byArray5[1]);
        this.addByte(byArray5[0]);
        this.addByte(byArray5[1]);
        byte[] byArray6 = this.convertShort(byArray.length + 32);
        this.addByte(byArray6[0]);
        this.addByte(byArray6[1]);
        this.addByte((byte)0);
        this.addByte((byte)0);
        byte[] byArray7 = this.convertShort(byArray.length);
        this.addByte(byArray7[0]);
        this.addByte(byArray7[1]);
        this.addByte(byArray7[0]);
        this.addByte(byArray7[1]);
        byte[] byArray8 = this.convertShort(32);
        this.addByte(byArray8[0]);
        this.addByte(byArray8[1]);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(byArray);
        this.addBytes(byArray2);
        return this.getResponse();
    }

    private byte[] parseType2Message(String string) throws UnsupportedEncodingException {
        byte[] byArray = Base64Encoder.decode(string.getBytes("ASCII"));
        byte[] byArray2 = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray2[n] = byArray[n + 24];
            ++n;
        }
        return byArray2;
    }

    private String getType3Message(String string, String string2, String string3, String string4, byte[] byArray) throws UnsupportedEncodingException, IOException {
        int n = 0;
        int n2 = 24;
        string4 = string4.toUpperCase();
        string3 = string3.toUpperCase();
        string = string.toUpperCase();
        byte[] byArray2 = string4.getBytes("ASCII");
        byte[] byArray3 = string3.getBytes("ASCII");
        byte[] byArray4 = string.getBytes("ASCII");
        int n3 = byArray2.length;
        int n4 = byArray3.length;
        int n5 = byArray4.length;
        int n6 = 64 + n + n2 + n3 + n5 + n4;
        this.prepareResponse(n6);
        byte[] byArray5 = "NTLMSSP".getBytes("ASCII");
        this.addBytes(byArray5);
        this.addByte((byte)0);
        this.addByte((byte)3);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(24));
        this.addBytes(this.convertShort(24));
        this.addBytes(this.convertShort(n6 - 24));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(0));
        this.addBytes(this.convertShort(0));
        this.addBytes(this.convertShort(n6));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(n3));
        this.addBytes(this.convertShort(n3));
        this.addBytes(this.convertShort(64));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(n5));
        this.addBytes(this.convertShort(n5));
        this.addBytes(this.convertShort(64 + n3));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(n4));
        this.addBytes(this.convertShort(n4));
        this.addBytes(this.convertShort(64 + n3 + n5));
        int n7 = 0;
        while (n7 < 6) {
            this.addByte((byte)0);
            ++n7;
        }
        this.addBytes(this.convertShort(n6));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addByte((byte)6);
        this.addByte((byte)82);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(byArray2);
        this.addBytes(byArray4);
        this.addBytes(byArray3);
        this.addBytes(this.hashPassword(string2, byArray));
        return this.getResponse();
    }

    private byte[] hashPassword(String string, byte[] byArray) throws UnsupportedEncodingException, IOException {
        byte[] byArray2 = string.toUpperCase().getBytes("ASCII");
        byte[] byArray3 = new byte[7];
        byte[] byArray4 = new byte[7];
        int n = byArray2.length;
        if (n > 7) {
            n = 7;
        }
        int n2 = 0;
        while (n2 < n) {
            byArray3[n2] = byArray2[n2];
            ++n2;
        }
        while (n2 < 7) {
            byArray3[n2] = 0;
            ++n2;
        }
        n = byArray2.length;
        if (n > 14) {
            n = 14;
        }
        n2 = 7;
        while (n2 < n) {
            byArray4[n2 - 7] = byArray2[n2];
            ++n2;
        }
        while (n2 < 14) {
            byArray4[n2 - 7] = 0;
            ++n2;
        }
        byte[] byArray5 = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
        byte[] byArray6 = this.encrypt(byArray3, byArray5);
        byte[] byArray7 = this.encrypt(byArray4, byArray5);
        byte[] byArray8 = new byte[21];
        int n3 = 0;
        while (n3 < byArray6.length) {
            byArray8[n3] = byArray6[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < byArray7.length) {
            byArray8[n4 + 8] = byArray7[n4];
            ++n4;
        }
        int n5 = 0;
        while (n5 < 5) {
            byArray8[n5 + 16] = 0;
            ++n5;
        }
        byte[] byArray9 = new byte[24];
        this.calc_resp(byArray8, byArray, byArray9);
        return byArray9;
    }

    private void calc_resp(byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        byte[] byArray4 = new byte[7];
        byte[] byArray5 = new byte[7];
        byte[] byArray6 = new byte[7];
        int n = 0;
        while (n < 7) {
            byArray4[n] = byArray[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < 7) {
            byArray5[n2] = byArray[n2 + 7];
            ++n2;
        }
        int n3 = 0;
        while (n3 < 7) {
            byArray6[n3] = byArray[n3 + 14];
            ++n3;
        }
        byte[] byArray7 = this.encrypt(byArray4, byArray2);
        byte[] byArray8 = this.encrypt(byArray5, byArray2);
        byte[] byArray9 = this.encrypt(byArray6, byArray2);
        int n4 = 0;
        while (n4 < 8) {
            byArray3[n4] = byArray7[n4];
            ++n4;
        }
        int n5 = 0;
        while (n5 < 8) {
            byArray3[n5 + 8] = byArray8[n5];
            ++n5;
        }
        int n6 = 0;
        while (n6 < 8) {
            byArray3[n6 + 16] = byArray9[n6];
            ++n6;
        }
    }

    private byte[] convertShort(int n) {
        byte[] byArray = new byte[2];
        String string = Integer.toString(n, 16);
        while (string.length() < 4) {
            string = "0" + string;
        }
        String string2 = string.substring(2, 4);
        String string3 = string.substring(0, 2);
        byArray[0] = (byte)Integer.parseInt(string2, 16);
        byArray[1] = (byte)Integer.parseInt(string3, 16);
        return byArray;
    }

    private static HttpURLConnection sendNTLMRequest(HttpData httpData) throws IOException {
        HttpURLConnection httpURLConnection = Util.getConnection(httpData.getURL(), httpData.getMethod());
        httpData.writeTo(httpURLConnection);
        int n = httpURLConnection.getResponseCode();
        if (n != 407 && n != 401) {
            throw new Error("Invalid NTLM response:" + n);
        }
        return httpURLConnection;
    }

    private static void printHeaders(HttpURLConnection httpURLConnection) throws IOException {
        int n = 1;
        String string = null;
        String string2 = null;
        while ((string = ((URLConnection)httpURLConnection).getHeaderFieldKey(n)) != null) {
            string2 = ((URLConnection)httpURLConnection).getHeaderField(n);
            System.out.println(string + "=" + string2);
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = System.getProperty("jbroker.web.security.provider", "com.sun.crypto.provider.SunJCE");
        try {
            Provider provider = (Provider)Class.forName(string).newInstance();
            Security.addProvider(provider);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Specified security provider " + string + " could not be found by the class loader: " + classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            System.err.println("Specified security provider " + string + " is not of type java.security.Provider: " + classCastException);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Specified security provider " + string + " could not be instantiated: " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Specified security provider " + string + " does not allow access to the constructor: " + illegalAccessException);
        }
        _POST = "POST";
        _NTLM = "NTLM";
        _HOST = "host";
        _NTLM_HOST = "jbroker.web.ntlm.server";
        _DOMAIN = "domain";
        _NTLM_DOMAIN = "jbroker.web.ntlm.domain";
        _USERNAME = "username";
        _PASSWORD = "password";
        _NONCE = "nonce";
        _Authenticate = "WWW-Authenticate";
        _Authorization = "Authorization";
    }
}

